


<?php $__env->startSection('title', 'Payment Details - Chingu Bite'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">Payment Details</h1>
        <div>
            <a href="<?php echo e(route('employee.payments.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-1"></i>Back to List
            </a>
        </div>
    </div>

    <div class="row">
        <!-- Left Column: Payment Details -->
        <div class="col-lg-8 mb-4">
            <!-- Payment Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-primary">
                        Payment #<?php echo e($payment['id']); ?>

                        <span class="badge bg-<?php echo e(match($payment['status']) {
                            'pending' => 'warning',
                            'waiting_confirmation' => 'info',
                            'confirmed' => 'success',
                            'failed' => 'danger',
                            'refunded' => 'secondary',
                            default => 'light'
                        }); ?> ms-2">
                            <?php echo e(ucfirst(str_replace('_', ' ', $payment['status']))); ?>

                        </span>
                    </h6>
                    <div class="dropdown">
                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" 
                                type="button" data-bs-toggle="dropdown">
                            <i class="fas fa-cog"></i> Actions
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <?php if($payment['status'] == 'waiting_confirmation'): ?>
                                <li>
                                    <button class="dropdown-item" data-bs-toggle="modal" 
                                            data-bs-target="#confirmModal">
                                        <i class="fas fa-check text-success me-2"></i>Confirm Payment
                                    </button>
                                </li>
                                <li>
                                    <button class="dropdown-item" data-bs-toggle="modal" 
                                            data-bs-target="#rejectModal">
                                        <i class="fas fa-times text-danger me-2"></i>Reject Payment
                                    </button>
                                </li>
                            <?php endif; ?>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('employee.orders.show', $payment['order_id'])); ?>">
                                    <i class="fas fa-shopping-cart me-2"></i>View Order
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('employee.receipts.show', $payment['order_id'])); ?>">
                                    <i class="fas fa-receipt me-2"></i>View Receipt
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="40%">Order Number:</th>
                                    <td>
                                        <a href="<?php echo e(route('employee.orders.show', $payment['order_id'])); ?>">
                                            #<?php echo e($payment['order']['order_number'] ?? 'N/A'); ?>

                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Customer:</th>
                                    <td><?php echo e($payment['order']['customer']['name'] ?? 'Guest'); ?></td>
                                </tr>
                                <tr>
                                    <th>Phone:</th>
                                    <td><?php echo e($payment['order']['customer']['phone'] ?? 'N/A'); ?></td>
                                </tr>
                                <tr>
                                    <th>Email:</th>
                                    <td><?php echo e($payment['order']['customer']['email'] ?? 'N/A'); ?></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="40%">Payment Method:</th>
                                    <td>
                                        <span class="badge bg-secondary">
                                            <?php echo e($payment['payment_method']['name'] ?? 'Unknown'); ?>

                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Amount:</th>
                                    <td class="h5 text-success">
                                        Rp <?php echo e(number_format($payment['amount'], 0, ',', '.')); ?>

                                    </td>
                                </tr>
                                <tr>
                                    <th>Submitted:</th>
                                    <td><?php echo e(\Carbon\Carbon::parse($payment['created_at'])->format('d M Y, H:i')); ?></td>
                                </tr>
                                <?php if($payment['confirmed_at']): ?>
                                <tr>
                                    <th>Confirmed:</th>
                                    <td><?php echo e(\Carbon\Carbon::parse($payment['confirmed_at'])->format('d M Y, H:i')); ?></td>
                                </tr>
                                <?php endif; ?>
                            </table>
                        </div>
                    </div>

                    <?php if($payment['notes']): ?>
                    <div class="alert alert-info mt-3">
                        <strong><i class="fas fa-sticky-note me-1"></i>Notes:</strong><br>
                        <?php echo e($payment['notes']); ?>

                    </div>
                    <?php endif; ?>

                    <?php if($payment['reference_number']): ?>
                    <div class="alert alert-light mt-3">
                        <strong><i class="fas fa-hashtag me-1"></i>Reference Number:</strong>
                        <?php echo e($payment['reference_number']); ?>

                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Order Summary -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Order Summary</h6>
                </div>
                <div class="card-body">
                    <?php if(isset($payment['order']['items'])): ?>
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Item</th>
                                        <th>Qty</th>
                                        <th>Price</th>
                                        <th>Subtotal</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $payment['order']['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($item['menu']['name'] ?? 'Menu Item'); ?></td>
                                            <td><?php echo e($item['quantity']); ?></td>
                                            <td>Rp <?php echo e(number_format($item['unit_price'], 0, ',', '.')); ?></td>
                                            <td>Rp <?php echo e(number_format($item['subtotal'], 0, ',', '.')); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="3" class="text-end">Subtotal:</th>
                                        <th>Rp <?php echo e(number_format($payment['order']['total_amount'] ?? 0, 0, ',', '.')); ?></th>
                                    </tr>
                                    <?php if(($payment['order']['tax_amount'] ?? 0) > 0): ?>
                                    <tr>
                                        <th colspan="3" class="text-end">Tax:</th>
                                        <th>Rp <?php echo e(number_format($payment['order']['tax_amount'] ?? 0, 0, ',', '.')); ?></th>
                                    </tr>
                                    <?php endif; ?>
                                    <?php if(($payment['order']['discount_amount'] ?? 0) > 0): ?>
                                    <tr>
                                        <th colspan="3" class="text-end">Discount:</th>
                                        <th class="text-success">-Rp <?php echo e(number_format($payment['order']['discount_amount'] ?? 0, 0, ',', '.')); ?></th>
                                    </tr>
                                    <?php endif; ?>
                                    <tr>
                                        <th colspan="3" class="text-end">Final Amount:</th>
                                        <th class="h5 text-success">Rp <?php echo e(number_format($payment['order']['final_amount'] ?? 0, 0, ',', '.')); ?></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    <?php else: ?>
                        <p class="text-muted">Order details not available</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Right Column: Payment Proof & Actions -->
        <div class="col-lg-4">
            <!-- Payment Proof Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Payment Proof</h6>
                </div>
                <div class="card-body text-center">
                    <?php if($payment['proof_image']): ?>
                        <div class="mb-3">
                            <img src="<?php echo e(asset('storage/' . $payment['proof_image'])); ?>" 
                                 alt="Payment Proof" 
                                 class="img-fluid rounded border" 
                                 style="max-height: 300px;">
                        </div>
                        <a href="<?php echo e(asset('storage/' . $payment['proof_image'])); ?>" 
                           target="_blank" 
                           class="btn btn-outline-primary">
                            <i class="fas fa-expand me-1"></i>View Full Size
                        </a>
                        <a href="<?php echo e(asset('storage/' . $payment['proof_image'])); ?>" 
                           download 
                           class="btn btn-outline-success">
                            <i class="fas fa-download me-1"></i>Download
                        </a>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="fas fa-image fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No payment proof uploaded</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Payment Status Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Payment Status</h6>
                </div>
                <div class="card-body">
                    <?php if($payment['status'] == 'waiting_confirmation'): ?>
                        <div class="alert alert-warning">
                            <i class="fas fa-clock me-2"></i>
                            <strong>Waiting for Confirmation</strong>
                            <p class="mb-0 mt-2">Please verify the payment proof and confirm or reject.</p>
                        </div>
                    <?php elseif($payment['status'] == 'confirmed'): ?>
                        <div class="alert alert-success">
                            <i class="fas fa-check-circle me-2"></i>
                            <strong>Payment Confirmed</strong>
                            <?php if($payment['confirmed_by']): ?>
                                <p class="mb-0 mt-2">
                                    Confirmed by: <?php echo e($payment['confirmed_by_user']['name'] ?? 'Staff'); ?><br>
                                    Date: <?php echo e(\Carbon\Carbon::parse($payment['confirmed_at'])->format('d M Y, H:i')); ?>

                                </p>
                            <?php endif; ?>
                        </div>
                    <?php elseif($payment['status'] == 'failed'): ?>
                        <div class="alert alert-danger">
                            <i class="fas fa-times-circle me-2"></i>
                            <strong>Payment Failed</strong>
                            <?php if($payment['notes']): ?>
                                <p class="mb-0 mt-2"><?php echo e($payment['notes']); ?></p>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Quick Actions -->
            <?php if($payment['status'] == 'waiting_confirmation'): ?>
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Quick Actions</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <button type="button" class="btn btn-success" data-bs-toggle="modal" 
                                data-bs-target="#confirmModal">
                            <i class="fas fa-check me-1"></i>Confirm Payment
                        </button>
                        <button type="button" class="btn btn-danger" data-bs-toggle="modal" 
                                data-bs-target="#rejectModal">
                            <i class="fas fa-times me-1"></i>Reject Payment
                        </button>
                        <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal" 
                                data-bs-target="#requestProofModal">
                            <i class="fas fa-paper-plane me-1"></i>Request New Proof
                        </button>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Modals -->
<?php echo $__env->make('employee.payments.modals.confirm', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('employee.payments.modals.reject', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('employee.payments.modals.request-proof', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Auto refresh if waiting confirmation
        <?php if($payment['status'] == 'waiting_confirmation'): ?>
            setInterval(() => {
                const shouldRefresh = !document.querySelector('.modal.show');
                if (shouldRefresh) {
                    location.reload();
                }
            }, 15000); // Refresh every 15 seconds
        <?php endif; ?>
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.employee', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\employee\payments\show.blade.php ENDPATH**/ ?>