


<?php $__env->startSection('title', 'Make Payment - Chingu Bite'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <h1 class="mb-4">Make Payment</h1>
    
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Order Details</h5>
                    <p><strong>Order #:</strong> <?php echo e($order['order_number'] ?? 'N/A'); ?></p>
                    <p><strong>Total Amount:</strong> Rp <?php echo e(number_format($order['final_amount'] ?? 0, 0, ',', '.')); ?></p>
                    
                    <form method="POST" action="<?php echo e(route('customer.payments.store')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="order_id" value="<?php echo e($orderId); ?>">
                        
                        <div class="mb-3">
                            <label for="payment_method_id" class="form-label">Payment Method</label>
                            <select class="form-select" id="payment_method_id" name="payment_method_id" required>
                                <option value="">Select Payment Method</option>
                                <?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($method['is_active']): ?>
                                        <option value="<?php echo e($method['id']); ?>">
                                            <?php echo e($method['name']); ?>

                                        </option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label for="amount" class="form-label">Amount</label>
                            <input type="number" 
                                   class="form-control" 
                                   id="amount" 
                                   name="amount" 
                                   value="<?php echo e($order['final_amount'] ?? 0); ?>" 
                                   required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="notes" class="form-label">Notes (Optional)</label>
                            <textarea class="form-control" id="notes" name="notes" rows="3"></textarea>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">Submit Payment</button>
                        <a href="<?php echo e(route('customer.orders.show', $orderId)); ?>" class="btn btn-secondary">Cancel</a>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Payment Instructions</h5>
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        Please complete your payment within 24 hours
                    </div>
                    <ul>
                        <li>Keep your payment receipt</li>
                        <li>You can upload payment proof after submission</li>
                        <li>Payment confirmation may take up to 2 hours</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\customer\payments\create.blade.php ENDPATH**/ ?>