

<?php $__env->startSection('title', 'Checkout - Chingu Bite'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <h1 class="mb-4">Checkout</h1>
    
    <?php if(session('error')): ?>
        <div class="alert alert-danger">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>
    
    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
    
    <div class="row">
        <div class="col-md-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Order Items</h5>
                </div>
                <div class="card-body">
                    <?php $__currentLoopData = $cartItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="d-flex align-items-center border-bottom py-3">
                            <img src="<?php echo e($item->menu->image ?? $item->menu->image_url ?? '/images/default-food.jpg'); ?>" 
                                 alt="<?php echo e($item->menu->name); ?>" 
                                 class="img-thumbnail me-3" 
                                 style="width: 60px; height: 60px; object-fit: cover;">
                            
                            <div class="flex-grow-1">
                                <h6 class="mb-1"><?php echo e($item->menu->name); ?></h6>
                                <p class="text-muted mb-0 small">
                                    Rp <?php echo e(number_format($item->menu->price, 0, ',', '.')); ?> x <?php echo e($item->quantity); ?>

                                </p>
                                <?php if($item->notes): ?>
                                    <p class="text-muted mb-0 small">Note: <?php echo e($item->notes); ?></p>
                                <?php endif; ?>
                            </div>
                            
                            <div class="text-end">
                                <strong>Rp <?php echo e(number_format($item->menu->price * $item->quantity, 0, ',', '.')); ?></strong>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Order Details</h5>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('customer.orders.store')); ?>" method="POST" id="checkoutForm">
                        <?php echo csrf_field(); ?>
                        
                        <div class="mb-3">
                            <label for="order_type" class="form-label">Order Type <span class="text-danger">*</span></label>
                            <select class="form-select" id="order_type" name="order_type" required>
                                <option value="">Select order type</option>
                                <option value="dine_in" <?php echo e(old('order_type') == 'dine_in' ? 'selected' : ''); ?>>Dine In</option>
                                <option value="takeaway" <?php echo e(old('order_type') == 'takeaway' ? 'selected' : ''); ?>>Takeaway</option>
                                <option value="delivery" <?php echo e(old('order_type') == 'delivery' ? 'selected' : ''); ?>>Delivery</option>
                            </select>
                        </div>
                        
                        <div class="mb-3" id="addressField" style="display: none;">
                            <label for="delivery_address" class="form-label">
                                Delivery Address <span class="text-danger" id="addressRequired">*</span>
                            </label>
                            <textarea class="form-control" id="delivery_address" name="delivery_address" rows="3" 
                                      placeholder="Enter complete delivery address"><?php echo e(old('delivery_address')); ?></textarea>
                            <small class="text-muted">Complete address with street name, number, and landmark</small>
                        </div>
                        
                        <div class="mb-3">
                            <label for="payment_method_id" class="form-label">Payment Method <span class="text-danger">*</span></label>
                            <select class="form-select" id="payment_method_id" name="payment_method_id" required>
                                <option value="">Select payment method</option>
                                <?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($method->id); ?>" <?php echo e(old('payment_method_id') == $method->id ? 'selected' : ''); ?>>
                                        <?php echo e($method->name); ?>

                                        <?php if($method->account_number): ?>
                                            - <?php echo e($method->account_number); ?>

                                        <?php endif; ?>
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label for="notes" class="form-label">Order Notes (Optional)</label>
                            <textarea class="form-control" id="notes" name="notes" rows="2" 
                                      placeholder="Special instructions for your order"><?php echo e(old('notes')); ?></textarea>
                        </div>
                        
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg" id="placeOrderBtn">
                                <i class="fas fa-check-circle me-2"></i> Place Order
                            </button>
                            <a href="<?php echo e(route('customer.cart.index')); ?>" class="btn btn-outline-secondary">
                                <i class="fas fa-arrow-left me-2"></i> Back to Cart
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card sticky-top" style="top: 20px;">
                <div class="card-header">
                    <h5 class="mb-0">Order Summary</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Subtotal:</span>
                        <span>Rp <?php echo e(number_format($subtotal, 0, ',', '.')); ?></span>
                    </div>
                    
                    <div class="d-flex justify-content-between mb-2">
                        <span>Tax (10%):</span>
                        <span>Rp <?php echo e(number_format($taxAmount, 0, ',', '.')); ?></span>
                    </div>
                    
                    <div class="d-flex justify-content-between mb-3">
                        <span>Service Fee:</span>
                        <span>Rp <?php echo e(number_format($serviceFee, 0, ',', '.')); ?></span>
                    </div>
                    
                    <hr>
                    
                    <div class="d-flex justify-content-between mb-3">
                        <strong>Total:</strong>
                        <strong class="text-primary">Rp <?php echo e(number_format($total, 0, ',', '.')); ?></strong>
                    </div>
                    
                    <div class="alert alert-info small mb-0">
                        <i class="fas fa-info-circle me-1"></i>
                        <strong>Note:</strong> Your order will be processed after payment confirmation.
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const orderTypeSelect = document.getElementById('order_type');
    const addressField = document.getElementById('addressField');
    const deliveryAddressInput = document.getElementById('delivery_address');
    const checkoutForm = document.getElementById('checkoutForm');
    
    // Show/hide address field based on order type
    function updateAddressField() {
        const orderType = orderTypeSelect.value;
        
        if (orderType === 'delivery') {
            // Show address field for delivery
            addressField.style.display = 'block';
            deliveryAddressInput.required = true;
            deliveryAddressInput.value = '<?php echo e(old("delivery_address")); ?>';
        } else {
            // Hide address field for dine_in and takeaway
            addressField.style.display = 'none';
            deliveryAddressInput.required = false;
            
            // Set default address value based on order type
            if (orderType === 'dine_in') {
                deliveryAddressInput.value = 'Chingu Bite Restaurant - Dine In';
            } else if (orderType === 'takeaway') {
                deliveryAddressInput.value = 'Chingu Bite Restaurant - Takeaway';
            } else {
                deliveryAddressInput.value = '';
            }
        }
    }
    
    orderTypeSelect.addEventListener('change', updateAddressField);
    
    // Trigger on page load if order type is already selected
    if (orderTypeSelect.value) {
        updateAddressField();
    }
    
    // Form submission
    checkoutForm.addEventListener('submit', function(e) {
        const btn = document.getElementById('placeOrderBtn');
        btn.disabled = true;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i> Processing...';
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\customer\orders\create.blade.php ENDPATH**/ ?>