
<?php $__env->startSection('title', 'My Orders'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <!-- Page Header -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h1 class="h3 mb-2">My Orders</h1>
                    <p class="text-muted mb-0">Track and manage your food orders</p>
                </div>
                <a href="<?php echo e(route('customer.dashboard')); ?>" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-1"></i> Back to Dashboard
                </a>
            </div>
        </div>
    </div>

    <?php if(isset($apiError)): ?>
        <div class="alert alert-warning">
            <i class="fas fa-exclamation-triangle me-2"></i>
            Using sample data. API Error: <?php echo e($apiError); ?>

        </div>
    <?php endif; ?>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-md-3 mb-3">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Orders
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($stats['total'] ?? 0); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-shopping-bag fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Completed
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($stats['completed'] ?? 0); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Pending
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($stats['pending'] ?? 0); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 mb-3">
            <div class="card border-left-danger shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                Cancelled
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($stats['cancelled'] ?? 0); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Orders Table -->
    <div class="card shadow">
        <div class="card-header bg-white py-3">
            <h5 class="mb-0">Order History</h5>
        </div>
        <div class="card-body">
            <?php if($orders->count() > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Order #</th>
                                <th>Date</th>
                                <th>Items</th>
                                <th>Total</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <strong><?php echo e($order->order_number); ?></strong>
                                    </td>
                                    <td>
                                        <?php echo e($order->created_at->format('M d, Y')); ?><br>
                                        <small class="text-muted"><?php echo e($order->created_at->format('H:i')); ?></small>
                                    </td>
                                    <td>
                                        <?php if($order->items->count() > 0): ?>
                                            <?php
                                                $itemCount = $order->items->count();
                                                $firstItem = $order->items->first()->menu->name ?? 'Item';
                                            ?>
                                            <?php echo e($firstItem); ?>

                                            <?php if($itemCount > 1): ?>
                                                <span class="badge bg-secondary">+<?php echo e($itemCount - 1); ?></span>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <span class="text-muted">No items</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <strong>Rp <?php echo e(number_format($order->final_amount, 0, ',', '.')); ?></strong>
                                    </td>
                                    <td>
                                        <?php
                                            $statusColor = $statusColors[$order->status] ?? 'secondary';
                                            $statusText = str_replace('_', ' ', ucfirst($order->status));
                                        ?>
                                        <span class="badge bg-<?php echo e($statusColor); ?>"><?php echo e($statusText); ?></span>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('customer.orders.show', $order->id)); ?>" 
                                               class="btn btn-sm btn-outline-primary" title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <?php if(in_array($order->status, ['pending', 'confirmed'])): ?>
                                                <form action="<?php echo e(route('customer.orders.cancel', $order->id)); ?>" method="POST" class="d-inline" 
                                                      onsubmit="return confirm('Are you sure you want to cancel this order?')">
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" class="btn btn-sm btn-outline-danger" title="Cancel Order">
                                                        <i class="fas fa-times"></i>
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                <div class="mt-3">
                    <?php echo e($orders->links()); ?>

                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-shopping-bag fa-3x text-muted mb-3"></i>
                    <h5>No orders yet</h5>
                    <p class="text-muted">You haven't placed any orders yet.</p>
                    <a href="<?php echo e(route('menu.public')); ?>" class="btn btn-primary mt-2">
                        <i class="fas fa-utensils me-2"></i>Browse Menu
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Order Status Legend -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header bg-light">
                    <h6 class="mb-0">Order Status Guide</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-2 col-6 mb-2">
                            <span class="badge bg-warning">Pending</span>
                            <small class="d-block text-muted">Order received</small>
                        </div>
                        <div class="col-md-2 col-6 mb-2">
                            <span class="badge bg-info">Processing</span>
                            <small class="d-block text-muted">Preparing order</small>
                        </div>
                        <div class="col-md-2 col-6 mb-2">
                            <span class="badge bg-primary">Preparing</span>
                            <small class="d-block text-muted">Cooking in progress</small>
                        </div>
                        <div class="col-md-2 col-6 mb-2">
                            <span class="badge bg-success">Ready</span>
                            <small class="d-block text-muted">Ready for pickup</small>
                        </div>
                        <div class="col-md-2 col-6 mb-2">
                            <span class="badge bg-info">On Delivery</span>
                            <small class="d-block text-muted">Out for delivery</small>
                        </div>
                        <div class="col-md-2 col-6 mb-2">
                            <span class="badge bg-success">Completed</span>
                            <small class="d-block text-muted">Order delivered</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Cancel Order Modal -->
<div class="modal fade" id="cancelOrderModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cancel Order</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to cancel this order?</p>
                <p class="text-muted"><small>Note: Orders can only be cancelled within 15 minutes of placement.</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">No, Keep Order</button>
                <form id="cancelOrderForm" method="POST" action="">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-danger">Yes, Cancel Order</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function confirmCancel(orderId) {
    const form = document.getElementById('cancelOrderForm');
    form.action = "<?php echo e(route('customer.orders.cancel', ':id')); ?>".replace(':id', orderId);
    
    const modal = new bootstrap.Modal(document.getElementById('cancelOrderModal'));
    modal.show();
}

setTimeout(() => {
    const hasActiveOrders = <?php echo e(collect($orders)->whereIn('status', ['pending', 'processing', 'preparing', 'ready', 'on_delivery'])->count() > 0 ? 'true' : 'false'); ?>;
    if (hasActiveOrders) {
        window.location.reload();
    }
}, 30000);
</script>

<style>
.table-hover tbody tr:hover {
    background-color: rgba(78, 115, 223, 0.05);
}

.badge {
    font-size: 0.8em;
    padding: 0.4em 0.8em;
}

.page-item.active .page-link {
    background-color: #4e73df;
    border-color: #4e73df;
}

.card {
    border: 1px solid #e3e6f0;
    border-radius: 10px;
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\customer\orders\index.blade.php ENDPATH**/ ?>