


<?php $__env->startSection('title', 'Payment Confirmations - Chingu Bite'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">Payment Confirmations</h1>
        <div class="d-flex">
            <button type="button" class="btn btn-primary me-2" data-bs-toggle="modal" data-bs-target="#filterModal">
                <i class="fas fa-filter me-1"></i>Filter
            </button>
            <a href="<?php echo e(route('employee.payments.index')); ?>?status=waiting_confirmation" 
               class="btn btn-warning position-relative">
                <i class="fas fa-clock me-1"></i>Pending
                <?php if($pendingCount ?? 0 > 0): ?>
                    <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                        <?php echo e($pendingCount); ?>

                    </span>
                <?php endif; ?>
            </a>
        </div>
    </div>

    <!-- Filter Modal -->
    <div class="modal fade" id="filterModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Filter Payments</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form method="GET" action="<?php echo e(route('employee.payments.index')); ?>">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Status</label>
                            <select name="status" class="form-select">
                                <option value="">All Status</option>
                                <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($status); ?>" <?php echo e(request('status') == $status ? 'selected' : ''); ?>>
                                        <?php echo e(ucfirst(str_replace('_', ' ', $status))); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Date Range</label>
                            <div class="row">
                                <div class="col-md-6">
                                    <input type="date" name="start_date" class="form-control" 
                                           value="<?php echo e(request('start_date')); ?>" placeholder="Start Date">
                                </div>
                                <div class="col-md-6">
                                    <input type="date" name="end_date" class="form-control" 
                                           value="<?php echo e(request('end_date')); ?>" placeholder="End Date">
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Search</label>
                            <input type="text" name="search" class="form-control" 
                                   value="<?php echo e(request('search')); ?>" placeholder="Order #, Customer Name...">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Apply Filters</button>
                        <a href="<?php echo e(route('employee.payments.index')); ?>" class="btn btn-outline-danger">Clear</a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Waiting Confirmation
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($waitingCount ?? 0); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Confirmed Today
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($confirmedToday ?? 0); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-danger shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                Failed Today
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($failedToday ?? 0); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Total Amount
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                Rp <?php echo e(number_format($totalAmount ?? 0, 0, ',', '.')); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-money-bill-wave fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Payments Table -->
    <div class="card shadow">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Payment ID</th>
                            <th>Order #</th>
                            <th>Customer</th>
                            <th>Method</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Proof</th>
                            <th>Submitted</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <strong>#<?php echo e($payment['id']); ?></strong>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('employee.orders.show', $payment['order_id'])); ?>">
                                        #<?php echo e($payment['order']['order_number'] ?? 'N/A'); ?>

                                    </a>
                                </td>
                                <td>
                                    <?php echo e($payment['order']['customer']['name'] ?? 'Guest'); ?>

                                    <br><small class="text-muted"><?php echo e($payment['order']['customer']['phone'] ?? ''); ?></small>
                                </td>
                                <td>
                                    <span class="badge bg-secondary">
                                        <?php echo e($payment['payment_method']['name'] ?? 'Unknown'); ?>

                                    </span>
                                </td>
                                <td>
                                    <strong>Rp <?php echo e(number_format($payment['amount'], 0, ',', '.')); ?></strong>
                                </td>
                                <td>
                                    <?php
                                        $statusColors = [
                                            'pending' => 'warning',
                                            'waiting_confirmation' => 'info',
                                            'confirmed' => 'success',
                                            'failed' => 'danger',
                                            'refunded' => 'secondary'
                                        ];
                                    ?>
                                    <span class="badge bg-<?php echo e($statusColors[$payment['status']] ?? 'light'); ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $payment['status']))); ?>

                                    </span>
                                </td>
                                <td>
                                    <?php if($payment['proof_image']): ?>
                                        <a href="<?php echo e(asset('storage/' . $payment['proof_image'])); ?>" 
                                           target="_blank" class="btn btn-sm btn-outline-info">
                                            <i class="fas fa-eye"></i> View
                                        </a>
                                    <?php else: ?>
                                        <span class="text-muted">No proof</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo e(\Carbon\Carbon::parse($payment['created_at'])->format('H:i')); ?>

                                    <br><small class="text-muted"><?php echo e(\Carbon\Carbon::parse($payment['created_at'])->format('M d')); ?></small>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="<?php echo e(route('employee.payments.show', $payment['id'])); ?>" 
                                           class="btn btn-outline-primary" title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        
                                        <?php if($payment['status'] == 'waiting_confirmation'): ?>
                                            <button type="button" class="btn btn-outline-success confirm-btn" 
                                                    data-payment-id="<?php echo e($payment['id']); ?>" title="Confirm Payment">
                                                <i class="fas fa-check"></i>
                                            </button>
                                            <button type="button" class="btn btn-outline-danger reject-btn" 
                                                    data-payment-id="<?php echo e($payment['id']); ?>" title="Reject Payment">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        <?php endif; ?>
                                        
                                        <?php if($payment['status'] == 'confirmed'): ?>
                                            <button type="button" class="btn btn-outline-secondary" disabled
                                                    title="Payment Confirmed">
                                                <i class="fas fa-check-double"></i>
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="9" class="text-center py-5">
                                    <i class="fas fa-money-check fa-3x text-muted mb-3"></i>
                                    <h5 class="text-muted">No payments found</h5>
                                    <?php if(request()->hasAny(['status', 'search'])): ?>
                                        <p class="text-muted">Try adjusting your filters</p>
                                        <a href="<?php echo e(route('employee.payments.index')); ?>" class="btn btn-primary">
                                            Show All Payments
                                        </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            <?php if(isset($pagination)): ?>
            <div class="d-flex justify-content-between align-items-center mt-4">
                <div class="text-muted">
                    Showing <?php echo e(($pagination['current_page'] - 1) * $pagination['per_page'] + 1); ?> to 
                    <?php echo e(min($pagination['current_page'] * $pagination['per_page'], $pagination['total'])); ?> of 
                    <?php echo e($pagination['total']); ?> payments
                </div>
                <nav>
                    <ul class="pagination mb-0">
                        <li class="page-item <?php echo e($pagination['current_page'] == 1 ? 'disabled' : ''); ?>">
                            <a class="page-link" 
                               href="<?php echo e(route('employee.payments.index', array_merge($filters, ['page' => $pagination['current_page'] - 1]))); ?>">
                                Previous
                            </a>
                        </li>
                        
                        <?php for($i = 1; $i <= min($pagination['last_page'], 5); $i++): ?>
                            <li class="page-item <?php echo e($pagination['current_page'] == $i ? 'active' : ''); ?>">
                                <a class="page-link" 
                                   href="<?php echo e(route('employee.payments.index', array_merge($filters, ['page' => $i]))); ?>">
                                    <?php echo e($i); ?>

                                </a>
                            </li>
                        <?php endfor; ?>
                        
                        <?php if($pagination['last_page'] > 5): ?>
                            <li class="page-item disabled"><span class="page-link">...</span></li>
                            <li class="page-item">
                                <a class="page-link" 
                                   href="<?php echo e(route('employee.payments.index', array_merge($filters, ['page' => $pagination['last_page']]))); ?>">
                                    <?php echo e($pagination['last_page']); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        
                        <li class="page-item <?php echo e($pagination['current_page'] == $pagination['last_page'] ? 'disabled' : ''); ?>">
                            <a class="page-link" 
                               href="<?php echo e(route('employee.payments.index', array_merge($filters, ['page' => $pagination['current_page'] + 1]))); ?>">
                                Next
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Confirm Payment Modal -->
<div class="modal fade" id="confirmModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirm Payment</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="confirmForm" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <input type="hidden" name="payment_id" id="confirmPaymentId">
                    
                    <div class="mb-3">
                        <label for="confirmed_amount" class="form-label">Confirmed Amount *</label>
                        <input type="number" class="form-control" id="confirmed_amount" 
                               name="confirmed_amount" required step="100">
                    </div>
                    
                    <div class="mb-3">
                        <label for="reference_number" class="form-label">Reference Number</label>
                        <input type="text" class="form-control" id="reference_number" 
                               name="reference_number" placeholder="e.g., TRX123456">
                    </div>
                    
                    <div class="mb-3">
                        <label for="notes" class="form-label">Notes (Optional)</label>
                        <textarea class="form-control" id="notes" name="notes" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">Confirm Payment</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Reject Payment Modal -->
<div class="modal fade" id="rejectModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Reject Payment</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="rejectForm" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <input type="hidden" name="payment_id" id="rejectPaymentId">
                    
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        Are you sure you want to reject this payment?
                    </div>
                    
                    <div class="mb-3">
                        <label for="validation_notes" class="form-label">Reason for Rejection *</label>
                        <textarea class="form-control" id="validation_notes" name="validation_notes" 
                                  rows="4" required placeholder="Please provide reason for rejection..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Reject Payment</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Confirm payment button
        document.querySelectorAll('.confirm-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                const paymentId = this.dataset.paymentId;
                document.getElementById('confirmPaymentId').value = paymentId;
                document.getElementById('confirmForm').action = `/employee/payments/${paymentId}/confirm`;
                
                // Get payment amount for default value
                fetch(`/api/payments/${paymentId}`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.success && data.data) {
                            document.getElementById('confirmed_amount').value = data.data.amount;
                        }
                    });
                
                const modal = new bootstrap.Modal(document.getElementById('confirmModal'));
                modal.show();
            });
        });
        
        // Reject payment button
        document.querySelectorAll('.reject-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                const paymentId = this.dataset.paymentId;
                document.getElementById('rejectPaymentId').value = paymentId;
                document.getElementById('rejectForm').action = `/employee/payments/${paymentId}/validate`;
                
                const modal = new bootstrap.Modal(document.getElementById('rejectModal'));
                modal.show();
            });
        });
        
        // Auto refresh for waiting confirmation payments
        <?php if(request('status') == 'waiting_confirmation' || !request()->has('status')): ?>
            setInterval(() => {
                const shouldRefresh = !document.querySelector('.modal.show');
                if (shouldRefresh) {
                    location.reload();
                }
            }, 30000); // Refresh every 30 seconds
        <?php endif; ?>
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.employee', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\employee\payments\index.blade.php ENDPATH**/ ?>