
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title', 'Admin Dashboard - Chingu Bite'); ?></title>
    
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- DataTables -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <!-- Select2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" />
    <!-- Date Range Picker -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css">
    
    <!-- Custom CSS -->
    <style>
        :root {
            --primary-color: #4e73df;
            --primary-dark: #224abe;
            --secondary-color: #858796;
            --success-color: #1cc88a;
            --info-color: #36b9cc;
            --warning-color: #f6c23e;
            --danger-color: #e74a3b;
            --dark-color: #5a5c69;
            --light-color: #f8f9fc;
        }
        
        body {
            background-color: var(--light-color);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 0.9rem;
        }
        
        #wrapper {
            display: flex;
            min-height: 100vh;
        }
        
        /* Sidebar */
        #sidebar-wrapper {
            min-width: 250px;
            max-width: 250px;
            background: linear-gradient(180deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            color: white;
            transition: all 0.3s;
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
            z-index: 1000;
        }
        
        .sidebar-heading {
            padding: 1.5rem;
            background: rgba(0,0,0,0.1);
            font-size: 1.2rem;
            font-weight: 700;
        }
        
        .sidebar-heading img {
            height: 40px;
            margin-right: 10px;
        }
        
        .list-group-item {
            border: none;
            padding: 0.75rem 1.5rem;
            background: transparent;
            color: rgba(255,255,255,0.8);
            border-left: 4px solid transparent;
            transition: all 0.3s;
            text-decoration: none;
            cursor: pointer;
        }
        
        .list-group-item:hover,
        .list-group-item.active {
            background: rgba(255,255,255,0.1);
            color: white;
            border-left-color: var(--warning-color);
        }
        
        .list-group-item i {
            width: 20px;
            margin-right: 10px;
            text-align: center;
        }
        
        .submenu {
            padding-left: 2.5rem !important;
            font-size: 0.85rem;
            background: rgba(0,0,0,0.05) !important;
        }
        
        .submenu:hover {
            background: rgba(255,255,255,0.05) !important;
        }
        
        .dropdown-toggle::after {
            float: right;
            margin-top: 0.5rem;
        }
        
        /* Topbar */
        #topbar-wrapper {
            width: 100%;
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            z-index: 999;
            position: sticky;
            top: 0;
        }
        
        .navbar-toggler {
            border: none;
            font-size: 1.5rem;
            color: var(--dark-color);
            background: transparent;
        }
        
        .navbar-search {
            max-width: 400px;
        }
        
        .user-dropdown img {
            width: 40px;
            height: 40px;
            border-radius: 50%;
        }
        
        /* Main Content */
        #page-content-wrapper {
            flex: 1;
            display: flex;
            flex-direction: column;
            min-width: 0;
        }
        
        #content-wrapper {
            width: 100%;
            padding: 20px;
            overflow-x: auto;
            flex: 1;
        }
        
        /* Cards */
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0,0,0,0.05);
            margin-bottom: 1.5rem;
            transition: transform 0.2s;
        }
        
        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        
        .card-header {
            background: white;
            border-bottom: 1px solid #e3e6f0;
            font-weight: 600;
            padding: 1rem 1.25rem;
        }
        
        .card-body {
            padding: 1.25rem;
        }
        
        /* Stats Cards */
        .stat-card {
            border-left: 4px solid;
        }
        
        .stat-card.border-primary {
            border-left-color: var(--primary-color);
        }
        
        .stat-card.border-success {
            border-left-color: var(--success-color);
        }
        
        .stat-card.border-warning {
            border-left-color: var(--warning-color);
        }
        
        .stat-card.border-danger {
            border-left-color: var(--danger-color);
        }
        
        .stat-card .stat-value {
            font-size: 1.8rem;
            font-weight: 700;
            margin-bottom: 0.25rem;
        }
        
        .stat-card .stat-label {
            color: var(--secondary-color);
            font-size: 0.85rem;
        }
        
        /* Buttons */
        .btn-primary {
            background: var(--primary-color);
            border: none;
            padding: 0.5rem 1.5rem;
            border-radius: 8px;
            font-weight: 500;
        }
        
        .btn-primary:hover {
            background: var(--primary-dark);
        }
        
        .btn-sm {
            padding: 0.25rem 0.75rem;
            font-size: 0.875rem;
        }
        
        /* Tables */
        .table {
            border-radius: 8px;
            overflow: hidden;
            margin-bottom: 0;
        }
        
        .table thead th {
            background: #f8f9fc;
            border-bottom: 2px solid #e3e6f0;
            font-weight: 600;
            color: var(--dark-color);
            padding: 0.75rem 1rem;
            white-space: nowrap;
        }
        
        .table tbody td {
            padding: 0.75rem 1rem;
            vertical-align: middle;
        }
        
        /* Badges */
        .badge {
            padding: 0.35em 0.65em;
            font-size: 0.75em;
            border-radius: 10rem;
            font-weight: 600;
        }
        
        /* Status Badges */
        .badge-status-pending {
            background-color: #f8f9fa;
            color: #6c757d;
            border: 1px solid #dee2e6;
        }
        
        .badge-status-processing {
            background-color: #cfe2ff;
            color: #084298;
            border: 1px solid #9ec5fe;
        }
        
        .badge-status-completed {
            background-color: #d1e7dd;
            color: #0a3622;
            border: 1px solid #a3cfbb;
        }
        
        .badge-status-cancelled {
            background-color: #f8d7da;
            color: #58151c;
            border: 1px solid #f1aeb5;
        }
        
        /* Charts */
        .chart-container {
            position: relative;
            height: 300px;
            width: 100%;
        }
        
        /* Forms */
        .form-control, .form-select {
            border: 1px solid #e3e6f0;
            border-radius: 8px;
            padding: 0.5rem 0.75rem;
            font-size: 0.9rem;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(78, 115, 223, 0.25);
        }
        
        /* Alerts */
        .alert {
            border: none;
            border-radius: 8px;
            padding: 1rem 1.25rem;
        }
        
        /* Pagination */
        .pagination {
            justify-content: flex-end;
        }
        
        .page-link {
            border: 1px solid #e3e6f0;
            color: var(--primary-color);
        }
        
        .page-item.active .page-link {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }
        
        /* Modal */
        .modal-content {
            border-radius: 10px;
            border: none;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            #sidebar-wrapper {
                margin-left: -250px;
                position: fixed;
                height: 100vh;
                overflow-y: auto;
            }
            
            #sidebar-wrapper.toggled {
                margin-left: 0;
            }
            
            #content-wrapper {
                padding: 15px;
            }
            
            .stat-card .stat-value {
                font-size: 1.5rem;
            }
            
            .navbar-search {
                max-width: 250px;
            }
        }
        
        @media (max-width: 576px) {
            .card-body {
                padding: 1rem;
            }
            
            .table-responsive {
                font-size: 0.85rem;
            }
        }
        
        /* Animation */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .fade-in {
            animation: fadeIn 0.3s ease-in-out;
        }
        
        /* Loading */
        .loading {
            opacity: 0.7;
            pointer-events: none;
        }
        
        /* Print styles */
        @media print {
            #sidebar-wrapper, #topbar-wrapper, .btn {
                display: none !important;
            }
            
            #content-wrapper {
                padding: 0;
                margin: 0;
            }
            
            .card {
                box-shadow: none;
                border: 1px solid #dee2e6;
            }
        }
        
        /* Custom scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }
        
        ::-webkit-scrollbar-track {
            background: #f1f1f1;
            border-radius: 4px;
        }
        
        ::-webkit-scrollbar-thumb {
            background: #c1c1c1;
            border-radius: 4px;
        }
        
        ::-webkit-scrollbar-thumb:hover {
            background: #a8a8a8;
        }
    </style>
    
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <div id="wrapper">
        <!-- Sidebar -->
        <div id="sidebar-wrapper" class="d-flex flex-column">
            <div class="sidebar-heading d-flex align-items-center">
                <i class="fas fa-crown fa-2x me-2"></i>
                <span>Chingu Bite<br><small class="fs-6 fw-normal">Admin Panel</small></span>
            </div>
            
            <div class="list-group list-group-flush flex-grow-1">
                <!-- Dashboard -->
                <a href="<?php echo e(url('admin/dashboard')); ?>" 
                   class="list-group-item list-group-item-action <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>">
                    <i class="fas fa-tachometer-alt"></i>
                    Dashboard
                </a>
                
                <!-- Payment Methods -->
                <a href="<?php echo e(url('admin/payment-methods/index')); ?>" 
                   class="list-group-item list-group-item-action <?php echo e(request()->routeIs('admin.payment-methods.*') ? 'active' : ''); ?>">
                    <i class="fas fa-credit-card"></i>
                    Payment Methods
                </a>
                
                <!-- Menu Management -->
<div class="dropdown">
    <a class="list-group-item list-group-item-action dropdown-toggle <?php echo e(request()->is('admin/menu*') ? 'active' : ''); ?>" 
       data-bs-toggle="dropdown" href="#">
        <i class="fas fa-utensils"></i>
        Menu Management
    </a>
    <div class="dropdown-menu">
        <a class="dropdown-item <?php echo e(request()->routeIs('admin.menu.index') ? 'active' : ''); ?>" 
           href="<?php echo e(url('admin/menu/index')); ?>">
            <i class="fas fa-list me-2"></i>All Menu Items
        </a>
        <a class="dropdown-item <?php echo e(request()->routeIs('admin.menu.create') ? 'active' : ''); ?>" 
           href="<?php echo e(url('admin/menu/create')); ?>">
            <i class="fas fa-plus me-2"></i>Add New Menu
        </a>
        
        
        
        
        
        <a class="dropdown-item" href="#">
            <i class="fas fa-tags me-2"></i>Categories (Coming Soon)
        </a>
        
        
        
        
        
        <a class="dropdown-item" href="#">
            <i class="fas fa-star me-2"></i>Special Menu (Coming Soon)
        </a>
        <a class="dropdown-item" href="#">
            <i class="fas fa-fire me-2"></i>Best Sellers (Coming Soon)
        </a>
    </div>
</div>
                
                <!-- Promotions -->
                <div class="dropdown">
                    <a class="list-group-item list-group-item-action dropdown-toggle <?php echo e(request()->is('admin/promos*') ? 'active' : ''); ?>" 
                       data-bs-toggle="dropdown" href="#">
                        <i class="fas fa-tag"></i>
                        Promotions
                    </a>
                    <div class="dropdown-menu">
                        <a class="dropdown-item <?php echo e(request()->routeIs('admin.promos.index') ? 'active' : ''); ?>" 
                           href="<?php echo e(url('admin/promos/index')); ?>">
                            <i class="fas fa-list me-2"></i>All Promotions
                        </a>
                        <a class="dropdown-item <?php echo e(request()->routeIs('admin.promos.create') ? 'active' : ''); ?>" 
                           href="<?php echo e(url('admin/promos/create')); ?>">
                            <i class="fas fa-plus me-2"></i>Create Promotion
                        </a>
                        <a class="dropdown-item <?php echo e(request()->routeIs('admin.promos.active') ? 'active' : ''); ?>" 
                           href="<?php echo e(url('admin/promos/active')); ?>">
                            <i class="fas fa-play-circle me-2"></i>Active Promos
                        </a>
                        <a class="dropdown-item <?php echo e(request()->routeIs('admin.promos.expired') ? 'active' : ''); ?>" 
                           href="<?php echo e(url('admin/promos/expired')); ?>">
                            <i class="fas fa-stop-circle me-2"></i>Expired Promos
                        </a>
                    </div>
                </div>
                
                <!-- Career Management -->
                <div class="dropdown">
                    <a class="list-group-item list-group-item-action dropdown-toggle <?php echo e(request()->is('admin/careers*') ? 'active' : ''); ?>" 
                       data-bs-toggle="dropdown" href="#">
                        <i class="fas fa-briefcase"></i>
                        Careers
                    </a>
                    <div class="dropdown-menu">
                        <a class="dropdown-item <?php echo e(request()->routeIs('admin.careers.index') ? 'active' : ''); ?>" 
                           href="<?php echo e(url('admin/careers/index')); ?>">
                            <i class="fas fa-list me-2"></i>Job Postings
                        </a>
                        <a class="dropdown-item <?php echo e(request()->routeIs('admin.careers.create') ? 'active' : ''); ?>" 
                           href="<?php echo e(url('admin/careers/create')); ?>">
                            <i class="fas fa-plus me-2"></i>Create Job Posting
                        </a>
                        <a class="dropdown-item <?php echo e(request()->routeIs('admin.career-applications.index') ? 'active' : ''); ?>" 
                           href="<?php echo e(url('admin/career-applications/index')); ?>">
                            <i class="fas fa-file-alt me-2"></i>Applications
                            <?php if($newApplicationsCount ?? 0 > 0): ?>
                                <span class="badge bg-danger float-end"><?php echo e($newApplicationsCount); ?></span>
                            <?php endif; ?>
                        </a>
                        <a class="dropdown-item <?php echo e(request()->routeIs('admin.career-applications.reviewed') ? 'active' : ''); ?>" 
                           href="<?php echo e(url('admin/career-applications/reviewed')); ?>">
                            <i class="fas fa-check me-2"></i>Reviewed
                        </a>
                    </div>
                </div>
                
                <!-- Users Management -->
                <div class="dropdown">
                    <a class="list-group-item list-group-item-action dropdown-toggle <?php echo e(request()->is('admin/users*') ? 'active' : ''); ?>" 
                       data-bs-toggle="dropdown" href="#">
                        <i class="fas fa-users"></i>
                        Users
                    </a>
                    <div class="dropdown-menu">
                        <a class="dropdown-item <?php echo e(request()->routeIs('admin.users.index') ? 'active' : ''); ?>" 
                           href="<?php echo e(url('admin/users/index')); ?>">
                            <i class="fas fa-users me-2"></i>All Users
                        </a>
                        <a class="dropdown-item <?php echo e(request()->routeIs('admin.customers.index') ? 'active' : ''); ?>" 
                           href="<?php echo e(url('admin/customers/index')); ?>">
                            <i class="fas fa-user-friends me-2"></i>Customers
                        </a>
                        <a class="dropdown-item <?php echo e(request()->routeIs('admin.employees.index') ? 'active' : ''); ?>" 
                           href="<?php echo e(url('admin/employees/index')); ?>">
                            <i class="fas fa-user-tie me-2"></i>Employees
                        </a>
                        <a class="dropdown-item <?php echo e(request()->routeIs('admin.users.create') ? 'active' : ''); ?>" 
                           href="<?php echo e(url('admin/users/create')); ?>">
                            <i class="fas fa-user-plus me-2"></i>Add New User
                        </a>
                    </div>
                </div>
                
<!-- Reports Dropdown - Perbaiki route yang belum ada -->
<div class="dropdown">
    <a class="list-group-item list-group-item-action dropdown-toggle <?php echo e(request()->is('admin/reports*') ? 'active' : ''); ?>" 
       data-bs-toggle="dropdown" href="#">
        <i class="fas fa-chart-bar"></i>
        Reports
    </a>
    <div class="dropdown-menu">
        <a class="dropdown-item <?php echo e(request()->routeIs('admin.reports.sales') ? 'active' : ''); ?>" 
           href="<?php echo e(url('admin/reports/sales')); ?>">
            <i class="fas fa-chart-line me-2"></i>Sales Reports
        </a>
        <a class="dropdown-item <?php echo e(request()->routeIs('admin.reports.finance') ? 'active' : ''); ?>" 
           href="<?php echo e(url('admin/reports/finance')); ?>">
            <i class="fas fa-money-bill-wave me-2"></i>Finance Reports
        </a>
        <a class="dropdown-item <?php echo e(request()->routeIs('admin.reports.performance') ? 'active' : ''); ?>" 
           href="<?php echo e(url('admin/reports/performance')); ?>">
            <i class="fas fa-chart-pie me-2"></i>Employee Performance
        </a>
        
        
        
        
        
        <a class="dropdown-item" href="#">
            <i class="fas fa-boxes me-2"></i>Inventory Reports (Coming Soon)
        </a>
        <a class="dropdown-item" href="#">
            <i class="fas fa-user-chart me-2"></i>Customer Analytics (Coming Soon)
        </a>
    </div>
</div>

<!-- System Settings Dropdown - Perbaiki -->
<div class="dropdown">
    <a class="list-group-item list-group-item-action dropdown-toggle <?php echo e(request()->is('admin/settings*') ? 'active' : ''); ?>" 
       data-bs-toggle="dropdown" href="#">
        <i class="fas fa-cog"></i>
        System Settings
    </a>
    <div class="dropdown-menu">
        
        <a class="dropdown-item <?php echo e(request()->routeIs('admin.settings.index') ? 'active' : ''); ?>" 
           href="<?php echo e(url('admin/settings/index')); ?>">
            <i class="fas fa-sliders-h me-2"></i>General Settings
        </a>
        
        
        
        
        
        <a class="dropdown-item" href="#">
            <i class="fas fa-clock me-2"></i>Operational Hours (Coming Soon)
        </a>
        <a class="dropdown-item" href="#">
            <i class="fas fa-percentage me-2"></i>Tax & Fees (Coming Soon)
        </a>
    </div>
</div>
</div>
            
            <!-- Sidebar Footer -->
            <div class="sidebar-footer p-3 border-top">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <small class="text-light"><?php echo e(Auth::user()->name ?? 'Admin'); ?></small>
                        <div class="small text-white-50"><?php echo e(Auth::user()->email ?? 'admin@chingubite.com'); ?></div>
                        <div class="small text-white-50">
                            <i class="fas fa-user-shield me-1"></i> <?php echo e(ucfirst(Auth::user()->role ?? 'admin')); ?>

                        </div>
                    </div>
                    <div class="dropdown">
                        <button class="btn btn-sm btn-outline-light dropdown-toggle" 
                                type="button" data-bs-toggle="dropdown">
                            <i class="fas fa-cog"></i>
                        </button>
                        <div class="dropdown-menu dropdown-menu-end">
                            <a class="dropdown-item" href="<?php echo e(url('admin/profile')); ?>">
                                <i class="fas fa-user-cog me-2"></i>My Profile
                            </a>
                            <a class="dropdown-item" href="<?php echo e(url('admin/settings/general')); ?>">
                                <i class="fas fa-sliders-h me-2"></i>Settings
                            </a>
                            <div class="dropdown-divider"></div>
                            <form method="POST" action="<?php echo e(url('logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="dropdown-item text-danger">
                                    <i class="fas fa-sign-out-alt me-2"></i>Logout
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Page Content -->
        <div id="page-content-wrapper">
            <!-- Topbar -->
            <nav id="topbar-wrapper" class="navbar navbar-expand-lg">
                <div class="container-fluid">
                    <button class="btn btn-outline-secondary" id="sidebarToggle">
                        <i class="fas fa-bars"></i>
                    </button>
                    
                    <!-- Breadcrumb -->
                    <nav aria-label="breadcrumb" class="ms-3">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('admin/dashboard')); ?>">Dashboard</a></li>
                            <?php echo $__env->yieldContent('breadcrumb'); ?>
                        </ol>
                    </nav>
                    
                    <!-- Topbar Right -->
                    <div class="d-flex align-items-center ms-auto">
                        <!-- Quick Stats -->
                        <div class="d-none d-md-flex me-3">
                            <div class="text-end">
                                <div class="small text-muted">Today's Sales</div>
                                <div class="fw-bold text-success">Rp <?php echo e(number_format($todaySales ?? 0, 0, ',', '.')); ?></div>
                            </div>
                        </div>
                        
                        <!-- Notifications -->
                        <div class="dropdown me-3">
                            <button class="btn btn-outline-secondary position-relative" 
                                    type="button" data-bs-toggle="dropdown">
                                <i class="fas fa-bell"></i>
                                <?php if($notificationCount ?? 0 > 0): ?>
                                    <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                                        <?php echo e($notificationCount > 9 ? '9+' : $notificationCount); ?>

                                    </span>
                                <?php endif; ?>
                            </button>
                            <div class="dropdown-menu dropdown-menu-end" style="min-width: 300px;">
                                <h6 class="dropdown-header">Notifications</h6>
                                
                                <?php $__empty_1 = true; $__currentLoopData = $notifications ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <a class="dropdown-item" href="<?php echo e($notification['link'] ?? '#'); ?>">
                                        <div class="d-flex">
                                            <div class="flex-shrink-0">
                                                <i class="fas <?php echo e($notification['icon'] ?? 'fa-bell'); ?> <?php echo e($notification['color'] ?? 'text-primary'); ?>"></i>
                                            </div>
                                            <div class="flex-grow-1 ms-3">
                                                <div class="small"><?php echo e($notification['title']); ?></div>
                                                <small class="text-muted"><?php echo e($notification['time']); ?></small>
                                            </div>
                                        </div>
                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="dropdown-item text-center text-muted py-3">
                                        <i class="fas fa-bell-slash fa-2x mb-2"></i>
                                        <div>No new notifications</div>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item text-center" href="<?php echo e(url('admin/notifications')); ?>">
                                    View all notifications
                                </a>
                            </div>
                        </div>
                        
                        <!-- User Menu -->
                        <div class="user-dropdown dropdown">
                            <button class="btn btn-outline-secondary dropdown-toggle d-flex align-items-center" 
                                    type="button" data-bs-toggle="dropdown">
                                <img src="<?php echo e(Auth::user()->avatar_url ?? 'https://ui-avatars.com/api/?name=' . urlencode(Auth::user()->name ?? 'Admin') . '&background=4e73df&color=fff'); ?>" 
                                     alt="<?php echo e(Auth::user()->name ?? 'Admin'); ?>" 
                                     class="me-2 rounded-circle" 
                                     style="width: 32px; height: 32px;">
                                <span class="d-none d-md-inline"><?php echo e(Auth::user()->name ?? 'Admin'); ?></span>
                            </button>
                            <div class="dropdown-menu dropdown-menu-end">
                                <div class="dropdown-header">
                                    <div class="fw-bold"><?php echo e(Auth::user()->name ?? 'Admin'); ?></div>
                                    <small class="text-muted"><?php echo e(Auth::user()->email ?? 'admin@chingubite.com'); ?></small>
                                </div>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="<?php echo e(url('admin/profile')); ?>">
                                    <i class="fas fa-user-cog me-2"></i>Profile Settings
                                </a>
                                <a class="dropdown-item" href="<?php echo e(url('admin/settings/general')); ?>">
                                    <i class="fas fa-cog me-2"></i>System Settings
                                </a>
                                <div class="dropdown-divider"></div>
                                <form method="POST" action="<?php echo e(url('logout')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="dropdown-item text-danger">
                                        <i class="fas fa-sign-out-alt me-2"></i>Logout
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </nav>
            
            <!-- Main Content -->
            <div id="content-wrapper" class="fade-in">
                <!-- Flash Messages -->
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i> <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i> <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <?php if(session('warning')): ?>
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-triangle me-2"></i> <?php echo e(session('warning')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <?php if($errors->any()): ?>
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        <ul class="mb-0">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <!-- Page Title -->
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div>
                        <h1 class="h3 mb-0 text-gray-800">
                            <i class="fas <?php echo $__env->yieldContent('icon', 'fa-tachometer-alt'); ?> me-2"></i>
                            <?php echo $__env->yieldContent('page_title', 'Dashboard'); ?>
                        </h1>
                        <p class="text-muted mb-0"><?php echo $__env->yieldContent('page_description', 'Admin dashboard overview'); ?></p>
                    </div>
                    
                    <div class="d-flex">
                        <?php echo $__env->yieldContent('page_actions'); ?>
                        
                        <!-- Date Range Selector -->
                        <?php if (! empty(trim($__env->yieldContent('date_range_selector')))): ?>
                            <div class="ms-2">
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-calendar"></i></span>
                                    <input type="text" class="form-control date-range-picker" 
                                           id="dateRange" placeholder="Select date range">
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Print Button -->
                        <?php if (! empty(trim($__env->yieldContent('print_button')))): ?>
                            <button class="btn btn-outline-secondary ms-2" onclick="window.print()">
                                <i class="fas fa-print me-1"></i> Print
                            </button>
                        <?php endif; ?>
                        
                        <!-- Export Button -->
                        <?php if (! empty(trim($__env->yieldContent('export_button')))): ?>
                            <div class="dropdown ms-2">
                                <button class="btn btn-outline-primary dropdown-toggle" type="button" 
                                        data-bs-toggle="dropdown">
                                    <i class="fas fa-download me-1"></i> Export
                                </button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="#" onclick="exportData('csv')">
                                        <i class="fas fa-file-csv me-2"></i> CSV
                                    </a>
                                    <a class="dropdown-item" href="#" onclick="exportData('excel')">
                                        <i class="fas fa-file-excel me-2"></i> Excel
                                    </a>
                                    <a class="dropdown-item" href="#" onclick="exportData('pdf')">
                                        <i class="fas fa-file-pdf me-2"></i> PDF
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Page Content -->
                <?php echo $__env->yieldContent('content'); ?>
                
                <!-- Footer -->
                <footer class="mt-5 pt-3 border-top">
                    <div class="row">
                        <div class="col-md-6">
                            <p class="text-muted small mb-0">
                                &copy; <?php echo e(date('Y')); ?> Chingu Bite. All rights reserved.
                            </p>
                        </div>
                        <div class="col-md-6 text-end">
                            <p class="text-muted small mb-0">
                                <i class="fas fa-server me-1"></i> Server: <?php echo e(gethostname()); ?>

                                | <i class="fas fa-clock me-1"></i> 
                                <span class="current-time"><?php echo e(now()->format('l, F d, Y H:i:s')); ?></span>
                            </p>
                        </div>
                    </div>
                </footer>
            </div>
        </div>
    </div>
    
    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <!-- DataTables -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <!-- Select2 -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <!-- Date Range Picker -->
    <script src="https://cdn.jsdelivr.net/npm/moment@2.29.4/min/moment.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <!-- Custom Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Toggle sidebar
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebarWrapper = document.getElementById('sidebar-wrapper');
            
            if (sidebarToggle && sidebarWrapper) {
                sidebarToggle.addEventListener('click', function() {
                    sidebarWrapper.classList.toggle('toggled');
                });
            }
            
            // Initialize DataTables
            $('.data-table').DataTable({
                pageLength: 25,
                responsive: true,
                language: {
                    search: "_INPUT_",
                    searchPlaceholder: "Search...",
                    paginate: {
                        previous: "<i class='fas fa-chevron-left'></i>",
                        next: "<i class='fas fa-chevron-right'></i>"
                    }
                },
                dom: '<"row"<"col-md-6"l><"col-md-6"f>>rt<"row"<"col-md-6"i><"col-md-6"p>>',
                drawCallback: function() {
                    $('.dataTables_paginate .pagination').addClass('pagination-sm');
                }
            });
            
            // Initialize Select2
            $('.select2').select2({
                theme: 'bootstrap-5',
                width: '100%'
            });
            
            // Initialize Date Range Picker
            $('.date-range-picker').daterangepicker({
                opens: 'left',
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                },
                locale: {
                    format: 'YYYY-MM-DD',
                    separator: ' to ',
                    applyLabel: 'Apply',
                    cancelLabel: 'Cancel',
                    fromLabel: 'From',
                    toLabel: 'To',
                    customRangeLabel: 'Custom',
                    weekLabel: 'W',
                    daysOfWeek: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
                    monthNames: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'],
                    firstDay: 1
                },
                startDate: moment().subtract(29, 'days'),
                endDate: moment()
            });
            
            // Auto-hide alerts after 5 seconds
            setTimeout(() => {
                document.querySelectorAll('.alert').forEach(alert => {
                    const bsAlert = new bootstrap.Alert(alert);
                    bsAlert.close();
                });
            }, 5000);
            
            // Update time every second
            function updateTime() {
                const now = new Date();
                const options = { 
                    weekday: 'long', 
                    year: 'numeric', 
                    month: 'long', 
                    day: 'numeric',
                    hour: '2-digit',
                    minute: '2-digit',
                    second: '2-digit'
                };
                const timeElements = document.querySelectorAll('.current-time');
                timeElements.forEach(el => {
                    el.textContent = now.toLocaleDateString('en-US', options);
                });
            }
            
            updateTime();
            setInterval(updateTime, 1000);
            
            // Confirm delete
            window.confirmDelete = function(formId, message = 'Are you sure you want to delete this item?') {
                Swal.fire({
                    title: 'Confirm Delete',
                    text: message,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#e74a3b',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Yes, delete it!',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById(formId).submit();
                    }
                });
            };
            
            // Confirm action
            window.confirmAction = function(formId, title = 'Confirm Action', message = 'Are you sure?') {
                Swal.fire({
                    title: title,
                    text: message,
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonColor: '#4e73df',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Yes, proceed',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById(formId).submit();
                    }
                });
            };
            
            // Show loading
            window.showLoading = function(show = true) {
                if (show) {
                    document.body.classList.add('loading');
                } else {
                    document.body.classList.remove('loading');
                }
            };
            
            // Export data function
            window.exportData = function(format) {
                const table = $('.data-table').DataTable();
                let data, filename;
                
                switch(format) {
                    case 'csv':
                        data = table.buttons.exportData({
                            format: {
                                body: function ( data, row, column, node ) {
                                    return data;
                                }
                            }
                        });
                        filename = 'export.csv';
                        break;
                    case 'excel':
                        // Implement Excel export
                        alert('Excel export feature coming soon!');
                        return;
                    case 'pdf':
                        // Implement PDF export
                        alert('PDF export feature coming soon!');
                        return;
                }
                
                // For CSV export
                if (format === 'csv') {
                    let csvContent = "data:text/csv;charset=utf-8,";
                    data.header.forEach(header => {
                        csvContent += '"' + header + '",';
                    });
                    csvContent = csvContent.slice(0, -1) + "\n";
                    
                    data.body.forEach(row => {
                        row.forEach(cell => {
                            csvContent += '"' + cell + '",';
                        });
                        csvContent = csvContent.slice(0, -1) + "\n";
                    });
                    
                    const encodedUri = encodeURI(csvContent);
                    const link = document.createElement("a");
                    link.setAttribute("href", encodedUri);
                    link.setAttribute("download", filename);
                    document.body.appendChild(link);
                    link.click();
                    document.body.removeChild(link);
                }
            };
            
            // Image preview
            window.previewImage = function(input, previewId) {
                const preview = document.getElementById(previewId);
                const file = input.files[0];
                const reader = new FileReader();
                
                reader.onloadend = function() {
                    preview.src = reader.result;
                    preview.style.display = 'block';
                };
                
                if (file) {
                    reader.readAsDataURL(file);
                } else {
                    preview.src = '';
                    preview.style.display = 'none';
                }
            };
            
            // Initialize tooltips
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            const tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
            
            // Initialize popovers
            const popoverTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="popover"]'));
            const popoverList = popoverTriggerList.map(function (popoverTriggerEl) {
                return new bootstrap.Popover(popoverTriggerEl);
            });
            
            // Form validation
            const forms = document.querySelectorAll('.needs-validation');
            Array.from(forms).forEach(form => {
                form.addEventListener('submit', event => {
                    if (!form.checkValidity()) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    form.classList.add('was-validated');
                }, false);
            });
            
            // Auto-save form data
            const autoSaveForms = document.querySelectorAll('.auto-save');
            autoSaveForms.forEach(form => {
                const inputs = form.querySelectorAll('input, textarea, select');
                const formId = form.id || 'form-' + Math.random().toString(36).substr(2, 9);
                
                inputs.forEach(input => {
                    const key = formId + '-' + input.name;
                    const savedValue = localStorage.getItem(key);
                    
                    if (savedValue !== null) {
                        if (input.type === 'checkbox') {
                            input.checked = savedValue === 'true';
                        } else if (input.type === 'radio') {
                            if (input.value === savedValue) {
                                input.checked = true;
                            }
                        } else {
                            input.value = savedValue;
                        }
                    }
                    
                    input.addEventListener('input', () => {
                        if (input.type === 'checkbox') {
                            localStorage.setItem(key, input.checked);
                        } else if (input.type === 'radio' && input.checked) {
                            localStorage.setItem(key, input.value);
                        } else {
                            localStorage.setItem(key, input.value);
                        }
                    });
                });
                
                form.addEventListener('submit', () => {
                    inputs.forEach(input => {
                        const key = formId + '-' + input.name;
                        localStorage.removeItem(key);
                    });
                });
            });
        });
        
        // AJAX helper function
        window.ajaxRequest = function(url, method = 'GET', data = null) {
            return new Promise((resolve, reject) => {
                showLoading(true);
                
                const options = {
                    method: method,
                    headers: {
                        'Content-Type': 'application/json',
                        'Accept': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
                    }
                };
                
                if (data) {
                    options.body = JSON.stringify(data);
                }
                
                fetch(url, options)
                    .then(response => {
                        showLoading(false);
                        if (!response.ok) {
                            throw new Error(`HTTP ${response.status}`);
                        }
                        return response.json();
                    })
                    .then(data => resolve(data))
                    .catch(error => {
                        showLoading(false);
                        Swal.fire({
                            icon: 'error',
                            title: 'Request Failed',
                            text: error.message || 'Something went wrong',
                            confirmButtonColor: '#e74a3b'
                        });
                        reject(error);
                    });
            });
        };
    </script>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\layouts\admin.blade.php ENDPATH**/ ?>