


<?php $__env->startSection('title', 'Employee Dashboard - Chingu Bite'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <!-- Welcome Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">Welcome, <?php echo e(auth()->user()->name); ?>!</h1>
            <p class="text-muted mb-0">Here's what needs your attention today</p>
        </div>
        <div class="d-flex align-items-center">
            <span class="me-3 text-muted">
                <i class="fas fa-calendar-alt me-1"></i>
                <?php echo e(now()->format('l, F j, Y')); ?>

            </span>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card employee-card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="rounded-circle bg-warning bg-opacity-10 p-3">
                                <i class="fas fa-clock fa-2x text-warning"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Pending Orders</h6>
                            <h2 class="mb-0" id="pending-orders-count">0</h2>
                        </div>
                    </div>
                    <div class="mt-3">
                        <a href="<?php echo e(route('employee.orders.index')); ?>?status=pending" class="text-decoration-none small">
                            View pending orders <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card employee-card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="rounded-circle bg-info bg-opacity-10 p-3">
                                <i class="fas fa-utensils fa-2x text-info"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Preparing Now</h6>
                            <h2 class="mb-0" id="preparing-orders-count">0</h2>
                        </div>
                    </div>
                    <div class="mt-3">
                        <a href="<?php echo e(route('employee.orders.index')); ?>?status=preparing" class="text-decoration-none small">
                            View kitchen orders <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card employee-card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="rounded-circle bg-danger bg-opacity-10 p-3">
                                <i class="fas fa-money-bill-wave fa-2x text-danger"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Pending Payments</h6>
                            <h2 class="mb-0" id="pending-payments-count">0</h2>
                        </div>
                    </div>
                    <div class="mt-3">
                        <a href="<?php echo e(route('employee.payments.index')); ?>" class="text-decoration-none small">
                            Confirm payments <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card employee-card">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="flex-shrink-0">
                            <div class="rounded-circle bg-success bg-opacity-10 p-3">
                                <i class="fas fa-check-circle fa-2x text-success"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1 ms-3">
                            <h6 class="text-muted mb-1">Ready for Pickup</h6>
                            <h2 class="mb-0" id="ready-orders-count">0</h2>
                        </div>
                    </div>
                    <div class="mt-3">
                        <a href="<?php echo e(route('employee.orders.index')); ?>?status=ready" class="text-decoration-none small">
                            View ready orders <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card employee-card">
                <div class="employee-card-header">
                    <h6 class="mb-0">
                        <i class="fas fa-bolt me-2 text-warning"></i>Quick Actions
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3 col-6 mb-3">
                            <a href="<?php echo e(route('employee.orders.index')); ?>?status=pending" class="quick-action-btn d-block text-decoration-none">
                                <i class="fas fa-clock"></i>
                                <h6 class="mt-2 mb-1">Pending Orders</h6>
                                <small class="text-muted">View & process</small>
                            </a>
                        </div>
                        <div class="col-md-3 col-6 mb-3">
                            <a href="<?php echo e(route('employee.payments.index')); ?>" class="quick-action-btn d-block text-decoration-none">
                                <i class="fas fa-money-check-alt"></i>
                                <h6 class="mt-2 mb-1">Confirm Payments</h6>
                                <small class="text-muted">Verify transactions</small>
                            </a>
                        </div>
                        <div class="col-md-3 col-6 mb-3">
                            <a href="<?php echo e(route('employee.orders.index')); ?>?status=preparing" class="quick-action-btn d-block text-decoration-none">
                                <i class="fas fa-utensils"></i>
                                <h6 class="mt-2 mb-1">Kitchen Orders</h6>
                                <small class="text-muted">Monitor preparation</small>
                            </a>
                        </div>
                        <div class="col-md-3 col-6 mb-3">
                            <a href="<?php echo e(route('employee.receipts.index')); ?>" class="quick-action-btn d-block text-decoration-none">
                                <i class="fas fa-receipt"></i>
                                <h6 class="mt-2 mb-1">Print Receipts</h6>
                                <small class="text-muted">Customer receipts</small>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Orders Table -->
    <div class="row">
        <div class="col-12">
            <div class="card employee-card">
                <div class="employee-card-header d-flex justify-content-between align-items-center">
                    <h6 class="mb-0">
                        <i class="fas fa-history me-2"></i>Recent Orders
                    </h6>
                    <a href="<?php echo e(route('employee.orders.index')); ?>" class="btn btn-sm btn-outline-primary">
                        View All <i class="fas fa-arrow-right ms-1"></i>
                    </a>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover employee-table">
                            <thead>
                                <tr>
                                    <th>Order #</th>
                                    <th>Customer</th>
                                    <th>Type</th>
                                    <th>Items</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Time</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody id="recent-orders-table">
                                <!-- Will be populated by JavaScript -->
                                <tr>
                                    <td colspan="8" class="text-center py-4">
                                        <div class="spinner-border spinner-border-sm text-primary" role="status">
                                            <span class="visually-hidden">Loading...</span>
                                        </div>
                                        <span class="ms-2">Loading recent orders...</span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Load dashboard data
        loadEmployeeDashboardData();
        
        // Auto-refresh every 30 seconds
        setInterval(loadEmployeeDashboardData, 30000);
        
        function loadEmployeeDashboardData() {
            // This would typically be API calls
            // For demo, using sample data
            
            // Sample data
            const dashboardData = {
                pendingOrders: 3,
                preparingOrders: 2,
                pendingPayments: 5,
                readyOrders: 1,
                recentOrders: [
                    {
                        id: 1,
                        order_number: 'ORD-2024-001',
                        customer: { name: 'John Doe' },
                        order_type: 'takeaway',
                        items_count: 3,
                        final_amount: 185000,
                        status: 'pending',
                        created_at: '2024-01-15 14:30:00'
                    },
                    {
                        id: 2,
                        order_number: 'ORD-2024-002',
                        customer: { name: 'Jane Smith' },
                        order_type: 'dine_in',
                        items_count: 2,
                        final_amount: 120000,
                        status: 'preparing',
                        created_at: '2024-01-15 14:25:00'
                    },
                    // Add more sample orders...
                ]
            };
            
            // Update stats
            document.getElementById('pending-orders-count').textContent = dashboardData.pendingOrders;
            document.getElementById('preparing-orders-count').textContent = dashboardData.preparingOrders;
            document.getElementById('pending-payments-count').textContent = dashboardData.pendingPayments;
            document.getElementById('ready-orders-count').textContent = dashboardData.readyOrders;
            
            // Update recent orders table
            updateRecentOrdersTable(dashboardData.recentOrders);
        }
        
        function updateRecentOrdersTable(orders) {
            const tbody = document.getElementById('recent-orders-table');
            
            if (orders.length === 0) {
                tbody.innerHTML = `
                    <tr>
                        <td colspan="8" class="text-center py-4">
                            <i class="fas fa-shopping-cart fa-2x text-muted mb-3"></i>
                            <p class="text-muted">No recent orders</p>
                        </td>
                    </tr>
                `;
                return;
            }
            
            let html = '';
            orders.forEach(order => {
                const statusClass = getStatusClass(order.status);
                const statusText = order.status.charAt(0).toUpperCase() + order.status.slice(1);
                const timeAgo = getTimeAgo(order.created_at);
                
                html += `
                    <tr>
                        <td><strong>${order.order_number}</strong></td>
                        <td>${order.customer.name}</td>
                        <td>
                            <span class="badge ${order.order_type === 'dine_in' ? 'bg-info' : 'bg-warning'}">
                                ${order.order_type === 'dine_in' ? 'Dine-in' : 'Takeaway'}
                            </span>
                        </td>
                        <td>${order.items_count} items</td>
                        <td>Rp ${order.final_amount.toLocaleString('id-ID')}</td>
                        <td>
                            <span class="status-badge ${statusClass}">${statusText}</span>
                        </td>
                        <td><small class="text-muted">${timeAgo}</small></td>
                        <td>
                            <a href="/employee/orders/${order.id}" class="btn btn-sm btn-outline-primary">
                                <i class="fas fa-eye"></i>
                            </a>
                        </td>
                    </tr>
                `;
            });
            
            tbody.innerHTML = html;
        }
        
        function getStatusClass(status) {
            const classes = {
                'pending': 'status-pending',
                'processing': 'status-processing',
                'preparing': 'status-preparing',
                'ready': 'status-ready',
                'completed': 'status-completed',
                'cancelled': 'status-cancelled'
            };
            return classes[status] || 'status-pending';
        }
        
        function getTimeAgo(dateString) {
            const date = new Date(dateString);
            const now = new Date();
            const diffMs = now - date;
            const diffMins = Math.floor(diffMs / 60000);
            
            if (diffMins < 1) return 'Just now';
            if (diffMins < 60) return `${diffMins}m ago`;
            
            const diffHours = Math.floor(diffMins / 60);
            if (diffHours < 24) return `${diffHours}h ago`;
            
            const diffDays = Math.floor(diffHours / 24);
            return `${diffDays}d ago`;
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.employee', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\layouts\employee.blade.php ENDPATH**/ ?>