

<?php $__env->startSection('title', 'My Rating History'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <!-- Breadcrumb -->
    <nav aria-label="breadcrumb" class="mb-4">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="<?php echo e(route('customer.dashboard')); ?>">
                    <i class="fas fa-home me-1"></i> Dashboard
                </a>
            </li>
            <li class="breadcrumb-item">
                <a href="<?php echo e(route('customer.orders.index')); ?>">
                    <i class="fas fa-list me-1"></i> My Orders
                </a>
            </li>
            <li class="breadcrumb-item active">
                <i class="fas fa-star me-1"></i> Rating History
            </li>
        </ol>
    </nav>

    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-1">
                        <i class="fas fa-star text-warning me-2"></i> My Rating History
                    </h2>
                    <p class="text-muted mb-0">All reviews you've submitted</p>
                </div>
                <a href="<?php echo e(route('customer.orders.index')); ?>" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-1"></i> Back to Orders
                </a>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-md-4 mb-3">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-body text-center">
                    <h1 class="display-4 text-primary"><?php echo e($stats['total']); ?></h1>
                    <p class="text-muted mb-0">Total Ratings</p>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-body text-center">
                    <h1 class="display-4 text-warning"><?php echo e($stats['average']); ?>/5</h1>
                    <p class="text-muted mb-0">Average Rating</p>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-body text-center">
                    <h1 class="display-4 text-success"><?php echo e($stats['recent']); ?></h1>
                    <p class="text-muted mb-0">Last 30 Days</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Reviews List -->
    <div class="card shadow">
        <div class="card-header bg-white">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0">All Reviews</h5>
                <span class="badge bg-primary"><?php echo e($reviews->total()); ?> reviews</span>
            </div>
        </div>
        
        <div class="card-body">
            <?php if($reviews->count() > 0): ?>
                <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="review-item border-bottom pb-4 mb-4 <?php echo e(!$loop->last ? '' : 'border-bottom-0 pb-0 mb-0'); ?>">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="d-flex align-items-start mb-2">
                                    <div class="flex-grow-1">
                                        <h5 class="mb-1">
                                            <?php echo e($review->menu->name ?? 'Menu Item'); ?>

                                            <?php if($review->order): ?>
                                                <small class="text-muted ms-2">
                                                    Order #<?php echo e($review->order->order_number); ?>

                                                </small>
                                            <?php endif; ?>
                                        </h5>
                                        <div class="mb-2">
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <?php if($i <= $review->rating): ?>
                                                    <i class="fas fa-star text-warning"></i>
                                                <?php else: ?>
                                                    <i class="far fa-star text-warning"></i>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                            <span class="ms-2 fw-bold"><?php echo e($review->rating); ?>/5</span>
                                        </div>
                                    </div>
                                    <div class="text-end">
                                        <small class="text-muted">
                                            <?php echo e($review->created_at->format('M d, Y')); ?>

                                        </small>
                                        <br>
                                        <span class="badge bg-<?php echo e($review->is_approved ? 'success' : 'warning'); ?>">
                                            <?php echo e($review->is_approved ? 'Approved' : 'Pending'); ?>

                                        </span>
                                    </div>
                                </div>
                                
                                <?php if($review->comment): ?>
                                    <div class="bg-light p-3 rounded mb-2">
                                        <p class="mb-0"><?php echo e($review->comment); ?></p>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="d-flex align-items-center text-muted">
                                    <small>
                                        <i class="fas fa-calendar me-1"></i>
                                        Ordered: <?php echo e($review->order->created_at->format('M d, Y') ?? 'N/A'); ?>

                                    </small>
                                    <span class="mx-2">•</span>
                                    <small>
                                        <i class="fas fa-dollar-sign me-1"></i>
                                        Rp <?php echo e(number_format($review->order->final_amount ?? 0, 0, ',', '.')); ?>

                                    </small>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="card border">
                                    <div class="card-body p-3">
                                        <h6 class="card-title mb-2">Order Details</h6>
                                        <?php if($review->order): ?>
                                            <p class="mb-1">
                                                <small>Status:</small>
                                                <?php
                                                    $statusColors = [
                                                        'pending' => 'warning',
                                                        'processing' => 'info',
                                                        'preparing' => 'primary',
                                                        'ready' => 'success',
                                                        'on_delivery' => 'info',
                                                        'completed' => 'success',
                                                        'cancelled' => 'danger',
                                                    ];
                                                    $status = $review->order->status;
                                                    $statusColor = $statusColors[$status] ?? 'secondary';
                                                ?>
                                                <span class="badge bg-<?php echo e($statusColor); ?> ms-1">
                                                    <?php echo e(ucfirst($status)); ?>

                                                </span>
                                            </p>
                                            <p class="mb-1">
                                                <small>Type:</small>
                                                <strong class="ms-1"><?php echo e(ucfirst($review->order->order_type)); ?></strong>
                                            </p>
                                            <p class="mb-0">
                                                <small>Items:</small>
                                                <strong class="ms-1"><?php echo e($review->order->items->count() ?? 0); ?></strong>
                                            </p>
                                        <?php else: ?>
                                            <p class="text-muted mb-0">Order details not available</p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Actions -->
                        <div class="mt-3">
                            <a href="<?php echo e(route('customer.orders.show', $review->order_id)); ?>" 
                               class="btn btn-sm btn-outline-primary me-2">
                                <i class="fas fa-eye me-1"></i> View Order
                            </a>
                            <?php if($review->menu): ?>
                                <a href="<?php echo e(route('customer.menu.index')); ?>?search=<?php echo e(urlencode($review->menu->name)); ?>" 
                                   class="btn btn-sm btn-outline-secondary">
                                    <i class="fas fa-utensils me-1"></i> View Menu
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                <!-- Pagination -->
                <?php if($reviews->hasPages()): ?>
                    <div class="mt-4">
                        <?php echo e($reviews->links()); ?>

                    </div>
                <?php endif; ?>
                
            <?php else: ?>
                <div class="text-center py-5">
                    <div class="mb-3">
                        <i class="fas fa-star fa-3x text-muted"></i>
                    </div>
                    <h4 class="text-muted mb-3">No Reviews Yet</h4>
                    <p class="text-muted mb-4">
                        You haven't rated any orders yet. After completing an order, 
                        you can rate it to help us improve our service.
                    </p>
                    <a href="<?php echo e(route('customer.orders.index')); ?>" class="btn btn-primary">
                        <i class="fas fa-list me-1"></i> View My Orders
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Rating Distribution -->
    <?php if($reviews->count() > 0): ?>
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card shadow">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Rating Distribution</h5>
                </div>
                <div class="card-body">
                    <?php
                        $ratingCounts = [
                            5 => 0,
                            4 => 0,
                            3 => 0,
                            2 => 0,
                            1 => 0
                        ];
                        
                        foreach($reviews as $review) {
                            if(isset($ratingCounts[$review->rating])) {
                                $ratingCounts[$review->rating]++;
                            }
                        }
                        
                        $maxCount = max($ratingCounts);
                    ?>
                    
                    <?php for($i = 5; $i >= 1; $i--): ?>
                        <div class="mb-3">
                            <div class="d-flex justify-content-between mb-1">
                                <div>
                                    <?php for($j = 1; $j <= 5; $j++): ?>
                                        <?php if($j <= $i): ?>
                                            <i class="fas fa-star text-warning"></i>
                                        <?php else: ?>
                                            <i class="far fa-star text-warning"></i>
                                        <?php endif; ?>
                                    <?php endfor; ?>
                                    <span class="ms-2"><?php echo e($i); ?> Star<?php echo e($i > 1 ? 's' : ''); ?></span>
                                </div>
                                <span class="fw-bold"><?php echo e($ratingCounts[$i]); ?></span>
                            </div>
                            <div class="progress" style="height: 8px;">
                                <?php
                                    $percentage = $maxCount > 0 ? ($ratingCounts[$i] / $maxCount) * 100 : 0;
                                    $colorClass = match($i) {
                                        5 => 'bg-success',
                                        4 => 'bg-info',
                                        3 => 'bg-primary',
                                        2 => 'bg-warning',
                                        1 => 'bg-danger',
                                        default => 'bg-secondary'
                                    };
                                ?>
                                <div class="progress-bar <?php echo e($colorClass); ?>" 
                                     role="progressbar" 
                                     style="width: <?php echo e($percentage); ?>%"
                                     aria-valuenow="<?php echo e($percentage); ?>" 
                                     aria-valuemin="0" 
                                     aria-valuemax="100">
                                </div>
                            </div>
                        </div>
                    <?php endfor; ?>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card shadow">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Recent Activity</h5>
                </div>
                <div class="card-body">
                    <?php
                        $recentReviews = $reviews->take(5);
                    ?>
                    
                    <?php if($recentReviews->count() > 0): ?>
                        <div class="list-group list-group-flush">
                            <?php $__currentLoopData = $recentReviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="list-group-item border-0 px-0 py-3">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div>
                                            <h6 class="mb-1"><?php echo e($recent->menu->name ?? 'Menu Item'); ?></h6>
                                            <div class="mb-1">
                                                <?php for($i = 1; $i <= 5; $i++): ?>
                                                    <?php if($i <= $recent->rating): ?>
                                                        <i class="fas fa-star text-warning" style="font-size: 0.8rem;"></i>
                                                    <?php else: ?>
                                                        <i class="far fa-star text-warning" style="font-size: 0.8rem;"></i>
                                                    <?php endif; ?>
                                                <?php endfor; ?>
                                            </div>
                                        </div>
                                        <small class="text-muted">
                                            <?php echo e($recent->created_at->diffForHumans()); ?>

                                        </small>
                                    </div>
                                    <?php if($recent->comment): ?>
                                        <p class="mb-0 text-muted" style="font-size: 0.9rem;">
                                            "<?php echo e(Str::limit($recent->comment, 50)); ?>"
                                        </p>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <p class="text-muted mb-0">No recent activity</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
</div>

<?php $__env->startPush('styles'); ?>
<style>
    .review-item {
        transition: all 0.3s;
    }
    
    .review-item:hover {
        background-color: rgba(0, 0, 0, 0.02);
        border-radius: 8px;
        padding-left: 10px;
        padding-right: 10px;
        margin-left: -10px;
        margin-right: -10px;
    }
    
    .progress {
        background-color: #e9ecef;
        border-radius: 4px;
    }
    
    .progress-bar {
        border-radius: 4px;
    }
    
    .list-group-item {
        border-left: none;
        border-right: none;
    }
    
    .list-group-item:first-child {
        border-top: none;
        padding-top: 0;
    }
    
    .list-group-item:last-child {
        border-bottom: none;
        padding-bottom: 0;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\customer\orders\rating-history.blade.php ENDPATH**/ ?>