

<?php $__env->startSection('title', 'Dashboard - Chingu Bite'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4 py-4">
    <!-- Welcome Banner -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="welcome-banner rounded-4 shadow-sm overflow-hidden">
                <div class="row align-items-center">
                    <div class="col-lg-8 p-5">
                        <h1 class="display-5 fw-bold text-white mb-3">Welcome back, <?php echo e(Auth::user()->name); ?>! 🎉</h1>
                        <p class="lead text-white mb-4">Ready for some delicious Korean food? Explore our menu and place your order!</p>
                        <div class="d-flex gap-3">
                            <a href="<?php echo e(route('customer.menu.index')); ?>" class="btn btn-light btn-lg px-4">
                                <i class="fas fa-utensils me-2"></i>Order Now
                            </a>
                            <a href="<?php echo e(route('customer.orders.index')); ?>" class="btn btn-outline-light btn-lg px-4">
                                <i class="fas fa-clock me-2"></i>Track Orders
                            </a>
                        </div>
                    </div>
                    <div class="col-lg-4 d-none d-lg-block text-center">
                        <div class="banner-illustration">
                            <i class="fas fa-utensils fa-6x text-white opacity-75"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="row g-4 mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="card stat-card border-0 shadow-sm h-100">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <h6 class="text-muted mb-2">Active Orders</h6>
                            <h2 class="fw-bold mb-0" id="active-orders">0</h2>
                            <small class="text-success">
                                <i class="fas fa-arrow-up me-1"></i>
                                <span id="today-orders">0</span> today
                            </small>
                        </div>
                        <div class="stat-icon bg-primary-light">
                            <i class="fas fa-shopping-cart text-primary"></i>
                        </div>
                    </div>
                    <div class="mt-3">
                        <a href="<?php echo e(route('customer.orders.index')); ?>" class="text-decoration-none small">
                            View all orders <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card stat-card border-0 shadow-sm h-100">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <h6 class="text-muted mb-2">Cart Items</h6>
                            <h2 class="fw-bold mb-0" id="cart-items">0</h2>
                            <small class="text-warning">
                                <i class="fas fa-shopping-basket me-1"></i>
                                Ready to order
                            </small>
                        </div>
                        <div class="stat-icon bg-success-light">
                            <i class="fas fa-shopping-basket text-success"></i>
                        </div>
                    </div>
                    <div class="mt-3">
                        <a href="<?php echo e(route('customer.cart.index')); ?>" class="text-decoration-none small">
                            View cart <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card stat-card border-0 shadow-sm h-100">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <h6 class="text-muted mb-2">Total Spent</h6>
                            <h2 class="fw-bold mb-0" id="total-spent">Rp 0</h2>
                            <small class="text-info">
                                <i class="fas fa-calendar me-1"></i>
                                This month
                            </small>
                        </div>
                        <div class="stat-icon bg-warning-light">
                            <i class="fas fa-wallet text-warning"></i>
                        </div>
                    </div>
                    <div class="mt-3">
                        <a href="<?php echo e(route('customer.orders.index')); ?>" class="text-decoration-none small">
                            View history <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6">
            <div class="card stat-card border-0 shadow-sm h-100">
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <h6 class="text-muted mb-2">Loyalty Points</h6>
                            <h2 class="fw-bold mb-0" id="points">850</h2>
                            <small class="text-danger">
                                <i class="fas fa-gem me-1"></i>
                                Gold Member
                            </small>
                        </div>
                        <div class="stat-icon bg-danger-light">
                            <i class="fas fa-crown text-danger"></i>
                        </div>
                    </div>
                    <div class="mt-3">
                        <a href="#" class="text-decoration-none small" data-bs-toggle="modal" data-bs-target="#pointsModal">
                            Redeem points <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="row g-4">
        <!-- Left Column: Quick Actions & Recent Orders -->
        <div class="col-lg-8">
            <!-- Quick Actions Grid -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white py-3">
                    <h5 class="mb-0 fw-bold">
                        <i class="fas fa-bolt text-warning me-2"></i>Quick Actions
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-3 col-6">
                            <a href="<?php echo e(route('customer.menu.index')); ?>" class="action-item text-center p-3 rounded-3 d-block text-decoration-none">
                                <div class="action-icon-lg mb-3">
                                    <i class="fas fa-utensils"></i>
                                </div>
                                <h6 class="fw-bold mb-1">Order Food</h6>
                                <small class="text-muted">Browse menu</small>
                            </a>
                        </div>
                        <div class="col-md-3 col-6">
                            <a href="<?php echo e(route('customer.cart.index')); ?>" class="action-item text-center p-3 rounded-3 d-block text-decoration-none">
                                <div class="action-icon-lg mb-3">
                                    <i class="fas fa-shopping-cart"></i>
                                </div>
                                <h6 class="fw-bold mb-1">My Cart</h6>
                                <small class="text-muted" id="cart-summary">0 items</small>
                            </a>
                        </div>
                        <div class="col-md-3 col-6">
                            <a href="<?php echo e(route('customer.orders.index')); ?>" class="action-item text-center p-3 rounded-3 d-block text-decoration-none">
                                <div class="action-icon-lg mb-3">
                                    <i class="fas fa-clipboard-list"></i>
                                </div>
                                <h6 class="fw-bold mb-1">My Orders</h6>
                                <small class="text-muted" id="order-summary">0 active</small>
                            </a>
                        </div>
                        <div class="col-md-3 col-6">
                            <a href="<?php echo e(route('customer.profile.index')); ?>" class="action-item text-center p-3 rounded-3 d-block text-decoration-none">
                                <div class="action-icon-lg mb-3">
                                    <i class="fas fa-user-circle"></i>
                                </div>
                                <h6 class="fw-bold mb-1">Profile</h6>
                                <small class="text-muted">Account settings</small>
                            </a>
                        </div>
                    </div>
                    
                    <!-- Secondary Actions -->
                    <div class="row g-3 mt-2">
                        <div class="col-md-2 col-4">
                            <a href="<?php echo e(route('customer.reviews.index')); ?>" class="action-item-sm text-center p-2 rounded-3 d-block text-decoration-none">
                                <div class="action-icon-sm mb-2">
                                    <i class="fas fa-star"></i>
                                </div>
                                <small class="fw-bold">Reviews</small>
                            </a>
                        </div>
                        <div class="col-md-2 col-4">
                            <a href="<?php echo e(route('customer.careers.index')); ?>" class="action-item-sm text-center p-2 rounded-3 d-block text-decoration-none">
                                <div class="action-icon-sm mb-2">
                                    <i class="fas fa-briefcase"></i>
                                </div>
                                <small class="fw-bold">Careers</small>
                            </a>
                        </div>
                        <div class="col-md-2 col-4">
                            <a href="<?php echo e(route('customer.careers.applications.index')); ?>" class="action-item-sm text-center p-2 rounded-3 d-block text-decoration-none">
                                <div class="action-icon-sm mb-2">
                                    <i class="fas fa-file-alt"></i>
                                </div>
                                <small class="fw-bold">Applications</small>
                            </a>
                        </div>
                        <div class="col-md-2 col-4">
                            <a href="#" class="action-item-sm text-center p-2 rounded-3 d-block text-decoration-none" data-bs-toggle="modal" data-bs-target="#helpModal">
                                <div class="action-icon-sm mb-2">
                                    <i class="fas fa-question-circle"></i>
                                </div>
                                <small class="fw-bold">Help</small>
                            </a>
                        </div>
                        <div class="col-md-2 col-4">
                            <a href="#" class="action-item-sm text-center p-2 rounded-3 d-block text-decoration-none" data-bs-toggle="modal" data-bs-target="#promoModal">
                                <div class="action-icon-sm mb-2">
                                    <i class="fas fa-tag"></i>
                                </div>
                                <small class="fw-bold">Promos</small>
                            </a>
                        </div>
                        <div class="col-md-2 col-4">
                            <a href="<?php echo e(route('home')); ?>" class="action-item-sm text-center p-2 rounded-3 d-block text-decoration-none">
                                <div class="action-icon-sm mb-2">
                                    <i class="fas fa-home"></i>
                                </div>
                                <small class="fw-bold">Home</small>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Orders -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white py-3 d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 fw-bold">
                        <i class="fas fa-history text-primary me-2"></i>Recent Orders
                    </h5>
                    <a href="<?php echo e(route('customer.orders.index')); ?>" class="btn btn-sm btn-outline-primary">
                        View All <i class="fas fa-arrow-right ms-1"></i>
                    </a>
                </div>
                <div class="card-body">
                    <div id="recent-orders-container">
                        <!-- Loading skeleton -->
                        <div class="skeleton-loader">
                            <div class="skeleton-line"></div>
                            <div class="skeleton-line"></div>
                            <div class="skeleton-line"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Right Column: Recommendations & Status -->
        <div class="col-lg-4">
            <!-- Order Status Timeline -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white py-3">
                    <h5 class="mb-0 fw-bold">
                        <i class="fas fa-shipping-fast text-success me-2"></i>Current Order Status
                    </h5>
                </div>
                <div class="card-body">
                    <div id="order-timeline">
                        <div class="timeline-item active">
                            <div class="timeline-marker">
                                <i class="fas fa-check"></i>
                            </div>
                            <div class="timeline-content">
                                <h6 class="mb-1">Order Placed</h6>
                                <small class="text-muted">Just now</small>
                            </div>
                        </div>
                        <div class="timeline-item">
                            <div class="timeline-marker">
                                <i class="fas fa-utensils"></i>
                            </div>
                            <div class="timeline-content">
                                <h6 class="mb-1">Preparing</h6>
                                <small class="text-muted">Estimated: 10 mins</small>
                            </div>
                        </div>
                        <div class="timeline-item">
                            <div class="timeline-marker">
                                <i class="fas fa-check-circle"></i>
                            </div>
                            <div class="timeline-content">
                                <h6 class="mb-1">Ready</h6>
                                <small class="text-muted">Next step</small>
                            </div>
                        </div>
                        <div class="timeline-item">
                            <div class="timeline-marker">
                                <i class="fas fa-truck"></i>
                            </div>
                            <div class="timeline-content">
                                <h6 class="mb-1">On Delivery</h6>
                                <small class="text-muted">Final step</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="text-center mt-4">
                        <div class="progress mb-2" style="height: 8px;">
                            <div class="progress-bar" role="progressbar" style="width: 25%;"></div>
                        </div>
                        <small class="text-muted">Order progress: 25%</small>
                    </div>
                </div>
            </div>

            <!-- Recommended Items -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white py-3">
                    <h5 class="mb-0 fw-bold">
                        <i class="fas fa-fire text-danger me-2"></i>Popular This Week
                    </h5>
                </div>
                <div class="card-body">
                    <div class="recommendation-list">
                        <div class="recommendation-item d-flex align-items-center mb-3">
                            <div class="rec-image me-3">
                                <div class="image-placeholder rounded-3">
                                    <i class="fas fa-utensils"></i>
                                </div>
                            </div>
                            <div class="rec-content flex-grow-1">
                                <h6 class="fw-bold mb-1">Bibimbap Special</h6>
                                <div class="d-flex justify-content-between align-items-center">
                                    <small class="text-muted">Korean mixed rice</small>
                                    <span class="badge bg-danger">Hot</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mt-2">
                                    <strong class="text-primary">Rp 45,000</strong>
                                    <button class="btn btn-sm btn-outline-primary">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        
                        <div class="recommendation-item d-flex align-items-center mb-3">
                            <div class="rec-image me-3">
                                <div class="image-placeholder rounded-3">
                                    <i class="fas fa-drumstick-bite"></i>
                                </div>
                            </div>
                            <div class="rec-content flex-grow-1">
                                <h6 class="fw-bold mb-1">Korean Fried Chicken</h6>
                                <div class="d-flex justify-content-between align-items-center">
                                    <small class="text-muted">Crispy & spicy</small>
                                    <span class="badge bg-warning">Trending</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mt-2">
                                    <strong class="text-primary">Rp 65,000</strong>
                                    <button class="btn btn-sm btn-outline-primary">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        
                        <div class="recommendation-item d-flex align-items-center">
                            <div class="rec-image me-3">
                                <div class="image-placeholder rounded-3">
                                    <i class="fas fa-bacon"></i>
                                </div>
                            </div>
                            <div class="rec-content flex-grow-1">
                                <h6 class="fw-bold mb-1">Samgyeopsal Set</h6>
                                <div class="d-flex justify-content-between align-items-center">
                                    <small class="text-muted">Pork belly BBQ</small>
                                    <span class="badge bg-success">New</span>
                                </div>
                                <div class="d-flex justify-content-between align-items-center mt-2">
                                    <strong class="text-primary">Rp 95,000</strong>
                                    <button class="btn btn-sm btn-outline-primary">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="text-center mt-3">
                        <a href="<?php echo e(route('customer.menu.index')); ?>" class="btn btn-outline-primary btn-sm">
                            View All Recommendations <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Promo Banner -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="promo-banner rounded-4 overflow-hidden shadow-sm">
                <div class="row align-items-center">
                    <div class="col-md-8 p-4">
                        <h4 class="text-white mb-2">
                            <i class="fas fa-gift me-2"></i>Weekend Special!
                        </h4>
                        <p class="text-white mb-3">Get 25% off on all Korean BBQ orders this weekend. Use code: <strong>WEEKEND25</strong></p>
                        <a href="<?php echo e(route('customer.menu.index')); ?>" class="btn btn-light btn-sm">
                            Order Now <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                    <div class="col-md-4 d-none d-md-block text-center">
                        <i class="fas fa-gift fa-4x text-white opacity-50"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Points Modal -->
<div class="modal fade" id="pointsModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header border-0">
                <h5 class="modal-title">
                    <i class="fas fa-crown text-warning me-2"></i>Loyalty Points
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body text-center py-4">
                <div class="points-display mb-4">
                    <h1 class="display-3 fw-bold text-warning">850</h1>
                    <p class="text-muted">Available Points</p>
                </div>
                <div class="row g-3">
                    <div class="col-6">
                        <div class="card border">
                            <div class="card-body text-center">
                                <h6 class="text-primary">100 Points</h6>
                                <p class="small text-muted mb-2">Free Kimchi</p>
                                <button class="btn btn-sm btn-outline-primary">Redeem</button>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="card border">
                            <div class="card-body text-center">
                                <h6 class="text-primary">250 Points</h6>
                                <p class="small text-muted mb-2">10% Discount</p>
                                <button class="btn btn-sm btn-outline-primary">Redeem</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Help Modal -->
<div class="modal fade" id="helpModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header border-0">
                <h5 class="modal-title">
                    <i class="fas fa-question-circle text-info me-2"></i>Need Help?
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="list-group list-group-flush">
                    <a href="#" class="list-group-item list-group-item-action border-0 py-3">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-phone text-primary me-3"></i>
                            <div>
                                <h6 class="mb-1">Call Support</h6>
                                <small class="text-muted">+62 812-3456-7890</small>
                            </div>
                        </div>
                    </a>
                    <a href="#" class="list-group-item list-group-item-action border-0 py-3">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-comment text-success me-3"></i>
                            <div>
                                <h6 class="mb-1">Live Chat</h6>
                                <small class="text-muted">24/7 available</small>
                            </div>
                        </div>
                    </a>
                    <a href="#" class="list-group-item list-group-item-action border-0 py-3">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-envelope text-warning me-3"></i>
                            <div>
                                <h6 class="mb-1">Email Support</h6>
                                <small class="text-muted">support@chingubite.com</small>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Welcome Banner */
.welcome-banner {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    position: relative;
    overflow: hidden;
}

.welcome-banner::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -50%;
    width: 100%;
    height: 200%;
    background: radial-gradient(circle, rgba(255,255,255,0.1) 1px, transparent 1px);
    background-size: 20px 20px;
    opacity: 0.3;
}

/* Stat Cards */
.stat-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 12px;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.1) !important;
}

.stat-icon {
    width: 50px;
    height: 50px;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
}

.bg-primary-light { background-color: rgba(78, 115, 223, 0.1); }
.bg-success-light { background-color: rgba(28, 200, 138, 0.1); }
.bg-warning-light { background-color: rgba(246, 194, 62, 0.1); }
.bg-danger-light { background-color: rgba(231, 74, 59, 0.1); }

/* Action Items */
.action-item {
    transition: all 0.3s ease;
    background: white;
    border: 2px solid transparent;
}

.action-item:hover {
    border-color: #4e73df;
    background: rgba(78, 115, 223, 0.05);
    transform: translateY(-3px);
}

.action-item-sm {
    transition: all 0.3s ease;
    background: #f8f9fa;
    border: 1px solid transparent;
}

.action-item-sm:hover {
    border-color: #4e73df;
    background: white;
    transform: translateY(-2px);
}

.action-icon-lg {
    width: 60px;
    height: 60px;
    margin: 0 auto;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.8rem;
    color: #4e73df;
    background: rgba(78, 115, 223, 0.1);
    border-radius: 12px;
}

.action-icon-sm {
    width: 40px;
    height: 40px;
    margin: 0 auto;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.2rem;
    color: #4e73df;
    background: rgba(78, 115, 223, 0.1);
    border-radius: 8px;
}

/* Timeline */
.timeline-item {
    display: flex;
    margin-bottom: 1.5rem;
    position: relative;
}

.timeline-item:last-child {
    margin-bottom: 0;
}

.timeline-item:not(:last-child)::after {
    content: '';
    position: absolute;
    left: 16px;
    top: 40px;
    bottom: -1.5rem;
    width: 2px;
    background-color: #e3e6f0;
    z-index: 1;
}

.timeline-item.active::after {
    background-color: #4e73df;
}

.timeline-item.active .timeline-marker {
    background-color: #4e73df;
    color: white;
    border-color: #4e73df;
}

.timeline-marker {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    background-color: white;
    border: 2px solid #e3e6f0;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 1rem;
    z-index: 2;
    position: relative;
}

.timeline-content {
    flex: 1;
}

/* Recommendations */
.recommendation-item {
    padding: 0.5rem;
    border-radius: 10px;
    transition: all 0.3s ease;
}

.recommendation-item:hover {
    background-color: #f8f9fa;
}

.image-placeholder {
    width: 60px;
    height: 60px;
    display: flex;
    align-items: center;
    justify-content: center;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    color: #6c757d;
    font-size: 1.5rem;
}

/* Promo Banner */
.promo-banner {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
}

/* Skeleton Loader */
.skeleton-loader {
    padding: 1rem;
}

.skeleton-line {
    height: 20px;
    background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
    background-size: 200% 100%;
    animation: loading 1.5s infinite;
    border-radius: 4px;
    margin-bottom: 1rem;
}

.skeleton-line:last-child {
    width: 60%;
}

@keyframes loading {
    0% { background-position: 200% 0; }
    100% { background-position: -200% 0; }
}

/* Responsive */
@media (max-width: 768px) {
    .welcome-banner {
        padding: 2rem 1rem !important;
    }
    
    .display-5 {
        font-size: 2rem;
    }
    
    .btn-lg {
        padding: 0.5rem 1rem;
        font-size: 1rem;
    }
    
    .action-icon-lg {
        width: 50px;
        height: 50px;
        font-size: 1.5rem;
    }
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const API_BASE_URL = window.API_BASE_URL || '<?php echo e(config("app.api_url")); ?>';
    const USER_TOKEN = window.USER_TOKEN || '<?php echo e(session("api_token")); ?>';
    
    // Initialize dashboard
    loadDashboardData();
    
    // Load dashboard data
    async function loadDashboardData() {
        try {
            await Promise.all([
                fetchOrderStats(),
                fetchCartData(),
                fetchRecentOrders()
            ]);
        } catch (error) {
            console.log('Using sample data for dashboard');
            loadSampleData();
        }
    }
    
    // Fetch order statistics
    async function fetchOrderStats() {
        try {
            const response = await fetch(`${API_BASE_URL}/customer/orders/stats`, {
                headers: {
                    'Authorization': `Bearer ${USER_TOKEN}`,
                    'Accept': 'application/json'
                }
            });
            
            if (response.ok) {
                const data = await response.json();
                if (data.success) {
                    updateStatsUI(data.data);
                }
            }
        } catch (error) {
            console.log('Failed to fetch order stats');
        }
    }
    
    // Fetch cart data
    async function fetchCartData() {
        try {
            const response = await fetch(`${API_BASE_URL}/customer/cart`, {
                headers: {
                    'Authorization': `Bearer ${USER_TOKEN}`,
                    'Accept': 'application/json'
                }
            });
            
            if (response.ok) {
                const data = await response.json();
                if (data.success) {
                    updateCartUI(data.data);
                }
            }
        } catch (error) {
            console.log('Failed to fetch cart data');
        }
    }
    
    // Fetch recent orders
    async function fetchRecentOrders() {
        try {
            const response = await fetch(`${API_BASE_URL}/customer/orders?limit=3`, {
                headers: {
                    'Authorization': `Bearer ${USER_TOKEN}`,
                    'Accept': 'application/json'
                }
            });
            
            if (response.ok) {
                const data = await response.json();
                if (data.success) {
                    updateRecentOrdersUI(data.data?.orders || data.data?.data || []);
                }
            }
        } catch (error) {
            console.log('Failed to fetch recent orders');
        }
    }
    
    // Update statistics UI
    function updateStatsUI(stats) {
        document.getElementById('active-orders').textContent = stats.active_orders || 0;
        document.getElementById('today-orders').textContent = stats.today_orders || 0;
        document.getElementById('total-spent').textContent = formatCurrency(stats.total_spent || 0);
        document.getElementById('order-summary').textContent = 
            `${stats.active_orders || 0} active`;
    }
    
    // Update cart UI
    function updateCartUI(cartData) {
        const items = cartData?.items || [];
        const itemCount = items.reduce((sum, item) => sum + (item.quantity || 0), 0);
        const totalPrice = items.reduce((sum, item) => sum + ((item.price || 0) * (item.quantity || 0)), 0);
        
        document.getElementById('cart-items').textContent = itemCount;
        document.getElementById('cart-summary').textContent = 
            itemCount === 1 ? '1 item' : `${itemCount} items`;
            
        // Update navbar cart count
        const navbarCart = document.getElementById('cart-count');
        if (navbarCart) {
            navbarCart.textContent = itemCount;
        }
    }
    
    // Update recent orders UI
    function updateRecentOrdersUI(orders) {
        const container = document.getElementById('recent-orders-container');
        
        if (orders.length === 0) {
            container.innerHTML = `
                <div class="text-center py-4">
                    <i class="fas fa-shopping-bag fa-3x text-muted mb-3"></i>
                    <h5>No Recent Orders</h5>
                    <p class="text-muted mb-3">You haven't placed any orders yet.</p>
                    <a href="<?php echo e(route('customer.menu.index')); ?>" class="btn btn-primary">
                        <i class="fas fa-utensils me-2"></i>Order Now
                    </a>
                </div>
            `;
            return;
        }
        
        let html = '';
        orders.forEach(order => {
            const status = order.status || 'pending';
            const statusColor = getStatusColor(status);
            const statusText = status.replace('_', ' ').toUpperCase();
            const date = new Date(order.created_at).toLocaleDateString('en-US', {
                month: 'short',
                day: 'numeric'
            });
            const time = new Date(order.created_at).toLocaleTimeString('en-US', {
                hour: '2-digit',
                minute: '2-digit'
            });
            
            // Get first item
            const firstItem = order.items?.[0]?.name || 'Items';
            const itemCount = order.items?.length || 0;
            const itemText = itemCount > 1 ? `${firstItem} +${itemCount - 1}` : firstItem;
            
            html += `
                <div class="order-card p-3 border rounded-3 mb-3">
                    <div class="d-flex justify-content-between align-items-start mb-2">
                        <div>
                            <h6 class="fw-bold mb-1">${order.order_number || 'Order #' + order.id}</h6>
                            <small class="text-muted">${date} • ${time}</small>
                        </div>
                        <span class="badge bg-${statusColor}">${statusText}</span>
                    </div>
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <small class="text-muted">${itemText}</small>
                            <div class="mt-1">
                                <strong>${formatCurrency(order.total_amount || 0)}</strong>
                            </div>
                        </div>
                        <a href="/customer/orders/${order.id}" class="btn btn-sm btn-outline-primary">
                            Details <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                </div>
            `;
        });
        
        container.innerHTML = html;
    }
    
    // Load sample data for demo
    function loadSampleData() {
        document.getElementById('active-orders').textContent = '2';
        document.getElementById('today-orders').textContent = '1';
        document.getElementById('cart-items').textContent = '3';
        document.getElementById('total-spent').textContent = 'Rp 1,250,000';
        document.getElementById('order-summary').textContent = '2 active';
        document.getElementById('cart-summary').textContent = '3 items';
        
        // Sample recent orders
        updateRecentOrdersUI([
            {
                id: 1,
                order_number: 'ORD-2024-001',
                total_amount: 185000,
                status: 'completed',
                created_at: new Date().toISOString(),
                items: [{ name: 'Bibimbap', quantity: 2 }]
            },
            {
                id: 2,
                order_number: 'ORD-2024-002',
                total_amount: 125000,
                status: 'on_delivery',
                created_at: new Date(Date.now() - 3600000).toISOString(),
                items: [{ name: 'Bulgogi', quantity: 1 }]
            },
            {
                id: 3,
                order_number: 'ORD-2024-003',
                total_amount: 75000,
                status: 'preparing',
                created_at: new Date(Date.now() - 7200000).toISOString(),
                items: [{ name: 'Kimchi Fried Rice', quantity: 1 }]
            }
        ]);
    }
    
    // Helper functions
    function formatCurrency(amount) {
        return 'Rp ' + amount.toLocaleString('id-ID');
    }
    
    function getStatusColor(status) {
        const colors = {
            'pending': 'warning',
            'processing': 'info',
            'preparing': 'primary',
            'ready': 'primary',
            'on_delivery': 'info',
            'completed': 'success',
            'cancelled': 'danger'
        };
        return colors[status] || 'secondary';
    }
    
    // Auto-refresh dashboard every 60 seconds
    setInterval(loadDashboardData, 60000);
    
    // Add to cart buttons for recommendations
    document.querySelectorAll('.recommendation-item button').forEach(button => {
        button.addEventListener('click', function() {
            const itemName = this.closest('.recommendation-item').querySelector('h6').textContent;
            showToast(`Added ${itemName} to cart!`, 'success');
            
            // Update cart count
            const currentCount = parseInt(document.getElementById('cart-items').textContent);
            document.getElementById('cart-items').textContent = currentCount + 1;
            document.getElementById('cart-summary').textContent = 
                currentCount + 1 === 1 ? '1 item' : `${currentCount + 1} items`;
        });
    });
    
    // Toast notification function
    function showToast(message, type = 'success') {
        // Create toast element
        const toast = document.createElement('div');
        toast.className = `toast align-items-center text-bg-${type} border-0 position-fixed bottom-0 end-0 m-3`;
        toast.setAttribute('role', 'alert');
        toast.innerHTML = `
            <div class="d-flex">
                <div class="toast-body">
                    <i class="fas fa-${type === 'success' ? 'check-circle' : 'exclamation-triangle'} me-2"></i>
                    ${message}
                </div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
            </div>
        `;
        
        document.body.appendChild(toast);
        const bsToast = new bootstrap.Toast(toast);
        bsToast.show();
        
        toast.addEventListener('hidden.bs.toast', function () {
            toast.remove();
        });
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views/customer/dashboard.blade.php ENDPATH**/ ?>