


<?php $__env->startSection('title', 'API Error'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow">
                <div class="card-header bg-danger text-white">
                    <h4 class="mb-0">API Connection Error</h4>
                </div>
                <div class="card-body text-center py-5">
                    <div class="mb-4">
                        <i class="fas fa-exclamation-triangle fa-4x text-danger mb-3"></i>
                        <h3>Unable to connect to server</h3>
                    </div>
                    
                    <div class="alert alert-info text-start mb-4">
                        <p><strong>Status Code:</strong> <?php echo e($status ?? 'Unknown'); ?></p>
                        <p><strong>Error Message:</strong> <?php echo e($error ?? 'API connection failed'); ?></p>
                        
                        <?php if(isset($errors) && count($errors) > 0): ?>
                            <div class="mt-3">
                                <h6>Details:</h6>
                                <ul class="mb-0">
                                    <?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $errorMsg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($errorMsg); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="d-grid gap-2 d-md-flex justify-content-center">
                        <a href="<?php echo e(url()->previous()); ?>" class="btn btn-primary">
                            <i class="fas fa-arrow-left me-2"></i>Go Back
                        </a>
                        <a href="<?php echo e(route('home')); ?>" class="btn btn-outline-secondary">
                            <i class="fas fa-home me-2"></i>Home Page
                        </a>
                        <a href="javascript:location.reload()" class="btn btn-outline-info">
                            <i class="fas fa-redo me-2"></i>Try Again
                        </a>
                    </div>
                    
                    <div class="mt-4 text-muted small">
                        <p>If this error persists, please contact the system administrator.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\errors\api.blade.php ENDPATH**/ ?>