

<?php $__env->startSection('title', 'Rate Order #' . $order->order_number); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <!-- Breadcrumb -->
    <nav aria-label="breadcrumb" class="mb-4">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="<?php echo e(route('customer.dashboard')); ?>">
                    <i class="fas fa-home me-1"></i> Dashboard
                </a>
            </li>
            <li class="breadcrumb-item">
                <a href="<?php echo e(route('customer.orders.index')); ?>">
                    <i class="fas fa-list me-1"></i> My Orders
                </a>
            </li>
            <li class="breadcrumb-item">
                <a href="<?php echo e(route('customer.orders.show', $order->id)); ?>">
                    <i class="fas fa-receipt me-1"></i> Order #<?php echo e($order->order_number); ?>

                </a>
            </li>
            <li class="breadcrumb-item active">
                <i class="fas fa-star me-1"></i> Rate Order
            </li>
        </ol>
    </nav>

    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">
                        <i class="fas fa-star me-2"></i> Rate Your Order
                    </h4>
                    <p class="mb-0 mt-1">Order #<?php echo e($order->order_number); ?> - <?php echo e(date('F j, Y', strtotime($order->created_at))); ?></p>
                </div>
                
                <div class="card-body">
                    <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible fade show">
                            <i class="fas fa-exclamation-circle me-2"></i>
                            <?php echo e(session('error')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger alert-dismissible fade show">
                            <ul class="mb-0">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>
                    
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        Your feedback helps us improve our service. Please rate your order experience.
                    </div>
                    
                    <form method="POST" action="<?php echo e(route('customer.orders.rate.submit', $order->id)); ?>">
                        <?php echo csrf_field(); ?>
                        
                        <!-- Overall Rating -->
                        <div class="card mb-4 border">
                            <div class="card-body">
                                <h5 class="card-title mb-3">
                                    <i class="fas fa-clipboard-check me-2"></i> Overall Experience
                                </h5>
                                
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Overall Rating *</label>
                                    <div class="rating-stars">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" 
                                                       name="rating" id="rating<?php echo e($i); ?>" 
                                                       value="<?php echo e($i); ?>" required 
                                                       <?php echo e(old('rating') == $i ? 'checked' : ''); ?>>
                                                <label class="form-check-label star-label" for="rating<?php echo e($i); ?>">
                                                    <?php for($j = 1; $j <= $i; $j++): ?>
                                                        <i class="fas fa-star"></i>
                                                    <?php endfor; ?>
                                                    <?php for($j = $i + 1; $j <= 5; $j++): ?>
                                                        <i class="far fa-star"></i>
                                                    <?php endfor; ?>
                                                    <span class="ms-2"><?php echo e($i); ?> Star<?php echo e($i > 1 ? 's' : ''); ?></span>
                                                </label>
                                            </div>
                                        <?php endfor; ?>
                                    </div>
                                    <?php $__errorArgs = ['rating'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="comment" class="form-label fw-bold">Overall Review</label>
                                    <textarea class="form-control <?php $__errorArgs = ['comment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                              id="review" name="review" rows="3" 
                                              placeholder="Tell us about your overall experience..."><?php echo e(old('comment')); ?></textarea>
                                    <small class="text-muted">Optional - What did you like or dislike?</small>
                                    <?php $__errorArgs = ['comment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Item Ratings -->
                        <div class="card mb-4 border">
                            <div class="card-body">
                                <h5 class="card-title mb-3">
                                    <i class="fas fa-utensils me-2"></i> Rate Individual Items
                                </h5>
                                
                                <?php if($order->items && $order->items->count() > 0): ?>
                                    <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="item-rating mb-4 pb-3 <?php echo e(!$loop->last ? 'border-bottom' : ''); ?>">
                                            <div class="d-flex justify-content-between align-items-start mb-2">
                                                <div>
                                                    <h6 class="mb-1"><?php echo e($item->menu->name ?? 'Item ' . ($index + 1)); ?></h6>
                                                    <small class="text-muted">Quantity: <?php echo e($item->quantity); ?></small>
                                                </div>
                                                <span class="text-primary fw-bold">
                                                    Rp <?php echo e(number_format($item->unit_price, 0, ',', '.')); ?>

                                                </span>
                                            </div>
                                            
                                            <input type="hidden" name="items[<?php echo e($index); ?>][item_id]" value="<?php echo e($item->id); ?>">
                                            
                                            <div class="mb-2">
                                                <label class="form-label">Item Rating *</label>
                                                <div class="item-stars">
                                                    <?php for($i = 1; $i <= 5; $i++): ?>
                                                        <div class="form-check form-check-inline">
                                                            <input class="form-check-input item-rating-input" 
                                                                   type="radio" 
                                                                   name="items[<?php echo e($index); ?>][rating]" 
                                                                   id="item<?php echo e($index); ?>_rating<?php echo e($i); ?>" 
                                                                   value="<?php echo e($i); ?>" required
                                                                   <?php echo e(old('items.' . $index . '.rating') == $i ? 'checked' : ''); ?>>
                                                            <label class="form-check-label" for="item<?php echo e($index); ?>_rating<?php echo e($i); ?>">
                                                                <?php for($j = 1; $j <= $i; $j++): ?>
                                                                    <i class="fas fa-star text-warning"></i>
                                                                <?php endfor; ?>
                                                                <?php for($j = $i + 1; $j <= 5; $j++): ?>
                                                                    <i class="far fa-star text-warning"></i>
                                                                <?php endfor; ?>
                                                            </label>
                                                        </div>
                                                    <?php endfor; ?>
                                                </div>
                                            </div>
                                            
<!-- Item Review textarea -->
<textarea class="form-control" 
          name="items[<?php echo e($index); ?>][comment]" 
          rows="2" 
          placeholder="How was this item? (Optional)"><?php echo e(old('items.' . $index . '.comment')); ?></textarea>
            </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <div class="text-center text-muted py-3">
                                        <i class="fas fa-utensils fa-2x mb-2"></i>
                                        <p>No items to rate</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <!-- Delivery Rating (if delivery order) -->
                        <?php if($order->order_type === 'delivery'): ?>
                        <div class="card mb-4 border">
                            <div class="card-body">
                                <h5 class="card-title mb-3">
                                    <i class="fas fa-truck me-2"></i> Delivery Experience
                                </h5>
                                
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Delivery Rating</label>
                                    <div class="delivery-stars">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" 
                                                       name="delivery_rating" id="delivery_rating<?php echo e($i); ?>" 
                                                       value="<?php echo e($i); ?>"
                                                       <?php echo e(old('delivery_rating') == $i ? 'checked' : ''); ?>>
                                                <label class="form-check-label" for="delivery_rating<?php echo e($i); ?>">
                                                    <?php for($j = 1; $j <= $i; $j++): ?>
                                                        <i class="fas fa-star text-info"></i>
                                                    <?php endfor; ?>
                                                    <?php for($j = $i + 1; $j <= 5; $j++): ?>
                                                        <i class="far fa-star text-info"></i>
                                                    <?php endfor; ?>
                                                    <span class="ms-2"><?php echo e($i); ?> Star<?php echo e($i > 1 ? 's' : ''); ?></span>
                                                </label>
                                            </div>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                                
<textarea class="form-control" id="delivery_comment" 
          name="delivery_comment" rows="2" 
          placeholder="How was the delivery? (Optional)"><?php echo e(old('delivery_comment')); ?></textarea>
                                    </div>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Form Actions -->
                        <div class="d-flex justify-content-between mt-4">
                            <a href="<?php echo e(route('customer.orders.show', $order->id)); ?>" 
                               class="btn btn-outline-secondary">
                                <i class="fas fa-arrow-left me-1"></i> Back to Order
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-paper-plane me-1"></i> Submit Rating
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
    .rating-stars .form-check-input,
    .item-stars .form-check-input,
    .delivery-stars .form-check-input {
        display: none;
    }
    
    .rating-stars .form-check-label,
    .item-stars .form-check-label,
    .delivery-stars .form-check-label {
        cursor: pointer;
        font-size: 1.5rem;
        margin-right: 15px;
        padding: 5px;
        border-radius: 5px;
        transition: all 0.3s;
    }
    
    .rating-stars .form-check-label:hover,
    .item-stars .form-check-label:hover,
    .delivery-stars .form-check-label:hover {
        background-color: rgba(0, 0, 0, 0.05);
    }
    
    .rating-stars .form-check-input:checked + label,
    .item-stars .form-check-input:checked + label,
    .delivery-stars .form-check-input:checked + label {
        background-color: rgba(13, 110, 253, 0.1);
        border: 1px solid rgba(13, 110, 253, 0.2);
    }
    
    .star-label span {
        font-size: 0.9rem;
        vertical-align: middle;
    }
    
    .item-rating {
        background-color: #f8f9fa;
        padding: 15px;
        border-radius: 8px;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Highlight stars on hover
    document.querySelectorAll('.form-check-label').forEach(label => {
        label.addEventListener('mouseenter', function() {
            const input = this.previousElementSibling;
            const stars = this.querySelectorAll('i');
            const value = input.value;
            
            stars.forEach((star, index) => {
                if (index < value) {
                    star.classList.remove('far');
                    star.classList.add('fas');
                }
            });
        });
        
        label.addEventListener('mouseleave', function() {
            const input = this.previousElementSibling;
            const stars = this.querySelectorAll('i');
            
            stars.forEach((star, index) => {
                if (!input.checked) {
                    if (index >= input.value) {
                        star.classList.remove('fas');
                        star.classList.add('far');
                    }
                }
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\customer\orders\rate.blade.php ENDPATH**/ ?>