

<?php $__env->startSection('title', 'Track Order'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <!-- Back Button -->
    <div class="row mb-4">
        <div class="col-md-12">
            <a href="<?php echo e(route('customer.orders.show', $order['id'])); ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-1"></i> Back to Order Details
            </a>
        </div>
    </div>

    <!-- Order Tracking Header -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card shadow">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h4 class="mb-1">Track Order #<?php echo e($order['order_number'] ?? $order['id']); ?></h4>
                            <p class="text-muted mb-0">
                                <i class="fas fa-truck me-1"></i>
                                Real-time delivery tracking
                            </p>
                        </div>
                        <div class="col-md-4 text-md-end">
                            <?php
                                $status = $order['status'] ?? 'pending';
                                $statusText = str_replace('_', ' ', ucfirst($status));
                                $badgeColor = match($status) {
                                    'pending' => 'warning',
                                    'processing' => 'info',
                                    'preparing' => 'primary',
                                    'ready' => 'success',
                                    'on_delivery' => 'info',
                                    'completed' => 'success',
                                    'cancelled' => 'danger',
                                    default => 'secondary'
                                };
                            ?>
                            <span class="badge bg-<?php echo e($badgeColor); ?> p-2 fs-6"><?php echo e($statusText); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Tracking Map (Simulated) -->
        <div class="col-lg-8 mb-4">
            <div class="card shadow h-100">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Delivery Route</h5>
                </div>
                <div class="card-body">
                    <div class="text-center py-5">
                        <div class="mb-4">
                            <i class="fas fa-map-marked-alt fa-4x text-primary mb-3"></i>
                            <h4>Live Tracking Map</h4>
                        </div>
                        
                        <!-- Simulated Map -->
                        <div class="simulated-map mb-4">
                            <div class="map-container">
                                <div class="restaurant-location">
                                    <i class="fas fa-store text-danger"></i>
                                    <div class="location-label">Restaurant</div>
                                </div>
                                <div class="delivery-route">
                                    <div class="route-line"></div>
                                    <div class="delivery-bike">
                                        <i class="fas fa-motorcycle text-warning"></i>
                                    </div>
                                </div>
                                <div class="delivery-location">
                                    <i class="fas fa-home text-success"></i>
                                    <div class="location-label">Your Location</div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Delivery Info -->
                        <div class="row text-start">
                            <div class="col-md-6 mb-3">
                                <p class="mb-1"><strong>Delivery Address:</strong></p>
                                <p class="text-muted"><?php echo e($order['delivery_address'] ?? 'Not specified'); ?></p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <p class="mb-1"><strong>Estimated Arrival:</strong></p>
                                <p class="text-muted">
                                    <?php echo e($order['delivery']['estimated_time'] ?? '30-45 minutes'); ?>

                                    <br>
                                    <small>Order placed at <?php echo e(date('h:i A', strtotime($order['created_at']))); ?></small>
                                </p>
                            </div>
                        </div>
                        
                        <!-- Driver Info (Simulated) -->
                        <div class="card mt-3">
                            <div class="card-body">
                                <div class="row align-items-center">
                                    <div class="col-auto">
                                        <div class="driver-avatar">
                                            <i class="fas fa-user"></i>
                                        </div>
                                    </div>
                                    <div class="col">
                                        <h6 class="mb-1">Driver: Budi Santoso</h6>
                                        <p class="mb-0 text-muted">
                                            <i class="fas fa-phone me-1"></i> 0812-3456-7890
                                            <br>
                                            <i class="fas fa-motorcycle me-1"></i> Honda Beat - B 1234 XYZ
                                        </p>
                                    </div>
                                    <div class="col-auto">
                                        <button class="btn btn-outline-primary btn-sm">
                                            <i class="fas fa-phone me-1"></i> Call Driver
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tracking Timeline -->
        <div class="col-lg-4 mb-4">
            <div class="card shadow h-100">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Delivery Status</h5>
                </div>
                <div class="card-body">
                    <div class="tracking-timeline">
                        <?php
                            $timelineSteps = [
                                ['icon' => 'fas fa-shopping-cart', 'status' => 'Order placed', 'time' => date('h:i A', strtotime($order['created_at'])), 'active' => true],
                                ['icon' => 'fas fa-check-circle', 'status' => 'Order confirmed', 'time' => date('h:i A', strtotime($order['created_at']) + 300), 'active' => true],
                                ['icon' => 'fas fa-utensils', 'status' => 'Food preparing', 'time' => date('h:i A', strtotime($order['created_at']) + 600), 'active' => true],
                                ['icon' => 'fas fa-box', 'status' => 'Ready for pickup', 'time' => date('h:i A', strtotime($order['created_at']) + 1200), 'active' => true],
                                ['icon' => 'fas fa-motorcycle', 'status' => 'Out for delivery', 'time' => date('h:i A', strtotime($order['created_at']) + 1500), 'active' => $status == 'on_delivery'],
                                ['icon' => 'fas fa-home', 'status' => 'Delivered', 'time' => 'Estimated: ' . date('h:i A', strtotime($order['created_at']) + 2700), 'active' => false]
                            ];
                        ?>
                        
                        <?php $__currentLoopData = $timelineSteps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $step): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="tracking-step <?php echo e($step['active'] ? 'active' : ''); ?>">
                                <div class="step-icon">
                                    <i class="<?php echo e($step['icon']); ?>"></i>
                                </div>
                                <div class="step-content">
                                    <h6 class="mb-1"><?php echo e($step['status']); ?></h6>
                                    <p class="text-muted mb-0"><?php echo e($step['time']); ?></p>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    
                    <!-- Estimated Time -->
                    <div class="mt-4 p-3 bg-light rounded">
                        <div class="text-center">
                            <i class="fas fa-clock text-warning fa-2x mb-2"></i>
                            <h5>Estimated Delivery Time</h5>
                            <h3 class="text-primary"><?php echo e(date('h:i A', strtotime($order['created_at']) + 2700)); ?></h3>
                            <p class="text-muted mb-0">Approximately 45 minutes from order time</p>
                        </div>
                    </div>
                    
                    <!-- Action Buttons -->
                    <div class="mt-3">
                        <div class="d-grid gap-2">
                            <button class="btn btn-primary" onclick="refreshTracking()">
                                <i class="fas fa-redo me-2"></i> Refresh Tracking
                            </button>
                            <button class="btn btn-outline-secondary" onclick="shareTracking()">
                                <i class="fas fa-share-alt me-2"></i> Share Tracking Link
                            </button>
                            <a href="<?php echo e(route('customer.orders.show', $order['id'])); ?>" class="btn btn-outline-secondary">
                                <i class="fas fa-file-alt me-2"></i> View Order Details
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Live Updates Section -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card shadow">
                <div class="card-header bg-white d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Live Updates</h5>
                    <span class="badge bg-success">
                        <i class="fas fa-wifi me-1"></i> Live
                    </span>
                </div>
                <div class="card-body">
                    <div class="updates-container">
                        <div class="update-item">
                            <div class="update-icon">
                                <i class="fas fa-motorcycle text-warning"></i>
                            </div>
                            <div class="update-content">
                                <h6 class="mb-1">Driver is on the way</h6>
                                <p class="text-muted mb-1">Your order is out for delivery</p>
                                <small class="text-muted">2 minutes ago</small>
                            </div>
                        </div>
                        <div class="update-item">
                            <div class="update-icon">
                                <i class="fas fa-box text-info"></i>
                            </div>
                            <div class="update-content">
                                <h6 class="mb-1">Order picked up by driver</h6>
                                <p class="text-muted mb-1">Driver has collected your order from the restaurant</p>
                                <small class="text-muted">5 minutes ago</small>
                            </div>
                        </div>
                        <div class="update-item">
                            <div class="update-icon">
                                <i class="fas fa-utensils text-primary"></i>
                            </div>
                            <div class="update-content">
                                <h6 class="mb-1">Food preparation complete</h6>
                                <p class="text-muted mb-1">Your order is ready and waiting for pickup</p>
                                <small class="text-muted">10 minutes ago</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function refreshTracking() {
    const btn = event.target;
    const originalText = btn.innerHTML;
    
    btn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i> Refreshing...';
    btn.disabled = true;
    
    setTimeout(() => {
        btn.innerHTML = originalText;
        btn.disabled = false;
        // In real app, this would fetch new tracking data
        alert('Tracking information refreshed!');
    }, 1500);
}

function shareTracking() {
    const trackingUrl = window.location.href;
    
    if (navigator.share) {
        navigator.share({
            title: 'Track my order from Chingu Bite',
            text: 'Track my food delivery order in real-time',
            url: trackingUrl,
        });
    } else {
        // Fallback for browsers without Web Share API
        navigator.clipboard.writeText(trackingUrl).then(() => {
            alert('Tracking link copied to clipboard!');
        });
    }
}

// Auto-refresh every 30 seconds
setTimeout(() => {
    if (<?php echo e($status == 'on_delivery' ? 'true' : 'false'); ?>) {
        refreshTracking();
    }
}, 30000);
</script>

<style>
.simulated-map {
    position: relative;
    height: 300px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 10px;
    overflow: hidden;
}

.map-container {
    position: relative;
    width: 100%;
    height: 100%;
    padding: 20px;
}

.restaurant-location {
    position: absolute;
    top: 50px;
    left: 50px;
    color: white;
    font-size: 2rem;
    text-align: center;
}

.delivery-location {
    position: absolute;
    bottom: 50px;
    right: 50px;
    color: white;
    font-size: 2rem;
    text-align: center;
}

.location-label {
    font-size: 0.8rem;
    margin-top: 5px;
}

.delivery-route {
    position: absolute;
    top: 50%;
    left: 0;
    right: 0;
    height: 4px;
    background: rgba(255, 255, 255, 0.3);
}

.route-line {
    width: 100%;
    height: 100%;
    background: transparent;
}

.delivery-bike {
    position: absolute;
    top: -18px;
    left: 30%;
    animation: moveBike 10s linear infinite;
    font-size: 2.5rem;
}

@keyframes moveBike {
    0% { left: 30%; }
    100% { left: 70%; }
}

.tracking-timeline {
    position: relative;
}

.tracking-step {
    display: flex;
    align-items: center;
    margin-bottom: 25px;
    position: relative;
}

.tracking-step:not(:last-child)::before {
    content: '';
    position: absolute;
    left: 17px;
    top: 40px;
    bottom: -25px;
    width: 2px;
    background-color: #e3e6f0;
    z-index: 1;
}

.tracking-step.active::before {
    background-color: #4e73df;
}

.tracking-step.active .step-icon {
    background-color: #4e73df;
    color: white;
}

.step-icon {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    background-color: #e3e6f0;
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 15px;
    z-index: 2;
    position: relative;
}

.step-content {
    flex: 1;
}

.driver-avatar {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background-color: #4e73df;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
}

.update-item {
    display: flex;
    padding: 15px 0;
    border-bottom: 1px solid #e3e6f0;
}

.update-item:last-child {
    border-bottom: none;
}

.update-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background-color: rgba(78, 115, 223, 0.1);
    display: flex;
    align-items: center;
    justify-content: center;
    margin-right: 15px;
    color: #4e73df;
}

.update-content {
    flex: 1;
}

.card {
    border: 1px solid #e3e6f0;
    border-radius: 10px;
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\customer\orders\track.blade.php ENDPATH**/ ?>