

<?php $__env->startSection('title', 'System Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">System Settings</h1>
    </div>

    <div class="row">
        <div class="col-lg-3">
            <!-- Settings Navigation -->
            <div class="card shadow mb-4">
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        <a href="#general" class="list-group-item list-group-item-action active" 
                           data-bs-toggle="tab">
                            <i class="fas fa-cog me-2"></i> General Settings
                        </a>
                        <a href="#operational" class="list-group-item list-group-item-action" 
                           data-bs-toggle="tab">
                            <i class="fas fa-clock me-2"></i> Operational Hours
                        </a>
                        <a href="#tax" class="list-group-item list-group-item-action" 
                           data-bs-toggle="tab">
                            <i class="fas fa-percentage me-2"></i> Tax & Fees
                        </a>
                        <a href="#payment" class="list-group-item list-group-item-action" 
                           data-bs-toggle="tab">
                            <i class="fas fa-credit-card me-2"></i> Payment Settings
                        </a>
                        <a href="#notification" class="list-group-item list-group-item-action" 
                           data-bs-toggle="tab">
                            <i class="fas fa-bell me-2"></i> Notifications
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-9">
            <div class="tab-content">
                <!-- General Settings Tab -->
                <div class="tab-pane fade show active" id="general">
                    <div class="card shadow">
                        <div class="card-header bg-primary text-white">
                            <h5 class="mb-0">General Settings</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="<?php echo e(route('admin.settings.general.update')); ?>">
                                <?php echo csrf_field(); ?>
                                
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="app_name" class="form-label">Application Name *</label>
                                        <input type="text" class="form-control" id="app_name" 
                                               name="app_name" value="<?php echo e(old('app_name', $settings['app_name'] ?? 'Chingu Bite')); ?>" 
                                               required>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="app_logo" class="form-label">Logo URL</label>
                                        <input type="text" class="form-control" id="app_logo" 
                                               name="app_logo" value="<?php echo e(old('app_logo', $settings['app_logo'] ?? '/logo.png')); ?>">
                                        <small class="text-muted">Path to logo image</small>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="app_description" class="form-label">Description</label>
                                    <textarea class="form-control" id="app_description" 
                                              name="app_description" rows="3"><?php echo e(old('app_description', $settings['app_description'] ?? '')); ?></textarea>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <label for="currency" class="form-label">Currency *</label>
                                        <input type="text" class="form-control" id="currency" 
                                               name="currency" value="<?php echo e(old('currency', $settings['currency'] ?? 'IDR')); ?>" 
                                               maxlength="3" required>
                                        <small class="text-muted">e.g., IDR, USD</small>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="currency_symbol" class="form-label">Currency Symbol *</label>
                                        <input type="text" class="form-control" id="currency_symbol" 
                                               name="currency_symbol" value="<?php echo e(old('currency_symbol', $settings['currency_symbol'] ?? 'Rp')); ?>" 
                                               maxlength="5" required>
                                        <small class="text-muted">e.g., Rp, $, €</small>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="timezone" class="form-label">Timezone *</label>
                                        <select class="form-control" id="timezone" name="timezone" required>
                                            <option value="Asia/Jakarta" <?php echo e((old('timezone', $settings['timezone'] ?? 'Asia/Jakarta') == 'Asia/Jakarta') ? 'selected' : ''); ?>>
                                                Asia/Jakarta (GMT+7)
                                            </option>
                                            <option value="UTC" <?php echo e((old('timezone', $settings['timezone'] ?? '') == 'UTC') ? 'selected' : ''); ?>>
                                                UTC
                                            </option>
                                        </select>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="email_sender" class="form-label">Default Email Sender</label>
                                    <input type="email" class="form-control" id="email_sender" 
                                           name="email_sender" value="<?php echo e(old('email_sender', $settings['email_sender'] ?? 'noreply@chingubite.com')); ?>">
                                </div>

                                <div class="d-flex justify-content-end">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save me-1"></i> Save General Settings
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Operational Hours Tab -->
                <div class="tab-pane fade" id="operational">
                    <div class="card shadow">
                        <div class="card-header bg-primary text-white">
                            <h5 class="mb-0">Operational Hours</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="<?php echo e(route('admin.settings.operational-hours.update')); ?>">
                                <?php echo csrf_field(); ?>
                                
                                <?php
                                    $days = [
                                        'monday' => 'Monday',
                                        'tuesday' => 'Tuesday',
                                        'wednesday' => 'Wednesday',
                                        'thursday' => 'Thursday',
                                        'friday' => 'Friday',
                                        'saturday' => 'Saturday',
                                        'sunday' => 'Sunday'
                                    ];
                                    
                                    $operationalHours = $settings['operational_hours'] ?? [];
                                ?>
                                
                                <?php $__currentLoopData = $days; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="row mb-3 align-items-center border-bottom pb-3">
                                    <div class="col-md-2">
                                        <strong><?php echo e($day); ?></strong>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-check">
                                            <input type="checkbox" class="form-check-input" 
                                                   id="<?php echo e($key); ?>_open" name="<?php echo e($key); ?>_open" value="1"
                                                   <?php echo e(old($key.'_open', $operationalHours[$loop->index]['is_open'] ?? true) ? 'checked' : ''); ?>>
                                            <label class="form-check-label" for="<?php echo e($key); ?>_open">Open</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="<?php echo e($key); ?>_open_time" class="form-label">Open Time</label>
                                        <input type="time" class="form-control" 
                                               id="<?php echo e($key); ?>_open_time" name="<?php echo e($key); ?>_open_time"
                                               value="<?php echo e(old($key.'_open_time', $operationalHours[$loop->index]['open_time'] ?? '08:00')); ?>">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="<?php echo e($key); ?>_close_time" class="form-label">Close Time</label>
                                        <input type="time" class="form-control" 
                                               id="<?php echo e($key); ?>_close_time" name="<?php echo e($key); ?>_close_time"
                                               value="<?php echo e(old($key.'_close_time', $operationalHours[$loop->index]['close_time'] ?? '22:00')); ?>">
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle me-2"></i>
                                    <strong>Note:</strong> Times are in 24-hour format. Set open/close times for each day.
                                </div>

                                <div class="d-flex justify-content-end mt-4">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save me-1"></i> Save Operational Hours
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Tax & Fees Tab -->
                <div class="tab-pane fade" id="tax">
                    <div class="card shadow">
                        <div class="card-header bg-primary text-white">
                            <h5 class="mb-0">Tax & Fees Settings</h5>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="<?php echo e(route('admin.settings.tax.update')); ?>">
                                <?php echo csrf_field(); ?>
                                
                                <div class="row mb-4">
                                    <div class="col-md-6">
                                        <label for="tax_rate" class="form-label">Tax Rate (%) *</label>
                                        <div class="input-group">
                                            <input type="number" class="form-control" id="tax_rate" 
                                                   name="tax_rate" step="0.01" min="0" max="100"
                                                   value="<?php echo e(old('tax_rate', $settings['tax_rate'] ?? 10)); ?>" required>
                                            <span class="input-group-text">%</span>
                                        </div>
                                        <small class="text-muted">Percentage of tax applied to orders</small>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="service_fee" class="form-label">Service Fee (Rp) *</label>
                                        <div class="input-group">
                                            <span class="input-group-text">Rp</span>
                                            <input type="number" class="form-control" id="service_fee" 
                                                   name="service_fee" min="0"
                                                   value="<?php echo e(old('service_fee', $settings['service_fee'] ?? 5000)); ?>" required>
                                        </div>
                                        <small class="text-muted">Fixed service fee per order</small>
                                    </div>
                                </div>

                                <div class="mb-4">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="tax_inclusive" 
                                               name="tax_inclusive" value="1"
                                               <?php echo e(old('tax_inclusive', $settings['tax_inclusive'] ?? true) ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="tax_inclusive">
                                            Tax Inclusive Pricing
                                        </label>
                                    </div>
                                    <small class="text-muted">
                                        If checked, tax is included in menu prices. If unchecked, tax is added at checkout.
                                    </small>
                                </div>

                                <div class="alert alert-warning">
                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                    <strong>Important:</strong> Changing tax settings will affect all future orders. 
                                    Existing orders will not be modified.
                                </div>

                                <div class="d-flex justify-content-end">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save me-1"></i> Save Tax Settings
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Payment Settings Tab -->
                <div class="tab-pane fade" id="payment">
                    <div class="card shadow">
                        <div class="card-header bg-primary text-white">
                            <h5 class="mb-0">Payment Settings</h5>
                        </div>
                        <div class="card-body">
                            <form>
                                <?php echo csrf_field(); ?>
                                
                                <div class="row mb-4">
                                    <div class="col-md-6">
                                        <label for="payment_confirmation_timeout" class="form-label">Payment Confirmation Timeout (Hours)</label>
                                        <input type="number" class="form-control" id="payment_confirmation_timeout" 
                                               name="payment_confirmation_timeout" min="1" max="72"
                                               value="<?php echo e(old('payment_confirmation_timeout', $settings['payment_confirmation_timeout'] ?? 24)); ?>">
                                        <small class="text-muted">Time allowed for customers to upload payment proof</small>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="auto_confirm_cash_payment" class="form-label">Cash Payment Handling</label>
                                        <select class="form-control" id="auto_confirm_cash_payment" name="auto_confirm_cash_payment">
                                            <option value="1" <?php echo e((old('auto_confirm_cash_payment', $settings['auto_confirm_cash_payment'] ?? true)) ? 'selected' : ''); ?>>
                                                Auto-confirm cash payments
                                            </option>
                                            <option value="0" <?php echo e(!(old('auto_confirm_cash_payment', $settings['auto_confirm_cash_payment'] ?? true)) ? 'selected' : ''); ?>>
                                                Manual confirmation required
                                            </option>
                                        </select>
                                        <small class="text-muted">How cash payments are handled</small>
                                    </div>
                                </div>

                                <div class="mb-4">
                                    <h6>Payment Methods</h6>
                                    <div class="alert alert-info">
                                        <i class="fas fa-info-circle me-2"></i>
                                        Payment methods are managed separately in 
                                        <a href="<?php echo e(route('admin.payment-methods.index')); ?>" class="alert-link">
                                            Payment Methods section
                                        </a>.
                                    </div>
                                </div>

                                <div class="d-flex justify-content-end">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save me-1"></i> Save Payment Settings
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Notification Settings Tab -->
                <div class="tab-pane fade" id="notification">
                    <div class="card shadow">
                        <div class="card-header bg-primary text-white">
                            <h5 class="mb-0">Notification Settings</h5>
                        </div>
                        <div class="card-body">
                            <form>
                                <?php echo csrf_field(); ?>
                                
                                <div class="mb-4">
                                    <h6>Email Notifications</h6>
                                    
                                    <div class="form-check mb-3">
                                        <input type="checkbox" class="form-check-input" 
                                               id="notification_order_new" name="notification_order_new" value="1"
                                               <?php echo e(old('notification_order_new', $settings['notification_order_new'] ?? true) ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="notification_order_new">
                                            New Order Notifications
                                        </label>
                                        <small class="text-muted d-block">
                                            Send email when new order is placed
                                        </small>
                                    </div>

                                    <div class="form-check mb-3">
                                        <input type="checkbox" class="form-check-input" 
                                               id="notification_payment_confirmed" name="notification_payment_confirmed" value="1"
                                               <?php echo e(old('notification_payment_confirmed', $settings['notification_payment_confirmed'] ?? true) ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="notification_payment_confirmed">
                                            Payment Confirmation Notifications
                                        </label>
                                        <small class="text-muted d-block">
                                            Send email when payment is confirmed
                                        </small>
                                    </div>

                                    <div class="form-check mb-3">
                                        <input type="checkbox" class="form-check-input" 
                                               id="notification_order_ready" name="notification_order_ready" value="1"
                                               <?php echo e(old('notification_order_ready', $settings['notification_order_ready'] ?? true) ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="notification_order_ready">
                                            Order Ready Notifications
                                        </label>
                                        <small class="text-muted d-block">
                                            Send email when order is ready for pickup/delivery
                                        </small>
                                    </div>
                                </div>

                                <div class="mb-4">
                                    <h6>Admin Notifications</h6>
                                    
                                    <div class="form-check mb-3">
                                        <input type="checkbox" class="form-check-input" 
                                               id="admin_notification_new_order" name="admin_notification_new_order" value="1"
                                               <?php echo e(old('admin_notification_new_order', $settings['admin_notification_new_order'] ?? true) ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="admin_notification_new_order">
                                            New Order Alerts
                                        </label>
                                        <small class="text-muted d-block">
                                            Alert admins about new orders
                                        </small>
                                    </div>

                                    <div class="form-check mb-3">
                                        <input type="checkbox" class="form-check-input" 
                                               id="admin_notification_low_stock" name="admin_notification_low_stock" value="1"
                                               <?php echo e(old('admin_notification_low_stock', $settings['admin_notification_low_stock'] ?? true) ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="admin_notification_low_stock">
                                            Low Stock Alerts
                                        </label>
                                        <small class="text-muted d-block">
                                            Alert when menu items are low in stock
                                        </small>
                                    </div>
                                </div>

                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle me-2"></i>
                                    Email notifications require proper email configuration in your .env file.
                                </div>

                                <div class="d-flex justify-content-end">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save me-1"></i> Save Notification Settings
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Tab switching with URL hash
        const hash = window.location.hash;
        if (hash) {
            const tab = document.querySelector(`[data-bs-target="${hash}"]`);
            if (tab) {
                new bootstrap.Tab(tab).show();
            }
        }

        // Update URL when tab changes
        document.querySelectorAll('[data-bs-toggle="tab"]').forEach(tab => {
            tab.addEventListener('shown.bs.tab', function(event) {
                window.location.hash = event.target.getAttribute('href');
            });
        });

        // Toggle time fields based on open/close checkbox
        document.querySelectorAll('[id$="_open"]').forEach(checkbox => {
            const day = checkbox.id.replace('_open', '');
            const openTime = document.getElementById(`${day}_open_time`);
            const closeTime = document.getElementById(`${day}_close_time`);
            
            function toggleTimeFields() {
                const disabled = !checkbox.checked;
                openTime.disabled = disabled;
                closeTime.disabled = disabled;
            }
            
            toggleTimeFields();
            checkbox.addEventListener('change', toggleTimeFields);
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\admin\settings\index.blade.php ENDPATH**/ ?>