


<?php $__env->startSection('title', 'Manage Orders - Chingu Bite'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">Manage Orders</h1>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#filterModal">
            <i class="fas fa-filter me-1"></i>Filter
        </button>
    </div>

    <!-- Filter Modal -->
    <div class="modal fade" id="filterModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Filter Orders</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form method="GET" action="<?php echo e(route('employee.orders.index')); ?>">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label">Status</label>
                            <select name="status" class="form-select">
                                <option value="">All Status</option>
                                <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($status); ?>" <?php echo e(request('status') == $status ? 'selected' : ''); ?>>
                                        <?php echo e(ucfirst($status)); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Order Type</label>
                            <select name="order_type" class="form-select">
                                <option value="">All Types</option>
                                <?php $__currentLoopData = $orderTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($type); ?>" <?php echo e(request('order_type') == $type ? 'selected' : ''); ?>>
                                        <?php echo e(ucfirst(str_replace('_', ' ', $type))); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Start Date</label>
                                <input type="date" name="start_date" class="form-control" 
                                       value="<?php echo e(request('start_date')); ?>">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">End Date</label>
                                <input type="date" name="end_date" class="form-control" 
                                       value="<?php echo e(request('end_date')); ?>">
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Search</label>
                            <input type="text" name="search" class="form-control" 
                                   value="<?php echo e(request('search')); ?>" placeholder="Order #, Customer Name...">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Apply Filters</button>
                        <a href="<?php echo e(route('employee.orders.index')); ?>" class="btn btn-outline-danger">Clear</a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Active Filters -->
    <?php if(request()->hasAny(['status', 'order_type', 'start_date', 'end_date', 'search'])): ?>
    <div class="alert alert-info d-flex justify-content-between align-items-center mb-4">
        <div>
            <i class="fas fa-filter me-2"></i>
            <strong>Active Filters:</strong>
            <?php if(request('status')): ?> <span class="badge bg-primary ms-2"><?php echo e(ucfirst(request('status'))); ?></span> <?php endif; ?>
            <?php if(request('order_type')): ?> <span class="badge bg-info ms-2"><?php echo e(ucfirst(str_replace('_', ' ', request('order_type')))); ?></span> <?php endif; ?>
            <?php if(request('search')): ?> <span class="badge bg-secondary ms-2">Search: <?php echo e(request('search')); ?></span> <?php endif; ?>
            <?php if(request('start_date') && request('end_date')): ?> 
                <span class="badge bg-warning ms-2"><?php echo e(request('start_date')); ?> to <?php echo e(request('end_date')); ?></span>
            <?php endif; ?>
        </div>
        <a href="<?php echo e(route('employee.orders.index')); ?>" class="btn btn-sm btn-outline-danger">
            Clear All
        </a>
    </div>
    <?php endif; ?>

    <!-- Orders Table -->
    <div class="card shadow">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Order #</th>
                            <th>Customer</th>
                            <th>Type</th>
                            <th>Items</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <strong>#<?php echo e($order['order_number']); ?></strong>
                                    <?php if($order['table_number']): ?>
                                        <br><small class="text-muted">Table <?php echo e($order['table_number']); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo e($order['customer']['name'] ?? 'Guest'); ?>

                                    <br><small class="text-muted"><?php echo e($order['customer']['phone'] ?? ''); ?></small>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($order['order_type'] == 'dine_in' ? 'info' : ($order['order_type'] == 'takeaway' ? 'warning' : 'success')); ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $order['order_type']))); ?>

                                    </span>
                                </td>
                                <td>
                                    <?php echo e($order['items_count'] ?? count($order['items'] ?? [])); ?>

                                    <br><small class="text-muted"><?php echo e($order['items_sum_quantity'] ?? '0'); ?> items</small>
                                </td>
                                <td>
                                    <strong>Rp <?php echo e(number_format($order['final_amount'], 0, ',', '.')); ?></strong>
                                    <?php if($order['discount_amount'] > 0): ?>
                                        <br><small class="text-success">-Rp <?php echo e(number_format($order['discount_amount'], 0, ',', '.')); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e(match($order['status']) {
                                        'pending' => 'warning',
                                        'confirmed' => 'primary',
                                        'preparing' => 'info',
                                        'ready' => 'success',
                                        'completed' => 'secondary',
                                        'cancelled' => 'danger',
                                        default => 'light'
                                    }); ?>">
                                        <?php echo e(ucfirst($order['status'])); ?>

                                    </span>
                                </td>
                                <td>
                                    <?php echo e(\Carbon\Carbon::parse($order['created_at'])->format('H:i')); ?>

                                    <br><small class="text-muted"><?php echo e(\Carbon\Carbon::parse($order['created_at'])->format('M d')); ?></small>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <a href="<?php echo e(route('employee.orders.show', $order['id'])); ?>" 
                                           class="btn btn-outline-primary" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        
                                        <?php if($order['status'] == 'pending'): ?>
                                            <button type="button" class="btn btn-outline-success confirm-btn" 
                                                    data-order-id="<?php echo e($order['id']); ?>" title="Confirm">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        <?php endif; ?>
                                        
                                        <?php if($order['status'] == 'confirmed'): ?>
                                            <button type="button" class="btn btn-outline-info preparing-btn" 
                                                    data-order-id="<?php echo e($order['id']); ?>" title="Start Preparing">
                                                <i class="fas fa-utensils"></i>
                                            </button>
                                        <?php endif; ?>
                                        
                                        <?php if($order['status'] == 'preparing'): ?>
                                            <button type="button" class="btn btn-outline-success ready-btn" 
                                                    data-order-id="<?php echo e($order['id']); ?>" title="Mark as Ready">
                                                <i class="fas fa-check-circle"></i>
                                            </button>
                                        <?php endif; ?>
                                        
                                        <?php if($order['status'] == 'ready'): ?>
                                            <button type="button" class="btn btn-outline-secondary complete-btn" 
                                                    data-order-id="<?php echo e($order['id']); ?>" title="Mark as Completed">
                                                <i class="fas fa-flag-checkered"></i>
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center py-5">
                                    <i class="fas fa-clipboard-list fa-3x text-muted mb-3"></i>
                                    <h5 class="text-muted">No orders found</h5>
                                    <p class="text-muted">Try adjusting your filters</p>
                                    <a href="<?php echo e(route('employee.orders.index')); ?>" class="btn btn-primary">
                                        Show All Orders
                                    </a>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            <?php if(isset($pagination)): ?>
            <div class="d-flex justify-content-between align-items-center mt-4">
                <div class="text-muted">
                    Showing <?php echo e(($pagination['current_page'] - 1) * $pagination['per_page'] + 1); ?> to 
                    <?php echo e(min($pagination['current_page'] * $pagination['per_page'], $pagination['total'])); ?> of 
                    <?php echo e($pagination['total']); ?> orders
                </div>
                <nav>
                    <ul class="pagination mb-0">
                        <li class="page-item <?php echo e($pagination['current_page'] == 1 ? 'disabled' : ''); ?>">
                            <a class="page-link" 
                               href="<?php echo e(route('employee.orders.index', array_merge($filters, ['page' => $pagination['current_page'] - 1]))); ?>">
                                Previous
                            </a>
                        </li>
                        
                        <?php for($i = 1; $i <= min($pagination['last_page'], 5); $i++): ?>
                            <li class="page-item <?php echo e($pagination['current_page'] == $i ? 'active' : ''); ?>">
                                <a class="page-link" 
                                   href="<?php echo e(route('employee.orders.index', array_merge($filters, ['page' => $i]))); ?>">
                                    <?php echo e($i); ?>

                                </a>
                            </li>
                        <?php endfor; ?>
                        
                        <?php if($pagination['last_page'] > 5): ?>
                            <li class="page-item disabled"><span class="page-link">...</span></li>
                            <li class="page-item">
                                <a class="page-link" 
                                   href="<?php echo e(route('employee.orders.index', array_merge($filters, ['page' => $pagination['last_page']]))); ?>">
                                    <?php echo e($pagination['last_page']); ?>

                                </a>
                            </li>
                        <?php endif; ?>
                        
                        <li class="page-item <?php echo e($pagination['current_page'] == $pagination['last_page'] ? 'disabled' : ''); ?>">
                            <a class="page-link" 
                               href="<?php echo e(route('employee.orders.index', array_merge($filters, ['page' => $pagination['current_page'] + 1]))); ?>">
                                Next
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Status update buttons
        document.querySelectorAll('.confirm-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                updateOrderStatus(this.dataset.orderId, 'confirmed');
            });
        });
        
        document.querySelectorAll('.preparing-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                updateOrderStatus(this.dataset.orderId, 'preparing');
            });
        });
        
        document.querySelectorAll('.ready-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                updateOrderStatus(this.dataset.orderId, 'ready');
            });
        });
        
        document.querySelectorAll('.complete-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                updateOrderStatus(this.dataset.orderId, 'completed');
            });
        });
        
        function updateOrderStatus(orderId, status) {
            if (!confirm(`Are you sure you want to mark this order as ${status}?`)) {
                return;
            }
            
            fetch(`/api/orders/${orderId}/status`, {
                method: 'PUT',
                headers: {
                    'Authorization': `Bearer ${window.USER_TOKEN}`,
                    'Content-Type': 'application/json',
                    'Accept': 'application/json'
                },
                body: JSON.stringify({ status: status })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Failed to update status: ' + (data.message || 'Unknown error'));
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Failed to update status');
            });
        }
        
        // Auto refresh every 60 seconds
        setInterval(() => {
            const shouldRefresh = !document.querySelector('.modal.show');
            if (shouldRefresh) {
                location.reload();
            }
        }, 60000);
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.employee', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\employee\orders\index.blade.php ENDPATH**/ ?>