

<?php $__env->startSection('title', 'Menu Management'); ?>
<?php $__env->startSection('page-title', 'Menu Management'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item active">Menu Management</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title mb-0">Menu Items</h6>
                    <a href="<?php echo e(route('admin.menu.create')); ?>" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus mr-1"></i> Add New Item
                    </a>
                </div>
                <div class="card-body">
                    <!-- Filter Form -->
                    <form method="GET" action="<?php echo e(route('admin.menu.index')); ?>" class="mb-4">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="search">Search</label>
                                    <input type="text" class="form-control" id="search" name="search" 
                                           value="<?php echo e(request('search')); ?>" placeholder="Search by name...">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="category_id">Category</label>
                                    <select class="form-control select2" id="category_id" name="category_id">
                                        <option value="">All Categories</option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($category['id']); ?>" 
                                                <?php echo e(request('category_id') == $category['id'] ? 'selected' : ''); ?>>
                                                <?php echo e($category['name']); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="is_available">Availability</label>
                                    <select class="form-control" id="is_available" name="is_available">
                                        <option value="">All</option>
                                        <option value="1" <?php echo e(request('is_available') == '1' ? 'selected' : ''); ?>>Available</option>
                                        <option value="0" <?php echo e(request('is_available') == '0' ? 'selected' : ''); ?>>Unavailable</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="fas fa-filter"></i> Filter
                                </button>
                            </div>
                        </div>
                    </form>

                    <!-- Menu Items Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered data-table">
                            <thead>
                                <tr>
                                    <th width="50">#</th>
                                    <th>Image</th>
                                    <th>Name</th>
                                    <th>Category</th>
                                    <th>Price</th>
                                    <th>Stock</th>
                                    <th>Status</th>
                                    <th>Tags</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td>
                                        <?php if($menu['image_url']): ?>
                                            <img src="<?php echo e($menu['image_url']); ?>" alt="<?php echo e($menu['name']); ?>" 
                                                 style="width: 50px; height: 50px; object-fit: cover; border-radius: 5px;">
                                        <?php else: ?>
                                            <div class="bg-light text-center" style="width: 50px; height: 50px; line-height: 50px; border-radius: 5px;">
                                                <i class="fas fa-utensils text-muted"></i>
                                            </div>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <strong><?php echo e($menu['name']); ?></strong>
                                        <?php if($menu['is_best_seller']): ?>
                                            <span class="badge bg-warning ml-2">Best Seller</span>
                                        <?php endif; ?>
                                        <?php if($menu['is_special']): ?>
                                            <span class="badge bg-danger ml-2">Special</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($menu['category_name'] ?? 'N/A'); ?></td>
                                    <td>Rp <?php echo e(number_format($menu['price'], 0, ',', '.')); ?></td>
                                    <td>
                                        <?php if($menu['stock'] === null): ?>
                                            <span class="text-muted">N/A</span>
                                        <?php else: ?>
                                            <span class="<?php echo e($menu['stock'] <= 10 ? 'text-danger' : 'text-success'); ?>">
                                                <?php echo e($menu['stock']); ?>

                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge badge-<?php echo e($menu['is_available'] ? 'success' : 'danger'); ?>">
                                            <?php echo e($menu['is_available'] ? 'Available' : 'Unavailable'); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-wrap gap-1">
                                            <?php if($menu['is_best_seller']): ?>
                                                <span class="badge bg-warning">Best Seller</span>
                                            <?php endif; ?>
                                            <?php if($menu['is_special']): ?>
                                                <span class="badge bg-danger">Special</span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('admin.menu.show', $menu['id'])); ?>" 
                                               class="btn btn-info btn-sm" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.menu.edit', $menu['id'])); ?>" 
                                               class="btn btn-warning btn-sm" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="<?php echo e(route('admin.menu.destroy', $menu['id'])); ?>" 
                                                  method="POST" class="d-inline" 
                                                  onsubmit="return confirm('Are you sure you want to delete this item?');">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger btn-sm" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            <form action="<?php echo e(route('admin.menu.toggle_availability', $menu['id'])); ?>" 
                                                  method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <button type="submit" class="btn btn-<?php echo e($menu['is_available'] ? 'secondary' : 'success'); ?> btn-sm" 
                                                        title="<?php echo e($menu['is_available'] ? 'Make Unavailable' : 'Make Available'); ?>">
                                                    <i class="fas fa-<?php echo e($menu['is_available'] ? 'times' : 'check'); ?>"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center">No menu items found</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <?php if($pagination): ?>
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div class="text-muted">
                                Showing <?php echo e(($pagination['current_page'] - 1) * $pagination['per_page'] + 1); ?> to 
                                <?php echo e(min($pagination['current_page'] * $pagination['per_page'], $pagination['total'])); ?> of 
                                <?php echo e($pagination['total']); ?> entries
                            </div>
                            <nav>
                                <ul class="pagination pagination-sm mb-0">
                                    <?php if($pagination['current_page'] > 1): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?php echo e(request()->fullUrlWithQuery(['page' => $pagination['current_page'] - 1])); ?>">
                                                Previous
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php for($i = 1; $i <= $pagination['last_page']; $i++): ?>
                                        <?php if($i == 1 || $i == $pagination['last_page'] || ($i >= $pagination['current_page'] - 2 && $i <= $pagination['current_page'] + 2)): ?>
                                            <li class="page-item <?php echo e($i == $pagination['current_page'] ? 'active' : ''); ?>">
                                                <a class="page-link" href="<?php echo e(request()->fullUrlWithQuery(['page' => $i])); ?>">
                                                    <?php echo e($i); ?>

                                                </a>
                                            </li>
                                        <?php elseif($i == $pagination['current_page'] - 3 || $i == $pagination['current_page'] + 3): ?>
                                            <li class="page-item disabled">
                                                <span class="page-link">...</span>
                                            </li>
                                        <?php endif; ?>
                                    <?php endfor; ?>

                                    <?php if($pagination['current_page'] < $pagination['last_page']): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?php echo e(request()->fullUrlWithQuery(['page' => $pagination['current_page'] + 1])); ?>">
                                                Next
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </nav>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .table-responsive {
        overflow-x: auto;
    }
    .btn-group .btn {
        border-radius: 0;
    }
    .btn-group .btn:first-child {
        border-radius: 4px 0 0 4px;
    }
    .btn-group .btn:last-child {
        border-radius: 0 4px 4px 0;
    }
    .badge {
        font-size: 0.75em;
        padding: 0.35em 0.65em;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function() {
        // Initialize DataTable
        $('.data-table').DataTable({
            paging: false,
            searching: false,
            info: false,
            order: [[2, 'asc']] // Sort by name
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\admin\menu\index.blade.php ENDPATH**/ ?>