

<?php $__env->startSection('title', 'Add Promotion'); ?>
<?php $__env->startSection('page-title', 'Add Promotion'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.promos.index')); ?>">Promo Management</a></li>
    <li class="breadcrumb-item active">Add Promotion</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">Add New Promotion</h6>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('admin.promos.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <!-- Basic Information -->
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">Basic Information</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="name">Promotion Name *</label>
                                            <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   id="name" name="name" value="<?php echo e(old('name')); ?>" required>
                                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="type">Discount Type *</label>
                                            <select class="form-control <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                    id="type" name="type" required>
                                                <option value="">Select Type</option>
                                                <option value="percentage" <?php echo e(old('type') == 'percentage' ? 'selected' : ''); ?>>Percentage Discount</option>
                                                <option value="fixed" <?php echo e(old('type') == 'fixed' ? 'selected' : ''); ?>>Fixed Amount Discount</option>
                                                <option value="bogo" <?php echo e(old('type') == 'bogo' ? 'selected' : ''); ?>>Buy One Get One (BOGO)</option>
                                            </select>
                                            <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="discount_value">Discount Value *</label>
                                            <div class="input-group">
                                                <input type="number" class="form-control <?php $__errorArgs = ['discount_value'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                       id="discount_value" name="discount_value" value="<?php echo e(old('discount_value')); ?>" 
                                                       min="0" step="0.01" required>
                                                <div class="input-group-append">
                                                    <span class="input-group-text" id="discount_suffix">%</span>
                                                </div>
                                                <?php $__errorArgs = ['discount_value'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <small class="form-text text-muted" id="discount_hint">
                                                Enter percentage (e.g., 10 for 10%)
                                            </small>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="code">Promo Code</label>
                                            <input type="text" class="form-control <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   id="code" name="code" value="<?php echo e(old('code')); ?>" 
                                                   placeholder="Leave empty for auto-apply promotions">
                                            <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            <small class="form-text text-muted">
                                                Leave blank for promotions that apply automatically (e.g., seasonal discounts)
                                            </small>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="description">Description</label>
                                            <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                      id="description" name="description" rows="3"><?php echo e(old('description')); ?></textarea>
                                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <!-- Conditions & Validity -->
                                <div class="card mb-4">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">Conditions & Validity</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="min_purchase">Minimum Purchase (Rp)</label>
                                                    <input type="number" class="form-control <?php $__errorArgs = ['min_purchase'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                           id="min_purchase" name="min_purchase" value="<?php echo e(old('min_purchase')); ?>" 
                                                           min="0" step="100">
                                                    <?php $__errorArgs = ['min_purchase'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    <small class="form-text text-muted">
                                                        Minimum order amount to apply this promo
                                                    </small>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="max_discount">Maximum Discount (Rp)</label>
                                                    <input type="number" class="form-control <?php $__errorArgs = ['max_discount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                           id="max_discount" name="max_discount" value="<?php echo e(old('max_discount')); ?>" 
                                                           min="0" step="100">
                                                    <?php $__errorArgs = ['max_discount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                    <small class="form-text text-muted">
                                                        Maximum discount amount (for percentage discounts)
                                                    </small>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="start_date">Start Date *</label>
                                                    <input type="date" class="form-control datepicker <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                           id="start_date" name="start_date" value="<?php echo e(old('start_date')); ?>" required>
                                                    <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="end_date">End Date *</label>
                                                    <input type="date" class="form-control datepicker <?php $__errorArgs = ['end_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                           id="end_date" name="end_date" value="<?php echo e(old('end_date')); ?>" required>
                                                    <?php $__errorArgs = ['end_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="form-group">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="is_active" 
                                                       name="is_active" value="1" <?php echo e(old('is_active', true) ? 'checked' : ''); ?>>
                                                <label class="custom-control-label" for="is_active">Active</label>
                                            </div>
                                            <small class="form-text text-muted">
                                                Inactive promotions won't be available to customers
                                            </small>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Usage Statistics Preview -->
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="card-title mb-0">Preview</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="alert alert-info">
                                            <h6><i class="fas fa-info-circle mr-2"></i>Promotion Preview</h6>
                                            <p class="mb-1" id="preview_name"><strong>Name:</strong> <span id="preview_name_value"><?php echo e(old('name', 'New Promotion')); ?></span></p>
                                            <p class="mb-1" id="preview_type"><strong>Type:</strong> <span id="preview_type_value"><?php echo e(old('type', 'Percentage')); ?></span></p>
                                            <p class="mb-1" id="preview_value"><strong>Value:</strong> <span id="preview_value_value"><?php echo e(old('discount_value', 0)); ?></span></p>
                                            <p class="mb-0" id="preview_validity"><strong>Validity:</strong> <span id="preview_validity_value">
                                                <?php echo e(old('start_date') ? date('d M Y', strtotime(old('start_date'))) : 'Today'); ?> to 
                                                <?php echo e(old('end_date') ? date('d M Y', strtotime(old('end_date'))) : 'Next Month'); ?>

                                            </span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Action Buttons -->
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="d-flex justify-content-between">
                                    <a href="<?php echo e(route('admin.promos.index')); ?>" class="btn btn-secondary">
                                        <i class="fas fa-arrow-left mr-1"></i> Back
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save mr-1"></i> Create Promotion
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const typeSelect = document.getElementById('type');
        const discountValueInput = document.getElementById('discount_value');
        const discountSuffix = document.getElementById('discount_suffix');
        const discountHint = document.getElementById('discount_hint');
        
        const previewName = document.getElementById('preview_name_value');
        const previewType = document.getElementById('preview_type_value');
        const previewValue = document.getElementById('preview_value_value');
        
        // Update preview when inputs change
        document.getElementById('name').addEventListener('input', function() {
            previewName.textContent = this.value || 'New Promotion';
        });
        
        typeSelect.addEventListener('change', function() {
            const type = this.value;
            let suffix = '%';
            let hint = 'Enter percentage (e.g., 10 for 10%)';
            let typeText = 'Percentage';
            
            if (type === 'fixed') {
                suffix = 'Rp';
                hint = 'Enter fixed amount (e.g., 5000 for Rp 5,000)';
                typeText = 'Fixed Amount';
            } else if (type === 'bogo') {
                suffix = '';
                discountValueInput.value = '';
                discountValueInput.disabled = true;
                hint = 'Buy One Get One - No value needed';
                typeText = 'BOGO';
            } else {
                discountValueInput.disabled = false;
            }
            
            discountSuffix.textContent = suffix;
            discountHint.textContent = hint;
            previewType.textContent = typeText;
            
            updateValuePreview();
        });
        
        discountValueInput.addEventListener('input', updateValuePreview);
        
        function updateValuePreview() {
            const type = typeSelect.value;
            const value = discountValueInput.value;
            
            if (type === 'percentage') {
                previewValue.textContent = value + '% discount';
            } else if (type === 'fixed') {
                previewValue.textContent = 'Rp ' + Number(value).toLocaleString() + ' discount';
            } else if (type === 'bogo') {
                previewValue.textContent = 'Buy One Get One';
            }
        }
        
        // Update date preview
        const startDateInput = document.getElementById('start_date');
        const endDateInput = document.getElementById('end_date');
        const previewValidity = document.getElementById('preview_validity_value');
        
        function updateDatePreview() {
            const startDate = startDateInput.value ? new Date(startDateInput.value) : new Date();
            const endDate = endDateInput.value ? new Date(endDateInput.value) : new Date();
            endDate.setMonth(endDate.getMonth() + 1);
            
            const formatDate = (date) => {
                return date.toLocaleDateString('en-GB', {
                    day: '2-digit',
                    month: 'short',
                    year: 'numeric'
                });
            };
            
            previewValidity.textContent = formatDate(startDate) + ' to ' + formatDate(endDate);
        }
        
        startDateInput.addEventListener('change', updateDatePreview);
        endDateInput.addEventListener('change', updateDatePreview);
        
        // Set default dates if not set
        if (!startDateInput.value) {
            const today = new Date();
            startDateInput.value = today.toISOString().split('T')[0];
            
            const nextMonth = new Date();
            nextMonth.setMonth(nextMonth.getMonth() + 1);
            endDateInput.value = nextMonth.toISOString().split('T')[0];
        }
        
        // Initialize datepickers
        flatpickr(".datepicker", {
            dateFormat: "Y-m-d",
            minDate: "today"
        });
        
        // Update preview on load
        updateDatePreview();
        updateValuePreview();
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\admin\promos\create.blade.php ENDPATH**/ ?>