


<?php $__env->startSection('title', 'Orders Management'); ?>
<?php $__env->startSection('page_title', 'Orders Management'); ?>
<?php $__env->startSection('icon', 'fa-shopping-cart'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active">Orders Management</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Filter Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card employee-card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="card-title mb-0">Filter Orders</h5>
                        <a href="<?php echo e(route('employee.orders.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> New Order
                        </a>
                    </div>
                    
                    <form method="GET" action="<?php echo e(route('employee.orders.index')); ?>" class="row g-3">
                        <div class="col-md-3">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-control" name="status" id="status">
                                <option value="">All Status</option>
                                <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                                <option value="processing" <?php echo e(request('status') == 'processing' ? 'selected' : ''); ?>>Processing</option>
                                <option value="preparing" <?php echo e(request('status') == 'preparing' ? 'selected' : ''); ?>>Preparing</option>
                                <option value="ready" <?php echo e(request('status') == 'ready' ? 'selected' : ''); ?>>Ready</option>
                                <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>>Completed</option>
                                <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                            </select>
                        </div>
                        
                        <div class="col-md-3">
                            <label for="order_type" class="form-label">Order Type</label>
                            <select class="form-control" name="order_type" id="order_type">
                                <option value="">All Types</option>
                                <option value="dine_in" <?php echo e(request('order_type') == 'dine_in' ? 'selected' : ''); ?>>Dine-in</option>
                                <option value="takeaway" <?php echo e(request('order_type') == 'takeaway' ? 'selected' : ''); ?>>Takeaway</option>
                                <option value="delivery" <?php echo e(request('order_type') == 'delivery' ? 'selected' : ''); ?>>Delivery</option>
                            </select>
                        </div>
                        
                        <div class="col-md-3">
                            <label for="date" class="form-label">Date</label>
                            <input type="date" class="form-control" name="date" id="date" 
                                   value="<?php echo e(request('date')); ?>">
                        </div>
                        
                        <div class="col-md-3 d-flex align-items-end">
                            <div class="d-flex gap-2 w-100">
                                <button type="submit" class="btn btn-primary flex-grow-1">
                                    <i class="fas fa-filter me-1"></i> Filter
                                </button>
                                <a href="<?php echo e(route('employee.orders.index')); ?>" class="btn btn-secondary">
                                    <i class="fas fa-redo"></i>
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Orders Table -->
    <div class="row">
        <div class="col-12">
            <div class="card employee-card">
                <div class="employee-card-header">
                    <h6 class="mb-0">
                        <i class="fas fa-list me-2"></i>All Orders (<?php echo e($orders->total()); ?>)
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover employee-table">
                            <thead>
                                <tr>
                                    <th>Order #</th>
                                    <th>Customer</th>
                                    <th>Type</th>
                                    <th>Items</th>
                                    <th>Total Amount</th>
                                    <th>Payment</th>
                                    <th>Status</th>
                                    <th>Time</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <strong>#<?php echo e($order->order_number); ?></strong>
                                        <?php if($order->is_urgent): ?>
                                            <span class="badge bg-danger ms-1">Urgent</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div><?php echo e($order->customer_name ?? 'Guest'); ?></div>
                                        <?php if($order->table): ?>
                                            <small class="text-muted">Table: <?php echo e($order->table->name); ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge <?php echo e($order->order_type == 'dine_in' ? 'bg-info' : ($order->order_type == 'takeaway' ? 'bg-warning' : 'bg-primary')); ?>">
                                            <?php echo e(ucfirst($order->order_type)); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($order->items_count); ?> items</td>
                                    <td>
                                        <strong>Rp <?php echo e(number_format($order->total_amount, 0, ',', '.')); ?></strong>
                                    </td>
                                    <td>
                                        <?php if($order->payment): ?>
                                            <span class="badge payment-<?php echo e($order->payment->status); ?>">
                                                <?php echo e(ucfirst($order->payment->status)); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">Pending</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="status-badge status-<?php echo e($order->status); ?>">
                                            <?php echo e(ucfirst($order->status)); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <small class="text-muted">
                                            <?php echo e($order->created_at->format('H:i')); ?><br>
                                            <?php echo e($order->created_at->diffForHumans()); ?>

                                        </small>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="<?php echo e(route('employee.orders.show', $order->id)); ?>" 
                                               class="btn btn-info" data-bs-toggle="tooltip" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            <!-- Update Status Dropdown -->
                                            <div class="dropdown">
                                                <button class="btn btn-warning dropdown-toggle" 
                                                        type="button" data-bs-toggle="dropdown"
                                                        data-bs-toggle="tooltip" title="Update Status">
                                                    <i class="fas fa-sync-alt"></i>
                                                </button>
                                                <div class="dropdown-menu">
                                                    <?php $__currentLoopData = ['processing', 'preparing', 'ready', 'completed']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $newStatus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($order->status != $newStatus): ?>
                                                            <form action="<?php echo e(route('employee.orders.update_status', $order->id)); ?>" 
                                                                  method="POST" class="d-inline">
                                                                <?php echo csrf_field(); ?>
                                                                <?php echo method_field('PUT'); ?>
                                                                <input type="hidden" name="status" value="<?php echo e($newStatus); ?>">
                                                                <button type="submit" class="dropdown-item">
                                                                    Mark as <?php echo e(ucfirst($newStatus)); ?>

                                                                </button>
                                                            </form>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    
                                                    <?php if($order->status != 'cancelled'): ?>
                                                        <div class="dropdown-divider"></div>
                                                        <form action="<?php echo e(route('employee.orders.update_status', $order->id)); ?>" 
                                                              method="POST" class="d-inline">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('PUT'); ?>
                                                            <input type="hidden" name="status" value="cancelled">
                                                            <button type="submit" class="dropdown-item text-danger">
                                                                Cancel Order
                                                            </button>
                                                        </form>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            
                                            <!-- Print Receipt -->
                                            <?php if($order->status == 'completed' || $order->status == 'ready'): ?>
                                                <a href="<?php echo e(route('employee.orders.print_receipt', $order->id)); ?>" 
                                                   class="btn btn-primary" target="_blank"
                                                   data-bs-toggle="tooltip" title="Print Receipt">
                                                    <i class="fas fa-print"></i>
                                                </a>
                                            <?php endif; ?>
                                            
                                            <!-- Make Urgent -->
                                            <?php if(!$order->is_urgent && $order->status == 'pending'): ?>
                                                <form action="<?php echo e(route('employee.orders.toggle_urgent', $order->id)); ?>" 
                                                      method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <button type="submit" class="btn btn-danger btn-sm"
                                                            data-bs-toggle="tooltip" title="Mark as Urgent">
                                                        <i class="fas fa-exclamation"></i>
                                                    </button>
                                                </form>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center py-4">
                                        <i class="fas fa-shopping-cart fa-3x text-muted mb-3"></i>
                                        <h5>No orders found</h5>
                                        <p class="text-muted">Try adjusting your filters</p>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <?php if($orders->hasPages()): ?>
                        <div class="d-flex justify-content-center mt-3">
                            <?php echo e($orders->links()); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function() {
        // Initialize tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
        
        // Auto-refresh orders every 60 seconds
        setInterval(function() {
            if (document.visibilityState === 'visible') {
                window.location.reload();
            }
        }, 60000);
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.employee', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views/employee/dashboard.blade.php ENDPATH**/ ?>