
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Careers - Chingu Bite</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding-top: 56px;
        }
        
        .hero-section {
            background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), 
                        url('https://images.unsplash.com/photo-1521791136064-7986c2920216?ixlib=rb-1.2.1&auto=format&fit=crop&w=1950&q=80');
            background-size: cover;
            background-position: center;
            color: white;
            padding: 80px 0;
        }
        
        .job-card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.08);
            transition: transform 0.3s, box-shadow 0.3s;
            height: 100%;
        }
        
        .job-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.15);
        }
        
        .job-card .card-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 10px 10px 0 0 !important;
        }
        
        .badge-urgent {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            color: white;
            padding: 5px 10px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: 600;
        }
        
        .badge-type {
            background: #e9ecef;
            color: #495057;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 0.75rem;
        }
        
        .feature-icon {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 15px;
        }
        
        .feature-icon i {
            font-size: 20px;
            color: white;
        }
        
        .apply-btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            color: white;
            padding: 8px 20px;
            border-radius: 25px;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .apply-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
        }
        
        .footer {
            background: #1a202c;
            color: white;
            margin-top: 50px;
        }
        
        .navbar {
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .search-box {
            max-width: 400px;
            margin: 0 auto;
        }
        
        .empty-state {
            text-align: center;
            padding: 60px 0;
        }
        
        .empty-state i {
            font-size: 4rem;
            color: #dee2e6;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>

    <!-- Hero Section -->
    <section class="hero-section text-center">
        <div class="container">
            <h1 class="display-4 mb-4">Join Our Team</h1>
            <p class="lead mb-4">Be part of our journey to bring authentic Korean cuisine to everyone</p>
            
            <!-- Search Box -->
            <div class="search-box mb-4">
                <div class="input-group">
                    <input type="text" class="form-control" id="searchJobs" placeholder="Search job titles...">
                    <button class="btn btn-primary" type="button">
                        <i class="fas fa-search"></i>
                    </button>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row text-center mb-5">
                <div class="col-md-12">
                    <h2 class="mb-3">Why Work With Us?</h2>
                    <p class="text-muted">We offer more than just a job</p>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-3 mb-4">
                    <div class="feature-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <h5>Great Team</h5>
                    <p class="text-muted">Work with passionate and friendly colleagues</p>
                </div>
                
                <div class="col-md-3 mb-4">
                    <div class="feature-icon">
                        <i class="fas fa-graduation-cap"></i>
                    </div>
                    <h5>Career Growth</h5>
                    <p class="text-muted">Opportunities for learning and advancement</p>
                </div>
                
                <div class="col-md-3 mb-4">
                    <div class="feature-icon">
                        <i class="fas fa-utensils"></i>
                    </div>
                    <h5>Food Benefits</h5>
                    <p class="text-muted">Enjoy delicious Korean food during shifts</p>
                </div>
                
                <div class="col-md-3 mb-4">
                    <div class="feature-icon">
                        <i class="fas fa-calendar-alt"></i>
                    </div>
                    <h5>Flexible Schedule</h5>
                    <p class="text-muted">Work-life balance with flexible hours</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Job Listings -->
    <section class="py-5" id="job-listings">
        <div class="container">
            <div class="row mb-4">
                <div class="col-md-6">
                    <h2>Current Openings</h2>
                    <p class="text-muted">Find your perfect role</p>
                </div>
                <div class="col-md-6 text-end">
                    <div class="dropdown">
                        <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            Filter by: All Departments
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#" data-filter="all">All Departments</a></li>
                            <li><a class="dropdown-item" href="#" data-filter="kitchen">Kitchen</a></li>
                            <li><a class="dropdown-item" href="#" data-filter="service">Service</a></li>
                            <li><a class="dropdown-item" href="#" data-filter="management">Management</a></li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <div class="row" id="jobs-container">
                <?php if(isset($careers) && count($careers) > 0): ?>
                    <?php $__currentLoopData = $careers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $career): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-6 mb-4 job-item" data-department="<?php echo e(strtolower($career['department'] ?? '')); ?>">
                        <div class="card job-card h-100">
                            <div class="card-header">
                                <div class="d-flex justify-content-between align-items-center">
                                    <h5 class="mb-0"><?php echo e($career['title']); ?></h5>
                                    <?php if($career['is_urgent'] ?? false): ?>
                                        <span class="badge-urgent">Urgent Hiring</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <div class="d-flex justify-content-between mb-2">
                                        <span><i class="fas fa-building me-2"></i><?php echo e(ucfirst($career['department'] ?? 'General')); ?></span>
                                        <span><i class="fas fa-map-marker-alt me-2"></i><?php echo e($career['location'] ?? 'Not specified'); ?></span>
                                    </div>
                                    <div class="d-flex justify-content-between">
                                        <span class="badge-type">
                                            <?php echo e(str_replace('_', ' ', ucfirst($career['employment_type'] ?? 'full_time'))); ?>

                                        </span>
                                        <span>
                                            <i class="fas fa-clock me-2"></i>
                                            Apply by: <?php echo e(\Carbon\Carbon::parse($career['application_deadline'])->format('M d, Y')); ?>

                                        </span>
                                    </div>
                                </div>
                                
                                <p class="card-text">
                                    <?php echo e(Str::limit($career['description'] ?? '', 150)); ?>

                                </p>
                                
                                <?php if($career['salary_range']): ?>
                                <div class="alert alert-info py-2 mb-3">
                                    <i class="fas fa-money-bill-wave me-2"></i>
                                    <strong>Salary:</strong> <?php echo e($career['salary_range']); ?>

                                </div>
                                <?php endif; ?>
                                
                                <div class="d-flex justify-content-between align-items-center mt-3">
                                    <small class="text-muted">
                                        <i class="fas fa-eye me-1"></i>
                                        <?php echo e($career['views_count'] ?? 0); ?> views
                                    </small>
                                    <div>
                                        <?php if(\Carbon\Carbon::parse($career['application_deadline'])->isPast()): ?>
                                            <span class="badge bg-danger">Expired</span>
                                        <?php else: ?>
                                            <a href="<?php echo e(route('customer.careers.show', $career['id'])); ?>" class="btn apply-btn">
                                                <i class="fas fa-paper-plane me-1"></i>Apply Now
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="col-md-12">
                        <div class="empty-state">
                            <i class="fas fa-briefcase"></i>
                            <h3 class="mt-3">No Open Positions</h3>
                            <p class="text-muted">There are currently no job openings available.</p>
                            <p class="text-muted">Check back later or submit your resume for future opportunities.</p>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            
            <?php if(isset($careers) && count($careers) > 0): ?>
            <div class="row mt-4">
                <div class="col-md-12 text-center">
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        Showing <?php echo e(count($careers)); ?> available positions. 
                        <?php if($isPublic ?? false): ?>
                            <a href="<?php echo e(route('login')); ?>" class="alert-link">Login</a> to see more details and apply.
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </section>

    <!-- How to Apply -->
    <section class="py-5 bg-light">
        <div class="container">
            <div class="row mb-4">
                <div class="col-md-12 text-center">
                    <h2>How to Apply</h2>
                    <p class="text-muted">Simple steps to join our team</p>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-3 mb-4">
                    <div class="text-center">
                        <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center mb-3" 
                             style="width: 60px; height: 60px;">
                            <span class="h4 mb-0">1</span>
                        </div>
                        <h5>Browse Jobs</h5>
                        <p class="text-muted">Find a position that matches your skills</p>
                    </div>
                </div>
                
                <div class="col-md-3 mb-4">
                    <div class="text-center">
                        <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center mb-3" 
                             style="width: 60px; height: 60px;">
                            <span class="h4 mb-0">2</span>
                        </div>
                        <h5>Create Account</h5>
                        <p class="text-muted">Register to start your application</p>
                    </div>
                </div>
                
                <div class="col-md-3 mb-4">
                    <div class="text-center">
                        <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center mb-3" 
                             style="width: 60px; height: 60px;">
                            <span class="h4 mb-0">3</span>
                        </div>
                        <h5>Submit Application</h5>
                        <p class="text-muted">Upload your CV and fill the form</p>
                    </div>
                </div>
                
                <div class="col-md-3 mb-4">
                    <div class="text-center">
                        <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center mb-3" 
                             style="width: 60px; height: 60px;">
                            <span class="h4 mb-0">4</span>
                        </div>
                        <h5>Interview</h5>
                        <p class="text-muted">We'll contact you for next steps</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Job search functionality
            $('#searchJobs').on('keyup', function() {
                const searchTerm = $(this).val().toLowerCase();
                $('.job-item').each(function() {
                    const jobTitle = $(this).find('.card-header h5').text().toLowerCase();
                    const jobDesc = $(this).find('.card-text').text().toLowerCase();
                    
                    if (jobTitle.includes(searchTerm) || jobDesc.includes(searchTerm)) {
                        $(this).show();
                    } else {
                        $(this).hide();
                    }
                });
            });
            
            // Filter by department
            $('[data-filter]').on('click', function(e) {
                e.preventDefault();
                const filter = $(this).data('filter');
                
                // Update dropdown text
                $('.dropdown-toggle').text('Filter by: ' + $(this).text());
                
                if (filter === 'all') {
                    $('.job-item').show();
                } else {
                    $('.job-item').each(function() {
                        const department = $(this).data('department');
                        if (department === filter) {
                            $(this).show();
                        } else {
                            $(this).hide();
                        }
                    });
                }
            });
            
            // Countdown for application deadlines
            $('.job-item').each(function() {
                const deadlineText = $(this).find('.fa-clock').parent().text();
                const deadlineMatch = deadlineText.match(/(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \d{1,2}, \d{4}/);
                
                if (deadlineMatch) {
                    const deadline = new Date(deadlineMatch[0]);
                    const today = new Date();
                    const diffTime = deadline - today;
                    const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));
                    
                    if (diffDays > 0) {
                        $(this).find('.fa-clock').parent().append(
                            ` <span class="badge bg-warning">${diffDays} days left</span>`
                        );
                    }
                }
            });
        });
    </script>
</body>
</html>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\customer\careers\index.blade.php ENDPATH**/ ?>