


<?php $__env->startSection('title', 'My Cart - Chingu Bite'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <h1 class="mb-4">Shopping Cart</h1>
    
    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    
    <?php if($cart && count($items) > 0): ?>
        <div class="row">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Cart Items</h5>
                        
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="cart-item d-flex align-items-center border-bottom py-3">
                                <img src="<?php echo e($item['menu']['image_url'] ?? '/images/default-food.jpg'); ?>" 
                                     alt="<?php echo e($item['menu']['name']); ?>" 
                                     class="img-thumbnail me-3" style="width: 80px; height: 80px; object-fit: cover;">
                                
                                <div class="flex-grow-1">
                                    <h6 class="mb-1"><?php echo e($item['menu']['name']); ?></h6>
                                    <p class="text-muted mb-1">Rp <?php echo e(number_format($item['unit_price'], 0, ',', '.')); ?></p>
                                    
                                    <form action="<?php echo e(route('customer.cart.update', $item['id'])); ?>" method="POST" class="d-inline">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PUT'); ?>
                                        <div class="input-group input-group-sm" style="width: 150px;">
                                            <button type="button" class="btn btn-outline-secondary btn-decrease">-</button>
                                            <input type="number" name="quantity" value="<?php echo e($item['quantity']); ?>" 
                                                   class="form-control text-center quantity-input" min="1">
                                            <button type="button" class="btn btn-outline-secondary btn-increase">+</button>
                                        </div>
                                    </form>
                                    
                                    <form action="<?php echo e(route('customer.cart.destroy', $item['id'])); ?>" method="POST" class="d-inline ms-2">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-sm btn-outline-danger">Remove</button>
                                    </form>
                                </div>
                                
                                <div class="text-end">
                                    <strong>Rp <?php echo e(number_format($item['subtotal'], 0, ',', '.')); ?></strong>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                        <div class="mt-3">
                            <form action="<?php echo e(route('customer.cart.clear')); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-outline-danger">Clear Cart</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-4">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Order Summary</h5>
                        
                        <div class="d-flex justify-content-between mb-2">
                            <span>Subtotal:</span>
                            <span>Rp <?php echo e(number_format($cart['subtotal'] ?? 0, 0, ',', '.')); ?></span>
                        </div>
                        
                        <div class="d-flex justify-content-between mb-2">
                            <span>Tax (10%):</span>
                            <span>Rp <?php echo e(number_format($cart['tax_amount'] ?? 0, 0, ',', '.')); ?></span>
                        </div>
                        
                        <div class="d-flex justify-content-between mb-3">
                            <span>Service Fee:</span>
                            <span>Rp <?php echo e(number_format($cart['service_fee'] ?? 0, 0, ',', '.')); ?></span>
                        </div>
                        
                        <hr>
                        
                        <div class="d-flex justify-content-between mb-3">
                            <strong>Total:</strong>
                            <strong>Rp <?php echo e(number_format($cart['total'] ?? 0, 0, ',', '.')); ?></strong>
                        </div>
                        
                        <a href="<?php echo e(route('customer.orders.create')); ?>" class="btn btn-primary w-100">
                            Proceed to Checkout
                        </a>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="text-center py-5">
            <i class="fas fa-shopping-cart fa-4x text-muted mb-3"></i>
            <h3>Your cart is empty</h3>
            <p class="text-muted">Add some delicious Korean food to your cart!</p>
            <a href="<?php echo e(route('menu.public')); ?>" class="btn btn-primary">Browse Menu</a>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Quantity controls with AJAX
        document.querySelectorAll('.btn-increase, .btn-decrease').forEach(btn => {
            btn.addEventListener('click', async function(e) {
                e.preventDefault();
                const input = this.closest('.input-group').querySelector('.quantity-input');
                const form = this.closest('form');
                const currentQty = parseInt(input.value);
                
                if (this.classList.contains('btn-increase')) {
                    input.value = currentQty + 1;
                } else if (this.classList.contains('btn-decrease') && currentQty > 1) {
                    input.value = currentQty - 1;
                } else {
                    return; // Don't allow quantity < 1
                }
                
                // Submit form via AJAX
                await updateCartQuantity(form, input.value);
            });
        });
        
        // Direct quantity input change
        document.querySelectorAll('.quantity-input').forEach(input => {
            input.addEventListener('change', async function() {
                const newQty = parseInt(this.value);
                if (newQty >= 1) {
                    const form = this.closest('form');
                    await updateCartQuantity(form, newQty);
                } else {
                    this.value = 1;
                }
            });
        });
        
        async function updateCartQuantity(form, quantity) {
            try {
                const formData = new FormData(form);
                formData.set('quantity', quantity);
                
                const response = await fetch(form.action, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                        'Accept': 'application/json',
                    },
                    body: formData
                });
                
                if (response.ok) {
                    // Reload page to update totals
                    window.location.reload();
                } else {
                    alert('Failed to update cart');
                }
            } catch (error) {
                console.error('Error updating cart:', error);
                alert('Failed to update cart');
            }
        }
        
        // Confirm before clearing cart
        const clearCartForm = document.querySelector('form[action*="clear"]');
        if (clearCartForm) {
            clearCartForm.addEventListener('submit', function(e) {
                if (!confirm('Are you sure you want to clear your cart?')) {
                    e.preventDefault();
                }
            });
        }
        
        // Confirm before removing item
        document.querySelectorAll('form[action*="destroy"]').forEach(form => {
            form.addEventListener('submit', function(e) {
                if (!confirm('Remove this item from cart?')) {
                    e.preventDefault();
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\customer\cart\index.blade.php ENDPATH**/ ?>