

<?php $__env->startSection('title', 'Menu Item Details'); ?>
<?php $__env->startSection('page-title', 'Menu Item Details'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.menu.index')); ?>">Menu Management</a></li>
    <li class="breadcrumb-item active">Details</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title mb-0">Item Information</h6>
                    <div>
                        <span class="badge badge-<?php echo e($menu['is_available'] ? 'success' : 'danger'); ?>">
                            <?php echo e($menu['is_available'] ? 'Available' : 'Unavailable'); ?>

                        </span>
                        <?php if($menu['is_best_seller']): ?>
                            <span class="badge bg-warning">Best Seller</span>
                        <?php endif; ?>
                        <?php if($menu['is_special']): ?>
                            <span class="badge bg-danger">Special</span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-4 text-center">
                            <?php if($menu['image_url']): ?>
                                <img src="<?php echo e($menu['image_url']); ?>" alt="<?php echo e($menu['name']); ?>" 
                                     class="img-fluid rounded" style="max-height: 300px;">
                            <?php else: ?>
                                <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                     style="height: 300px;">
                                    <i class="fas fa-utensils fa-4x text-muted"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="col-md-8">
                            <h4 class="font-weight-bold mb-3"><?php echo e($menu['name']); ?></h4>
                            
                            <div class="row mb-3">
                                <div class="col-6">
                                    <label class="text-muted">Category</label>
                                    <p class="font-weight-bold"><?php echo e($menu['category_name'] ?? 'N/A'); ?></p>
                                </div>
                                <div class="col-6">
                                    <label class="text-muted">Price</label>
                                    <p class="font-weight-bold">Rp <?php echo e(number_format($menu['price'], 0, ',', '.')); ?></p>
                                </div>
                            </div>
                            
                            <div class="row mb-3">
                                <div class="col-6">
                                    <label class="text-muted">Stock</label>
                                    <p class="font-weight-bold">
                                        <?php if($menu['stock'] === null): ?>
                                            <span class="text-muted">Unlimited</span>
                                        <?php else: ?>
                                            <span class="<?php echo e($menu['stock'] <= 10 ? 'text-danger' : 'text-success'); ?>">
                                                <?php echo e($menu['stock']); ?> units
                                            </span>
                                        <?php endif; ?>
                                    </p>
                                </div>
                                <div class="col-6">
                                    <label class="text-muted">Added On</label>
                                    <p class="font-weight-bold">
                                        <?php echo e(date('d M Y, H:i', strtotime($menu['created_at']))); ?>

                                    </p>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="text-muted">Description</label>
                                <p class="font-weight-bold"><?php echo e($menu['description'] ?? 'No description provided.'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Sales Statistics -->
            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">Sales Statistics</h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-md-4 mb-3">
                            <div class="metric-box p-3 border rounded">
                                <div class="metric-value font-weight-bold text-primary">
                                    <?php echo e($menu['total_sold'] ?? 0); ?>

                                </div>
                                <div class="metric-label text-muted">Total Sold</div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="metric-box p-3 border rounded">
                                <div class="metric-value font-weight-bold text-success">
                                    Rp <?php echo e(number_format($menu['total_revenue'] ?? 0, 0, ',', '.')); ?>

                                </div>
                                <div class="metric-label text-muted">Total Revenue</div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-3">
                            <div class="metric-box p-3 border rounded">
                                <div class="metric-value font-weight-bold text-info">
                                    <?php echo e($menu['average_rating'] ?? 0); ?>/5
                                </div>
                                <div class="metric-label text-muted">Average Rating</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <!-- Actions Card -->
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">Actions</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="<?php echo e(route('admin.menu.edit', $menu['id'])); ?>" class="btn btn-warning btn-block">
                            <i class="fas fa-edit mr-1"></i> Edit Item
                        </a>
                        
                        <form action="<?php echo e(route('admin.menu.toggle_availability', $menu['id'])); ?>" method="POST" class="d-grid">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <button type="submit" class="btn btn-<?php echo e($menu['is_available'] ? 'secondary' : 'success'); ?> btn-block">
                                <i class="fas fa-<?php echo e($menu['is_available'] ? 'times' : 'check'); ?> mr-1"></i>
                                <?php echo e($menu['is_available'] ? 'Make Unavailable' : 'Make Available'); ?>

                            </button>
                        </form>
                        
                        <form action="<?php echo e(route('admin.menu.destroy', $menu['id'])); ?>" method="POST" 
                              onsubmit="return confirm('Are you sure you want to delete this item?');" class="d-grid">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-block">
                                <i class="fas fa-trash mr-1"></i> Delete Item
                            </button>
                        </form>
                        
                        <a href="<?php echo e(route('admin.menu.index')); ?>" class="btn btn-secondary btn-block">
                            <i class="fas fa-arrow-left mr-1"></i> Back to List
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Recent Reviews -->
            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">Recent Reviews</h6>
                </div>
                <div class="card-body">
                    <?php if(isset($menu['recent_reviews']) && count($menu['recent_reviews']) > 0): ?>
                        <?php $__currentLoopData = $menu['recent_reviews']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="review-item mb-3 pb-3 border-bottom">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <div>
                                    <strong><?php echo e($review['customer_name']); ?></strong>
                                    <div class="stars">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <i class="fas fa-star <?php echo e($i <= $review['rating'] ? 'text-warning' : 'text-secondary'); ?>" 
                                               style="font-size: 12px;"></i>
                                        <?php endfor; ?>
                                    </div>
                                </div>
                                <small class="text-muted"><?php echo e(date('d M Y', strtotime($review['created_at']))); ?></small>
                            </div>
                            <p class="mb-0"><?php echo e($review['comment']); ?></p>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <p class="text-muted text-center mb-0">No reviews yet</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<style>
    .metric-box {
        transition: all 0.3s;
    }
    .metric-box:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    .stars {
        color: #ffc107;
    }
    .stars .fa-star.text-secondary {
        color: #e0e0e0 !important;
    }
    .review-item:last-child {
        border-bottom: none !important;
        margin-bottom: 0 !important;
        padding-bottom: 0 !important;
    }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\admin\menu\show.blade.php ENDPATH**/ ?>