


<?php $__env->startSection('title', 'Menu Management'); ?>
<?php $__env->startSection('page_title', 'Menu Management'); ?>
<?php $__env->startSection('icon', 'fa-utensils'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active">Menu Management</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-utensils me-2"></i>Menu Items
                        </h5>
                        <a href="<?php echo e(route('admin.menu.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> Add New Item
                        </a>
                    </div>
                </div>
                
                <div class="card-body">
                    <!-- Filter Form -->
                    <form method="GET" action="<?php echo e(route('admin.menu.index')); ?>" class="mb-4">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="search" class="form-label">Search</label>
                                    <input type="text" class="form-control form-control-sm" 
                                           id="search" name="search" 
                                           value="<?php echo e(request('search')); ?>" 
                                           placeholder="Search by name...">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="category_id" class="form-label">Category</label>
                                    <select class="form-control form-control-sm select2" 
                                            id="category_id" name="category_id">
                                        <option value="">All Categories</option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($category['id']); ?>" 
                                                <?php echo e(request('category_id') == $category['id'] ? 'selected' : ''); ?>>
                                                <?php echo e($category['name']); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="is_available" class="form-label">Availability</label>
                                    <select class="form-control form-control-sm" 
                                            id="is_available" name="is_available">
                                        <option value="">All</option>
                                        <option value="1" <?php echo e(request('is_available') == '1' ? 'selected' : ''); ?>>
                                            Available
                                        </option>
                                        <option value="0" <?php echo e(request('is_available') == '0' ? 'selected' : ''); ?>>
                                            Unavailable
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <div class="d-flex gap-2 w-100">
                                    <button type="submit" class="btn btn-primary btn-sm flex-grow-1">
                                        <i class="fas fa-filter me-1"></i> Filter
                                    </button>
                                    <a href="<?php echo e(route('admin.menu.index')); ?>" class="btn btn-secondary btn-sm">
                                        <i class="fas fa-redo"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </form>

                    <!-- Menu Items Table -->
                    <div class="table-responsive">
                        <table class="table table-hover data-table">
                            <thead>
                                <tr>
                                    <th width="50">#</th>
                                    <th>Image</th>
                                    <th>Name</th>
                                    <th>Category</th>
                                    <th>Price</th>
                                    <th>Stock</th>
                                    <th>Status</th>
                                    <th>Tags</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td>
                                        <?php if($menu['image_url']): ?>
                                            <img src="<?php echo e($menu['image_url']); ?>" 
                                                 alt="<?php echo e($menu['name']); ?>" 
                                                 class="rounded" 
                                                 style="width: 50px; height: 50px; object-fit: cover;">
                                        <?php else: ?>
                                            <div class="bg-light text-center rounded d-flex align-items-center justify-content-center" 
                                                 style="width: 50px; height: 50px;">
                                                <i class="fas fa-utensils text-muted"></i>
                                            </div>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <strong><?php echo e($menu['name']); ?></strong>
                                        <?php if($menu['description']): ?>
                                            <br>
                                            <small class="text-muted"><?php echo e(Str::limit($menu['description'], 50)); ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($menu['category_name'] ?? 'N/A'); ?></td>
                                    <td>
                                        <strong class="text-primary">
                                            Rp <?php echo e(number_format($menu['price'], 0, ',', '.')); ?>

                                        </strong>
                                    </td>
                                    <td>
                                        <?php if($menu['stock'] === null): ?>
                                            <span class="text-muted">Unlimited</span>
                                        <?php else: ?>
                                            <span class="<?php echo e($menu['stock'] <= 10 ? 'text-danger' : 'text-success'); ?>">
                                                <?php echo e($menu['stock']); ?>

                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($menu['is_available']): ?>
                                            <span class="badge bg-success">
                                                <i class="fas fa-check-circle me-1"></i> Available
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">
                                                <i class="fas fa-times-circle me-1"></i> Unavailable
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-wrap gap-1">
                                            <?php if($menu['is_best_seller']): ?>
                                                <span class="badge bg-warning">Best Seller</span>
                                            <?php endif; ?>
                                            <?php if($menu['is_special']): ?>
                                                <span class="badge bg-danger">Special</span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="<?php echo e(route('admin.menu.show', $menu['id'])); ?>" 
                                               class="btn btn-info" data-bs-toggle="tooltip" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.menu.edit', $menu['id'])); ?>" 
                                               class="btn btn-warning" data-bs-toggle="tooltip" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" class="btn btn-danger" 
                                                    onclick="confirmDelete('delete-menu-<?php echo e($menu['id']); ?>')"
                                                    data-bs-toggle="tooltip" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                            <form action="<?php echo e(route('admin.menu.toggle_availability', $menu['id'])); ?>" 
                                                  method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <button type="submit" 
                                                        class="btn btn-<?php echo e($menu['is_available'] ? 'secondary' : 'success'); ?>"
                                                        data-bs-toggle="tooltip" 
                                                        title="<?php echo e($menu['is_available'] ? 'Make Unavailable' : 'Make Available'); ?>">
                                                    <i class="fas fa-<?php echo e($menu['is_available'] ? 'times' : 'check'); ?>"></i>
                                                </button>
                                            </form>
                                        </div>
                                        
                                        <form id="delete-menu-<?php echo e($menu['id']); ?>" 
                                              action="<?php echo e(route('admin.menu.destroy', $menu['id'])); ?>" 
                                              method="POST" style="display: none;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center py-4">
                                        <div class="text-muted">
                                            <i class="fas fa-utensils fa-3x mb-3"></i>
                                            <h5>No menu items found</h5>
                                            <p>Try adjusting your search filters or add new items</p>
                                        </div>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <?php if(isset($pagination)): ?>
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div class="text-muted">
                                Showing <?php echo e($pagination['from'] ?? 0); ?> to 
                                <?php echo e($pagination['to'] ?? 0); ?> of 
                                <?php echo e($pagination['total'] ?? 0); ?> entries
                            </div>
                            <nav>
                                <ul class="pagination pagination-sm mb-0">
                                    
                                    <?php if(isset($pagination['current_page']) && $pagination['current_page'] > 1): ?>
                                        <li class="page-item">
                                            <a class="page-link" 
                                               href="<?php echo e(request()->fullUrlWithQuery(['page' => $pagination['current_page'] - 1])); ?>">
                                                &laquo;
                                            </a>
                                        </li>
                                    <?php else: ?>
                                        <li class="page-item disabled">
                                            <span class="page-link">&laquo;</span>
                                        </li>
                                    <?php endif; ?>

                                    
                                    <?php if(isset($pagination['last_page'])): ?>
                                        <?php
                                            $currentPage = $pagination['current_page'] ?? 1;
                                            $lastPage = $pagination['last_page'] ?? 1;
                                            $startPage = max(1, $currentPage - 2);
                                            $endPage = min($lastPage, $currentPage + 2);
                                        ?>
                                        
                                        <?php for($i = $startPage; $i <= $endPage; $i++): ?>
                                            <?php if($i == $currentPage): ?>
                                                <li class="page-item active">
                                                    <span class="page-link"><?php echo e($i); ?></span>
                                                </li>
                                            <?php else: ?>
                                                <li class="page-item">
                                                    <a class="page-link" 
                                                       href="<?php echo e(request()->fullUrlWithQuery(['page' => $i])); ?>">
                                                        <?php echo e($i); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                    <?php endif; ?>

                                    
                                    <?php if(isset($pagination['current_page']) && isset($pagination['last_page']) && 
                                        $pagination['current_page'] < $pagination['last_page']): ?>
                                        <li class="page-item">
                                            <a class="page-link" 
                                               href="<?php echo e(request()->fullUrlWithQuery(['page' => $pagination['current_page'] + 1])); ?>">
                                                &raquo;
                                            </a>
                                        </li>
                                    <?php else: ?>
                                        <li class="page-item disabled">
                                            <span class="page-link">&raquo;</span>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </nav>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function() {
        // Initialize DataTable
        $('.data-table').DataTable({
            pageLength: 25,
            responsive: true,
            order: [[2, 'asc']],
            columnDefs: [
                { orderable: false, targets: [1, 8] } // Disable sorting for image and actions columns
            ]
        });
        
        // Initialize tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
        
        // Initialize Select2
        $('.select2').select2({
            theme: 'bootstrap-5',
            width: '100%'
        });
    });
    
    function confirmDelete(formId) {
        if (confirm('Are you sure you want to delete this item?')) {
            document.getElementById(formId).submit();
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views/admin/menu/index.blade.php ENDPATH**/ ?>