

<?php $__env->startSection('title', 'Career Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    
    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="row mb-4">
        <div class="col-md-12">
            <a href="<?php echo e(route('careers.public')); ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i> Back to Careers
            </a>
        </div>
    </div>

    <?php
        $career = $apiData['data'] ?? [];
        $isExpired = \Carbon\Carbon::parse($career['application_deadline'] ?? now())->isPast();
    ?>

    <div class="row">
        <!-- Job Details -->
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header bg-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="mb-0"><?php echo e($career['title'] ?? 'Job Title'); ?></h3>
                        <?php if($career['is_urgent'] ?? false): ?>
                            <span class="badge bg-danger">Urgent Hiring</span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Job Info -->
                    <div class="row mb-4">
                        <div class="col-md-4">
                            <h6><i class="fas fa-building me-2"></i> Department</h6>
                            <p class="text-muted"><?php echo e(ucfirst($career['department'] ?? 'General')); ?></p>
                        </div>
                        <div class="col-md-4">
                            <h6><i class="fas fa-map-marker-alt me-2"></i> Location</h6>
                            <p class="text-muted"><?php echo e($career['location'] ?? 'Not specified'); ?></p>
                        </div>
                        <div class="col-md-4">
                            <h6><i class="fas fa-briefcase me-2"></i> Employment Type</h6>
                            <p class="text-muted">
                                <span class="badge bg-info">
                                    <?php echo e(str_replace('_', ' ', ucfirst($career['employment_type'] ?? 'full_time'))); ?>

                                </span>
                            </p>
                        </div>
                    </div>

                    <!-- Salary -->
                    <?php if($career['salary_range'] ?? false): ?>
                    <div class="alert alert-success mb-4">
                        <h6><i class="fas fa-money-bill-wave me-2"></i> Salary Range</h6>
                        <p class="mb-0 h5"><?php echo e($career['salary_range']); ?></p>
                    </div>
                    <?php endif; ?>

                    <!-- Description -->
                    <div class="mb-4">
                        <h5>Job Description</h5>
                        <div class="border rounded p-3 bg-light">
                            <?php echo nl2br(e($career['description'] ?? 'No description provided.')); ?>

                        </div>
                    </div>

                    <!-- Requirements -->
                    <div class="mb-4">
                        <h5>Requirements</h5>
                        <div class="border rounded p-3 bg-light">
                            <?php echo nl2br(e($career['requirements'] ?? 'No specific requirements.')); ?>

                        </div>
                    </div>

                    <!-- Benefits -->
                    <?php if($career['benefits'] ?? false): ?>
                    <div class="mb-4">
                        <h5>Benefits</h5>
                        <div class="border rounded p-3 bg-light">
                            <?php echo nl2br(e($career['benefits'])); ?>

                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Application Deadline -->
                    <div class="alert <?php echo e($isExpired ? 'alert-danger' : 'alert-warning'); ?> mb-4">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <h6 class="mb-0">
                                    <i class="fas fa-calendar-alt me-2"></i>
                                    Application Deadline
                                </h6>
                                <p class="mb-0">
                                    <?php echo e(\Carbon\Carbon::parse($career['application_deadline'] ?? now())->format('F d, Y')); ?>

                                </p>
                            </div>
                            <?php if($isExpired): ?>
                                <span class="badge bg-danger">Expired</span>
                            <?php else: ?>
                                <?php
                                    $deadline = \Carbon\Carbon::parse($career['application_deadline']);
                                    $daysLeft = now()->diffInDays($deadline, false);
                                ?>
                                <span class="badge bg-warning"><?php echo e($daysLeft); ?> days left</span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Application Sidebar -->
        <div class="col-lg-4">
            <!-- Apply Card -->
            <div class="card shadow mb-4">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0">Apply for this Position</h5>
                </div>
                <div class="card-body">
                    <?php if($isExpired): ?>
                        <div class="alert alert-danger">
                            <i class="fas fa-exclamation-circle me-2"></i>
                            This position is no longer accepting applications.
                        </div>
                    <?php else: ?>
                        <?php if(Session::has('api_token') && Session::get('user_role') == 'customer'): ?>
                            <!-- Already logged in as customer -->
                            <?php if($hasApplied ?? false): ?>
                                <div class="alert alert-success">
                                    <i class="fas fa-check-circle me-2"></i>
                                    You have already applied for this position.
                                </div>
                                <a href="<?php echo e(route('customer.careers.applications.show', $applicationId ?? '#')); ?>" 
                                   class="btn btn-outline-primary w-100 mb-2">
                                    <i class="fas fa-eye me-2"></i>View Your Application
                                </a>
                            <?php else: ?>
                                <a href="<?php echo e(route('customer.careers.apply', $career['id'])); ?>" 
                                   class="btn btn-primary w-100 mb-2">
                                    <i class="fas fa-paper-plane me-2"></i>Apply Now
                                </a>
                            <?php endif; ?>
                        <?php else: ?>
                            <!-- Not logged in or not customer -->
                            <div class="alert alert-info mb-3">
                                <i class="fas fa-info-circle me-2"></i>
                                Please login as a customer to apply for this position.
                            </div>
                            <a href="<?php echo e(route('login')); ?>" class="btn btn-primary w-100 mb-2">
                                <i class="fas fa-sign-in-alt me-2"></i>Login to Apply
                            </a>
                            <a href="<?php echo e(route('register')); ?>" class="btn btn-outline-primary w-100">
                                <i class="fas fa-user-plus me-2"></i>Create Account
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Job Stats -->
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Job Information</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <small class="text-muted d-block">Posted Date</small>
                        <p class="mb-0">
                            <?php echo e(\Carbon\Carbon::parse($career['created_at'] ?? now())->format('M d, Y')); ?>

                        </p>
                    </div>
                    
                    <div class="mb-3">
                        <small class="text-muted d-block">Views</small>
                        <p class="mb-0">
                            <i class="fas fa-eye me-2"></i><?php echo e($career['views_count'] ?? 0); ?>

                        </p>
                    </div>
                    
                    <div class="mb-3">
                        <small class="text-muted d-block">Applications Received</small>
                        <p class="mb-0">
                            <i class="fas fa-users me-2"></i><?php echo e($career['applications_count'] ?? 0); ?>

                        </p>
                    </div>
                    
                    <div class="mb-3">
                        <small class="text-muted d-block">Job Status</small>
                        <p class="mb-0">
                            <?php if($career['is_active'] ?? false): ?>
                                <span class="badge bg-success">Active</span>
                            <?php else: ?>
                                <span class="badge bg-secondary">Inactive</span>
                            <?php endif; ?>
                        </p>
                    </div>
                </div>
            </div>

            <!-- Share Job -->
            <div class="card shadow">
                <div class="card-header">
                    <h6 class="mb-0">Share This Job</h6>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-center gap-2">
                        <button class="btn btn-outline-primary btn-sm" onclick="shareOnFacebook()">
                            <i class="fab fa-facebook"></i>
                        </button>
                        <button class="btn btn-outline-info btn-sm" onclick="shareOnLinkedIn()">
                            <i class="fab fa-linkedin"></i>
                        </button>
                        <button class="btn btn-outline-success btn-sm" onclick="copyJobLink()">
                            <i class="fas fa-link"></i>
                        </button>
                        <button class="btn btn-outline-dark btn-sm" onclick="printJobPage()">
                            <i class="fas fa-print"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    function shareOnFacebook() {
        const url = encodeURIComponent(window.location.href);
        const title = encodeURIComponent('<?php echo e($career['title'] ?? "Job Opening"); ?>');
        window.open(`https://www.facebook.com/sharer/sharer.php?u=${url}&quote=${title}`, '_blank');
    }
    
    function shareOnLinkedIn() {
        const url = encodeURIComponent(window.location.href);
        const title = encodeURIComponent('<?php echo e($career['title'] ?? "Job Opening"); ?>');
        window.open(`https://www.linkedin.com/shareArticle?mini=true&url=${url}&title=${title}`, '_blank');
    }
    
    function copyJobLink() {
        navigator.clipboard.writeText(window.location.href).then(() => {
            alert('Job link copied to clipboard!');
        });
    }
    
    function printJobPage() {
        window.print();
    }
    
    // Update page title
    document.title = '<?php echo e($career['title'] ?? "Career Details"); ?> - Chingu Bite';
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\customer\careers\show.blade.php ENDPATH**/ ?>