

<?php $__env->startSection('title', 'Create Career'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">Create Career</h1>
        <a href="<?php echo e(route('admin.careers.index')); ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-1"></i> Back to List
        </a>
    </div>

    <div class="card shadow">
        <div class="card-body">
            <form method="POST" action="<?php echo e(route('admin.careers.store')); ?>">
                <?php echo csrf_field(); ?>
                
                <div class="row">
                    <div class="col-md-8">
                        <div class="mb-3">
                            <label for="title" class="form-label">Job Title *</label>
                            <input type="text" class="form-control" id="title" name="title" 
                                   value="<?php echo e(old('title')); ?>" required>
                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="text-danger"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="department" class="form-label">Department *</label>
                                <input type="text" class="form-control" id="department" name="department" 
                                       value="<?php echo e(old('department')); ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label for="location" class="form-label">Location *</label>
                                <input type="text" class="form-control" id="location" name="location" 
                                       value="<?php echo e(old('location')); ?>" required>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="employment_type" class="form-label">Employment Type *</label>
                            <select class="form-control" id="employment_type" name="employment_type" required>
                                <option value="">Select Type</option>
                                <?php $__currentLoopData = $employmentTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($type); ?>" <?php echo e(old('employment_type') == $type ? 'selected' : ''); ?>>
                                        <?php echo e(str_replace('_', ' ', ucfirst($type))); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">Job Description *</label>
                            <textarea class="form-control" id="description" name="description" 
                                      rows="5" required><?php echo e(old('description')); ?></textarea>
                        </div>

                        <div class="mb-3">
                            <label for="requirements" class="form-label">Requirements *</label>
                            <textarea class="form-control" id="requirements" name="requirements" 
                                      rows="5" required><?php echo e(old('requirements')); ?></textarea>
                            <small class="text-muted">Separate requirements with new lines</small>
                        </div>

                        <div class="mb-3">
                            <label for="benefits" class="form-label">Benefits</label>
                            <textarea class="form-control" id="benefits" name="benefits" 
                                      rows="3"><?php echo e(old('benefits')); ?></textarea>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card mb-3">
                            <div class="card-header">
                                <h6 class="mb-0">Additional Information</h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label for="salary_range" class="form-label">Salary Range</label>
                                    <input type="text" class="form-control" id="salary_range" name="salary_range" 
                                           value="<?php echo e(old('salary_range')); ?>" placeholder="e.g., Rp 5.000.000 - Rp 8.000.000">
                                </div>

                                <div class="mb-3">
                                    <label for="application_deadline" class="form-label">Application Deadline *</label>
                                    <input type="date" class="form-control" id="application_deadline" 
                                           name="application_deadline" value="<?php echo e(old('application_deadline')); ?>" required>
                                </div>

                                <div class="mb-3">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="is_active" 
                                               name="is_active" value="1" <?php echo e(old('is_active', true) ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="is_active">Active Listing</label>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <div class="form-check">
                                        <input type="checkbox" class="form-check-input" id="is_urgent" 
                                               name="is_urgent" value="1" <?php echo e(old('is_urgent') ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="is_urgent">Mark as Urgent</label>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label for="views_count" class="form-label">Initial Views</label>
                                    <input type="number" class="form-control" id="views_count" name="views_count" 
                                           value="<?php echo e(old('views_count', 0)); ?>" min="0">
                                </div>
                            </div>
                        </div>

                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-1"></i> Create Career
                            </button>
                            <button type="reset" class="btn btn-secondary">
                                <i class="fas fa-redo me-1"></i> Reset Form
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Auto set deadline to 30 days from now if not set
        const deadlineField = document.getElementById('application_deadline');
        if (!deadlineField.value) {
            const today = new Date();
            const nextMonth = new Date(today);
            nextMonth.setDate(today.getDate() + 30);
            deadlineField.value = nextMonth.toISOString().split('T')[0];
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\admin\careers\create.blade.php ENDPATH**/ ?>