

<?php $__env->startSection('title', 'Promo Management'); ?>
<?php $__env->startSection('page-title', 'Promo Management'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item active">Promo Management</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title mb-0">Promotions</h6>
                    <a href="<?php echo e(route('admin.promos.create')); ?>" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus mr-1"></i> Add New Promo
                    </a>
                </div>
                <div class="card-body">
                    <!-- Filter Form -->
                    <form method="GET" action="<?php echo e(route('admin.promos.index')); ?>" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="search">Search</label>
                                    <input type="text" class="form-control" id="search" name="search" 
                                           value="<?php echo e(request('search')); ?>" placeholder="Search by name or code...">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="type">Type</label>
                                    <select class="form-control" id="type" name="type">
                                        <option value="">All Types</option>
                                        <option value="percentage" <?php echo e(request('type') == 'percentage' ? 'selected' : ''); ?>>Percentage</option>
                                        <option value="fixed" <?php echo e(request('type') == 'fixed' ? 'selected' : ''); ?>>Fixed Amount</option>
                                        <option value="bogo" <?php echo e(request('type') == 'bogo' ? 'selected' : ''); ?>>Buy One Get One</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="is_active">Status</label>
                                    <select class="form-control" id="is_active" name="is_active">
                                        <option value="">All Status</option>
                                        <option value="1" <?php echo e(request('is_active') == '1' ? 'selected' : ''); ?>>Active</option>
                                        <option value="0" <?php echo e(request('is_active') == '0' ? 'selected' : ''); ?>>Inactive</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="fas fa-filter"></i> Filter
                                </button>
                            </div>
                        </div>
                    </form>

                    <!-- Promotions Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered data-table">
                            <thead>
                                <tr>
                                    <th width="50">#</th>
                                    <th>Name</th>
                                    <th>Code</th>
                                    <th>Type</th>
                                    <th>Discount Value</th>
                                    <th>Validity Period</th>
                                    <th>Usage</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $promos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $promo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td>
                                        <strong><?php echo e($promo['name']); ?></strong>
                                        <?php if($promo['description']): ?>
                                            <br>
                                            <small class="text-muted"><?php echo e(Str::limit($promo['description'], 50)); ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($promo['code']): ?>
                                            <code><?php echo e($promo['code']); ?></code>
                                        <?php else: ?>
                                            <span class="text-muted">Auto-apply</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($promo['type'] == 'percentage' ? 'primary' : ($promo['type'] == 'fixed' ? 'success' : 'warning')); ?>">
                                            <?php echo e(ucfirst($promo['type'])); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <?php if($promo['type'] == 'percentage'): ?>
                                            <?php echo e($promo['discount_value']); ?>%
                                        <?php elseif($promo['type'] == 'fixed'): ?>
                                            Rp <?php echo e(number_format($promo['discount_value'], 0, ',', '.')); ?>

                                        <?php else: ?>
                                            BOGO
                                        <?php endif; ?>
                                        <?php if($promo['max_discount']): ?>
                                            <br>
                                            <small class="text-muted">Max: Rp <?php echo e(number_format($promo['max_discount'], 0, ',', '.')); ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <small>
                                            <?php echo e(date('d M Y', strtotime($promo['start_date']))); ?><br>
                                            to <?php echo e(date('d M Y', strtotime($promo['end_date']))); ?>

                                            <?php if(strtotime($promo['end_date']) < time()): ?>
                                                <br>
                                                <span class="text-danger">Expired</span>
                                            <?php endif; ?>
                                        </small>
                                    </td>
                                    <td>
                                        <small>
                                            Used: <?php echo e($promo['usage_count'] ?? 0); ?> times<br>
                                            <?php if($promo['min_purchase']): ?>
                                                Min: Rp <?php echo e(number_format($promo['min_purchase'], 0, ',', '.')); ?>

                                            <?php endif; ?>
                                        </small>
                                    </td>
                                    <td>
                                        <span class="badge badge-<?php echo e($promo['is_active'] ? 'success' : 'danger'); ?>">
                                            <?php echo e($promo['is_active'] ? 'Active' : 'Inactive'); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('admin.promos.show', $promo['id'])); ?>" 
                                               class="btn btn-info btn-sm" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.promos.edit', $promo['id'])); ?>" 
                                               class="btn btn-warning btn-sm" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="<?php echo e(route('admin.promos.destroy', $promo['id'])); ?>" 
                                                  method="POST" class="d-inline" 
                                                  onsubmit="return confirm('Are you sure you want to delete this promotion?');">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger btn-sm" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            <form action="<?php echo e(route('admin.promos.toggle_active', $promo['id'])); ?>" 
                                                  method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <button type="submit" class="btn btn-<?php echo e($promo['is_active'] ? 'secondary' : 'success'); ?> btn-sm" 
                                                        title="<?php echo e($promo['is_active'] ? 'Deactivate' : 'Activate'); ?>">
                                                    <i class="fas fa-<?php echo e($promo['is_active'] ? 'times' : 'check'); ?>"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center">No promotions found</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <?php if($pagination): ?>
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div class="text-muted">
                                Showing <?php echo e(($pagination['current_page'] - 1) * $pagination['per_page'] + 1); ?> to 
                                <?php echo e(min($pagination['current_page'] * $pagination['per_page'], $pagination['total'])); ?> of 
                                <?php echo e($pagination['total']); ?> entries
                            </div>
                            <nav>
                                <ul class="pagination pagination-sm mb-0">
                                    <?php if($pagination['current_page'] > 1): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?php echo e(request()->fullUrlWithQuery(['page' => $pagination['current_page'] - 1])); ?>">
                                                Previous
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php for($i = 1; $i <= $pagination['last_page']; $i++): ?>
                                        <?php if($i == 1 || $i == $pagination['last_page'] || ($i >= $pagination['current_page'] - 2 && $i <= $pagination['current_page'] + 2)): ?>
                                            <li class="page-item <?php echo e($i == $pagination['current_page'] ? 'active' : ''); ?>">
                                                <a class="page-link" href="<?php echo e(request()->fullUrlWithQuery(['page' => $i])); ?>">
                                                    <?php echo e($i); ?>

                                                </a>
                                            </li>
                                        <?php elseif($i == $pagination['current_page'] - 3 || $i == $pagination['current_page'] + 3): ?>
                                            <li class="page-item disabled">
                                                <span class="page-link">...</span>
                                            </li>
                                        <?php endif; ?>
                                    <?php endfor; ?>

                                    <?php if($pagination['current_page'] < $pagination['last_page']): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?php echo e(request()->fullUrlWithQuery(['page' => $pagination['current_page'] + 1])); ?>">
                                                Next
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </nav>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function() {
        // Initialize DataTable
        $('.data-table').DataTable({
            paging: false,
            searching: false,
            info: false,
            order: [[5, 'desc']] // Sort by start date
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\admin\promos\index.blade.php ENDPATH**/ ?>