

<?php $__env->startSection('title', $title ?? 'Receipts'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-receipt"></i> Receipts
        </h1>
    </div>

    <!-- Receipts List -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Recent Completed Orders</h6>
        </div>
        <div class="card-body">
            <?php if(count($orders) > 0): ?>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Order #</th>
                                <th>Customer</th>
                                <th>Date</th>
                                <th>Amount</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($order['order_number'] ?? '#' . $order['id']); ?></td>
                                <td><?php echo e($order['customer']['name'] ?? 'N/A'); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($order['created_at'])->format('d M Y H:i')); ?></td>
                                <td>Rp <?php echo e(number_format($order['final_amount'] ?? 0, 0, ',', '.')); ?></td>
                                <td>
                                    <a href="<?php echo e(route('employee.receipts.show', $order['id'])); ?>" 
                                       class="btn btn-sm btn-primary" title="View Receipt">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('employee.receipts.print', $order['id'])); ?>" 
                                       class="btn btn-sm btn-secondary" target="_blank" title="Print">
                                        <i class="fas fa-print"></i>
                                    </a>
                                    <a href="<?php echo e(route('employee.receipts.download', $order['id'])); ?>" 
                                       class="btn btn-sm btn-success" title="Download PDF">
                                        <i class="fas fa-download"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-receipt fa-3x text-muted mb-3"></i>
                    <p class="text-muted">No completed orders found</p>
                    <a href="<?php echo e(route('employee.orders.index')); ?>" class="btn btn-primary">
                        View All Orders
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.employee', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\employee\receipts\index.blade.php ENDPATH**/ ?>