

<?php $__env->startSection('title', 'Promotion Details'); ?>
<?php $__env->startSection('page-title', 'Promotion Details'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.promos.index')); ?>">Promo Management</a></li>
    <li class="breadcrumb-item active"><?php echo e($promo['name']); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title mb-0">Promotion Information</h6>
                    <div>
                        <span class="badge badge-<?php echo e($promo['is_active'] ? 'success' : 'danger'); ?>">
                            <?php echo e($promo['is_active'] ? 'Active' : 'Inactive'); ?>

                        </span>
                        <?php if(strtotime($promo['end_date']) < time()): ?>
                            <span class="badge bg-secondary ml-2">Expired</span>
                        <?php elseif(strtotime($promo['start_date']) > time()): ?>
                            <span class="badge bg-warning ml-2">Upcoming</span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <h4 class="font-weight-bold mb-3"><?php echo e($promo['name']); ?></h4>
                            
                            <div class="row mb-3">
                                <div class="col-6">
                                    <label class="text-muted">Promo Code</label>
                                    <p class="font-weight-bold">
                                        <?php if($promo['code']): ?>
                                            <code><?php echo e($promo['code']); ?></code>
                                        <?php else: ?>
                                            <span class="text-muted">Auto-apply</span>
                                        <?php endif; ?>
                                    </p>
                                </div>
                                <div class="col-6">
                                    <label class="text-muted">Discount Type</label>
                                    <p class="font-weight-bold">
                                        <span class="badge bg-<?php echo e($promo['type'] == 'percentage' ? 'primary' : ($promo['type'] == 'fixed' ? 'success' : 'warning')); ?>">
                                            <?php echo e(ucfirst($promo['type'])); ?>

                                        </span>
                                    </p>
                                </div>
                            </div>
                            
                            <div class="row mb-3">
                                <div class="col-6">
                                    <label class="text-muted">Discount Value</label>
                                    <p class="font-weight-bold">
                                        <?php if($promo['type'] == 'percentage'): ?>
                                            <?php echo e($promo['discount_value']); ?>%
                                        <?php elseif($promo['type'] == 'fixed'): ?>
                                            Rp <?php echo e(number_format($promo['discount_value'], 0, ',', '.')); ?>

                                        <?php else: ?>
                                            Buy One Get One
                                        <?php endif; ?>
                                    </p>
                                </div>
                                <div class="col-6">
                                    <label class="text-muted">Maximum Discount</label>
                                    <p class="font-weight-bold">
                                        <?php if($promo['max_discount']): ?>
                                            Rp <?php echo e(number_format($promo['max_discount'], 0, ',', '.')); ?>

                                        <?php else: ?>
                                            <span class="text-muted">No limit</span>
                                        <?php endif; ?>
                                    </p>
                                </div>
                            </div>
                            
                            <div class="row mb-3">
                                <div class="col-6">
                                    <label class="text-muted">Minimum Purchase</label>
                                    <p class="font-weight-bold">
                                        <?php if($promo['min_purchase']): ?>
                                            Rp <?php echo e(number_format($promo['min_purchase'], 0, ',', '.')); ?>

                                        <?php else: ?>
                                            <span class="text-muted">No minimum</span>
                                        <?php endif; ?>
                                    </p>
                                </div>
                                <div class="col-6">
                                    <label class="text-muted">Created On</label>
                                    <p class="font-weight-bold">
                                        <?php echo e(date('d M Y, H:i', strtotime($promo['created_at']))); ?>

                                    </p>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="text-muted">Validity Period</label>
                                <div class="d-flex align-items-center">
                                    <div class="flex-grow-1">
                                        <p class="font-weight-bold mb-0">
                                            <?php echo e(date('d M Y', strtotime($promo['start_date']))); ?> to 
                                            <?php echo e(date('d M Y', strtotime($promo['end_date']))); ?>

                                        </p>
                                        <?php if(strtotime($promo['end_date']) < time()): ?>
                                            <small class="text-danger">Expired <?php echo e(\Carbon\Carbon::parse($promo['end_date'])->diffForHumans()); ?></small>
                                        <?php elseif(strtotime($promo['start_date']) > time()): ?>
                                            <small class="text-warning">Starts in <?php echo e(\Carbon\Carbon::parse($promo['start_date'])->diffForHumans()); ?></small>
                                        <?php else: ?>
                                            <small class="text-success">Active - Ends in <?php echo e(\Carbon\Carbon::parse($promo['end_date'])->diffForHumans()); ?></small>
                                        <?php endif; ?>
                                    </div>
                                    <div class="ml-3">
                                        <div class="progress" style="width: 100px; height: 10px;">
                                            <?php
                                                $totalDays = \Carbon\Carbon::parse($promo['start_date'])->diffInDays($promo['end_date']);
                                                $daysPassed = min(max(\Carbon\Carbon::parse($promo['start_date'])->diffInDays(now()), 0), $totalDays);
                                                $percentage = $totalDays > 0 ? ($daysPassed / $totalDays) * 100 : 100;
                                            ?>
                                            <div class="progress-bar bg-<?php echo e($percentage >= 100 ? 'danger' : ($percentage >= 70 ? 'warning' : 'success')); ?>" 
                                                 role="progressbar" style="width: <?php echo e(min($percentage, 100)); ?>%"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <?php if($promo['description']): ?>
                                <div class="mb-3">
                                    <label class="text-muted">Description</label>
                                    <p class="font-weight-bold"><?php echo e($promo['description']); ?></p>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="col-md-4">
                            <!-- Usage Statistics -->
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="font-weight-bold mb-3">Usage Statistics</h6>
                                    
                                    <div class="text-center mb-4">
                                        <div class="display-4 font-weight-bold text-primary">
                                            <?php echo e($promo['usage_count'] ?? 0); ?>

                                        </div>
                                        <div class="text-muted">Total Uses</div>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="text-muted">Total Discount Given</label>
                                        <p class="font-weight-bold text-success">
                                            Rp <?php echo e(number_format($promo['total_discount_given'] ?? 0, 0, ',', '.')); ?>

                                        </p>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <label class="text-muted">Average Discount per Use</label>
                                        <p class="font-weight-bold text-info">
                                            Rp <?php echo e(number_format($promo['average_discount'] ?? 0, 0, ',', '.')); ?>

                                        </p>
                                    </div>
                                    
                                    <div class="mb-0">
                                        <label class="text-muted">Last Used</label>
                                        <p class="font-weight-bold">
                                            <?php if($promo['last_used']): ?>
                                                <?php echo e(date('d M Y, H:i', strtotime($promo['last_used']))); ?>

                                            <?php else: ?>
                                                <span class="text-muted">Never used</span>
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Recent Usage -->
            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">Recent Usage</h6>
                </div>
                <div class="card-body">
                    <?php if(isset($promo['recent_usage']) && count($promo['recent_usage']) > 0): ?>
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Order ID</th>
                                        <th>Customer</th>
                                        <th>Order Total</th>
                                        <th>Discount Applied</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $promo['recent_usage']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(date('d M Y, H:i', strtotime($usage['created_at']))); ?></td>
                                        <td>
                                            <a href="<?php echo e(route('employee.orders.show', $usage['order_id'])); ?>" target="_blank">
                                                #<?php echo e($usage['order_id']); ?>

                                            </a>
                                        </td>
                                        <td><?php echo e($usage['customer_name']); ?></td>
                                        <td>Rp <?php echo e(number_format($usage['order_total'], 0, ',', '.')); ?></td>
                                        <td class="text-success">-Rp <?php echo e(number_format($usage['discount_amount'], 0, ',', '.')); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <p class="text-muted text-center mb-0">No recent usage recorded</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <!-- Actions Card -->
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">Actions</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="<?php echo e(route('admin.promos.edit', $promo['id'])); ?>" class="btn btn-warning btn-block">
                            <i class="fas fa-edit mr-1"></i> Edit Promotion
                        </a>
                        
                        <form action="<?php echo e(route('admin.promos.toggle_active', $promo['id'])); ?>" method="POST" class="d-grid">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <button type="submit" class="btn btn-<?php echo e($promo['is_active'] ? 'secondary' : 'success'); ?> btn-block">
                                <i class="fas fa-<?php echo e($promo['is_active'] ? 'times' : 'check'); ?> mr-1"></i>
                                <?php echo e($promo['is_active'] ? 'Deactivate' : 'Activate'); ?>

                            </button>
                        </form>
                        
                        <form action="<?php echo e(route('admin.promos.destroy', $promo['id'])); ?>" method="POST" 
                              onsubmit="return confirm('Are you sure you want to delete this promotion?');" class="d-grid">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-block">
                                <i class="fas fa-trash mr-1"></i> Delete Promotion
                            </button>
                        </form>
                        
                        <?php if($promo['code']): ?>
                            <button type="button" class="btn btn-info btn-block" onclick="copyPromoCode()">
                                <i class="fas fa-copy mr-1"></i> Copy Promo Code
                            </button>
                        <?php endif; ?>
                        
                        <a href="<?php echo e(route('admin.promos.index')); ?>" class="btn btn-secondary btn-block">
                            <i class="fas fa-arrow-left mr-1"></i> Back to List
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Quick Stats -->
            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">Quick Stats</h6>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <span>Today's Uses</span>
                            <span class="badge badge-primary badge-pill"><?php echo e($promo['today_uses'] ?? 0); ?></span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <span>This Week's Uses</span>
                            <span class="badge badge-primary badge-pill"><?php echo e($promo['week_uses'] ?? 0); ?></span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <span>This Month's Uses</span>
                            <span class="badge badge-primary badge-pill"><?php echo e($promo['month_uses'] ?? 0); ?></span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <span>Unique Customers</span>
                            <span class="badge badge-success badge-pill"><?php echo e($promo['unique_customers'] ?? 0); ?></span>
                        </div>
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <span>Success Rate</span>
                            <span class="badge badge-info badge-pill"><?php echo e(number_format($promo['success_rate'] ?? 100, 1)); ?>%</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    function copyPromoCode() {
        const promoCode = "<?php echo e($promo['code']); ?>";
        navigator.clipboard.writeText(promoCode).then(function() {
            alert('Promo code copied to clipboard: ' + promoCode);
        }, function(err) {
            console.error('Failed to copy promo code: ', err);
        });
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views\admin\promos\show.blade.php ENDPATH**/ ?>