

<?php $__env->startSection('title', isset($order) ? 'Order #' . ($order['order_number'] ?? $order['id']) : 'Order Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">

    <?php if(isset($apiError)): ?>
        <div class="alert alert-warning">
            <i class="fas fa-exclamation-triangle me-2"></i>
            Using sample data. API Error: <?php echo e($apiError); ?>

        </div>
    <?php endif; ?>

    <!-- Tambah di bagian atas atau di order actions -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="d-flex justify-content-between">
            <a href="<?php echo e(route('customer.orders.index')); ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-1"></i> Back to Orders
            </a>
            <a href="'/customer/rating-history'" class="btn btn-outline-info">
                <i class="fas fa-star me-1"></i> View Rating History
            </a>
        </div>
    </div>
</div>

    <!-- Order Header -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card shadow">
                <div class="card-header bg-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h4 class="mb-1">Order #<?php echo e($order['order_number'] ?? $order['id'] ?? 'N/A'); ?></h4>
                            <p class="text-muted mb-0">
                                <i class="fas fa-calendar me-1"></i>
                                <?php echo e($order['created_at_formatted'] ?? date('F j, Y, g:i A', strtotime($order['created_at']))); ?>

                            </p>
                        </div>
                        <div class="text-end">
                            <?php
                                $status = $order['status'] ?? 'pending';
                                $statusColors = [
                                    'pending' => 'warning',
                                    'processing' => 'info',
                                    'preparing' => 'primary',
                                    'ready' => 'success',
                                    'on_delivery' => 'info',
                                    'completed' => 'success',
                                    'cancelled' => 'danger',
                                    'delivered' => 'success'
                                ];
                                $statusColor = $statusColors[$status] ?? 'secondary';
                                $statusText = str_replace('_', ' ', ucfirst($status));
                            ?>
                            <span class="badge bg-<?php echo e($statusColor); ?> p-2 fs-6"><?php echo e($statusText); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Order Details -->
        <div class="col-lg-8 mb-4">
            <!-- Order Items -->
            <div class="card shadow mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Order Items</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Item</th>
                                    <th class="text-center">Quantity</th>
                                    <th class="text-end">Price</th>
                                    <th class="text-end">Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(isset($order['items']) && count($order['items']) > 0): ?>
                                    <?php $__currentLoopData = $order['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <strong><?php echo e($item['name'] ?? 'Item'); ?></strong>
                                                <?php if(isset($item['notes']) && $item['notes']): ?>
                                                    <br><small class="text-muted"><?php echo e($item['notes']); ?></small>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-center"><?php echo e($item['quantity'] ?? 1); ?></td>
                                            <td class="text-end">Rp <?php echo e(number_format($item['price'] ?? 0, 0, ',', '.')); ?></td>
                                            <td class="text-end">Rp <?php echo e(number_format(($item['price'] ?? 0) * ($item['quantity'] ?? 1), 0, ',', '.')); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="4" class="text-center text-muted py-3">No items found</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="3" class="text-end"><strong>Subtotal</strong></td>
                                    <td class="text-end">Rp <?php echo e(number_format($order['total_amount'] ?? 0, 0, ',', '.')); ?></td>
                                </tr>
                                <?php if(isset($order['delivery']['delivery_fee']) && $order['delivery']['delivery_fee'] > 0): ?>
                                    <tr>
                                        <td colspan="3" class="text-end"><strong>Delivery Fee</strong></td>
                                        <td class="text-end">Rp <?php echo e(number_format($order['delivery']['delivery_fee'], 0, ',', '.')); ?></td>
                                    </tr>
                                <?php endif; ?>
                                <tr class="table-active">
                                    <td colspan="3" class="text-end"><strong>Total Amount</strong></td>
                                    <td class="text-end">
                                        <strong>Rp <?php echo e(number_format(($order['total_amount'] ?? 0) + ($order['delivery']['delivery_fee'] ?? 0), 0, ',', '.')); ?></strong>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>

            <!-- Order Notes -->
            <?php if(isset($order['order_notes']) && $order['order_notes']): ?>
                <div class="card shadow mb-4">
                    <div class="card-header bg-white">
                        <h5 class="mb-0">Order Notes</h5>
                    </div>
                    <div class="card-body">
                        <p class="mb-0"><?php echo e($order['order_notes']); ?></p>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <!-- Order Info Sidebar -->
        <div class="col-lg-4 mb-4">
            <!-- Customer Info -->
            <div class="card shadow mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Customer Information</h5>
                </div>
                <div class="card-body">
                    <p class="mb-1">
                        <strong>Name:</strong> <?php echo e($order['customer']['name'] ?? Auth::user()->name); ?>

                    </p>
                    <p class="mb-1">
                        <strong>Email:</strong> <?php echo e($order['customer']['email'] ?? Auth::user()->email); ?>

                    </p>
                    <p class="mb-0">
                        <strong>Phone:</strong> <?php echo e($order['customer']['phone'] ?? Auth::user()->phone ?? 'N/A'); ?>

                    </p>
                </div>
            </div>

            <!-- Delivery Info -->
            <div class="card shadow mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Delivery Information</h5>
                </div>
                <div class="card-body">
                    <p class="mb-2">
                        <strong>Address:</strong><br>
                        <?php echo e($order['delivery_address'] ?? 'Not specified'); ?>

                    </p>
                    <p class="mb-1">
                        <strong>Type:</strong>
                        <?php echo e(isset($order['delivery']['type']) ? ucfirst(str_replace('_', ' ', $order['delivery']['type'])) : 'Home Delivery'); ?>

                    </p>
                    <p class="mb-0">
                        <strong>Estimated Time:</strong>
                        <?php echo e($order['delivery']['estimated_time'] ?? '30-45 minutes'); ?>

                    </p>
                </div>
            </div>

            <!-- Payment Info -->
            <div class="card shadow mb-4">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Payment Information</h5>
                </div>
                <div class="card-body">
                    <?php
                        $paymentStatus = $order['payment_status'] ?? 'pending';
                        $paymentColor = $paymentStatus == 'paid' ? 'success' : ($paymentStatus == 'pending' ? 'warning' : 'danger');
                    ?>
                    <p class="mb-1">
                        <strong>Status:</strong>
                        <span class="badge bg-<?php echo e($paymentColor); ?> ms-1"><?php echo e(ucfirst($paymentStatus)); ?></span>
                    </p>
                    <p class="mb-1">
                        <strong>Method:</strong>
                        <?php echo e($order['payment']['method'] ?? 'Credit Card'); ?>

                    </p>
                    <?php if(isset($order['payment']['transaction_id'])): ?>
                        <p class="mb-1">
                            <strong>Transaction ID:</strong>
                            <?php echo e($order['payment']['transaction_id']); ?>

                        </p>
                    <?php endif; ?>
                    <?php if(isset($order['payment']['paid_at'])): ?>
                        <p class="mb-0">
                            <strong>Paid At:</strong>
                            <?php echo e(date('M d, Y H:i', strtotime($order['payment']['paid_at']))); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Order Actions -->
            <div class="card shadow">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Order Actions</h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <?php if(in_array($status, ['pending', 'processing'])): ?>
                            <button onclick="confirmCancel('<?php echo e($order['id']); ?>')" 
                                    class="btn btn-danger">
                                <i class="fas fa-times me-2"></i>Cancel Order
                            </button>
                        <?php endif; ?>
                        
                        <?php if($status == 'on_delivery'): ?>
                            <a href="<?php echo e(route('customer.orders.track', $order['id'])); ?>" 
                               class="btn btn-info">
                                <i class="fas fa-truck me-2"></i>Track Order
                            </a>
                        <?php endif; ?>
                        
<?php if($status == 'completed'): ?>
    <?php
        // Check if order has reviews
        $hasReview = \App\Models\Review::where('order_id', $order->id)
            ->where('customer_id', Auth::id())
            ->exists();
    ?>
    
    <?php if(!$hasReview): ?>
        <a href="<?php echo e(route('customer.orders.rate', $order->id)); ?>" class="btn btn-warning">
            <i class="fas fa-star me-2"></i>Rate Order
        </a>
    <?php else: ?>
        <button class="btn btn-success" disabled>
            <i class="fas fa-check me-2"></i>Already Rated
        </button>
    <?php endif; ?>
    
    <a href="#" class="btn btn-outline-secondary">
        <i class="fas fa-redo me-2"></i>Reorder
    </a>
<?php endif; ?>

                        <a href="#" class="btn btn-outline-primary">
                            <i class="fas fa-print me-2"></i>Print Receipt
                        </a>
                        
                        <a href="mailto:support@chingubite.com?subject=Help with Order <?php echo e($order->order_number); ?>" class="btn btn-outline-secondary">
                            <i class="fas fa-question-circle me-2"></i>Get Help
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Order Timeline -->
    <div class="row">
        <div class="col-md-12">
            <div class="card shadow">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Order Timeline</h5>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <?php
                            $timeline = [
                                'pending' => 'Order placed',
                                'processing' => 'Order confirmed',
                                'preparing' => 'Preparing food',
                                'ready' => 'Ready for delivery',
                                'on_delivery' => 'Out for delivery',
                                'completed' => 'Order delivered'
                            ];
                            
                            $statusOrder = ['pending', 'processing', 'preparing', 'ready', 'on_delivery', 'completed'];
                            $currentIndex = array_search($status, $statusOrder);
                        ?>
                        
                        <?php $__currentLoopData = $timeline; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="timeline-item <?php echo e($currentIndex >= array_search($key, $statusOrder) ? 'active' : ''); ?>">
                                <div class="timeline-marker">
                                    <i class="fas fa-check"></i>
                                </div>
                                <div class="timeline-content">
                                    <h6 class="mb-1"><?php echo e($label); ?></h6>
                                    <?php if($currentIndex >= array_search($key, $statusOrder)): ?>
                                        <small class="text-muted">Completed</small>
                                    <?php else: ?>
                                        <small class="text-muted">Pending</small>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Cancel Order Modal -->
<div class="modal fade" id="cancelOrderModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cancel Order</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to cancel this order?</p>
                <p class="text-muted"><small>Note: Orders can only be cancelled within 15 minutes of placement.</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">No, Keep Order</button>
                <form id="cancelOrderForm" method="POST" action="">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-danger">Yes, Cancel Order</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
function confirmCancel(orderId) {
    const form = document.getElementById('cancelOrderForm');
    form.action = "<?php echo e(url('customer/orders')); ?>/" + orderId + "/cancel";
    
    const modal = new bootstrap.Modal(document.getElementById('cancelOrderModal'));
    modal.show();
}
</script>

<style>
.timeline {
    position: relative;
    padding-left: 40px;
}

.timeline-item {
    position: relative;
    margin-bottom: 30px;
}

.timeline-item:last-child {
    margin-bottom: 0;
}

.timeline-marker {
    position: absolute;
    left: -40px;
    top: 0;
    width: 30px;
    height: 30px;
    border-radius: 50%;
    background-color: #e3e6f0;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #6c757d;
    border: 3px solid white;
}

.timeline-item.active .timeline-marker {
    background-color: #4e73df;
    color: white;
}

.timeline-content {
    padding-left: 15px;
}

.timeline-item::before {
    content: '';
    position: absolute;
    left: -26px;
    top: 30px;
    bottom: -30px;
    width: 2px;
    background-color: #e3e6f0;
}

.timeline-item:last-child::before {
    display: none;
}

.timeline-item.active::before {
    background-color: #4e73df;
}

.card {
    border: 1px solid #e3e6f0;
    border-radius: 10px;
}

.table tfoot tr:last-child {
    border-top: 2px solid #dee2e6;
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views/customer/orders/show.blade.php ENDPATH**/ ?>