


<?php $__env->startSection('title', 'User Management'); ?>
<?php $__env->startSection('page_title', 'User Management'); ?>
<?php $__env->startSection('icon', 'fa-users'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <?php if(request()->has('search') || request()->has('role') || request()->has('status')): ?>
        <li class="breadcrumb-item">Users</li>
        <li class="breadcrumb-item active">Search Results</li>
    <?php else: ?>
        <li class="breadcrumb-item active">Users</li>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="card-title mb-0">
                            <i class="fas fa-users me-2"></i>User Management
                        </h3>
                        <a href="<?php echo e(url('admin/users/create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> Add New User
                        </a>
                    </div>
                </div>
                
                <div class="card-body">
                    <!-- Filter Section -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card border">
                                <div class="card-body py-3">
                                    <form method="GET" action="<?php echo e(url('admin/users/index')); ?>" class="row g-3 align-items-end">
                                        <div class="col-md-3">
                                            <label class="form-label small">Search</label>
                                            <input type="text" name="search" class="form-control form-control-sm" 
                                                   placeholder="Name, email, or phone..." 
                                                   value="<?php echo e(request('search')); ?>">
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label small">Role</label>
                                            <select name="role" class="form-control form-control-sm">
                                                <option value="">All Roles</option>
                                                <?php $__currentLoopData = ['admin', 'employee', 'customer']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($role); ?>" 
                                                            <?php echo e(request('role') == $role ? 'selected' : ''); ?>>
                                                        <?php echo e(ucfirst($role)); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label small">Status</label>
                                            <select name="status" class="form-control form-control-sm">
                                                <option value="">All Status</option>
                                                <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>
                                                    Active
                                                </option>
                                                <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>
                                                    Inactive
                                                </option>
                                            </select>
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label small">Sort By</label>
                                            <select name="sort" class="form-control form-control-sm">
                                                <option value="newest" <?php echo e(request('sort') == 'newest' ? 'selected' : ''); ?>>
                                                    Newest First
                                                </option>
                                                <option value="oldest" <?php echo e(request('sort') == 'oldest' ? 'selected' : ''); ?>>
                                                    Oldest First
                                                </option>
                                                <option value="name_asc" <?php echo e(request('sort') == 'name_asc' ? 'selected' : ''); ?>>
                                                    Name A-Z
                                                </option>
                                                <option value="name_desc" <?php echo e(request('sort') == 'name_desc' ? 'selected' : ''); ?>>
                                                    Name Z-A
                                                </option>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="d-flex gap-2">
                                                <button type="submit" class="btn btn-primary btn-sm">
                                                    <i class="fas fa-filter me-1"></i> Filter
                                                </button>
                                                <a href="<?php echo e(url('admin/users/index')); ?>" class="btn btn-secondary btn-sm">
                                                    <i class="fas fa-redo me-1"></i> Reset
                                                </a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Stats Cards -->
                    <div class="row mb-4">
                        <div class="col-md-3 col-sm-6">
                            <div class="stat-card border-start border-primary">
                                <div class="stat-value"><?php echo e($totalUsers ?? 0); ?></div>
                                <div class="stat-label">Total Users</div>
                                <i class="fas fa-users text-primary"></i>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6">
                            <div class="stat-card border-start border-success">
                                <div class="stat-value"><?php echo e($activeUsers ?? 0); ?></div>
                                <div class="stat-label">Active Users</div>
                                <i class="fas fa-user-check text-success"></i>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6">
                            <div class="stat-card border-start border-warning">
                                <div class="stat-value"><?php echo e($adminCount ?? 0); ?></div>
                                <div class="stat-label">Admin Users</div>
                                <i class="fas fa-user-shield text-warning"></i>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6">
                            <div class="stat-card border-start border-info">
                                <div class="stat-value"><?php echo e($customerCount ?? 0); ?></div>
                                <div class="stat-label">Customers</div>
                                <i class="fas fa-shopping-cart text-info"></i>
                            </div>
                        </div>
                    </div>

                    <!-- Users Table -->
                    <div class="table-responsive">
                        <table class="table table-hover data-table">
                            <thead>
                                <tr>
                                    <th width="50">ID</th>
                                    <th>User</th>
                                    <th>Contact</th>
                                    <th>Role</th>
                                    <th>Status</th>
                                    <th>Last Login</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>#<?php echo e($user['id'] ?? 'N/A'); ?></td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <?php if(isset($user['avatar']) && $user['avatar']): ?>
                                                    <img src="<?php echo e($user['avatar']); ?>" alt="<?php echo e($user['name']); ?>" 
                                                         class="rounded-circle me-3" width="40" height="40" style="object-fit: cover;">
                                                <?php else: ?>
                                                    <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" 
                                                         style="width: 40px; height: 40px; font-size: 16px;">
                                                        <?php echo e(substr($user['name'] ?? '?', 0, 1)); ?>

                                                    </div>
                                                <?php endif; ?>
                                                <div>
                                                    <strong><?php echo e($user['name'] ?? 'N/A'); ?></strong>
                                                    <?php if(isset($user['date_of_birth'])): ?>
                                                        <br>
                                                        <small class="text-muted">
                                                            <?php echo e(\Carbon\Carbon::parse($user['date_of_birth'])->age); ?> years
                                                        </small>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div>
                                                <i class="fas fa-envelope text-muted me-1"></i>
                                                <small><?php echo e($user['email'] ?? 'N/A'); ?></small>
                                            </div>
                                            <?php if(isset($user['phone'])): ?>
                                                <div>
                                                    <i class="fas fa-phone text-muted me-1"></i>
                                                    <small><?php echo e($user['phone']); ?></small>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php
                                                $roleColors = [
                                                    'admin' => 'danger',
                                                    'employee' => 'warning',
                                                    'customer' => 'info'
                                                ];
                                                $roleColor = $roleColors[$user['role'] ?? 'customer'] ?? 'secondary';
                                            ?>
                                            <span class="badge bg-<?php echo e($roleColor); ?>">
                                                <i class="fas fa-<?php echo e($user['role'] == 'admin' ? 'user-shield' : ($user['role'] == 'employee' ? 'user-tie' : 'user')); ?> me-1"></i>
                                                <?php echo e(ucfirst($user['role'] ?? 'customer')); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <?php if(isset($user['is_active']) && $user['is_active']): ?>
                                                <span class="badge bg-success">
                                                    <i class="fas fa-check-circle me-1"></i> Active
                                                </span>
                                            <?php else: ?>
                                                <span class="badge bg-secondary">
                                                    <i class="fas fa-times-circle me-1"></i> Inactive
                                                </span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if(isset($user['last_login_at']) && $user['last_login_at']): ?>
                                                <span title="<?php echo e($user['last_login_at']); ?>">
                                                    <?php echo e(\Carbon\Carbon::parse($user['last_login_at'])->diffForHumans()); ?>

                                                </span>
                                                <?php if(isset($user['last_login_ip'])): ?>
                                                    <br>
                                                    <small class="text-muted">IP: <?php echo e($user['last_login_ip']); ?></small>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <span class="text-muted">Never</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="<?php echo e(url('admin/users/' . ($user['id'] ?? ''))); ?>" 
                                                   class="btn btn-info" data-bs-toggle="tooltip" title="View">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="<?php echo e(url('admin/users/' . ($user['id'] ?? '') . '/edit')); ?>" 
                                                   class="btn btn-warning" data-bs-toggle="tooltip" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" class="btn btn-danger" 
                                                        onclick="confirmDelete('delete-user-<?php echo e($user['id'] ?? ''); ?>')"
                                                        data-bs-toggle="tooltip" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                            
                                            <form id="delete-user-<?php echo e($user['id'] ?? ''); ?>" 
                                                  action="<?php echo e(url('admin/users/' . ($user['id'] ?? ''))); ?>" 
                                                  method="POST" style="display: none;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="fas fa-users fa-3x mb-3"></i>
                                                <h5>No users found</h5>
                                                <p>Try adjusting your search filters</p>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <?php if(isset($pagination) && $pagination['last_page'] > 1): ?>
                        <nav class="mt-4">
                            <ul class="pagination justify-content-center">
                                <?php if($pagination['current_page'] > 1): ?>
                                    <li class="page-item">
                                        <a class="page-link" 
                                           href="<?php echo e(request()->fullUrlWithQuery(['page' => $pagination['current_page'] - 1])); ?>">
                                            <i class="fas fa-chevron-left"></i>
                                        </a>
                                    </li>
                                <?php endif; ?>

                                <?php for($i = 1; $i <= $pagination['last_page']; $i++): ?>
                                    <?php if($i == $pagination['current_page']): ?>
                                        <li class="page-item active">
                                            <span class="page-link"><?php echo e($i); ?></span>
                                        </li>
                                    <?php elseif($i >= $pagination['current_page'] - 2 && $i <= $pagination['current_page'] + 2): ?>
                                        <li class="page-item">
                                            <a class="page-link" 
                                               href="<?php echo e(request()->fullUrlWithQuery(['page' => $i])); ?>">
                                                <?php echo e($i); ?>

                                            </a>
                                        </li>
                                    <?php endif; ?>
                                <?php endfor; ?>

                                <?php if($pagination['current_page'] < $pagination['last_page']): ?>
                                    <li class="page-item">
                                        <a class="page-link" 
                                           href="<?php echo e(request()->fullUrlWithQuery(['page' => $pagination['current_page'] + 1])); ?>">
                                            <i class="fas fa-chevron-right"></i>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </nav>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function() {
        // Initialize DataTable
        $('.data-table').DataTable({
            pageLength: 25,
            responsive: true,
            order: [[0, 'desc']],
            columnDefs: [
                { orderable: false, targets: [6] } // Disable sorting for actions column
            ]
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views/admin/users/index.blade.php ENDPATH**/ ?>