

<?php $__env->startSection('title', 'Payment Methods'); ?>
<?php $__env->startSection('page-title', 'Payment Methods'); ?>

<?php $__env->startSection('breadcrumbs'); ?>
    <li class="breadcrumb-item active">Payment Methods</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Statistics -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Methods
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($totalMethods ?? 0); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-credit-card fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Active Methods
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($activeMethods ?? 0); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Digital Methods
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e($digitalMethods ?? 0); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-mobile-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Most Used Method
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?php echo e(ucfirst(str_replace('_', ' ', $mostUsedMethod))); ?>

                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-chart-pie fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6 class="card-title mb-0">Payment Methods</h6>
                    <a href="<?php echo e(route('admin.payment-methods.create')); ?>" class="btn btn-primary btn-sm">
                        <i class="fas fa-plus mr-1"></i> Add New Method
                    </a>
                </div>
                <div class="card-body">
                    <!-- Filter Form -->
                    <form method="GET" action="<?php echo e(route('admin.payment-methods.index')); ?>" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="search">Search</label>
                                    <input type="text" class="form-control" id="search" name="search" 
                                           value="<?php echo e(request('search')); ?>" placeholder="Search by name...">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="code">Type</label>
                                    <select class="form-control" id="code" name="code">
                                        <option value="">All Types</option>
                                        <?php $__currentLoopData = $codes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($code); ?>" <?php echo e(request('code') == $code ? 'selected' : ''); ?>>
                                                <?php echo e(ucfirst(str_replace('_', ' ', $code))); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="is_active">Status</label>
                                    <select class="form-control" id="is_active" name="is_active">
                                        <option value="">All Status</option>
                                        <option value="1" <?php echo e(request('is_active') == '1' ? 'selected' : ''); ?>>Active</option>
                                        <option value="0" <?php echo e(request('is_active') == '0' ? 'selected' : ''); ?>>Inactive</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="fas fa-filter"></i> Filter
                                </button>
                            </div>
                        </div>
                    </form>

                    <!-- Payment Methods Table -->
                    <div class="table-responsive">
                        <table class="table table-bordered data-table">
                            <thead>
                                <tr>
                                    <th width="50">#</th>
                                    <th>Name</th>
                                    <th>Type</th>
                                    <th>Account Details</th>
                                    <th>Instructions</th>
                                    <th>Status</th>
                                    <th>Usage</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td>
                                        <strong><?php echo e($method['name']); ?></strong>
                                        <br>
                                        <small class="text-muted">
                                            <?php echo e($method['account_name'] ? 'Account: ' . $method['account_name'] : ''); ?>

                                            <?php echo e($method['account_number'] ? ' | ' . $method['account_number'] : ''); ?>

                                        </small>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e(getPaymentMethodColor($method['code'])); ?>">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $method['code']))); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <?php if($method['account_number']): ?>
                                            <small>
                                                <strong>Number:</strong> <?php echo e($method['account_number']); ?><br>
                                                <strong>Name:</strong> <?php echo e($method['account_name'] ?? 'N/A'); ?>

                                            </small>
                                        <?php else: ?>
                                            <span class="text-muted">No account details</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($method['instructions']): ?>
                                            <small><?php echo e(Str::limit($method['instructions'], 50)); ?></small>
                                        <?php else: ?>
                                            <span class="text-muted">No instructions</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <span class="badge badge-<?php echo e($method['is_active'] ? 'success' : 'danger'); ?>">
                                            <?php echo e($method['is_active'] ? 'Active' : 'Inactive'); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <small>
                                            <strong>Total:</strong> <?php echo e($method['total_transactions'] ?? 0); ?><br>
                                            <strong>Success:</strong> <?php echo e(number_format($method['success_rate'] ?? 100, 1)); ?>%
                                        </small>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="<?php echo e(route('admin.payment-methods.show', $method['id'])); ?>" 
                                               class="btn btn-info btn-sm" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.payment-methods.edit', $method['id'])); ?>" 
                                               class="btn btn-warning btn-sm" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="<?php echo e(route('admin.payment-methods.destroy', $method['id'])); ?>" 
                                                  method="POST" class="d-inline" 
                                                  onsubmit="return confirm('Are you sure you want to delete this payment method?');">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-danger btn-sm" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8" class="text-center">No payment methods found</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <?php if($pagination): ?>
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div class="text-muted">
                                Showing <?php echo e(($pagination['current_page'] - 1) * $pagination['per_page'] + 1); ?> to 
                                <?php echo e(min($pagination['current_page'] * $pagination['per_page'], $pagination['total'])); ?> of 
                                <?php echo e($pagination['total']); ?> entries
                            </div>
                            <nav>
                                <ul class="pagination pagination-sm mb-0">
                                    <?php if($pagination['current_page'] > 1): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?php echo e(request()->fullUrlWithQuery(['page' => $pagination['current_page'] - 1])); ?>">
                                                Previous
                                            </a>
                                        </li>
                                    <?php endif; ?>

                                    <?php for($i = 1; $i <= $pagination['last_page']; $i++): ?>
                                        <?php if($i == 1 || $i == $pagination['last_page'] || ($i >= $pagination['current_page'] - 2 && $i <= $pagination['current_page'] + 2)): ?>
                                            <li class="page-item <?php echo e($i == $pagination['current_page'] ? 'active' : ''); ?>">
                                                <a class="page-link" href="<?php echo e(request()->fullUrlWithQuery(['page' => $i])); ?>">
                                                    <?php echo e($i); ?>

                                                </a>
                                            </li>
                                        <?php elseif($i == $pagination['current_page'] - 3 || $i == $pagination['current_page'] + 3): ?>
                                            <li class="page-item disabled">
                                                <span class="page-link">...</span>
                                            </li>
                                        <?php endif; ?>
                                    <?php endfor; ?>

                                    <?php if($pagination['current_page'] < $pagination['last_page']): ?>
                                        <li class="page-item">
                                            <a class="page-link" href="<?php echo e(request()->fullUrlWithQuery(['page' => $pagination['current_page'] + 1])); ?>">
                                                Next
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </nav>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php
function getPaymentMethodColor($code) {
    $colors = [
        'cash' => 'success',
        'bank_transfer' => 'primary',
        'ewallet' => 'info',
        'qris' => 'warning',
        'credit_card' => 'danger'
    ];
    return $colors[$code] ?? 'secondary';
}
?>

<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function() {
        // Initialize DataTable
        $('.data-table').DataTable({
            paging: false,
            searching: false,
            info: false,
            order: [[1, 'asc']] // Sort by name
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views/admin/payment-methods/index.blade.php ENDPATH**/ ?>