


<?php $__env->startSection('title', 'Promo Management'); ?>
<?php $__env->startSection('page_title', 'Promo Management'); ?>
<?php $__env->startSection('icon', 'fa-tags'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active">Promo Management</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-tags me-2"></i>Promotions
                        </h5>
                        <a href="<?php echo e(route('admin.promos.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> Add New Promo
                        </a>
                    </div>
                </div>
                
                <div class="card-body">
                    <!-- Filter Form -->
                    <form method="GET" action="<?php echo e(route('admin.promos.index')); ?>" class="mb-4">
                        <div class="row g-3">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="search" class="form-label">Search</label>
                                    <input type="text" class="form-control form-control-sm" 
                                           id="search" name="search" 
                                           value="<?php echo e(request('search')); ?>" 
                                           placeholder="Name or code...">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="type" class="form-label">Type</label>
                                    <select class="form-control form-control-sm" id="type" name="type">
                                        <option value="">All Types</option>
                                        <option value="percentage" <?php echo e(request('type') == 'percentage' ? 'selected' : ''); ?>>
                                            Percentage
                                        </option>
                                        <option value="fixed" <?php echo e(request('type') == 'fixed' ? 'selected' : ''); ?>>
                                            Fixed Amount
                                        </option>
                                        <option value="bogo" <?php echo e(request('type') == 'bogo' ? 'selected' : ''); ?>>
                                            Buy One Get One
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="is_active" class="form-label">Status</label>
                                    <select class="form-control form-control-sm" id="is_active" name="is_active">
                                        <option value="">All Status</option>
                                        <option value="1" <?php echo e(request('is_active') == '1' ? 'selected' : ''); ?>>
                                            Active
                                        </option>
                                        <option value="0" <?php echo e(request('is_active') == '0' ? 'selected' : ''); ?>>
                                            Inactive
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3 d-flex align-items-end">
                                <div class="d-flex gap-2 w-100">
                                    <button type="submit" class="btn btn-primary btn-sm flex-grow-1">
                                        <i class="fas fa-filter me-1"></i> Filter
                                    </button>
                                    <a href="<?php echo e(route('admin.promos.index')); ?>" class="btn btn-secondary btn-sm">
                                        <i class="fas fa-redo"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </form>

                    <!-- Promotions Table -->
                    <div class="table-responsive">
                        <table class="table table-hover data-table">
                            <thead>
                                <tr>
                                    <th width="50">#</th>
                                    <th>Name</th>
                                    <th>Code</th>
                                    <th>Type</th>
                                    <th>Discount Value</th>
                                    <th>Validity Period</th>
                                    <th>Usage</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $promos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $promo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td>
                                        <strong><?php echo e($promo['name']); ?></strong>
                                        <?php if($promo['description']): ?>
                                            <br>
                                            <small class="text-muted"><?php echo e(Str::limit($promo['description'], 50)); ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($promo['code']): ?>
                                            <code class="bg-light px-2 py-1 rounded"><?php echo e($promo['code']); ?></code>
                                        <?php else: ?>
                                            <span class="text-muted">Auto-apply</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php
                                            $typeColors = [
                                                'percentage' => 'primary',
                                                'fixed' => 'success', 
                                                'bogo' => 'warning'
                                            ];
                                            $typeColor = $typeColors[$promo['type']] ?? 'secondary';
                                        ?>
                                        <span class="badge bg-<?php echo e($typeColor); ?>">
                                            <?php echo e(ucfirst($promo['type'])); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <?php if($promo['type'] == 'percentage'): ?>
                                            <strong><?php echo e($promo['discount_value']); ?>%</strong>
                                        <?php elseif($promo['type'] == 'fixed'): ?>
                                            <strong>Rp <?php echo e(number_format($promo['discount_value'], 0, ',', '.')); ?></strong>
                                        <?php else: ?>
                                            <span class="text-warning">BOGO</span>
                                        <?php endif; ?>
                                        <?php if($promo['max_discount']): ?>
                                            <br>
                                            <small class="text-muted">
                                                Max: Rp <?php echo e(number_format($promo['max_discount'], 0, ',', '.')); ?>

                                            </small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="small">
                                            <div><?php echo e(date('d M Y', strtotime($promo['start_date']))); ?></div>
                                            <div class="text-muted">to</div>
                                            <div><?php echo e(date('d M Y', strtotime($promo['end_date']))); ?></div>
                                            <?php if(strtotime($promo['end_date']) < time()): ?>
                                                <span class="badge bg-danger mt-1">Expired</span>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="small">
                                            <div>
                                                <i class="fas fa-fire text-warning me-1"></i>
                                                <?php echo e($promo['usage_count'] ?? 0); ?> uses
                                            </div>
                                            <?php if($promo['min_purchase']): ?>
                                                <div class="text-muted">
                                                    Min: Rp <?php echo e(number_format($promo['min_purchase'], 0, ',', '.')); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if($promo['is_active']): ?>
                                            <span class="badge bg-success">
                                                <i class="fas fa-check-circle me-1"></i> Active
                                            </span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">
                                                <i class="fas fa-times-circle me-1"></i> Inactive
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="<?php echo e(route('admin.promos.show', $promo['id'])); ?>" 
                                               class="btn btn-info" data-bs-toggle="tooltip" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?php echo e(route('admin.promos.edit', $promo['id'])); ?>" 
                                               class="btn btn-warning" data-bs-toggle="tooltip" title="Edit">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" class="btn btn-danger" 
                                                    onclick="confirmDelete('delete-promo-<?php echo e($promo['id']); ?>')"
                                                    data-bs-toggle="tooltip" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                            <form action="<?php echo e(route('admin.promos.toggle_active', $promo['id'])); ?>" 
                                                  method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>
                                                <button type="submit" 
                                                        class="btn btn-<?php echo e($promo['is_active'] ? 'secondary' : 'success'); ?>"
                                                        data-bs-toggle="tooltip" 
                                                        title="<?php echo e($promo['is_active'] ? 'Deactivate' : 'Activate'); ?>">
                                                    <i class="fas fa-<?php echo e($promo['is_active'] ? 'times' : 'check'); ?>"></i>
                                                </button>
                                            </form>
                                        </div>
                                        
                                        <form id="delete-promo-<?php echo e($promo['id']); ?>" 
                                              action="<?php echo e(route('admin.promos.destroy', $promo['id'])); ?>" 
                                              method="POST" style="display: none;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center py-4">
                                        <div class="text-muted">
                                            <i class="fas fa-tags fa-3x mb-3"></i>
                                            <h5>No promotions found</h5>
                                            <p>Try adjusting your search filters or add new promotions</p>
                                        </div>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <?php if(isset($pagination)): ?>
                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div class="text-muted">
                                Showing <?php echo e($pagination['from'] ?? 0); ?> to 
                                <?php echo e($pagination['to'] ?? 0); ?> of 
                                <?php echo e($pagination['total'] ?? 0); ?> entries
                            </div>
                            <nav>
                                <ul class="pagination pagination-sm mb-0">
                                    
                                    <?php if(isset($pagination['current_page']) && $pagination['current_page'] > 1): ?>
                                        <li class="page-item">
                                            <a class="page-link" 
                                               href="<?php echo e(request()->fullUrlWithQuery(['page' => $pagination['current_page'] - 1])); ?>">
                                                &laquo;
                                            </a>
                                        </li>
                                    <?php else: ?>
                                        <li class="page-item disabled">
                                            <span class="page-link">&laquo;</span>
                                        </li>
                                    <?php endif; ?>

                                    
                                    <?php if(isset($pagination['last_page'])): ?>
                                        <?php
                                            $currentPage = $pagination['current_page'] ?? 1;
                                            $lastPage = $pagination['last_page'] ?? 1;
                                            $startPage = max(1, $currentPage - 2);
                                            $endPage = min($lastPage, $currentPage + 2);
                                        ?>
                                        
                                        <?php for($i = $startPage; $i <= $endPage; $i++): ?>
                                            <?php if($i == $currentPage): ?>
                                                <li class="page-item active">
                                                    <span class="page-link"><?php echo e($i); ?></span>
                                                </li>
                                            <?php else: ?>
                                                <li class="page-item">
                                                    <a class="page-link" 
                                                       href="<?php echo e(request()->fullUrlWithQuery(['page' => $i])); ?>">
                                                        <?php echo e($i); ?>

                                                    </a>
                                                </li>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                    <?php endif; ?>

                                    
                                    <?php if(isset($pagination['current_page']) && isset($pagination['last_page']) && 
                                        $pagination['current_page'] < $pagination['last_page']): ?>
                                        <li class="page-item">
                                            <a class="page-link" 
                                               href="<?php echo e(request()->fullUrlWithQuery(['page' => $pagination['current_page'] + 1])); ?>">
                                                &raquo;
                                            </a>
                                        </li>
                                    <?php else: ?>
                                        <li class="page-item disabled">
                                            <span class="page-link">&raquo;</span>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </nav>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function() {
        // Initialize DataTable
        $('.data-table').DataTable({
            pageLength: 25,
            responsive: true,
            order: [[5, 'desc']], // Sort by validity date
            columnDefs: [
                { orderable: false, targets: [8] } // Disable sorting for actions column
            ]
        });
        
        // Initialize tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
    
    function confirmDelete(formId) {
        if (confirm('Are you sure you want to delete this promotion?')) {
            document.getElementById(formId).submit();
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\PABW\Chingu-Bite-fix\resources\views/admin/promos/index.blade.php ENDPATH**/ ?>