<!-- Navigation -->
<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm fixed-top">
    <div class="container">
        <a class="navbar-brand text-primary" href="{{ url('/') }}">
            <i class="fas fa-utensils me-2"></i>Chingu Bite
        </a>
        
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ms-auto">
                <li class="nav-item">
                    <a class="nav-link {{ request()->is('/') ? 'active' : '' }}" href="{{ url('/') }}">Home</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ request()->is('menu*') ? 'active' : '' }}" href="{{ route('menu.public') }}">Menu</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link {{ request()->is('careers*') ? 'active' : '' }}" href="{{ route('careers.public') }}">Careers</a>
                </li>
                
                @if(Session::has('is_logged_in') || Session::has('api_token'))
                    @if(Session::get('user_role') == 'customer')
                        <li class="nav-item">
                            <a class="nav-link {{ request()->is('customer/dashboard*') ? 'active' : '' }}" 
                               href="{{ route('customer.dashboard') }}">Dashboard</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->is('customer/cart*') ? 'active' : '' }}" 
                               href="{{ route('customer.cart.index') }}">
                                <i class="fas fa-shopping-cart"></i>
                                <span class="badge bg-warning" id="cart-count">0</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->is('customer/orders*') ? 'active' : '' }}" 
                               href="{{ route('customer.orders.index') }}">Orders</a>
                        </li>
                    @elseif(Session::get('user_role') == 'employee')
                        <li class="nav-item">
                            <a class="nav-link {{ request()->is('employee/dashboard*') ? 'active' : '' }}" 
                               href="{{ route('employee.dashboard') }}">Dashboard</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->is('employee/orders*') ? 'active' : '' }}" 
                               href="{{ route('employee.orders.index') }}">Orders</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link {{ request()->is('employee/payments*') ? 'active' : '' }}" 
                               href="{{ route('employee.payments.index') }}">Payments</a>
                        </li>
                    @elseif(Session::get('user_role') == 'admin')
                        <li class="nav-item">
                            <a class="nav-link {{ request()->is('admin/dashboard*') ? 'active' : '' }}" 
                               href="{{ route('admin.dashboard') }}">Dashboard</a>
                        </li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                Management
                            </a>
                            <ul class="dropdown-menu">
                                <li>
                                    <a class="dropdown-item" href="{{ route('admin.users.index') }}">
                                        <i class="fas fa-users me-2"></i>Users
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="{{ route('admin.menu.index') }}">
                                        <i class="fas fa-utensils me-2"></i>Menu
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="{{ route('admin.promos.index') }}">
                                        <i class="fas fa-tag me-2"></i>Promos
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="{{ route('admin.careers.index') }}">
                                        <i class="fas fa-briefcase me-2"></i>Careers
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="{{ route('admin.reports.sales') }}">
                                        <i class="fas fa-chart-bar me-2"></i>Reports
                                    </a>
                                </li>
                            </ul>
                        </li>
                    @endif
                    
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-user-circle me-1"></i>
                            {{ Session::get('user.name', 'User') }}
                            <span class="badge bg-{{ match(Session::get('user_role')) {
                                'admin' => 'danger',
                                'employee' => 'warning',
                                'customer' => 'info',
                                default => 'secondary'
                            } }}">
                                {{ ucfirst(Session::get('user_role', 'User')) }}
                            </span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end">
                            @if(Session::get('user_role') == 'customer')
                                <li>
                                    <a class="dropdown-item" href="{{ route('customer.profile') }}">
                                        <i class="fas fa-user me-2"></i>Profile
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="{{ route('customer.careers.applications.index') }}">
                                        <i class="fas fa-file-alt me-2"></i>My Applications
                                    </a>
                                </li>
                            @elseif(Session::get('user_role') == 'employee')
                                <li>
                                    <a class="dropdown-item" href="{{ route('employee.profile') }}">
                                        <i class="fas fa-user me-2"></i>Profile
                                    </a>
                                </li>
                            @elseif(Session::get('user_role') == 'admin')
                                <li>
                                    <a class="dropdown-item" href="{{ route('admin.profile') }}">
                                        <i class="fas fa-user me-2"></i>Profile
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item" href="{{ route('admin.settings.index') }}">
                                        <i class="fas fa-cog me-2"></i>Settings
                                    </a>
                                </li>
                            @endif
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <form action="{{ route('logout') }}" method="POST" class="dropdown-item p-0">
                                    @csrf
                                    <button type="submit" class="btn btn-link text-decoration-none w-100 text-start">
                                        <i class="fas fa-sign-out-alt me-2"></i>Logout
                                    </button>
                                </form>
                            </li>
                        </ul>
                    </li>
                @else
                    <li class="nav-item">
                        <a class="btn btn-outline-primary px-3" href="{{ route('login') }}">
                            <i class="fas fa-sign-in-alt me-1"></i>Login
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="btn btn-primary text-white px-3 ms-2" href="{{ route('register') }}">
                            <i class="fas fa-user-plus me-1"></i>Register
                        </a>
                    </li>
                @endif
            </ul>
        </div>
    </div>
</nav>

<!-- Cart Update Script -->
@if(Session::has('api_token') && Session::get('user_role') == 'customer')
<script>
    $(document).ready(function() {
        function updateCartCount() {
            const token = '{{ Session::get("api_token") }}';
            if (!token) return;
            
            $.ajax({
                url: '{{ config("app.api_url") }}/customer/cart',
                method: 'GET',
                headers: {
                    'Authorization': 'Bearer ' + token,
                    'Accept': 'application/json'
                },
                success: function(response) {
                    if (response.success && response.data && response.data.items) {
                        const count = response.data.items.reduce((total, item) => total + item.quantity, 0);
                        $('#cart-count').text(count);
                    }
                },
                error: function() {
                    console.log('Error fetching cart count');
                }
            });
        }
        
        // Update cart count on page load
        updateCartCount();
        
        // Update cart count every 30 seconds
        setInterval(updateCartCount, 30000);
    });
</script>
@endif