{{-- resources/views/layouts/employee.blade.php --}}
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Employee Panel - Chingu Bite')</title>
    
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom CSS -->
    <style>
        :root {
            --primary-color: #4e73df;
            --primary-dark: #224abe;
            --secondary-color: #858796;
            --success-color: #1cc88a;
            --info-color: #36b9cc;
            --warning-color: #f6c23e;
            --danger-color: #e74a3b;
            --dark-color: #5a5c69;
            --light-color: #f8f9fc;
        }
        
        body {
            background-color: var(--light-color);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 0.9rem;
        }
        
        .employee-wrapper {
            display: flex;
            min-height: 100vh;
        }
        
        /* Sidebar */
        .employee-sidebar {
            min-width: 250px;
            max-width: 250px;
            background: linear-gradient(180deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            color: white;
            transition: all 0.3s;
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
            z-index: 1000;
        }
        
        .sidebar-header {
            padding: 1.5rem;
            background: rgba(0,0,0,0.1);
            font-size: 1.2rem;
            font-weight: 700;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .sidebar-nav .nav-link {
            color: rgba(255,255,255,0.8);
            padding: 0.75rem 1.5rem;
            border-left: 4px solid transparent;
            transition: all 0.3s;
            text-decoration: none;
            cursor: pointer;
        }
        
        .sidebar-nav .nav-link:hover,
        .sidebar-nav .nav-link.active {
            background: rgba(255,255,255,0.1);
            color: white;
            border-left-color: var(--warning-color);
        }
        
        .sidebar-nav .nav-link i {
            width: 20px;
            margin-right: 10px;
            text-align: center;
        }
        
        /* Main Content */
        .employee-main {
            flex: 1;
            display: flex;
            flex-direction: column;
            min-width: 0;
        }
        
        .employee-navbar {
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            z-index: 999;
            position: sticky;
            top: 0;
        }
        
        .employee-content {
            padding: 20px;
            overflow-x: auto;
            flex: 1;
        }
        
        /* Employee Cards */
        .employee-card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0,0,0,0.05);
            margin-bottom: 1.5rem;
            transition: transform 0.2s;
        }
        
        .employee-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        
        .employee-card-header {
            background: white;
            border-bottom: 1px solid #e3e6f0;
            font-weight: 600;
            padding: 1rem 1.25rem;
            border-radius: 10px 10px 0 0;
        }
        
        /* Status Badges */
        .status-badge {
            padding: 0.35em 0.65em;
            font-size: 0.75em;
            border-radius: 10rem;
            font-weight: 600;
        }
        
        .status-pending {
            background-color: #f8f9fa;
            color: #6c757d;
            border: 1px solid #dee2e6;
        }
        
        .status-processing {
            background-color: #cfe2ff;
            color: #084298;
            border: 1px solid #9ec5fe;
        }
        
        .status-preparing {
            background-color: #fff3cd;
            color: #664d03;
            border: 1px solid #ffecb5;
        }
        
        .status-ready {
            background-color: #d1e7dd;
            color: #0a3622;
            border: 1px solid #a3cfbb;
        }
        
        .status-completed {
            background-color: #d1e7dd;
            color: #0a3622;
            border: 1px solid #a3cfbb;
        }
        
        .status-cancelled {
            background-color: #f8d7da;
            color: #58151c;
            border: 1px solid #f1aeb5;
        }
        
        /* Payment Status */
        .payment-pending {
            background-color: #fff3cd;
            color: #664d03;
        }
        
        .payment-verified {
            background-color: #d1e7dd;
            color: #0a3622;
        }
        
        .payment-failed {
            background-color: #f8d7da;
            color: #58151c;
        }
        
        /* Quick Actions */
        .quick-action-btn {
            text-align: center;
            padding: 1.5rem 1rem;
            border-radius: 8px;
            transition: all 0.3s;
            background: #f8f9fc;
        }
        
        .quick-action-btn:hover {
            background: #e9ecef;
            transform: translateY(-3px);
        }
        
        .quick-action-btn i {
            font-size: 2rem;
            color: var(--primary-color);
            margin-bottom: 0.5rem;
        }
        
        /* Table */
        .employee-table {
            border-radius: 8px;
            overflow: hidden;
            margin-bottom: 0;
        }
        
        .employee-table thead th {
            background: #f8f9fc;
            border-bottom: 2px solid #e3e6f0;
            font-weight: 600;
            color: var(--dark-color);
            padding: 0.75rem 1rem;
            white-space: nowrap;
        }
        
        .employee-table tbody td {
            padding: 0.75rem 1rem;
            vertical-align: middle;
        }
        
        /* Print Styles */
        @media print {
            .employee-sidebar, .employee-navbar, .btn {
                display: none !important;
            }
            
            .employee-content {
                padding: 0;
                margin: 0;
            }
            
            .employee-card {
                box-shadow: none;
                border: 1px solid #dee2e6;
            }
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .employee-sidebar {
                margin-left: -250px;
                position: fixed;
                height: 100vh;
                overflow-y: auto;
            }
            
            .employee-sidebar.toggled {
                margin-left: 0;
            }
            
            .employee-content {
                padding: 15px;
            }
        }
    </style>
    
    @stack('styles')
</head>
<body>
    <div class="employee-wrapper">
        <!-- Sidebar -->
        <div class="employee-sidebar d-flex flex-column">
            <div class="sidebar-header d-flex align-items-center">
                <i class="fas fa-store fa-2x me-2"></i>
                <div>
                    <span>Chingu Bite<br><small class="fs-6 fw-normal">Employee Panel</small></span>
                </div>
            </div>
            
            <nav class="sidebar-nav flex-grow-1 mt-3">
                <!-- Dashboard -->
                <a href="{{ route('employee.dashboard') }}" 
                   class="nav-link {{ request()->routeIs('employee.dashboard') ? 'active' : '' }}">
                    <i class="fas fa-tachometer-alt"></i>
                    Dashboard
                </a>
                
                <!-- Orders Management -->
                <a href="{{ route('employee.orders.index') }}" 
                   class="nav-link {{ request()->routeIs('employee.orders.*') ? 'active' : '' }}">
                    <i class="fas fa-shopping-cart"></i>
                    Orders Management
                </a>
                
                <!-- Payments Management -->
                <a href="{{ route('employee.payments.index') }}" 
                   class="nav-link {{ request()->routeIs('employee.payments.*') ? 'active' : '' }}">
                    <i class="fas fa-money-check-alt"></i>
                    Payment Verification
                </a>
                
                <!-- Receipts -->
                <a href="{{ route('employee.receipts.index') }}" 
                   class="nav-link {{ request()->routeIs('employee.receipts.*') ? 'active' : '' }}">
                    <i class="fas fa-receipt"></i>
                    Print Receipts
                </a>
                
                <!-- Menu -->
                <a href="{{ route('employee.menu.index') }}" 
                   class="nav-link {{ request()->routeIs('employee.menu.*') ? 'active' : '' }}">
                    <i class="fas fa-utensils"></i>
                    Menu Items
                </a>
                
                <!-- Tables (for dine-in) -->
                <a href="{{ route('employee.tables.index') }}" 
                   class="nav-link {{ request()->routeIs('employee.tables.*') ? 'active' : '' }}">
                    <i class="fas fa-chair"></i>
                    Table Management
                </a>
            </nav>
            
            <!-- Sidebar Footer -->
            <div class="mt-auto p-3 border-top">
                <div class="d-flex align-items-center">
                    <div class="flex-grow-1">
                        <small class="text-light">{{ auth()->user()->name ?? 'Employee' }}</small>
                        <div class="small text-white-50">{{ auth()->user()->email ?? 'employee@chingubite.com' }}</div>
                        <div class="small text-white-50">
                            <i class="fas fa-user-tie me-1"></i> Employee
                        </div>
                    </div>
                    <div class="dropdown">
                        <button class="btn btn-sm btn-outline-light dropdown-toggle" 
                                type="button" data-bs-toggle="dropdown">
                            <i class="fas fa-cog"></i>
                        </button>
                        <div class="dropdown-menu dropdown-menu-end">
                            <a class="dropdown-item" href="{{ route('employee.profile') }}">
                                <i class="fas fa-user-cog me-2"></i>My Profile
                            </a>
                            <div class="dropdown-divider"></div>
                            <form method="POST" action="{{ route('logout') }}">
                                @csrf
                                <button type="submit" class="dropdown-item text-danger">
                                    <i class="fas fa-sign-out-alt me-2"></i>Logout
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Main Content -->
        <div class="employee-main">
            <!-- Navbar -->
            <nav class="employee-navbar navbar navbar-expand-lg">
                <div class="container-fluid">
                    <button class="btn btn-outline-secondary" id="sidebarToggle">
                        <i class="fas fa-bars"></i>
                    </button>
                    
                    <!-- Notifications -->
                    <div class="dropdown ms-auto me-3">
                        <button class="btn btn-outline-secondary position-relative" 
                                type="button" data-bs-toggle="dropdown">
                            <i class="fas fa-bell"></i>
                            @if($notificationCount ?? 0 > 0)
                                <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                                    {{ $notificationCount > 9 ? '9+' : $notificationCount }}
                                </span>
                            @endif
                        </button>
                        <div class="dropdown-menu dropdown-menu-end" style="min-width: 300px;">
                            <h6 class="dropdown-header">Notifications</h6>
                            <div id="employee-notifications">
                                <!-- Notifications will be loaded here -->
                            </div>
                        </div>
                    </div>
                    
                    <!-- Current Time -->
                    <div class="d-none d-md-flex align-items-center">
                        <span class="text-muted">
                            <i class="fas fa-clock me-1"></i>
                            <span id="current-time">{{ now()->format('H:i:s') }}</span>
                        </span>
                    </div>
                </div>
            </nav>
            
            <!-- Content -->
            <div class="employee-content fade-in">
                <!-- Flash Messages -->
                @if(session('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle me-2"></i> {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif
                
                @if(session('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i> {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif
                
                @if(session('warning'))
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-triangle me-2"></i> {{ session('warning') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif
                
                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                @endif
                
                <!-- Page Content -->
                @yield('content')
            </div>
        </div>
    </div>
    
    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    
    <!-- Custom Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Toggle sidebar
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.querySelector('.employee-sidebar');
            
            if (sidebarToggle && sidebar) {
                sidebarToggle.addEventListener('click', function() {
                    sidebar.classList.toggle('toggled');
                });
            }
            
            // Update time every second
            function updateTime() {
                const now = new Date();
                const timeString = now.toLocaleTimeString('en-US', { hour12: false });
                document.getElementById('current-time').textContent = timeString;
            }
            
            updateTime();
            setInterval(updateTime, 1000);
            
            // Auto-hide alerts after 5 seconds
            setTimeout(() => {
                document.querySelectorAll('.alert').forEach(alert => {
                    const bsAlert = new bootstrap.Alert(alert);
                    bsAlert.close();
                });
            }, 5000);
            
            // Load notifications
            loadEmployeeNotifications();
            
            function loadEmployeeNotifications() {
                // In a real app, this would be an API call
                const notifications = [
                    {
                        id: 1,
                        title: 'New Order Received',
                        message: 'Order #ORD-2024-001 is pending',
                        time: '2 minutes ago',
                        icon: 'fa-shopping-cart',
                        color: 'text-primary',
                        link: '/employee/orders/1'
                    },
                    {
                        id: 2,
                        title: 'Payment Pending',
                        message: 'Payment for Order #ORD-2024-002 needs verification',
                        time: '5 minutes ago',
                        icon: 'fa-money-check',
                        color: 'text-warning',
                        link: '/employee/payments/1'
                    }
                ];
                
                const container = document.getElementById('employee-notifications');
                if (container && notifications.length > 0) {
                    let html = '';
                    notifications.forEach(notification => {
                        html += `
                            <a class="dropdown-item" href="${notification.link}">
                                <div class="d-flex">
                                    <div class="flex-shrink-0">
                                        <i class="fas ${notification.icon} ${notification.color}"></i>
                                    </div>
                                    <div class="flex-grow-1 ms-3">
                                        <div class="small">${notification.title}</div>
                                        <small class="text-muted">${notification.time}</small>
                                    </div>
                                </div>
                            </a>
                        `;
                    });
                    
                    html += `
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item text-center" href="#">
                            View all notifications
                        </a>
                    `;
                    
                    container.innerHTML = html;
                }
            }
            
            // Confirm action helper
            window.confirmAction = function(formId, message = 'Are you sure?') {
                if (confirm(message)) {
                    document.getElementById(formId).submit();
                }
            };
        });
    </script>
    
    @stack('scripts')
</body>
</html>