<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Chingu Bite') - {{ config('app.name', 'Chingu Bite') }}</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Montserrat:wght@700;800;900&display=swap" rel="stylesheet">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('favicon.ico') }}">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="{{ asset('css/custom.css') }}">
    
    <style>
        :root {
            --primary-red: #e63946;
            --primary-orange: #f4a261;
            --accent-yellow: #ffd166;
            --dark-navy: #1d3557;
            --light-gray: #f8f9fa;
            --dark-gray: #343a40;
            --white: #ffffff;
            --gradient-red: linear-gradient(135deg, #e63946 0%, #f4a261 100%);
            --shadow-light: 0 5px 15px rgba(0, 0, 0, 0.1);
            --shadow-medium: 0 10px 25px rgba(0, 0, 0, 0.15);
            --shadow-dark: 0 15px 35px rgba(0, 0, 0, 0.2);
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            color: #333;
            background-color: var(--white);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            padding-top: 80px; /* Space for fixed navbar */
        }
        
        .main-content {
            flex: 1;
        }
        
        /* ===== NAVBAR STYLING ===== */
        .navbar {
            background: var(--white) !important;
            box-shadow: var(--shadow-light);
            padding: 0.8rem 0;
            transition: all 0.3s ease;
        }
        
        .navbar-brand {
            font-family: 'Montserrat', sans-serif;
            font-weight: 900;
            font-size: 1.8rem;
            color: var(--primary-red) !important;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .navbar-brand i {
            color: var(--primary-orange);
            font-size: 2rem;
        }
        
        .navbar-nav .nav-link {
            font-weight: 600;
            color: var(--dark-navy) !important;
            padding: 0.5rem 1.2rem;
            margin: 0 0.2rem;
            border-radius: 5px;
            transition: all 0.3s ease;
            position: relative;
        }
        
        .navbar-nav .nav-link:hover {
            color: var(--primary-red) !important;
            background-color: rgba(230, 57, 70, 0.1);
        }
        
        .navbar-nav .nav-link.active {
            color: var(--primary-red) !important;
            background-color: rgba(230, 57, 70, 0.1);
        }
        
        .navbar-nav .nav-link::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            width: 0;
            height: 3px;
            background: var(--gradient-red);
            transition: all 0.3s ease;
            transform: translateX(-50%);
            border-radius: 2px;
        }
        
        .navbar-nav .nav-link:hover::after {
            width: 70%;
        }
        
        /* Cart Icon Styling */
        .nav-link.position-relative {
            padding-right: 2rem !important;
        }
        
        #cart-count {
            background: var(--gradient-red);
            color: white;
            font-size: 0.7rem;
            font-weight: bold;
            min-width: 20px;
            height: 20px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            position: absolute;
            top: -5px;
            right: 5px;
            border: 2px solid var(--white);
        }
        
        /* ===== DROPDOWN STYLING ===== */
        .dropdown-menu {
            border: none;
            border-radius: 10px;
            box-shadow: var(--shadow-medium);
            padding: 0.5rem 0;
            margin-top: 0.5rem;
            animation: dropdownSlide 0.3s ease;
            border-left: 4px solid var(--primary-red);
        }
        
        @keyframes dropdownSlide {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .dropdown-item {
            padding: 0.7rem 1.5rem;
            font-weight: 500;
            color: var(--dark-navy);
            transition: all 0.2s ease;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .dropdown-item i {
            color: var(--primary-red);
            width: 20px;
        }
        
        .dropdown-item:hover {
            background: var(--gradient-red);
            color: white;
            transform: translateX(5px);
        }
        
        .dropdown-item:hover i {
            color: white;
        }
        
        .dropdown-divider {
            margin: 0.5rem 0;
            border-color: rgba(0, 0, 0, 0.1);
        }
        
        /* User Badge Styling */
        .badge {
            padding: 0.35em 0.65em;
            font-size: 0.75em;
            font-weight: 600;
        }
        
        .bg-danger { background: var(--primary-red) !important; }
        .bg-warning { background: var(--accent-yellow) !important; color: #333 !important; }
        .bg-success { background: #2a9d8f !important; }
        
        /* ===== BUTTON STYLING ===== */
        .btn-primary {
            background: var(--gradient-red);
            border: none;
            padding: 10px 25px;
            font-weight: 600;
            border-radius: 8px;
            transition: all 0.3s ease;
            box-shadow: var(--shadow-light);
        }
        
        .btn-primary:hover {
            transform: translateY(-3px);
            box-shadow: var(--shadow-medium);
        }
        
        .btn-outline-primary {
            color: var(--primary-red);
            border-color: var(--primary-red);
        }
        
        .btn-outline-primary:hover {
            background: var(--gradient-red);
            border-color: transparent;
        }
        
        /* ===== ALERT STYLING ===== */
        .alert {
            border: none;
            border-radius: 10px;
            box-shadow: var(--shadow-light);
            padding: 1rem 1.5rem;
        }
        
        .alert-success {
            background: linear-gradient(135deg, #2a9d8f 0%, #a8dadc 100%);
            color: white;
        }
        
        .alert-danger {
            background: var(--gradient-red);
            color: white;
        }
        
        .alert-warning {
            background: linear-gradient(135deg, var(--accent-yellow) 0%, #ff9e6d 100%);
            color: #333;
        }
        
        .btn-close {
            filter: brightness(0) invert(1);
            opacity: 0.8;
        }
        
        /* ===== FOOTER STYLING ===== */
        .footer {
            background: var(--dark-navy);
            color: white;
            margin-top: auto;
            padding: 3rem 0 1.5rem;
            position: relative;
            overflow: hidden;
        }
        
        .footer::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: var(--gradient-red);
        }
        
        .footer h5 {
            color: var(--accent-yellow);
            font-weight: 700;
            margin-bottom: 1.5rem;
            position: relative;
            padding-bottom: 10px;
        }
        
        .footer h5::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 40px;
            height: 3px;
            background: var(--primary-red);
        }
        
        .footer ul li {
            margin-bottom: 0.8rem;
        }
        
        .footer ul li i {
            color: var(--primary-orange);
            margin-right: 10px;
            width: 20px;
        }
        
        .footer a {
            color: #ddd;
            text-decoration: none;
            transition: all 0.3s ease;
        }
        
        .footer a:hover {
            color: var(--primary-orange);
            padding-left: 5px;
        }
        
        .footer .text-center p {
            color: #aaa;
            font-size: 0.9rem;
        }
        
        .footer .text-center .text-danger {
            color: var(--primary-red) !important;
        }
        
        /* ===== RESPONSIVE STYLING ===== */
        @media (max-width: 991.98px) {
            .navbar-nav {
                padding: 1rem 0;
            }
            
            .navbar-nav .nav-link {
                padding: 0.7rem 1rem;
                margin: 0.2rem 0;
            }
            
            .dropdown-menu {
                background-color: rgba(255, 255, 255, 0.95);
                box-shadow: none;
                border: none;
                margin-top: 0;
                animation: none;
            }
            
            .dropdown-item {
                padding: 0.7rem 1rem;
            }
            
            body {
                padding-top: 70px;
            }
        }
        
        @media (max-width: 768px) {
            .navbar-brand {
                font-size: 1.5rem;
            }
            
            .navbar-brand i {
                font-size: 1.7rem;
            }
        }
        
        /* ===== ANIMATIONS ===== */
        .fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* ===== SPECIAL EFFECTS ===== */
        .nav-link .badge {
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.1); }
            100% { transform: scale(1); }
        }
    </style>
    
    @stack('styles')
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-light fixed-top">
        <div class="container">
            <a class="navbar-brand" href="{{ url('/') }}">
                <i class="fas fa-utensils"></i> Chingu Bite
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarContent" 
                    aria-controls="navbarContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarContent">
                <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                    <li class="nav-item">
                        <a class="nav-link {{ request()->is('/') ? 'active' : '' }}" href="{{ url('/') }}">
                            <i class="fas fa-home"></i> Home
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ request()->is('menu*') ? 'active' : '' }}" href="{{ route('customer.menu.index') }}">
                            <i class="fas fa-utensils"></i> Menu
                        </a>
                    </li>
                    @auth
                        @if(Auth::user()->role == 'customer')
                            <li class="nav-item">
                                <a class="nav-link {{ request()->is('customer/orders*') ? 'active' : '' }}" href="{{ route('customer.orders.index') }}">
                                    <i class="fas fa-history"></i> Pesanan Saya
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link position-relative {{ request()->is('customer/cart*') ? 'active' : '' }}" href="{{ route('customer.cart.index') }}">
                                    <i class="fas fa-shopping-cart"></i> Keranjang
                                    @php
                                        $cartCount = Auth::check() && Auth::user()->role == 'customer' 
                                            ? \App\Models\Cart::where('user_id', Auth::id())->count() 
                                            : 0;
                                    @endphp
                                    <span id="cart-count" class="badge">{{ $cartCount }}</span>
                                </a>
                            </li>
                        @endif
                    @endauth
                </ul>
                
                <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                    @guest
                        <li class="nav-item">
                            <a class="nav-link btn btn-primary text-white px-4" href="{{ route('login') }}" id="login-link">
                                <i class="fas fa-sign-in-alt"></i> Login
                            </a>
                        </li>
                        <li class="nav-item ms-2">
                            <a class="nav-link btn btn-outline-primary px-4" href="{{ route('register') }}" id="register-link">
                                <i class="fas fa-user-plus"></i> Register
                            </a>
                        </li>
                    @else
                        <!-- User Dropdown Menu -->
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" id="userDropdown" 
                               role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fas fa-user-circle fa-lg me-2" style="color: var(--primary-red);"></i>
                                <div class="d-flex flex-column">
                                    <span class="fw-bold">{{ Auth::user()->name }}</span>
                                    <small>
                                        @if(Auth::user()->role == 'admin')
                                            <span class="badge bg-danger">Admin</span>
                                        @elseif(Auth::user()->role == 'employee')
                                            <span class="badge bg-warning text-dark">Employee</span>
                                        @else
                                            <span class="badge bg-success">Customer</span>
                                        @endif
                                    </small>
                                </div>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                                <li>
                                    <a class="dropdown-item" href="{{ route('customer.profile.index') }}">
                                        <i class="fas fa-user"></i> Profile
                                    </a>
                                </li>
                                @if(Auth::user()->role == 'customer')
                                    <li>
                                        <a class="dropdown-item" href="{{ route('customer.orders.index') }}">
                                            <i class="fas fa-history"></i> Pesanan Saya
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="{{ route('customer.cart.index') }}">
                                            <i class="fas fa-shopping-cart"></i> Keranjang
                                            @php
                                                $cartCount = Auth::check() && Auth::user()->role == 'customer' 
                                                    ? \App\Models\Cart::where('user_id', Auth::id())->count() 
                                                    : 0;
                                            @endphp
                                            <span id="dropdown-cart-count" class="badge bg-danger float-end">{{ $cartCount }}</span>
                                        </a>
                                    </li>
                                @endif
                                <li><hr class="dropdown-divider"></li>
                                @if(Auth::user()->role == 'admin')
                                    <li>
                                        <a class="dropdown-item" href="{{ route('admin.dashboard') }}">
                                            <i class="fas fa-tachometer-alt"></i> Admin Dashboard
                                        </a>
                                    </li>
                                @elseif(Auth::user()->role == 'employee')
                                    <li>
                                        <a class="dropdown-item" href="{{ route('employee.dashboard') }}">
                                            <i class="fas fa-tachometer-alt"></i> Employee Dashboard
                                        </a>
                                    </li>
                                @endif

                                <!-- Tambah di dropdown menu user -->
@php
    // Debug dan fallback untuk rating route
    $ratingsUrl = null;
    
    // Coba beberapa kemungkinan route name
    $possibleRoutes = [
        'customer.ratings',
        'customer.orders.rating.history', 
        'customer.rating.history'
    ];
    
    foreach ($possibleRoutes as $routeName) {
        try {
            if (Route::has($routeName)) {
                $ratingsUrl = route($routeName);
                break;
            }
        } catch (Exception $e) {
            continue;
        }
    }
    
    // Jika tidak ada route yang valid, gunakan URL langsung
    if (!$ratingsUrl) {
        $ratingsUrl = '/customer/rating-history';
    }
@endphp

<li>
    <a class="dropdown-item" href="{{ $ratingsUrl }}">
        <i class="fas fa-star me-2"></i> My Ratings
    </a>
</li>
                                <li>
                                    <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                                        @csrf
                                    </form>
                                    <a class="dropdown-item text-danger" href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                        <i class="fas fa-sign-out-alt"></i> Logout
                                    </a>
                                </li>
                            </ul>
                        </li>
                    @endguest
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="main-content fade-in">
        <div class="container-fluid px-0">
            <!-- Notifications -->
            @if(session('success'))
                <div class="container mt-4">
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <i class="fas fa-check-circle"></i> {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                </div>
            @endif
            
            @if(session('error'))
                <div class="container mt-4">
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle"></i> {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                </div>
            @endif
            
            @if(session('warning'))
                <div class="container mt-4">
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-triangle"></i> {{ session('warning') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                </div>
            @endif
            
            @if($errors->any())
                <div class="container mt-4">
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle"></i> 
                        <ul class="mb-0">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                </div>
            @endif
            
            <!-- Page Content -->
            @yield('content')
        </div>
    </main>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="row">
                <div class="col-md-4 mb-4 mb-md-0">
                    <h5><i class="fas fa-utensils me-2"></i>Chingu Bite</h5>
                    <p class="mt-3">Restoran Korea autentik dengan cita rasa terbaik dari negeri ginseng. Kami menggunakan bahan-bahan segar dan resep tradisional untuk memberikan pengalaman kuliner yang tak terlupakan.</p>
                    <div class="social-icons mt-4">
                        <a href="#" class="text-white me-3"><i class="fab fa-instagram fa-lg"></i></a>
                        <a href="#" class="text-white me-3"><i class="fab fa-facebook fa-lg"></i></a>
                        <a href="#" class="text-white me-3"><i class="fab fa-twitter fa-lg"></i></a>
                        <a href="#" class="text-white"><i class="fab fa-whatsapp fa-lg"></i></a>
                    </div>
                </div>
                <div class="col-md-4 mb-4 mb-md-0">
                    <h5><i class="fas fa-phone-alt me-2"></i>Kontak Kami</h5>
                    <ul class="list-unstyled mt-3">
                        <li class="mb-3"><i class="fas fa-phone me-2"></i> +62 812 3456 7890</li>
                        <li class="mb-3"><i class="fas fa-envelope me-2"></i> info@chingubite.com</li>
                        <li class="mb-3"><i class="fas fa-map-marker-alt me-2"></i> Seoul Street No. 88, Jakarta</li>
                        <li><i class="fas fa-clock me-2"></i> Buka setiap hari 10:00 - 22:00</li>
                    </ul>
                </div>
                <div class="col-md-4">
                    <h5><i class="fas fa-link me-2"></i>Tautan Cepat</h5>
                    <ul class="list-unstyled mt-3">
                        <li class="mb-2"><a href="{{ url('/') }}" class="text-decoration-none">Home</a></li>
                        <li class="mb-2"><a href="{{ route('customer.menu.index') }}" class="text-decoration-none">Menu</a></li>
                        <li class="mb-2"><a href="#" class="text-decoration-none">Promo & Paket</a></li>
                        <li class="mb-2"><a href="#" class="text-decoration-none">Tentang Kami</a></li>
                        <li class="mb-2"><a href="{{ route('login') }}" class="text-decoration-none">Login</a></li>
                        <li><a href="{{ route('register') }}" class="text-decoration-none">Register</a></li>
                    </ul>
                </div>
            </div>
            <hr class="bg-light my-4">
            <div class="text-center pt-3">
                <p class="mb-2">&copy; {{ date('Y') }} Chingu Bite. All rights reserved.</p>
                <p class="mb-0">
                    <i class="fas fa-heart text-danger"></i> 
                    <span class="fw-bold">Annyeonghaseyo!</span> Selamat menikmati hidangan Korea terbaik di kota
                </p>
            </div>
        </div>
    </footer>

    <!-- SCRIPTS SECTION -->
    <!-- jQuery FIRST -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Bootstrap Bundle with Popper SECOND -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JavaScript -->
    <script>
        // Initialize when document is ready
        $(document).ready(function() {
            console.log('🚀 Chingu Bite - Initializing...');
            
            // 1. Initialize all dropdowns
            function initializeDropdowns() {
                const dropdowns = document.querySelectorAll('.dropdown-toggle');
                
                dropdowns.forEach(function(dropdown) {
                    try {
                        if (!bootstrap.Dropdown.getInstance(dropdown)) {
                            new bootstrap.Dropdown(dropdown, {
                                offset: [0, 10],
                                autoClose: true
                            });
                        }
                    } catch (error) {
                        console.error('Dropdown error:', error);
                    }
                });
            }
            
            // Call initialization
            initializeDropdowns();
            
            // 2. Auto-dismiss alerts after 5 seconds
            setTimeout(function() {
                $('.alert').alert('close');
            }, 5000);
            
            // 3. Cart functionality for customers
            @auth
                @if(Auth::user()->role == 'customer')
                    function updateCartCount() {
                        const token = '{{ session("api_token") }}';
                        if (!token) return;
                        
                        $.ajax({
                            url: '{{ config("app.api_url") }}/customer/cart',
                            method: 'GET',
                            headers: {
                                'Authorization': 'Bearer ' + token,
                                'Accept': 'application/json'
                            },
                            success: function(response) {
                                if (response.success && response.data && response.data.items) {
                                    // Count number of different products, not total quantity
                                    const count = response.data.items.length;
                                    $('#cart-count').text(count).toggle(count > 0);
                                    $('#dropdown-cart-count').text(count).toggle(count > 0);
                                }
                            }
                        });
                    }
                    
                    // Initial cart update
                    updateCartCount();
                    
                    // Update cart every 30 seconds
                    setInterval(updateCartCount, 30000);
                @else
                    // Hide cart for non-customers
                    $('#cart-count').closest('.nav-item').hide();
                @endif
            @endauth
            
            // 4. Navbar scroll effect
            $(window).scroll(function() {
                if ($(window).scrollTop() > 50) {
                    $('.navbar').css({
                        'padding': '0.5rem 0',
                        'box-shadow': '0 5px 20px rgba(0, 0, 0, 0.1)'
                    });
                } else {
                    $('.navbar').css({
                        'padding': '0.8rem 0',
                        'box-shadow': '0 5px 15px rgba(0, 0, 0, 0.1)'
                    });
                }
            });
            
            // 5. Add active class to current page link
            $('.nav-link').each(function() {
                if (this.href === window.location.href) {
                    $(this).addClass('active');
                }
            });
            
            // 6. Reinitialize dropdowns on AJAX content load
            $(document).ajaxComplete(function() {
                setTimeout(initializeDropdowns, 100);
            });
            
            // 7. Add animation to page load
            $('.fade-in').css('opacity', 0).animate({ opacity: 1 }, 500);
            
            console.log('✅ Chingu Bite ready!');
        });
        
        // Global click handler for dropdowns (fallback)
        document.addEventListener('click', function(e) {
            if (e.target.matches('.dropdown-toggle')) {
                const dropdown = bootstrap.Dropdown.getInstance(e.target);
                if (dropdown) {
                    dropdown.toggle();
                }
            }
        });
    </script>
    
    @stack('scripts')
</body>
</html>