@extends('layouts.app')

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chingu Bite - Authentic Korean Cuisine</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <style>
        /* Custom Styles */
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .hero-section {
            background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), 
                        url('https://images.unsplash.com/photo-1556909114-f6e7ad7d3136?ixlib=rb-1.2.1&auto=format&fit=crop&w=1950&q=80');
            background-size: cover;
            background-position: center;
            color: white;
            padding: 100px 0;
        }
        
        .menu-card {
            transition: transform 0.3s, box-shadow 0.3s;
            border: none;
            overflow: hidden;
        }
        
        .menu-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
        }
        
        .menu-card img {
            height: 200px;
            object-fit: cover;
        }
        
        .feature-icon {
            width: 60px;
            height: 60px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
        }
        
        .feature-icon i {
            font-size: 24px;
            color: white;
        }
        
        .footer {
            background: #1a202c;
            color: white;
        }
        
        .navbar-brand {
            font-weight: bold;
            font-size: 1.5rem;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            padding: 10px 30px;
            border-radius: 30px;
            font-weight: 600;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
        }
    </style>
</head>
<body>
    <!-- Hero Section -->
    <section class="hero-section text-center">
        <div class="container">
            <h1 class="display-4 mb-4">Authentic Korean Cuisine</h1>
            <p class="lead mb-4">Experience the taste of Korea with our traditional recipes and modern twist</p>
            <div class="d-flex justify-content-center gap-3">
                <a href="{{ route('menu.public') }}" class="btn btn-primary btn-lg">
                    <i class="fas fa-utensils me-2"></i>View Our Menu
                </a>
                <a href="#order-now" class="btn btn-outline-light btn-lg">
                    <i class="fas fa-shopping-cart me-2"></i>Order Now
                </a>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section class="py-5">
        <div class="container">
            <div class="row text-center mb-5">
                <div class="col-md-12">
                    <h2 class="mb-3">Why Choose Chingu Bite?</h2>
                    <p class="text-muted">We bring the authentic taste of Korea to your table</p>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-4 mb-4">
                    <div class="feature-icon">
                        <i class="fas fa-leaf"></i>
                    </div>
                    <h4>Fresh Ingredients</h4>
                    <p class="text-muted">We use only the freshest ingredients sourced daily for authentic taste.</p>
                </div>
                
                <div class="col-md-4 mb-4">
                    <div class="feature-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <h4>Fast Service</h4>
                    <p class="text-muted">Your food prepared quickly without compromising on quality.</p>
                </div>
                
                <div class="col-md-4 mb-4">
                    <div class="feature-icon">
                        <i class="fas fa-truck"></i>
                    </div>
                    <h4>Fast Delivery</h4>
                    <p class="text-muted">Hot and fresh food delivered to your doorstep in minutes.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Menu Preview -->
    <section class="py-5 bg-light" id="order-now">
        <div class="container">
            <div class="row mb-5">
                <div class="col-md-12 text-center">
                    <h2>Popular Dishes</h2>
                    <p class="text-muted">Try our customer favorites</p>
                </div>
            </div>
            
            <div class="row">
                <!-- Menu items will be loaded via API -->
                <div class="col-md-12 text-center" id="menu-preview">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                    <p class="mt-2">Loading menu...</p>
                </div>
            </div>
            
            <div class="row mt-4">
                <div class="col-md-12 text-center">
                    <a href="{{ route('menu.public') }}" class="btn btn-primary btn-lg">
                        <i class="fas fa-arrow-right me-2"></i>View Full Menu
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact/Info -->
    <section class="py-5">
        <div class="container">
            <div class="row">
                <div class="col-md-4 mb-4">
                    <h4><i class="fas fa-clock me-2"></i>Opening Hours</h4>
                    <p class="mb-1">Monday - Friday: 10:00 AM - 10:00 PM</p>
                    <p class="mb-1">Saturday - Sunday: 9:00 AM - 11:00 PM</p>
                </div>
                
                <div class="col-md-4 mb-4">
                    <h4><i class="fas fa-map-marker-alt me-2"></i>Location</h4>
                    <p>123 Korean Street<br>Food District, Jakarta 12345</p>
                </div>
                
                <div class="col-md-4 mb-4">
                    <h4><i class="fas fa-phone me-2"></i>Contact Us</h4>
                    <p class="mb-1">Phone: (021) 1234-5678</p>
                    <p class="mb-1">Email: info@chingubite.com</p>
                </div>
            </div>
        </div>
    </section>



    <!-- Bootstrap JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <script>
        $(document).ready(function() {
            // Load popular menu items
            function loadPopularMenu() {
                $.ajax({
                    url: '{{ config("app.api_url") }}/customer/menu?limit=3',
                    method: 'GET',
                    success: function(response) {
                        if (response.success && response.data && response.data.data) {
                            const menus = response.data.data.slice(0, 3);
                            let html = '';
                            
                            menus.forEach(menu => {
                                html += `
                                    <div class="col-md-4 mb-4">
                                        <div class="card menu-card h-100">
                                            <img src="${menu.image_url || '/images/default-food.jpg'}" 
                                                 class="card-img-top" alt="${menu.name}">
                                            <div class="card-body">
                                                <h5 class="card-title">${menu.name}</h5>
                                                <p class="card-text text-muted">${menu.description ? menu.description.substring(0, 100) + '...' : ''}</p>
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <span class="h5 mb-0 text-primary">Rp ${menu.price.toLocaleString('id-ID')}</span>
                                                    ${menu.is_available ? 
                                                        `<button class="btn btn-sm btn-outline-primary add-to-cart" data-id="${menu.id}">
                                                            <i class="fas fa-cart-plus me-1"></i>Add to Cart
                                                        </button>` : 
                                                        `<span class="badge bg-danger">Out of Stock</span>`
                                                    }
                                                </div>
                                            </div>
                                        </div>
                                    </div>`;
                            });
                            
                            $('#menu-preview').html(`
                                <div class="row">
                                    ${html}
                                </div>
                            `);
                        } else {
                            $('#menu-preview').html(`
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle me-2"></i>
                                    Menu items will be displayed here. Please try again later.
                                </div>
                            `);
                        }
                    },
                    error: function() {
                        $('#menu-preview').html(`
                            <div class="alert alert-warning">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                Unable to load menu at this time.
                            </div>
                        `);
                    }
                });
            }
            
            // Add to cart functionality
            $(document).on('click', '.add-to-cart', function() {
                const menuId = $(this).data('id');
                const token = '{{ Session::get("api_token") }}';
                
                if (!token) {
                    window.location.href = '{{ route("login") }}';
                    return;
                }
                
                $.ajax({
                    url: '{{ config("app.api_url") }}/customer/cart',
                    method: 'POST',
                    headers: {
                        'Authorization': 'Bearer ' + token,
                        'Content-Type': 'application/json',
                        'Accept': 'application/json'
                    },
                    data: JSON.stringify({
                        menu_id: menuId,
                        quantity: 1
                    }),
                    success: function(response) {
                        if (response.success) {
                            alert('Item added to cart!');
                            updateCartCount();
                        } else {
                            alert(response.message || 'Failed to add to cart');
                        }
                    },
                    error: function() {
                        alert('Error adding to cart. Please try again.');
                    }
                });
            });
            
            // Update cart count
            function updateCartCount() {
                const token = '{{ Session::get("api_token") }}';
                if (!token) return;
                
                $.ajax({
                    url: '{{ config("app.api_url") }}/customer/cart',
                    method: 'GET',
                    headers: {
                        'Authorization': 'Bearer ' + token,
                        'Accept': 'application/json'
                    },
                    success: function(response) {
                        if (response.success && response.data && response.data.items) {
                            const count = response.data.items.reduce((total, item) => total + item.quantity, 0);
                            $('#cart-count').text(count);
                        }
                    }
                });
            }
            
            // Initial load
            loadPopularMenu();
            updateCartCount();
        });
    </script>
</body>
</html>