{{-- resources/views/errors/api.blade.php --}}
@extends('layouts.app')

@section('title', 'API Error')

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow">
                <div class="card-header bg-danger text-white">
                    <h4 class="mb-0">API Connection Error</h4>
                </div>
                <div class="card-body text-center py-5">
                    <div class="mb-4">
                        <i class="fas fa-exclamation-triangle fa-4x text-danger mb-3"></i>
                        <h3>Unable to connect to server</h3>
                    </div>
                    
                    <div class="alert alert-info text-start mb-4">
                        <p><strong>Status Code:</strong> {{ $status ?? 'Unknown' }}</p>
                        <p><strong>Error Message:</strong> {{ $error ?? 'API connection failed' }}</p>
                        
                        @if(isset($errors) && count($errors) > 0)
                            <div class="mt-3">
                                <h6>Details:</h6>
                                <ul class="mb-0">
                                    @foreach($errors as $errorMsg)
                                        <li>{{ $errorMsg }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                    </div>
                    
                    <div class="d-grid gap-2 d-md-flex justify-content-center">
                        <a href="{{ url()->previous() }}" class="btn btn-primary">
                            <i class="fas fa-arrow-left me-2"></i>Go Back
                        </a>
                        <a href="{{ route('home') }}" class="btn btn-outline-secondary">
                            <i class="fas fa-home me-2"></i>Home Page
                        </a>
                        <a href="javascript:location.reload()" class="btn btn-outline-info">
                            <i class="fas fa-redo me-2"></i>Try Again
                        </a>
                    </div>
                    
                    <div class="mt-4 text-muted small">
                        <p>If this error persists, please contact the system administrator.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection