{{-- resources/views/employee/payments/show.blade.php --}}
@extends('layouts.employee')

@section('title', 'Payment Details - Chingu Bite')

@section('content')
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">Payment Details</h1>
        <div>
            <a href="{{ route('employee.payments.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-1"></i>Back to List
            </a>
        </div>
    </div>

    <div class="row">
        <!-- Left Column: Payment Details -->
        <div class="col-lg-8 mb-4">
            <!-- Payment Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex justify-content-between align-items-center">
                    <h6 class="m-0 font-weight-bold text-primary">
                        Payment #{{ $payment['id'] }}
                        <span class="badge bg-{{ match($payment['status']) {
                            'pending' => 'warning',
                            'waiting_confirmation' => 'info',
                            'confirmed' => 'success',
                            'failed' => 'danger',
                            'refunded' => 'secondary',
                            default => 'light'
                        } }} ms-2">
                            {{ ucfirst(str_replace('_', ' ', $payment['status'])) }}
                        </span>
                    </h6>
                    <div class="dropdown">
                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" 
                                type="button" data-bs-toggle="dropdown">
                            <i class="fas fa-cog"></i> Actions
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            @if($payment['status'] == 'waiting_confirmation')
                                <li>
                                    <button class="dropdown-item" data-bs-toggle="modal" 
                                            data-bs-target="#confirmModal">
                                        <i class="fas fa-check text-success me-2"></i>Confirm Payment
                                    </button>
                                </li>
                                <li>
                                    <button class="dropdown-item" data-bs-toggle="modal" 
                                            data-bs-target="#rejectModal">
                                        <i class="fas fa-times text-danger me-2"></i>Reject Payment
                                    </button>
                                </li>
                            @endif
                            <li>
                                <a class="dropdown-item" href="{{ route('employee.orders.show', $payment['order_id']) }}">
                                    <i class="fas fa-shopping-cart me-2"></i>View Order
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="{{ route('employee.receipts.show', $payment['order_id']) }}">
                                    <i class="fas fa-receipt me-2"></i>View Receipt
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="40%">Order Number:</th>
                                    <td>
                                        <a href="{{ route('employee.orders.show', $payment['order_id']) }}">
                                            #{{ $payment['order']['order_number'] ?? 'N/A' }}
                                        </a>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Customer:</th>
                                    <td>{{ $payment['order']['customer']['name'] ?? 'Guest' }}</td>
                                </tr>
                                <tr>
                                    <th>Phone:</th>
                                    <td>{{ $payment['order']['customer']['phone'] ?? 'N/A' }}</td>
                                </tr>
                                <tr>
                                    <th>Email:</th>
                                    <td>{{ $payment['order']['customer']['email'] ?? 'N/A' }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <th width="40%">Payment Method:</th>
                                    <td>
                                        <span class="badge bg-secondary">
                                            {{ $payment['payment_method']['name'] ?? 'Unknown' }}
                                        </span>
                                    </td>
                                </tr>
                                <tr>
                                    <th>Amount:</th>
                                    <td class="h5 text-success">
                                        Rp {{ number_format($payment['amount'], 0, ',', '.') }}
                                    </td>
                                </tr>
                                <tr>
                                    <th>Submitted:</th>
                                    <td>{{ \Carbon\Carbon::parse($payment['created_at'])->format('d M Y, H:i') }}</td>
                                </tr>
                                @if($payment['confirmed_at'])
                                <tr>
                                    <th>Confirmed:</th>
                                    <td>{{ \Carbon\Carbon::parse($payment['confirmed_at'])->format('d M Y, H:i') }}</td>
                                </tr>
                                @endif
                            </table>
                        </div>
                    </div>

                    @if($payment['notes'])
                    <div class="alert alert-info mt-3">
                        <strong><i class="fas fa-sticky-note me-1"></i>Notes:</strong><br>
                        {{ $payment['notes'] }}
                    </div>
                    @endif

                    @if($payment['reference_number'])
                    <div class="alert alert-light mt-3">
                        <strong><i class="fas fa-hashtag me-1"></i>Reference Number:</strong>
                        {{ $payment['reference_number'] }}
                    </div>
                    @endif
                </div>
            </div>

            <!-- Order Summary -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Order Summary</h6>
                </div>
                <div class="card-body">
                    @if(isset($payment['order']['items']))
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Item</th>
                                        <th>Qty</th>
                                        <th>Price</th>
                                        <th>Subtotal</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($payment['order']['items'] as $item)
                                        <tr>
                                            <td>{{ $item['menu']['name'] ?? 'Menu Item' }}</td>
                                            <td>{{ $item['quantity'] }}</td>
                                            <td>Rp {{ number_format($item['unit_price'], 0, ',', '.') }}</td>
                                            <td>Rp {{ number_format($item['subtotal'], 0, ',', '.') }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="3" class="text-end">Subtotal:</th>
                                        <th>Rp {{ number_format($payment['order']['total_amount'] ?? 0, 0, ',', '.') }}</th>
                                    </tr>
                                    @if(($payment['order']['tax_amount'] ?? 0) > 0)
                                    <tr>
                                        <th colspan="3" class="text-end">Tax:</th>
                                        <th>Rp {{ number_format($payment['order']['tax_amount'] ?? 0, 0, ',', '.') }}</th>
                                    </tr>
                                    @endif
                                    @if(($payment['order']['discount_amount'] ?? 0) > 0)
                                    <tr>
                                        <th colspan="3" class="text-end">Discount:</th>
                                        <th class="text-success">-Rp {{ number_format($payment['order']['discount_amount'] ?? 0, 0, ',', '.') }}</th>
                                    </tr>
                                    @endif
                                    <tr>
                                        <th colspan="3" class="text-end">Final Amount:</th>
                                        <th class="h5 text-success">Rp {{ number_format($payment['order']['final_amount'] ?? 0, 0, ',', '.') }}</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    @else
                        <p class="text-muted">Order details not available</p>
                    @endif
                </div>
            </div>
        </div>

        <!-- Right Column: Payment Proof & Actions -->
        <div class="col-lg-4">
            <!-- Payment Proof Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Payment Proof</h6>
                </div>
                <div class="card-body text-center">
                    @if($payment['proof_image'])
                        <div class="mb-3">
                            <img src="{{ asset('storage/' . $payment['proof_image']) }}" 
                                 alt="Payment Proof" 
                                 class="img-fluid rounded border" 
                                 style="max-height: 300px;">
                        </div>
                        <a href="{{ asset('storage/' . $payment['proof_image']) }}" 
                           target="_blank" 
                           class="btn btn-outline-primary">
                            <i class="fas fa-expand me-1"></i>View Full Size
                        </a>
                        <a href="{{ asset('storage/' . $payment['proof_image']) }}" 
                           download 
                           class="btn btn-outline-success">
                            <i class="fas fa-download me-1"></i>Download
                        </a>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-image fa-3x text-muted mb-3"></i>
                            <p class="text-muted">No payment proof uploaded</p>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Payment Status Card -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Payment Status</h6>
                </div>
                <div class="card-body">
                    @if($payment['status'] == 'waiting_confirmation')
                        <div class="alert alert-warning">
                            <i class="fas fa-clock me-2"></i>
                            <strong>Waiting for Confirmation</strong>
                            <p class="mb-0 mt-2">Please verify the payment proof and confirm or reject.</p>
                        </div>
                    @elseif($payment['status'] == 'confirmed')
                        <div class="alert alert-success">
                            <i class="fas fa-check-circle me-2"></i>
                            <strong>Payment Confirmed</strong>
                            @if($payment['confirmed_by'])
                                <p class="mb-0 mt-2">
                                    Confirmed by: {{ $payment['confirmed_by_user']['name'] ?? 'Staff' }}<br>
                                    Date: {{ \Carbon\Carbon::parse($payment['confirmed_at'])->format('d M Y, H:i') }}
                                </p>
                            @endif
                        </div>
                    @elseif($payment['status'] == 'failed')
                        <div class="alert alert-danger">
                            <i class="fas fa-times-circle me-2"></i>
                            <strong>Payment Failed</strong>
                            @if($payment['notes'])
                                <p class="mb-0 mt-2">{{ $payment['notes'] }}</p>
                            @endif
                        </div>
                    @endif
                </div>
            </div>

            <!-- Quick Actions -->
            @if($payment['status'] == 'waiting_confirmation')
            <div class="card shadow">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Quick Actions</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <button type="button" class="btn btn-success" data-bs-toggle="modal" 
                                data-bs-target="#confirmModal">
                            <i class="fas fa-check me-1"></i>Confirm Payment
                        </button>
                        <button type="button" class="btn btn-danger" data-bs-toggle="modal" 
                                data-bs-target="#rejectModal">
                            <i class="fas fa-times me-1"></i>Reject Payment
                        </button>
                        <button type="button" class="btn btn-outline-secondary" data-bs-toggle="modal" 
                                data-bs-target="#requestProofModal">
                            <i class="fas fa-paper-plane me-1"></i>Request New Proof
                        </button>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>

<!-- Modals -->
@include('employee.payments.modals.confirm')
@include('employee.payments.modals.reject')
@include('employee.payments.modals.request-proof')
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Auto refresh if waiting confirmation
        @if($payment['status'] == 'waiting_confirmation')
            setInterval(() => {
                const shouldRefresh = !document.querySelector('.modal.show');
                if (shouldRefresh) {
                    location.reload();
                }
            }, 15000); // Refresh every 15 seconds
        @endif
    });
</script>
@endsection