{{-- resources/views/employee/payments/index.blade.php --}}
@extends('layouts.employee')

@section('title', 'Payment Verification')
@section('page_title', 'Payment Verification')
@section('icon', 'fa-money-check-alt')

@section('breadcrumb')
    <li class="breadcrumb-item active">Payment Verification</li>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Filter Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card employee-card">
                <div class="card-body">
                    <h5 class="card-title mb-3">Filter Payments</h5>
                    
                    <form method="GET" action="{{ route('employee.payments.index') }}" class="row g-3">
                        <div class="col-md-3">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-control" name="status" id="status">
                                <option value="">All Status</option>
                                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                                <option value="verified" {{ request('status') == 'verified' ? 'selected' : '' }}>Verified</option>
                                <option value="failed" {{ request('status') == 'failed' ? 'selected' : '' }}>Failed</option>
                                <option value="refunded" {{ request('status') == 'refunded' ? 'selected' : '' }}>Refunded</option>
                            </select>
                        </div>
                        
                        <div class="col-md-3">
                            <label for="method" class="form-label">Payment Method</label>
                            <select class="form-control" name="method" id="method">
                                <option value="">All Methods</option>
                                <option value="cash" {{ request('method') == 'cash' ? 'selected' : '' }}>Cash</option>
                                <option value="transfer" {{ request('method') == 'transfer' ? 'selected' : '' }}>Bank Transfer</option>
                                <option value="qris" {{ request('method') == 'qris' ? 'selected' : '' }}>QRIS</option>
                                <option value="card" {{ request('method') == 'card' ? 'selected' : '' }}>Credit/Debit Card</option>
                            </select>
                        </div>
                        
                        <div class="col-md-3">
                            <label for="date" class="form-label">Date</label>
                            <input type="date" class="form-control" name="date" id="date" 
                                   value="{{ request('date') }}">
                        </div>
                        
                        <div class="col-md-3 d-flex align-items-end">
                            <div class="d-flex gap-2 w-100">
                                <button type="submit" class="btn btn-primary flex-grow-1">
                                    <i class="fas fa-filter me-1"></i> Filter
                                </button>
                                <a href="{{ route('employee.payments.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-redo"></i>
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Payments Table -->
    <div class="row">
        <div class="col-12">
            <div class="card employee-card">
                <div class="employee-card-header d-flex justify-content-between align-items-center">
                    <h6 class="mb-0">
                        <i class="fas fa-list me-2"></i>Payments ({{ $payments->total() }})
                        @if(request('status') == 'pending')
                            <span class="badge bg-warning ms-2">{{ $pendingCount ?? 0 }} Pending</span>
                        @endif
                    </h6>
                    <div>
                        <span class="text-success me-3">
                            <i class="fas fa-money-bill-wave me-1"></i>
                            Total: Rp {{ number_format($totalAmount ?? 0, 0, ',', '.') }}
                        </span>
                    </div>
                </div>
                
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover employee-table">
                            <thead>
                                <tr>
                                    <th>Payment ID</th>
                                    <th>Order</th>
                                    <th>Customer</th>
                                    <th>Method</th>
                                    <th>Amount</th>
                                    <th>Proof</th>
                                    <th>Status</th>
                                    <th>Time</th>
                                    <th>Verified By</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($payments as $payment)
                                <tr>
                                    <td>
                                        <strong>#{{ $payment->payment_code }}</strong>
                                        @if($payment->is_verified)
                                            <i class="fas fa-check-circle text-success ms-1"></i>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('employee.orders.show', $payment->order_id) }}" 
                                           class="text-decoration-none">
                                            #{{ $payment->order->order_number ?? 'N/A' }}
                                        </a>
                                    </td>
                                    <td>{{ $payment->customer_name ?? $payment->order->customer_name ?? 'Guest' }}</td>
                                    <td>
                                        <span class="badge bg-{{ $payment->method == 'cash' ? 'success' : ($payment->method == 'transfer' ? 'primary' : 'info') }}">
                                            {{ ucfirst($payment->method) }}
                                        </span>
                                    </td>
                                    <td>
                                        <strong>Rp {{ number_format($payment->amount, 0, ',', '.') }}</strong>
                                    </td>
                                    <td>
                                        @if($payment->proof_image)
                                            <a href="{{ asset('storage/' . $payment->proof_image) }}" 
                                               target="_blank" class="btn btn-sm btn-outline-info">
                                                <i class="fas fa-image"></i> View
                                            </a>
                                        @else
                                            <span class="text-muted">No proof</span>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="payment-{{ $payment->status }} p-2 rounded">
                                            {{ ucfirst($payment->status) }}
                                        </span>
                                    </td>
                                    <td>
                                        <small class="text-muted">
                                            {{ $payment->created_at->format('H:i') }}<br>
                                            {{ $payment->created_at->format('d/m') }}
                                        </small>
                                    </td>
                                    <td>
                                        @if($payment->verified_by)
                                            <small>{{ $payment->verifier->name ?? 'Staff' }}</small><br>
                                            <small class="text-muted">{{ $payment->verified_at->format('H:i') }}</small>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="{{ route('employee.payments.show', $payment->id) }}" 
                                               class="btn btn-info" data-bs-toggle="tooltip" title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            @if($payment->status == 'pending')
                                                <!-- Verify Payment -->
                                                <button type="button" class="btn btn-success" 
                                                        data-bs-toggle="modal" 
                                                        data-bs-target="#verifyModal{{ $payment->id }}"
                                                        data-bs-toggle="tooltip" title="Verify Payment">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                                
                                                <!-- Reject Payment -->
                                                <button type="button" class="btn btn-danger" 
                                                        data-bs-toggle="modal" 
                                                        data-bs-target="#rejectModal{{ $payment->id }}"
                                                        data-bs-toggle="tooltip" title="Reject Payment">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                                
                                                <!-- Verification Modal -->
                                                <div class="modal fade" id="verifyModal{{ $payment->id }}" tabindex="-1">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title">Verify Payment</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                            </div>
                                                            <form action="{{ route('employee.payments.verify', $payment->id) }}" method="POST">
                                                                @csrf
                                                                @method('PUT')
                                                                <div class="modal-body">
                                                                    <p>Are you sure you want to verify this payment?</p>
                                                                    <div class="alert alert-info">
                                                                        <strong>Payment Details:</strong><br>
                                                                        Order: #{{ $payment->order->order_number }}<br>
                                                                        Amount: Rp {{ number_format($payment->amount, 0, ',', '.') }}<br>
                                                                        Method: {{ ucfirst($payment->method) }}
                                                                    </div>
                                                                    <div class="mb-3">
                                                                        <label for="notes{{ $payment->id }}" class="form-label">Verification Notes (Optional)</label>
                                                                        <textarea class="form-control" id="notes{{ $payment->id }}" 
                                                                                  name="notes" rows="2" placeholder="Add verification notes..."></textarea>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-success">Verify Payment</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <!-- Rejection Modal -->
                                                <div class="modal fade" id="rejectModal{{ $payment->id }}" tabindex="-1">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title">Reject Payment</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                            </div>
                                                            <form action="{{ route('employee.payments.reject', $payment->id) }}" method="POST">
                                                                @csrf
                                                                @method('PUT')
                                                                <div class="modal-body">
                                                                    <p>Please provide a reason for rejecting this payment:</p>
                                                                    <div class="alert alert-warning">
                                                                        <strong>Payment Details:</strong><br>
                                                                        Order: #{{ $payment->order->order_number }}<br>
                                                                        Amount: Rp {{ number_format($payment->amount, 0, ',', '.') }}
                                                                    </div>
                                                                    <div class="mb-3">
                                                                        <label for="rejection_reason{{ $payment->id }}" class="form-label">Rejection Reason *</label>
                                                                        <textarea class="form-control" id="rejection_reason{{ $payment->id }}" 
                                                                                  name="rejection_reason" rows="3" required 
                                                                                  placeholder="Explain why this payment is being rejected..."></textarea>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-danger">Reject Payment</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                            
                                            @if($payment->status == 'verified')
                                                <!-- Refund Payment -->
                                                <button type="button" class="btn btn-warning" 
                                                        data-bs-toggle="modal" 
                                                        data-bs-target="#refundModal{{ $payment->id }}"
                                                        data-bs-toggle="tooltip" title="Process Refund">
                                                    <i class="fas fa-undo"></i>
                                                </button>
                                                
                                                <!-- Refund Modal -->
                                                <div class="modal fade" id="refundModal{{ $payment->id }}" tabindex="-1">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title">Process Refund</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                            </div>
                                                            <form action="{{ route('employee.payments.refund', $payment->id) }}" method="POST">
                                                                @csrf
                                                                @method('PUT')
                                                                <div class="modal-body">
                                                                    <div class="alert alert-warning">
                                                                        <i class="fas fa-exclamation-triangle me-2"></i>
                                                                        <strong>Warning:</strong> This action cannot be undone.
                                                                    </div>
                                                                    <div class="mb-3">
                                                                        <label for="refund_amount{{ $payment->id }}" class="form-label">Refund Amount *</label>
                                                                        <div class="input-group">
                                                                            <span class="input-group-text">Rp</span>
                                                                            <input type="number" class="form-control" 
                                                                                   id="refund_amount{{ $payment->id }}" 
                                                                                   name="refund_amount" 
                                                                                   value="{{ $payment->amount }}"
                                                                                   min="0" max="{{ $payment->amount }}"
                                                                                   step="1000" required>
                                                                        </div>
                                                                        <small class="text-muted">Max: Rp {{ number_format($payment->amount, 0, ',', '.') }}</small>
                                                                    </div>
                                                                    <div class="mb-3">
                                                                        <label for="refund_reason{{ $payment->id }}" class="form-label">Refund Reason *</label>
                                                                        <textarea class="form-control" id="refund_reason{{ $payment->id }}" 
                                                                                  name="refund_reason" rows="3" required 
                                                                                  placeholder="Explain why this refund is being processed..."></textarea>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                                    <button type="submit" class="btn btn-danger">Process Refund</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="10" class="text-center py-4">
                                        <i class="fas fa-money-check-alt fa-3x text-muted mb-3"></i>
                                        <h5>No payments found</h5>
                                        <p class="text-muted">Try adjusting your filters</p>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    @if($payments->hasPages())
                        <div class="d-flex justify-content-center mt-3">
                            {{ $payments->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    
    <!-- Statistics Summary -->
    <div class="row mt-4">
        <div class="col-md-3">
            <div class="card employee-card">
                <div class="card-body text-center">
                    <h6 class="text-muted mb-2">Total Verified</h6>
                    <h3 class="text-success">Rp {{ number_format($verifiedAmount ?? 0, 0, ',', '.') }}</h3>
                    <small class="text-muted">{{ $verifiedCount ?? 0 }} payments</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card employee-card">
                <div class="card-body text-center">
                    <h6 class="text-muted mb-2">Pending Verification</h6>
                    <h3 class="text-warning">Rp {{ number_format($pendingAmount ?? 0, 0, ',', '.') }}</h3>
                    <small class="text-muted">{{ $pendingCount ?? 0 }} payments</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card employee-card">
                <div class="card-body text-center">
                    <h6 class="text-muted mb-2">Failed Payments</h6>
                    <h3 class="text-danger">Rp {{ number_format($failedAmount ?? 0, 0, ',', '.') }}</h3>
                    <small class="text-muted">{{ $failedCount ?? 0 }} payments</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card employee-card">
                <div class="card-body text-center">
                    <h6 class="text-muted mb-2">Refunded</h6>
                    <h3 class="text-info">Rp {{ number_format($refundedAmount ?? 0, 0, ',', '.') }}</h3>
                    <small class="text-muted">{{ $refundedCount ?? 0 }} payments</small>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Initialize tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
        
        // Auto-refresh pending payments every 30 seconds
        if (window.location.href.includes('status=pending')) {
            setInterval(function() {
                if (document.visibilityState === 'visible') {
                    window.location.reload();
                }
            }, 30000);
        }
    });
</script>
@endsection