{{-- resources/views/employee/orders/show.blade.php --}}
@extends('layouts.employee')

@section('title', 'Order Details')
@section('page_title', 'Order Details')
@section('icon', 'fa-eye')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('employee.orders.index') }}">Orders</a></li>
    <li class="breadcrumb-item active">#{{ $order->order_number }}</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-8">
            <!-- Order Details -->
            <div class="card employee-card">
                <div class="employee-card-header d-flex justify-content-between align-items-center">
                    <div>
                        <h6 class="mb-0">
                            <i class="fas fa-receipt me-2"></i>Order #{{ $order->order_number }}
                            @if($order->is_urgent)
                                <span class="badge bg-danger ms-2">Urgent</span>
                            @endif
                        </h6>
                        <small class="text-muted">Placed {{ $order->created_at->diffForHumans() }}</small>
                    </div>
                    <div>
                        <span class="status-badge status-{{ $order->status }} fs-6">
                            {{ ucfirst($order->status) }}
                        </span>
                    </div>
                </div>
                
                <div class="card-body">
                    <!-- Order Information -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h6 class="border-bottom pb-2 mb-3">Customer Information</h6>
                            <div class="mb-2">
                                <strong>Name:</strong> {{ $order->customer_name ?? 'Guest' }}
                            </div>
                            @if($order->customer_phone)
                            <div class="mb-2">
                                <strong>Phone:</strong> {{ $order->customer_phone }}
                            </div>
                            @endif
                            @if($order->customer_email)
                            <div class="mb-2">
                                <strong>Email:</strong> {{ $order->customer_email }}
                            </div>
                            @endif
                            @if($order->order_type == 'dine_in' && $order->table)
                            <div class="mb-2">
                                <strong>Table:</strong> 
                                <span class="badge bg-info">{{ $order->table->name }}</span>
                            </div>
                            @endif
                            @if($order->order_type == 'delivery' && $order->delivery_address)
                            <div class="mb-2">
                                <strong>Delivery Address:</strong><br>
                                {{ $order->delivery_address }}
                            </div>
                            @endif
                        </div>
                        
                        <div class="col-md-6">
                            <h6 class="border-bottom pb-2 mb-3">Order Details</h6>
                            <div class="mb-2">
                                <strong>Order Type:</strong>
                                <span class="badge {{ $order->order_type == 'dine_in' ? 'bg-info' : ($order->order_type == 'takeaway' ? 'bg-warning' : 'bg-primary') }}">
                                    {{ ucfirst($order->order_type) }}
                                </span>
                            </div>
                            <div class="mb-2">
                                <strong>Order Time:</strong> {{ $order->created_at->format('d M Y, H:i') }}
                            </div>
                            <div class="mb-2">
                                <strong>Estimated Time:</strong> 
                                @if($order->estimated_time)
                                    {{ $order->estimated_time }} minutes
                                @else
                                    <span class="text-muted">Not set</span>
                                @endif
                            </div>
                            @if($order->notes)
                            <div class="mb-2">
                                <strong>Notes:</strong> {{ $order->notes }}
                            </div>
                            @endif
                        </div>
                    </div>
                    
                    <!-- Order Items -->
                    <h6 class="border-bottom pb-2 mb-3">Order Items</h6>
                    <div class="table-responsive mb-4">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Item</th>
                                    <th>Price</th>
                                    <th>Qty</th>
                                    <th>Subtotal</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($order->items as $item)
                                <tr>
                                    <td>
                                        <strong>{{ $item->menu->name }}</strong>
                                        @if($item->notes)
                                            <br>
                                            <small class="text-muted">{{ $item->notes }}</small>
                                        @endif
                                    </td>
                                    <td>Rp {{ number_format($item->price, 0, ',', '.') }}</td>
                                    <td>{{ $item->quantity }}</td>
                                    <td>Rp {{ number_format($item->price * $item->quantity, 0, ',', '.') }}</td>
                                    <td>
                                        <span class="badge {{ $item->status == 'preparing' ? 'bg-warning' : ($item->status == 'ready' ? 'bg-success' : 'bg-secondary') }}">
                                            {{ ucfirst($item->status) }}
                                        </span>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Order Summary -->
                    <div class="row justify-content-end">
                        <div class="col-md-6">
                            <div class="card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title mb-3">Order Summary</h6>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span>Subtotal:</span>
                                        <span>Rp {{ number_format($order->subtotal, 0, ',', '.') }}</span>
                                    </div>
                                    <div class="d-flex justify-content-between mb-2">
                                        <span>Tax (10%):</span>
                                        <span>Rp {{ number_format($order->tax_amount, 0, ',', '.') }}</span>
                                    </div>
                                    @if($order->service_charge > 0)
                                    <div class="d-flex justify-content-between mb-2">
                                        <span>Service Charge:</span>
                                        <span>Rp {{ number_format($order->service_charge, 0, ',', '.') }}</span>
                                    </div>
                                    @endif
                                    @if($order->discount_amount > 0)
                                    <div class="d-flex justify-content-between mb-2">
                                        <span>Discount:</span>
                                        <span class="text-success">-Rp {{ number_format($order->discount_amount, 0, ',', '.') }}</span>
                                    </div>
                                    @endif
                                    <hr>
                                    <div class="d-flex justify-content-between fw-bold fs-5">
                                        <span>Total:</span>
                                        <span>Rp {{ number_format($order->total_amount, 0, ',', '.') }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <!-- Actions Card -->
            <div class="card employee-card">
                <div class="employee-card-header">
                    <h6 class="mb-0">
                        <i class="fas fa-cogs me-2"></i>Order Actions
                    </h6>
                </div>
                <div class="card-body">
                    <!-- Update Status -->
                    <div class="mb-4">
                        <h6 class="mb-3">Update Status</h6>
                        <div class="d-grid gap-2">
                            @foreach(['processing', 'preparing', 'ready', 'completed'] as $newStatus)
                                @if($order->status != $newStatus)
                                    <form action="{{ route('employee.orders.update_status', $order->id) }}" 
                                          method="POST">
                                        @csrf
                                        @method('PUT')
                                        <input type="hidden" name="status" value="{{ $newStatus }}">
                                        <button type="submit" class="btn btn-outline-primary w-100 text-start">
                                            <i class="fas fa-arrow-right me-2"></i>
                                            Mark as {{ ucfirst($newStatus) }}
                                        </button>
                                    </form>
                                @endif
                            @endforeach
                            
                            @if($order->status != 'cancelled')
                                <div class="dropdown-divider"></div>
                                <form action="{{ route('employee.orders.update_status', $order->id) }}" 
                                      method="POST">
                                    @csrf
                                    @method('PUT')
                                    <input type="hidden" name="status" value="cancelled">
                                    <button type="submit" class="btn btn-outline-danger w-100 text-start">
                                        <i class="fas fa-times me-2"></i>
                                        Cancel Order
                                    </button>
                                </form>
                            @endif
                        </div>
                    </div>
                    
                    <!-- Payment Information -->
                    <div class="mb-4">
                        <h6 class="mb-3">Payment Status</h6>
                        @if($order->payment)
                            <div class="alert alert-{{ $order->payment->status == 'verified' ? 'success' : 'warning' }}">
                                <strong>Status:</strong> {{ ucfirst($order->payment->status) }}<br>
                                <strong>Method:</strong> {{ ucfirst($order->payment->method) }}<br>
                                <strong>Amount:</strong> Rp {{ number_format($order->payment->amount, 0, ',', '.') }}
                            </div>
                            
                            @if($order->payment->status == 'pending')
                                <a href="{{ route('employee.payments.verify', $order->payment->id) }}" 
                                   class="btn btn-success w-100 mb-2">
                                    <i class="fas fa-check-circle me-2"></i> Verify Payment
                                </a>
                            @endif
                        @else
                            <div class="alert alert-warning">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                Payment not recorded
                            </div>
                        @endif
                    </div>
                    
                    <!-- Print & Export -->
                    <div class="mb-4">
                        <h6 class="mb-3">Print & Export</h6>
                        <div class="d-grid gap-2">
                            <a href="{{ route('employee.orders.print_receipt', $order->id) }}" 
                               class="btn btn-primary" target="_blank">
                                <i class="fas fa-print me-2"></i> Print Receipt
                            </a>
                            <a href="{{ route('employee.orders.print_kitchen', $order->id) }}" 
                               class="btn btn-warning" target="_blank">
                                <i class="fas fa-utensils me-2"></i> Kitchen Ticket
                            </a>
                        </div>
                    </div>
                    
                    <!-- Other Actions -->
                    <div>
                        <h6 class="mb-3">Other Actions</h6>
                        <div class="d-grid gap-2">
                            @if(!$order->is_urgent)
                                <form action="{{ route('employee.orders.toggle_urgent', $order->id) }}" 
                                      method="POST">
                                    @csrf
                                    <button type="submit" class="btn btn-danger">
                                        <i class="fas fa-exclamation me-2"></i> Mark as Urgent
                                    </button>
                                </form>
                            @endif
                            
                            <a href="{{ route('employee.orders.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left me-2"></i> Back to Orders
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Order Timeline -->
            <div class="card employee-card mt-4">
                <div class="employee-card-header">
                    <h6 class="mb-0">
                        <i class="fas fa-history me-2"></i>Order Timeline
                    </h6>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        @foreach($order->statusHistory as $history)
                        <div class="timeline-item mb-3">
                            <div class="timeline-marker bg-{{ $history->status == 'completed' ? 'success' : 'primary' }}"></div>
                            <div class="timeline-content">
                                <small class="text-muted">{{ $history->created_at->format('H:i') }}</small>
                                <div class="fw-bold">{{ ucfirst($history->status) }}</div>
                                <small class="text-muted">by {{ $history->user->name ?? 'System' }}</small>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .timeline {
        position: relative;
        padding-left: 2rem;
    }
    .timeline-item {
        position: relative;
        padding-bottom: 1rem;
    }
    .timeline-marker {
        position: absolute;
        left: -1.5rem;
        top: 0;
        width: 1rem;
        height: 1rem;
        border-radius: 50%;
    }
    .timeline-content {
        padding-left: 0.5rem;
    }
</style>
@endsection