{{-- resources/views/employee/orders/index.blade.php --}}
@extends('layouts.employee')

@section('title', 'Orders Management')
@section('page_title', 'Orders Management')
@section('icon', 'fa-shopping-cart')

@section('breadcrumb')
    <li class="breadcrumb-item active">Orders Management</li>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Filter Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card employee-card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="card-title mb-0">Filter Orders</h5>
                        <a href="{{ route('employee.orders.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> New Order
                        </a>
                    </div>
                    
                    <form method="GET" action="{{ route('employee.orders.index') }}" class="row g-3">
                        <div class="col-md-3">
                            <label for="status" class="form-label">Status</label>
                            <select class="form-control" name="status" id="status">
                                <option value="">All Status</option>
                                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                                <option value="processing" {{ request('status') == 'processing' ? 'selected' : '' }}>Processing</option>
                                <option value="preparing" {{ request('status') == 'preparing' ? 'selected' : '' }}>Preparing</option>
                                <option value="ready" {{ request('status') == 'ready' ? 'selected' : '' }}>Ready</option>
                                <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                                <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                            </select>
                        </div>
                        
                        <div class="col-md-3">
                            <label for="order_type" class="form-label">Order Type</label>
                            <select class="form-control" name="order_type" id="order_type">
                                <option value="">All Types</option>
                                <option value="dine_in" {{ request('order_type') == 'dine_in' ? 'selected' : '' }}>Dine-in</option>
                                <option value="takeaway" {{ request('order_type') == 'takeaway' ? 'selected' : '' }}>Takeaway</option>
                                <option value="delivery" {{ request('order_type') == 'delivery' ? 'selected' : '' }}>Delivery</option>
                            </select>
                        </div>
                        
                        <div class="col-md-3">
                            <label for="date" class="form-label">Date</label>
                            <input type="date" class="form-control" name="date" id="date" 
                                   value="{{ request('date') }}">
                        </div>
                        
                        <div class="col-md-3 d-flex align-items-end">
                            <div class="d-flex gap-2 w-100">
                                <button type="submit" class="btn btn-primary flex-grow-1">
                                    <i class="fas fa-filter me-1"></i> Filter
                                </button>
                                <a href="{{ route('employee.orders.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-redo"></i>
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Orders Table -->
    <div class="row">
        <div class="col-12">
            <div class="card employee-card">
                <div class="employee-card-header">
                    <h6 class="mb-0">
                        <i class="fas fa-list me-2"></i>All Orders ({{ $orders->total() }})
                    </h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover employee-table">
                            <thead>
                                <tr>
                                    <th>Order #</th>
                                    <th>Customer</th>
                                    <th>Type</th>
                                    <th>Items</th>
                                    <th>Total Amount</th>
                                    <th>Payment</th>
                                    <th>Status</th>
                                    <th>Time</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($orders as $order)
                                <tr>
                                    <td>
                                        <strong>#{{ $order->order_number }}</strong>
                                        @if($order->is_urgent)
                                            <span class="badge bg-danger ms-1">Urgent</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div>{{ $order->customer_name ?? 'Guest' }}</div>
                                        @if($order->table)
                                            <small class="text-muted">Table: {{ $order->table->name }}</small>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge {{ $order->order_type == 'dine_in' ? 'bg-info' : ($order->order_type == 'takeaway' ? 'bg-warning' : 'bg-primary') }}">
                                            {{ ucfirst($order->order_type) }}
                                        </span>
                                    </td>
                                    <td>{{ $order->items_count }} items</td>
                                    <td>
                                        <strong>Rp {{ number_format($order->total_amount, 0, ',', '.') }}</strong>
                                    </td>
                                    <td>
                                        @if($order->payment)
                                            <span class="badge payment-{{ $order->payment->status }}">
                                                {{ ucfirst($order->payment->status) }}
                                            </span>
                                        @else
                                            <span class="badge bg-secondary">Pending</span>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="status-badge status-{{ $order->status }}">
                                            {{ ucfirst($order->status) }}
                                        </span>
                                    </td>
                                    <td>
                                        <small class="text-muted">
                                            {{ $order->created_at->format('H:i') }}<br>
                                            {{ $order->created_at->diffForHumans() }}
                                        </small>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="{{ route('employee.orders.show', $order->id) }}" 
                                               class="btn btn-info" data-bs-toggle="tooltip" title="View">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            <!-- Update Status Dropdown -->
                                            <div class="dropdown">
                                                <button class="btn btn-warning dropdown-toggle" 
                                                        type="button" data-bs-toggle="dropdown"
                                                        data-bs-toggle="tooltip" title="Update Status">
                                                    <i class="fas fa-sync-alt"></i>
                                                </button>
                                                <div class="dropdown-menu">
                                                    @foreach(['processing', 'preparing', 'ready', 'completed'] as $newStatus)
                                                        @if($order->status != $newStatus)
                                                            <form action="{{ route('employee.orders.update_status', $order->id) }}" 
                                                                  method="POST" class="d-inline">
                                                                @csrf
                                                                @method('PUT')
                                                                <input type="hidden" name="status" value="{{ $newStatus }}">
                                                                <button type="submit" class="dropdown-item">
                                                                    Mark as {{ ucfirst($newStatus) }}
                                                                </button>
                                                            </form>
                                                        @endif
                                                    @endforeach
                                                    
                                                    @if($order->status != 'cancelled')
                                                        <div class="dropdown-divider"></div>
                                                        <form action="{{ route('employee.orders.update_status', $order->id) }}" 
                                                              method="POST" class="d-inline">
                                                            @csrf
                                                            @method('PUT')
                                                            <input type="hidden" name="status" value="cancelled">
                                                            <button type="submit" class="dropdown-item text-danger">
                                                                Cancel Order
                                                            </button>
                                                        </form>
                                                    @endif
                                                </div>
                                            </div>
                                            
                                            <!-- Print Receipt -->
                                            @if($order->status == 'completed' || $order->status == 'ready')
                                                <a href="{{ route('employee.orders.print_receipt', $order->id) }}" 
                                                   class="btn btn-primary" target="_blank"
                                                   data-bs-toggle="tooltip" title="Print Receipt">
                                                    <i class="fas fa-print"></i>
                                                </a>
                                            @endif
                                            
                                            <!-- Make Urgent -->
                                            @if(!$order->is_urgent && $order->status == 'pending')
                                                <form action="{{ route('employee.orders.toggle_urgent', $order->id) }}" 
                                                      method="POST" class="d-inline">
                                                    @csrf
                                                    <button type="submit" class="btn btn-danger btn-sm"
                                                            data-bs-toggle="tooltip" title="Mark as Urgent">
                                                        <i class="fas fa-exclamation"></i>
                                                    </button>
                                                </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center py-4">
                                        <i class="fas fa-shopping-cart fa-3x text-muted mb-3"></i>
                                        <h5>No orders found</h5>
                                        <p class="text-muted">Try adjusting your filters</p>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    @if($orders->hasPages())
                        <div class="d-flex justify-content-center mt-3">
                            {{ $orders->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Initialize tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
        
        // Auto-refresh orders every 60 seconds
        setInterval(function() {
            if (document.visibilityState === 'visible') {
                window.location.reload();
            }
        }, 60000);
    });
</script>
@endsection