{{-- resources/views/customer/reviews/create.blade.php --}}
@extends('layouts.app')

@section('title', 'Write Review - Chingu Bite')

@section('content')
<div class="container py-4">
    <h1 class="mb-4">Write a Review</h1>
    
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    @if($orderItem)
                        <div class="alert alert-info">
                            <p><strong>Reviewing:</strong> {{ $orderItem['menu']['name'] ?? 'Menu Item' }}</p>
                            <p><strong>From Order:</strong> #{{ $orderItem['order']['order_number'] ?? 'N/A' }}</p>
                        </div>
                    @endif
                    
                    <form method="POST" action="{{ route('customer.reviews.store') }}">
                        @csrf
                        
                        @if($orderItem)
                            <input type="hidden" name="order_id" value="{{ $orderItem['order_id'] }}">
                            <input type="hidden" name="menu_id" value="{{ $orderItem['menu_id'] }}">
                        @else
                            <div class="mb-3">
                                <label for="order_id" class="form-label">Select Order</label>
                                <select class="form-select" id="order_id" name="order_id" required>
                                    <option value="">Select an order</option>
                                    @foreach($orders as $order)
                                        <option value="{{ $order['id'] }}">
                                            Order #{{ $order['order_number'] }} - {{ \Carbon\Carbon::parse($order['created_at'])->format('M d, Y') }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            
                            <div class="mb-3">
                                <label for="menu_id" class="form-label">Select Menu Item</label>
                                <select class="form-select" id="menu_id" name="menu_id" required>
                                    <option value="">Select a menu item</option>
                                    <!-- Will be populated by JavaScript based on order selection -->
                                </select>
                            </div>
                        @endif
                        
                        <div class="mb-3">
                            <label class="form-label">Rating</label>
                            <div class="rating-stars">
                                @for($i = 1; $i <= 5; $i++)
                                    <button type="button" class="star-btn" data-rating="{{ $i }}">
                                        <i class="far fa-star fa-2x"></i>
                                    </button>
                                @endfor
                                <input type="hidden" name="rating" id="rating" value="5" required>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="comment" class="form-label">Comment (Optional)</label>
                            <textarea class="form-control" id="comment" name="comment" rows="5" 
                                      placeholder="Share your experience..."></textarea>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">Submit Review</button>
                        <a href="{{ route('customer.reviews.index') }}" class="btn btn-secondary">Cancel</a>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Star rating
        const starButtons = document.querySelectorAll('.star-btn');
        const ratingInput = document.getElementById('rating');
        
        starButtons.forEach(btn => {
            btn.addEventListener('click', function() {
                const rating = this.dataset.rating;
                ratingInput.value = rating;
                
                starButtons.forEach((star, index) => {
                    const icon = star.querySelector('i');
                    if (index < rating) {
                        icon.classList.remove('far');
                        icon.classList.add('fas');
                        icon.style.color = '#ffc107';
                    } else {
                        icon.classList.remove('fas');
                        icon.classList.add('far');
                        icon.style.color = '#ccc';
                    }
                });
            });
        });
        
        // Initialize with 5 stars
        if (starButtons[4]) starButtons[4].click();
        
        // Dynamic menu items based on order selection
        const orderSelect = document.getElementById('order_id');
        const menuSelect = document.getElementById('menu_id');
        
        if (orderSelect && menuSelect) {
            orderSelect.addEventListener('change', function() {
                const orderId = this.value;
                
                if (!orderId) {
                    menuSelect.innerHTML = '<option value="">Select a menu item</option>';
                    return;
                }
                
                // Fetch order items for this order
                fetch(`/api/orders/${orderId}/items`)
                    .then(response => response.json())
                    .then(data => {
                        menuSelect.innerHTML = '<option value="">Select a menu item</option>';
                        
                        if (data.success && data.data) {
                            data.data.forEach(item => {
                                const option = document.createElement('option');
                                option.value = item.menu_id;
                                option.textContent = item.menu.name;
                                menuSelect.appendChild(option);
                            });
                        }
                    })
                    .catch(error => {
                        console.error('Error fetching order items:', error);
                    });
            });
        }
    });
</script>
@endsection
@endsection