@extends('layouts.app')

@section('title', 'My Profile')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-lg-4">
            <!-- Profile Card -->
            <div class="card shadow mb-4">
                <div class="card-body text-center">
                    <div class="mb-3">
                        <div class="avatar-placeholder rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center" 
                             style="width: 100px; height: 100px; font-size: 2.5rem;">
                            {{ Str::substr($user->name ?? 'U', 0, 1) }}
                        </div>
                    </div>
                    
                    <h4>{{ $user->name ?? 'User' }}</h4>
                    <p class="text-muted">{{ $user->email ?? '' }}</p>
                    
                    <div class="mb-3">
                        <span class="badge bg-info p-2">
                            <i class="fas fa-user me-1"></i>
                            {{ ucfirst($user->role ?? 'customer') }}
                        </span>
                    </div>
                    
                    <p class="text-muted mb-2">
                        <i class="fas fa-phone me-1"></i>
                        {{ $user->phone ?? 'No phone number' }}
                    </p>
                    
                    <p class="text-muted">
                        <i class="fas fa-calendar-alt me-1"></i>
                        Member since {{ \Carbon\Carbon::parse($user->created_at ?? now())->format('F Y') }}
                    </p>
                    
                    <!-- Edit Profile Button -->
                    <div class="mt-4">
                        <a href="{{ route('customer.profile.edit') }}" class="btn btn-primary">
                            <i class="fas fa-edit me-1"></i> Edit Profile
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Quick Stats -->
            <div class="card shadow">
                <div class="card-header bg-light">
                    <h6 class="mb-0">Account Stats</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <small class="text-muted d-block">Total Orders</small>
                        <h5 class="mb-0" id="total-orders">Loading...</h5>
                    </div>
                    <div class="mb-3">
                        <small class="text-muted d-block">Pending Reviews</small>
                        <h5 class="mb-0" id="pending-reviews">Loading...</h5>
                    </div>
                    <div class="mb-3">
                        <small class="text-muted d-block">Active Applications</small>
                        <h5 class="mb-0" id="active-applications">Loading...</h5>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-8">
            <!-- Profile Information -->
            <div class="card shadow mb-4">
                <div class="card-header bg-light">
                    <h5 class="mb-0">
                        <i class="fas fa-info-circle me-2"></i> Profile Information
                    </h5>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle me-2"></i>
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label text-muted">Full Name</label>
                            <p class="h6">{{ $user->name ?? 'Not set' }}</p>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label class="form-label text-muted">Email Address</label>
                            <p class="h6">{{ $user->email ?? 'Not set' }}</p>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label text-muted">Phone Number</label>
                        <p class="h6">{{ $user->phone ?? 'Not set' }}</p>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label text-muted">Account Role</label>
                            <p class="h6">
                                <span class="badge bg-info">
                                    {{ ucfirst($user->role ?? 'customer') }}
                                </span>
                            </p>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label class="form-label text-muted">Account Created</label>
                            <p class="h6">
                                {{ \Carbon\Carbon::parse($user->created_at ?? now())->format('d F Y') }}
                            </p>
                        </div>
                    </div>
                    
                    <div class="mt-4">
                        <a href="{{ route('customer.profile.edit') }}" class="btn btn-primary">
                            <i class="fas fa-edit me-1"></i> Edit Profile
                        </a>
                        <a href="{{ route('customer.dashboard') }}" class="btn btn-outline-secondary ms-2">
                            <i class="fas fa-tachometer-alt me-1"></i> Back to Dashboard
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Recent Activity -->
            <div class="card shadow">
                <div class="card-header bg-light">
                    <h6 class="mb-0">
                        <i class="fas fa-history me-2"></i> Recent Activity
                    </h6>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush" id="recent-activity">
                        <div class="text-center py-3">
                            <div class="spinner-border spinner-border-sm text-primary" role="status">
                                <span class="visually-hidden">Loading...</span>
                            </div>
                            <span class="ms-2">Loading activity...</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    .avatar-placeholder {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        font-weight: bold;
    }
    
    .activity-item {
        border-left: 3px solid #667eea;
        padding-left: 15px;
        margin-bottom: 15px;
    }
    
    .activity-item .time {
        font-size: 0.8rem;
        color: #6c757d;
    }
    
    .form-label.text-muted {
        font-size: 0.875rem;
        margin-bottom: 0.25rem;
    }
    
    .h6 {
        margin-bottom: 0;
    }
</style>
@endpush

@push('scripts')
<script>
    $(document).ready(function() {
        // Load profile stats from API
        function loadProfileStats() {
            const token = '{{ Session::get("api_token") }}';
            if (!token) return;
            
            // Load orders count
            $.ajax({
                url: '{{ config("app.api_url") }}/customer/orders',
                method: 'GET',
                headers: {
                    'Authorization': 'Bearer ' + token,
                    'Accept': 'application/json'
                },
                success: function(response) {
                    if (response.success && response.data) {
                        const totalOrders = response.data.total || response.data.length || 0;
                        $('#total-orders').text(totalOrders);
                    }
                }
            });
            
            // Load pending reviews
            $.ajax({
                url: '{{ config("app.api_url") }}/customer/reviews/pending',
                method: 'GET',
                headers: {
                    'Authorization': 'Bearer ' + token,
                    'Accept': 'application/json'
                },
                success: function(response) {
                    if (response.success && response.data) {
                        const pendingReviews = response.data.length || 0;
                        $('#pending-reviews').text(pendingReviews);
                    }
                }
            });
            
            // Load active applications
            $.ajax({
                url: '{{ config("app.api_url") }}/customer/careers/applications',
                method: 'GET',
                headers: {
                    'Authorization': 'Bearer ' + token,
                    'Accept': 'application/json'
                },
                success: function(response) {
                    if (response.success && response.data) {
                        const activeApps = response.data.filter(app => 
                            ['pending', 'reviewed', 'interviewed'].includes(app.status)
                        ).length;
                        $('#active-applications').text(activeApps);
                    }
                }
            });
            
            // Load recent activity
            $.ajax({
                url: '{{ config("app.api_url") }}/customer/orders?limit=5',
                method: 'GET',
                headers: {
                    'Authorization': 'Bearer ' + token,
                    'Accept': 'application/json'
                },
                success: function(response) {
                    if (response.success && response.data && response.data.data) {
                        const activities = response.data.data;
                        let html = '';
                        
                        if (activities.length === 0) {
                            html = '<div class="text-center py-3 text-muted">No recent activity</div>';
                        } else {
                            activities.forEach(order => {
                                const date = new Date(order.created_at).toLocaleDateString('en-US', {
                                    month: 'short',
                                    day: 'numeric'
                                });
                                
                                html += `
                                    <div class="activity-item">
                                        <div class="d-flex justify-content-between">
                                            <strong>Order #${order.order_number}</strong>
                                            <span class="badge bg-${order.status === 'completed' ? 'success' : 
                                                                     order.status === 'cancelled' ? 'danger' : 
                                                                     'warning'}">
                                                ${order.status}
                                            </span>
                                        </div>
                                        <p class="mb-1">${order.order_type.replace('_', ' ')} - Rp ${order.final_amount.toLocaleString('id-ID')}</p>
                                        <small class="time">${date}</small>
                                    </div>
                                `;
                            });
                        }
                        
                        $('#recent-activity').html(html);
                    }
                }
            });
        }
        
        // Load stats on page load
        loadProfileStats();
    });
</script>
@endpush