{{-- resources/views/customer/payments/create.blade.php --}}
@extends('layouts.app')

@section('title', 'Make Payment - Chingu Bite')

@section('content')
<div class="container py-4">
    <h1 class="mb-4">Make Payment</h1>
    
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Order Details</h5>
                    <p><strong>Order #:</strong> {{ $order['order_number'] ?? 'N/A' }}</p>
                    <p><strong>Total Amount:</strong> Rp {{ number_format($order['final_amount'] ?? 0, 0, ',', '.') }}</p>
                    
                    <form method="POST" action="{{ route('customer.payments.store') }}">
                        @csrf
                        <input type="hidden" name="order_id" value="{{ $orderId }}">
                        
                        <div class="mb-3">
                            <label for="payment_method_id" class="form-label">Payment Method</label>
                            <select class="form-select" id="payment_method_id" name="payment_method_id" required>
                                <option value="">Select Payment Method</option>
                                @foreach($paymentMethods as $method)
                                    @if($method['is_active'])
                                        <option value="{{ $method['id'] }}">
                                            {{ $method['name'] }}
                                        </option>
                                    @endif
                                @endforeach
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label for="amount" class="form-label">Amount</label>
                            <input type="number" 
                                   class="form-control" 
                                   id="amount" 
                                   name="amount" 
                                   value="{{ $order['final_amount'] ?? 0 }}" 
                                   required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="notes" class="form-label">Notes (Optional)</label>
                            <textarea class="form-control" id="notes" name="notes" rows="3"></textarea>
                        </div>
                        
                        <button type="submit" class="btn btn-primary">Submit Payment</button>
                        <a href="{{ route('customer.orders.show', $orderId) }}" class="btn btn-secondary">Cancel</a>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Payment Instructions</h5>
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        Please complete your payment within 24 hours
                    </div>
                    <ul>
                        <li>Keep your payment receipt</li>
                        <li>You can upload payment proof after submission</li>
                        <li>Payment confirmation may take up to 2 hours</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection