@extends('layouts.app')

@section('title', 'My Rating History')

@section('content')
<div class="container py-4">
    <!-- Breadcrumb -->
    <nav aria-label="breadcrumb" class="mb-4">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="{{ route('customer.dashboard') }}">
                    <i class="fas fa-home me-1"></i> Dashboard
                </a>
            </li>
            <li class="breadcrumb-item">
                <a href="{{ route('customer.orders.index') }}">
                    <i class="fas fa-list me-1"></i> My Orders
                </a>
            </li>
            <li class="breadcrumb-item active">
                <i class="fas fa-star me-1"></i> Rating History
            </li>
        </ol>
    </nav>

    <!-- Header -->
    <div class="row mb-4">
        <div class="col-md-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-1">
                        <i class="fas fa-star text-warning me-2"></i> My Rating History
                    </h2>
                    <p class="text-muted mb-0">All reviews you've submitted</p>
                </div>
                <a href="{{ route('customer.orders.index') }}" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-1"></i> Back to Orders
                </a>
            </div>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-md-4 mb-3">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-body text-center">
                    <h1 class="display-4 text-primary">{{ $stats['total'] }}</h1>
                    <p class="text-muted mb-0">Total Ratings</p>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-body text-center">
                    <h1 class="display-4 text-warning">{{ $stats['average'] }}/5</h1>
                    <p class="text-muted mb-0">Average Rating</p>
                </div>
            </div>
        </div>
        <div class="col-md-4 mb-3">
            <div class="card shadow-sm border-0 h-100">
                <div class="card-body text-center">
                    <h1 class="display-4 text-success">{{ $stats['recent'] }}</h1>
                    <p class="text-muted mb-0">Last 30 Days</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Reviews List -->
    <div class="card shadow">
        <div class="card-header bg-white">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="mb-0">All Reviews</h5>
                <span class="badge bg-primary">{{ $reviews->total() }} reviews</span>
            </div>
        </div>
        
        <div class="card-body">
            @if($reviews->count() > 0)
                @foreach($reviews as $review)
                    <div class="review-item border-bottom pb-4 mb-4 {{ !$loop->last ? '' : 'border-bottom-0 pb-0 mb-0' }}">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="d-flex align-items-start mb-2">
                                    <div class="flex-grow-1">
                                        <h5 class="mb-1">
                                            {{ $review->menu->name ?? 'Menu Item' }}
                                            @if($review->order)
                                                <small class="text-muted ms-2">
                                                    Order #{{ $review->order->order_number }}
                                                </small>
                                            @endif
                                        </h5>
                                        <div class="mb-2">
                                            @for($i = 1; $i <= 5; $i++)
                                                @if($i <= $review->rating)
                                                    <i class="fas fa-star text-warning"></i>
                                                @else
                                                    <i class="far fa-star text-warning"></i>
                                                @endif
                                            @endfor
                                            <span class="ms-2 fw-bold">{{ $review->rating }}/5</span>
                                        </div>
                                    </div>
                                    <div class="text-end">
                                        <small class="text-muted">
                                            {{ $review->created_at->format('M d, Y') }}
                                        </small>
                                        <br>
                                        <span class="badge bg-{{ $review->is_approved ? 'success' : 'warning' }}">
                                            {{ $review->is_approved ? 'Approved' : 'Pending' }}
                                        </span>
                                    </div>
                                </div>
                                
                                @if($review->comment)
                                    <div class="bg-light p-3 rounded mb-2">
                                        <p class="mb-0">{{ $review->comment }}</p>
                                    </div>
                                @endif
                                
                                <div class="d-flex align-items-center text-muted">
                                    <small>
                                        <i class="fas fa-calendar me-1"></i>
                                        Ordered: {{ $review->order->created_at->format('M d, Y') ?? 'N/A' }}
                                    </small>
                                    <span class="mx-2">•</span>
                                    <small>
                                        <i class="fas fa-dollar-sign me-1"></i>
                                        Rp {{ number_format($review->order->final_amount ?? 0, 0, ',', '.') }}
                                    </small>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="card border">
                                    <div class="card-body p-3">
                                        <h6 class="card-title mb-2">Order Details</h6>
                                        @if($review->order)
                                            <p class="mb-1">
                                                <small>Status:</small>
                                                @php
                                                    $statusColors = [
                                                        'pending' => 'warning',
                                                        'processing' => 'info',
                                                        'preparing' => 'primary',
                                                        'ready' => 'success',
                                                        'on_delivery' => 'info',
                                                        'completed' => 'success',
                                                        'cancelled' => 'danger',
                                                    ];
                                                    $status = $review->order->status;
                                                    $statusColor = $statusColors[$status] ?? 'secondary';
                                                @endphp
                                                <span class="badge bg-{{ $statusColor }} ms-1">
                                                    {{ ucfirst($status) }}
                                                </span>
                                            </p>
                                            <p class="mb-1">
                                                <small>Type:</small>
                                                <strong class="ms-1">{{ ucfirst($review->order->order_type) }}</strong>
                                            </p>
                                            <p class="mb-0">
                                                <small>Items:</small>
                                                <strong class="ms-1">{{ $review->order->items->count() ?? 0 }}</strong>
                                            </p>
                                        @else
                                            <p class="text-muted mb-0">Order details not available</p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Actions -->
                        <div class="mt-3">
                            <a href="{{ route('customer.orders.show', $review->order_id) }}" 
                               class="btn btn-sm btn-outline-primary me-2">
                                <i class="fas fa-eye me-1"></i> View Order
                            </a>
                            @if($review->menu)
                                <a href="{{ route('customer.menu.index') }}?search={{ urlencode($review->menu->name) }}" 
                                   class="btn btn-sm btn-outline-secondary">
                                    <i class="fas fa-utensils me-1"></i> View Menu
                                </a>
                            @endif
                        </div>
                    </div>
                @endforeach
                
                <!-- Pagination -->
                @if($reviews->hasPages())
                    <div class="mt-4">
                        {{ $reviews->links() }}
                    </div>
                @endif
                
            @else
                <div class="text-center py-5">
                    <div class="mb-3">
                        <i class="fas fa-star fa-3x text-muted"></i>
                    </div>
                    <h4 class="text-muted mb-3">No Reviews Yet</h4>
                    <p class="text-muted mb-4">
                        You haven't rated any orders yet. After completing an order, 
                        you can rate it to help us improve our service.
                    </p>
                    <a href="{{ route('customer.orders.index') }}" class="btn btn-primary">
                        <i class="fas fa-list me-1"></i> View My Orders
                    </a>
                </div>
            @endif
        </div>
    </div>

    <!-- Rating Distribution -->
    @if($reviews->count() > 0)
    <div class="row mt-4">
        <div class="col-md-6">
            <div class="card shadow">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Rating Distribution</h5>
                </div>
                <div class="card-body">
                    @php
                        $ratingCounts = [
                            5 => 0,
                            4 => 0,
                            3 => 0,
                            2 => 0,
                            1 => 0
                        ];
                        
                        foreach($reviews as $review) {
                            if(isset($ratingCounts[$review->rating])) {
                                $ratingCounts[$review->rating]++;
                            }
                        }
                        
                        $maxCount = max($ratingCounts);
                    @endphp
                    
                    @for($i = 5; $i >= 1; $i--)
                        <div class="mb-3">
                            <div class="d-flex justify-content-between mb-1">
                                <div>
                                    @for($j = 1; $j <= 5; $j++)
                                        @if($j <= $i)
                                            <i class="fas fa-star text-warning"></i>
                                        @else
                                            <i class="far fa-star text-warning"></i>
                                        @endif
                                    @endfor
                                    <span class="ms-2">{{ $i }} Star{{ $i > 1 ? 's' : '' }}</span>
                                </div>
                                <span class="fw-bold">{{ $ratingCounts[$i] }}</span>
                            </div>
                            <div class="progress" style="height: 8px;">
                                @php
                                    $percentage = $maxCount > 0 ? ($ratingCounts[$i] / $maxCount) * 100 : 0;
                                    $colorClass = match($i) {
                                        5 => 'bg-success',
                                        4 => 'bg-info',
                                        3 => 'bg-primary',
                                        2 => 'bg-warning',
                                        1 => 'bg-danger',
                                        default => 'bg-secondary'
                                    };
                                @endphp
                                <div class="progress-bar {{ $colorClass }}" 
                                     role="progressbar" 
                                     style="width: {{ $percentage }}%"
                                     aria-valuenow="{{ $percentage }}" 
                                     aria-valuemin="0" 
                                     aria-valuemax="100">
                                </div>
                            </div>
                        </div>
                    @endfor
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card shadow">
                <div class="card-header bg-white">
                    <h5 class="mb-0">Recent Activity</h5>
                </div>
                <div class="card-body">
                    @php
                        $recentReviews = $reviews->take(5);
                    @endphp
                    
                    @if($recentReviews->count() > 0)
                        <div class="list-group list-group-flush">
                            @foreach($recentReviews as $recent)
                                <div class="list-group-item border-0 px-0 py-3">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div>
                                            <h6 class="mb-1">{{ $recent->menu->name ?? 'Menu Item' }}</h6>
                                            <div class="mb-1">
                                                @for($i = 1; $i <= 5; $i++)
                                                    @if($i <= $recent->rating)
                                                        <i class="fas fa-star text-warning" style="font-size: 0.8rem;"></i>
                                                    @else
                                                        <i class="far fa-star text-warning" style="font-size: 0.8rem;"></i>
                                                    @endif
                                                @endfor
                                            </div>
                                        </div>
                                        <small class="text-muted">
                                            {{ $recent->created_at->diffForHumans() }}
                                        </small>
                                    </div>
                                    @if($recent->comment)
                                        <p class="mb-0 text-muted" style="font-size: 0.9rem;">
                                            "{{ Str::limit($recent->comment, 50) }}"
                                        </p>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    @else
                        <p class="text-muted mb-0">No recent activity</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
    @endif
</div>

@push('styles')
<style>
    .review-item {
        transition: all 0.3s;
    }
    
    .review-item:hover {
        background-color: rgba(0, 0, 0, 0.02);
        border-radius: 8px;
        padding-left: 10px;
        padding-right: 10px;
        margin-left: -10px;
        margin-right: -10px;
    }
    
    .progress {
        background-color: #e9ecef;
        border-radius: 4px;
    }
    
    .progress-bar {
        border-radius: 4px;
    }
    
    .list-group-item {
        border-left: none;
        border-right: none;
    }
    
    .list-group-item:first-child {
        border-top: none;
        padding-top: 0;
    }
    
    .list-group-item:last-child {
        border-bottom: none;
        padding-bottom: 0;
    }
</style>
@endpush
@endsection