@extends('layouts.app')

@section('title', 'Rate Order #' . $order->order_number)

@section('content')
<div class="container py-4">
    <!-- Breadcrumb -->
    <nav aria-label="breadcrumb" class="mb-4">
        <ol class="breadcrumb">
            <li class="breadcrumb-item">
                <a href="{{ route('customer.dashboard') }}">
                    <i class="fas fa-home me-1"></i> Dashboard
                </a>
            </li>
            <li class="breadcrumb-item">
                <a href="{{ route('customer.orders.index') }}">
                    <i class="fas fa-list me-1"></i> My Orders
                </a>
            </li>
            <li class="breadcrumb-item">
                <a href="{{ route('customer.orders.show', $order->id) }}">
                    <i class="fas fa-receipt me-1"></i> Order #{{ $order->order_number }}
                </a>
            </li>
            <li class="breadcrumb-item active">
                <i class="fas fa-star me-1"></i> Rate Order
            </li>
        </ol>
    </nav>

    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">
                        <i class="fas fa-star me-2"></i> Rate Your Order
                    </h4>
                    <p class="mb-0 mt-1">Order #{{ $order->order_number }} - {{ date('F j, Y', strtotime($order->created_at)) }}</p>
                </div>
                
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show">
                            <i class="fas fa-exclamation-circle me-2"></i>
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif
                    
                    @if($errors->any())
                        <div class="alert alert-danger alert-dismissible fade show">
                            <ul class="mb-0">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif
                    
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        Your feedback helps us improve our service. Please rate your order experience.
                    </div>
                    
                    <form method="POST" action="{{ route('customer.orders.rate.submit', $order->id) }}">
                        @csrf
                        
                        <!-- Overall Rating -->
                        <div class="card mb-4 border">
                            <div class="card-body">
                                <h5 class="card-title mb-3">
                                    <i class="fas fa-clipboard-check me-2"></i> Overall Experience
                                </h5>
                                
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Overall Rating *</label>
                                    <div class="rating-stars">
                                        @for($i = 1; $i <= 5; $i++)
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" 
                                                       name="rating" id="rating{{ $i }}" 
                                                       value="{{ $i }}" required 
                                                       {{ old('rating') == $i ? 'checked' : '' }}>
                                                <label class="form-check-label star-label" for="rating{{ $i }}">
                                                    @for($j = 1; $j <= $i; $j++)
                                                        <i class="fas fa-star"></i>
                                                    @endfor
                                                    @for($j = $i + 1; $j <= 5; $j++)
                                                        <i class="far fa-star"></i>
                                                    @endfor
                                                    <span class="ms-2">{{ $i }} Star{{ $i > 1 ? 's' : '' }}</span>
                                                </label>
                                            </div>
                                        @endfor
                                    </div>
                                    @error('rating')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                
                                <div class="mb-3">
                                    <label for="comment" class="form-label fw-bold">Overall Review</label>
                                    <textarea class="form-control @error('comment') is-invalid @enderror" 
                                              id="review" name="review" rows="3" 
                                              placeholder="Tell us about your overall experience...">{{ old('comment') }}</textarea>
                                    <small class="text-muted">Optional - What did you like or dislike?</small>
                                    @error('comment')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <!-- Item Ratings -->
                        <div class="card mb-4 border">
                            <div class="card-body">
                                <h5 class="card-title mb-3">
                                    <i class="fas fa-utensils me-2"></i> Rate Individual Items
                                </h5>
                                
                                @if($order->items && $order->items->count() > 0)
                                    @foreach($order->items as $index => $item)
                                        <div class="item-rating mb-4 pb-3 {{ !$loop->last ? 'border-bottom' : '' }}">
                                            <div class="d-flex justify-content-between align-items-start mb-2">
                                                <div>
                                                    <h6 class="mb-1">{{ $item->menu->name ?? 'Item ' . ($index + 1) }}</h6>
                                                    <small class="text-muted">Quantity: {{ $item->quantity }}</small>
                                                </div>
                                                <span class="text-primary fw-bold">
                                                    Rp {{ number_format($item->unit_price, 0, ',', '.') }}
                                                </span>
                                            </div>
                                            
                                            <input type="hidden" name="items[{{ $index }}][item_id]" value="{{ $item->id }}">
                                            
                                            <div class="mb-2">
                                                <label class="form-label">Item Rating *</label>
                                                <div class="item-stars">
                                                    @for($i = 1; $i <= 5; $i++)
                                                        <div class="form-check form-check-inline">
                                                            <input class="form-check-input item-rating-input" 
                                                                   type="radio" 
                                                                   name="items[{{ $index }}][rating]" 
                                                                   id="item{{ $index }}_rating{{ $i }}" 
                                                                   value="{{ $i }}" required
                                                                   {{ old('items.' . $index . '.rating') == $i ? 'checked' : '' }}>
                                                            <label class="form-check-label" for="item{{ $index }}_rating{{ $i }}">
                                                                @for($j = 1; $j <= $i; $j++)
                                                                    <i class="fas fa-star text-warning"></i>
                                                                @endfor
                                                                @for($j = $i + 1; $j <= 5; $j++)
                                                                    <i class="far fa-star text-warning"></i>
                                                                @endfor
                                                            </label>
                                                        </div>
                                                    @endfor
                                                </div>
                                            </div>
                                            
<!-- Item Review textarea -->
<textarea class="form-control" 
          name="items[{{ $index }}][comment]" 
          rows="2" 
          placeholder="How was this item? (Optional)">{{ old('items.' . $index . '.comment') }}</textarea>
            </div>
                                    @endforeach
                                @else
                                    <div class="text-center text-muted py-3">
                                        <i class="fas fa-utensils fa-2x mb-2"></i>
                                        <p>No items to rate</p>
                                    </div>
                                @endif
                            </div>
                        </div>
                        
                        <!-- Delivery Rating (if delivery order) -->
                        @if($order->order_type === 'delivery')
                        <div class="card mb-4 border">
                            <div class="card-body">
                                <h5 class="card-title mb-3">
                                    <i class="fas fa-truck me-2"></i> Delivery Experience
                                </h5>
                                
                                <div class="mb-3">
                                    <label class="form-label fw-bold">Delivery Rating</label>
                                    <div class="delivery-stars">
                                        @for($i = 1; $i <= 5; $i++)
                                            <div class="form-check form-check-inline">
                                                <input class="form-check-input" type="radio" 
                                                       name="delivery_rating" id="delivery_rating{{ $i }}" 
                                                       value="{{ $i }}"
                                                       {{ old('delivery_rating') == $i ? 'checked' : '' }}>
                                                <label class="form-check-label" for="delivery_rating{{ $i }}">
                                                    @for($j = 1; $j <= $i; $j++)
                                                        <i class="fas fa-star text-info"></i>
                                                    @endfor
                                                    @for($j = $i + 1; $j <= 5; $j++)
                                                        <i class="far fa-star text-info"></i>
                                                    @endfor
                                                    <span class="ms-2">{{ $i }} Star{{ $i > 1 ? 's' : '' }}</span>
                                                </label>
                                            </div>
                                        @endfor
                                    </div>
                                </div>
                                
<textarea class="form-control" id="delivery_comment" 
          name="delivery_comment" rows="2" 
          placeholder="How was the delivery? (Optional)">{{ old('delivery_comment') }}</textarea>
                                    </div>
                        </div>
                        @endif
                        
                        <!-- Form Actions -->
                        <div class="d-flex justify-content-between mt-4">
                            <a href="{{ route('customer.orders.show', $order->id) }}" 
                               class="btn btn-outline-secondary">
                                <i class="fas fa-arrow-left me-1"></i> Back to Order
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-paper-plane me-1"></i> Submit Rating
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    .rating-stars .form-check-input,
    .item-stars .form-check-input,
    .delivery-stars .form-check-input {
        display: none;
    }
    
    .rating-stars .form-check-label,
    .item-stars .form-check-label,
    .delivery-stars .form-check-label {
        cursor: pointer;
        font-size: 1.5rem;
        margin-right: 15px;
        padding: 5px;
        border-radius: 5px;
        transition: all 0.3s;
    }
    
    .rating-stars .form-check-label:hover,
    .item-stars .form-check-label:hover,
    .delivery-stars .form-check-label:hover {
        background-color: rgba(0, 0, 0, 0.05);
    }
    
    .rating-stars .form-check-input:checked + label,
    .item-stars .form-check-input:checked + label,
    .delivery-stars .form-check-input:checked + label {
        background-color: rgba(13, 110, 253, 0.1);
        border: 1px solid rgba(13, 110, 253, 0.2);
    }
    
    .star-label span {
        font-size: 0.9rem;
        vertical-align: middle;
    }
    
    .item-rating {
        background-color: #f8f9fa;
        padding: 15px;
        border-radius: 8px;
    }
</style>
@endpush

@push('scripts')
<script>
    // Highlight stars on hover
    document.querySelectorAll('.form-check-label').forEach(label => {
        label.addEventListener('mouseenter', function() {
            const input = this.previousElementSibling;
            const stars = this.querySelectorAll('i');
            const value = input.value;
            
            stars.forEach((star, index) => {
                if (index < value) {
                    star.classList.remove('far');
                    star.classList.add('fas');
                }
            });
        });
        
        label.addEventListener('mouseleave', function() {
            const input = this.previousElementSibling;
            const stars = this.querySelectorAll('i');
            
            stars.forEach((star, index) => {
                if (!input.checked) {
                    if (index >= input.value) {
                        star.classList.remove('fas');
                        star.classList.add('far');
                    }
                }
            });
        });
    });
</script>
@endpush
@endsection