@extends('layouts.app')

@section('title', 'Checkout - Chingu Bite')

@section('content')
<div class="container py-4">
    <h1 class="mb-4">Checkout</h1>
    
    @if(session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif
    
    @if($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    
    <div class="row">
        <div class="col-md-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Order Items</h5>
                </div>
                <div class="card-body">
                    @foreach($cartItems as $item)
                        <div class="d-flex align-items-center border-bottom py-3">
                            <img src="{{ $item->menu->image ?? $item->menu->image_url ?? '/images/default-food.jpg' }}" 
                                 alt="{{ $item->menu->name }}" 
                                 class="img-thumbnail me-3" 
                                 style="width: 60px; height: 60px; object-fit: cover;">
                            
                            <div class="flex-grow-1">
                                <h6 class="mb-1">{{ $item->menu->name }}</h6>
                                <p class="text-muted mb-0 small">
                                    Rp {{ number_format($item->menu->price, 0, ',', '.') }} x {{ $item->quantity }}
                                </p>
                                @if($item->notes)
                                    <p class="text-muted mb-0 small">Note: {{ $item->notes }}</p>
                                @endif
                            </div>
                            
                            <div class="text-end">
                                <strong>Rp {{ number_format($item->menu->price * $item->quantity, 0, ',', '.') }}</strong>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
            
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Order Details</h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('customer.orders.store') }}" method="POST" id="checkoutForm">
                        @csrf
                        
                        <div class="mb-3">
                            <label for="order_type" class="form-label">Order Type <span class="text-danger">*</span></label>
                            <select class="form-select" id="order_type" name="order_type" required>
                                <option value="">Select order type</option>
                                <option value="dine_in" {{ old('order_type') == 'dine_in' ? 'selected' : '' }}>Dine In</option>
                                <option value="takeaway" {{ old('order_type') == 'takeaway' ? 'selected' : '' }}>Takeaway</option>
                                <option value="delivery" {{ old('order_type') == 'delivery' ? 'selected' : '' }}>Delivery</option>
                            </select>
                        </div>
                        
                        <div class="mb-3" id="addressField" style="display: none;">
                            <label for="delivery_address" class="form-label">
                                Delivery Address <span class="text-danger" id="addressRequired">*</span>
                            </label>
                            <textarea class="form-control" id="delivery_address" name="delivery_address" rows="3" 
                                      placeholder="Enter complete delivery address">{{ old('delivery_address') }}</textarea>
                            <small class="text-muted">Complete address with street name, number, and landmark</small>
                        </div>
                        
                        <div class="mb-3">
                            <label for="payment_method_id" class="form-label">Payment Method <span class="text-danger">*</span></label>
                            <select class="form-select" id="payment_method_id" name="payment_method_id" required>
                                <option value="">Select payment method</option>
                                @foreach($paymentMethods as $method)
                                    <option value="{{ $method->id }}" {{ old('payment_method_id') == $method->id ? 'selected' : '' }}>
                                        {{ $method->name }}
                                        @if($method->account_number)
                                            - {{ $method->account_number }}
                                        @endif
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label for="notes" class="form-label">Order Notes (Optional)</label>
                            <textarea class="form-control" id="notes" name="notes" rows="2" 
                                      placeholder="Special instructions for your order">{{ old('notes') }}</textarea>
                        </div>
                        
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg" id="placeOrderBtn">
                                <i class="fas fa-check-circle me-2"></i> Place Order
                            </button>
                            <a href="{{ route('customer.cart.index') }}" class="btn btn-outline-secondary">
                                <i class="fas fa-arrow-left me-2"></i> Back to Cart
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card sticky-top" style="top: 20px;">
                <div class="card-header">
                    <h5 class="mb-0">Order Summary</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Subtotal:</span>
                        <span>Rp {{ number_format($subtotal, 0, ',', '.') }}</span>
                    </div>
                    
                    <div class="d-flex justify-content-between mb-2">
                        <span>Tax (10%):</span>
                        <span>Rp {{ number_format($taxAmount, 0, ',', '.') }}</span>
                    </div>
                    
                    <div class="d-flex justify-content-between mb-3">
                        <span>Service Fee:</span>
                        <span>Rp {{ number_format($serviceFee, 0, ',', '.') }}</span>
                    </div>
                    
                    <hr>
                    
                    <div class="d-flex justify-content-between mb-3">
                        <strong>Total:</strong>
                        <strong class="text-primary">Rp {{ number_format($total, 0, ',', '.') }}</strong>
                    </div>
                    
                    <div class="alert alert-info small mb-0">
                        <i class="fas fa-info-circle me-1"></i>
                        <strong>Note:</strong> Your order will be processed after payment confirmation.
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const orderTypeSelect = document.getElementById('order_type');
    const addressField = document.getElementById('addressField');
    const deliveryAddressInput = document.getElementById('delivery_address');
    const checkoutForm = document.getElementById('checkoutForm');
    
    // Show/hide address field based on order type
    function updateAddressField() {
        const orderType = orderTypeSelect.value;
        
        if (orderType === 'delivery') {
            // Show address field for delivery
            addressField.style.display = 'block';
            deliveryAddressInput.required = true;
            deliveryAddressInput.value = '{{ old("delivery_address") }}';
        } else {
            // Hide address field for dine_in and takeaway
            addressField.style.display = 'none';
            deliveryAddressInput.required = false;
            
            // Set default address value based on order type
            if (orderType === 'dine_in') {
                deliveryAddressInput.value = 'Chingu Bite Restaurant - Dine In';
            } else if (orderType === 'takeaway') {
                deliveryAddressInput.value = 'Chingu Bite Restaurant - Takeaway';
            } else {
                deliveryAddressInput.value = '';
            }
        }
    }
    
    orderTypeSelect.addEventListener('change', updateAddressField);
    
    // Trigger on page load if order type is already selected
    if (orderTypeSelect.value) {
        updateAddressField();
    }
    
    // Form submission
    checkoutForm.addEventListener('submit', function(e) {
        const btn = document.getElementById('placeOrderBtn');
        btn.disabled = true;
        btn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i> Processing...';
    });
});
</script>
@endsection
