@extends('layouts.app')

@section('title', 'Apply for Position')

@section('content')
<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">Apply for: {{ $career['title'] ?? 'Position' }}</h4>
                </div>
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif
                    
                    <form method="POST" action="{{ route('customer.careers.apply.submit', $career['id']) }}" 
                          enctype="multipart/form-data" id="applicationForm">
                        @csrf
                        
                        <!-- Personal Information -->
                        <div class="mb-4">
                            <h5>Personal Information</h5>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="applicant_name" class="form-label">Full Name *</label>
                                    <input type="text" 
                                           class="form-control" 
                                           id="applicant_name" 
                                           name="applicant_name" 
                                           value="{{ old('applicant_name', Session::get('user.name', '')) }}" 
                                           required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="applicant_email" class="form-label">Email Address *</label>
                                    <input type="email" 
                                           class="form-control" 
                                           id="applicant_email" 
                                           name="applicant_email" 
                                           value="{{ old('applicant_email', Session::get('user.email', '')) }}" 
                                           required>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label for="applicant_phone" class="form-label">Phone Number *</label>
                                <input type="tel" 
                                       class="form-control" 
                                       id="applicant_phone" 
                                       name="applicant_phone" 
                                       value="{{ old('applicant_phone', Session::get('user.phone', '')) }}" 
                                       required>
                            </div>
                        </div>
                        
                        <!-- Resume/CV Upload -->
                        <div class="mb-4">
                            <h5>Resume/CV</h5>
                            <div class="mb-3">
                                <label for="applicant_cv" class="form-label">Upload CV/Resume *</label>
                                <input type="file" 
                                       class="form-control" 
                                       id="applicant_cv" 
                                       name="applicant_cv" 
                                       accept=".pdf,.doc,.docx" 
                                       required>
                                <small class="text-muted">Accepted formats: PDF, DOC, DOCX (Max: 5MB)</small>
                            </div>
                        </div>
                        
                        <!-- Cover Letter -->
                        <div class="mb-4">
                            <h5>Cover Letter</h5>
                            <div class="mb-3">
                                <label for="cover_letter" class="form-label">Why are you interested in this position? *</label>
                                <textarea class="form-control" 
                                          id="cover_letter" 
                                          name="cover_letter" 
                                          rows="5" 
                                          required>{{ old('cover_letter') }}</textarea>
                                <small class="text-muted">Tell us why you would be a great fit for this role (minimum 100 characters)</small>
                            </div>
                        </div>
                        
                        <!-- Job Details (Readonly) -->
                        <div class="mb-4">
                            <h5>Position Details</h5>
                            <div class="alert alert-info">
                                <div class="row">
                                    <div class="col-md-6">
                                        <p class="mb-1"><strong>Position:</strong> {{ $career['title'] ?? '' }}</p>
                                        <p class="mb-1"><strong>Department:</strong> {{ ucfirst($career['department'] ?? '') }}</p>
                                    </div>
                                    <div class="col-md-6">
                                        <p class="mb-1"><strong>Location:</strong> {{ $career['location'] ?? '' }}</p>
                                        <p class="mb-1"><strong>Type:</strong> {{ str_replace('_', ' ', ucfirst($career['employment_type'] ?? '')) }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Terms -->
                        <div class="mb-4">
                            <div class="form-check">
                                <input type="checkbox" 
                                       class="form-check-input" 
                                       id="terms" 
                                       name="terms" 
                                       value="1" 
                                       required>
                                <label class="form-check-label" for="terms">
                                    I confirm that the information provided is accurate and complete. *
                                </label>
                            </div>
                            <div class="form-check">
                                <input type="checkbox" 
                                       class="form-check-input" 
                                       id="privacy" 
                                       name="privacy" 
                                       value="1" 
                                       required>
                                <label class="form-check-label" for="privacy">
                                    I agree to the processing of my personal data for recruitment purposes. *
                                </label>
                            </div>
                        </div>
                        
                        <!-- Submit Buttons -->
                        <div class="d-flex justify-content-between">
                            <a href="{{ route('customer.careers.show', $career['id']) }}" 
                               class="btn btn-secondary">
                                <i class="fas fa-arrow-left me-2"></i> Back to Job
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-paper-plane me-2"></i> Submit Application
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- Application Tips -->
            <div class="card shadow mt-4">
                <div class="card-header bg-light">
                    <h6 class="mb-0"><i class="fas fa-lightbulb me-2"></i> Application Tips</h6>
                </div>
                <div class="card-body">
                    <ul class="mb-0">
                        <li>Make sure your CV is up-to-date and includes relevant experience</li>
                        <li>Customize your cover letter for this specific position</li>
                        <li>Highlight skills that match the job requirements</li>
                        <li>Check for spelling and grammar errors</li>
                        <li>We'll contact you via email for any updates on your application</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('applicationForm');
        const coverLetter = document.getElementById('cover_letter');
        const charCount = document.createElement('small');
        charCount.className = 'text-muted float-end';
        charCount.id = 'charCount';
        
        coverLetter.parentNode.appendChild(charCount);
        
        // Character count for cover letter
        function updateCharCount() {
            const length = coverLetter.value.length;
            charCount.textContent = `${length} characters`;
            
            if (length < 100) {
                charCount.classList.remove('text-success');
                charCount.classList.add('text-danger');
            } else {
                charCount.classList.remove('text-danger');
                charCount.classList.add('text-success');
            }
        }
        
        coverLetter.addEventListener('input', updateCharCount);
        updateCharCount();
        
        // Form validation
        form.addEventListener('submit', function(e) {
            if (coverLetter.value.length < 100) {
                e.preventDefault();
                alert('Please write a cover letter with at least 100 characters.');
                coverLetter.focus();
                return false;
            }
            
            const fileInput = document.getElementById('applicant_cv');
            if (fileInput.files.length > 0) {
                const file = fileInput.files[0];
                const maxSize = 5 * 1024 * 1024; // 5MB
                const allowedTypes = ['application/pdf', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'];
                
                if (file.size > maxSize) {
                    e.preventDefault();
                    alert('File size exceeds 5MB limit.');
                    return false;
                }
                
                if (!allowedTypes.includes(file.type)) {
                    e.preventDefault();
                    alert('Please upload a PDF, DOC, or DOCX file.');
                    return false;
                }
            }
        });
    });
</script>
@endpush
@endsection