@extends('layouts.app')

@section('title', 'My Profile')

@section('content')
<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">My Profile</h4>
                </div>
                <div class="card-body">
                    
                    <!-- Profile Header -->
                    <div class="text-center mb-4">
                        <div class="mb-3">
                            <div class="avatar-circle mx-auto mb-3" style="width: 100px; height: 100px; background-color: #4e73df; border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                                <span class="text-white display-4">{{ substr($user['name'] ?? 'C', 0, 1) }}</span>
                            </div>
                        </div>
                        <h3 class="font-weight-bold">{{ $user['name'] ?? 'Customer' }}</h3>
                        <p class="text-muted">{{ $user['email'] ?? '' }}</p>
                        <span class="badge badge-success">Active Customer</span>
                    </div>

                    <hr>

                    <!-- Profile Information -->
                    <div class="mb-4">
                        <h5 class="font-weight-bold mb-3">Personal Information</h5>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="text-muted small">Full Name</label>
                                <div class="form-control bg-light">{{ $user['name'] ?? 'Not set' }}</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="text-muted small">Email Address</label>
                                <div class="form-control bg-light">{{ $user['email'] ?? 'Not set' }}</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="text-muted small">Phone Number</label>
                                <div class="form-control bg-light">{{ $user['phone'] ?? 'Not set' }}</div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="text-muted small">Member Since</label>
                                <div class="form-control bg-light">{{ isset($user['created_at']) ? \Carbon\Carbon::parse($user['created_at'])->format('M d, Y') : 'Not available' }}</div>
                            </div>
                        </div>
                    </div>

                    <!-- Address Information -->
                    <div class="mb-4">
                        <h5 class="font-weight-bold mb-3">Address Information</h5>
                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <label class="text-muted small">Delivery Address</label>
                                <div class="form-control bg-light" style="min-height: 100px;">
                                    {{ $user['address'] ?? 'No address saved. Please update your address for faster delivery.' }}
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Account Settings -->
                    <div class="mb-4">
                        <h5 class="font-weight-bold mb-3">Account Settings</h5>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="text-muted small">Account Status</label>
                                <div class="form-control bg-light">
                                    <span class="badge badge-success">Active</span>
                                    Verified Account
                                </div>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="text-muted small">Last Login</label>
                                <div class="form-control bg-light">
                                    {{ now()->format('M d, Y H:i') }}
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="mt-4 pt-3 border-top">
                        <div class="row">
                            <div class="col-md-6 mb-2">
                                <a href="{{ route('customer.dashboard') }}" class="btn btn-outline-secondary w-100">
                                    <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
                                </a>
                            </div>
                            <div class="col-md-6 mb-2">
                                <a href="{{ route('customer.profile') }}" class="btn btn-primary w-100">
                                    <i class="fas fa-edit mr-2"></i>Edit Profile
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <!-- Quick Stats -->
            <div class="row mt-4">
                <div class="col-md-4 mb-3">
                    <div class="card border-left-info shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                        Total Orders
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">0</div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-clipboard-list fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-4 mb-3">
                    <div class="card border-left-success shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                        Success Rate
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">100%</div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-4 mb-3">
                    <div class="card border-left-warning shadow h-100 py-2">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                        Total Spent
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">$0.00</div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.avatar-circle {
    background: linear-gradient(45deg, #4e73df, #224abe);
    color: white;
    font-weight: bold;
}
.form-control[readonly] {
    background-color: #f8f9fc;
    border: 1px solid #e3e6f0;
    cursor: not-allowed;
}
</style>
@endsection