@extends('layouts.admin')

@section('title', 'User Details: ' . $user['name'])

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-4">
            <!-- User Profile Card -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">User Profile</h3>
                </div>
                <div class="card-body text-center">
                    @if(isset($user['avatar']) && $user['avatar'])
                        <img src="{{ $user['avatar'] }}" alt="{{ $user['name'] }}" 
                             class="img-fluid rounded-circle mb-3" style="width: 150px; height: 150px; object-fit: cover;">
                    @else
                        <div class="rounded-circle bg-secondary text-white d-flex align-items-center justify-content-center mx-auto mb-3" 
                             style="width: 150px; height: 150px; font-size: 48px;">
                            {{ substr($user['name'], 0, 1) }}
                        </div>
                    @endif
                    
                    <h4>{{ $user['name'] }}</h4>
                    <p class="text-muted">{{ $user['email'] }}</p>
                    
                    <div class="mb-3">
                        @if(isset($user['is_active']) && $user['is_active'])
                            <span class="badge badge-success">Active</span>
                        @else
                            <span class="badge badge-secondary">Inactive</span>
                        @endif
                        <span class="badge badge-{{ $user['role'] == 'admin' ? 'danger' : ($user['role'] == 'employee' ? 'warning' : 'info') }}">
                            {{ ucfirst($user['role']) }}
                        </span>
                    </div>
                    
                    <div class="row mt-3">
                        <div class="col-12">
                            @if(isset($user['id']))
                            <a href="{{ route('admin.users.edit', $user['id']) }}" class="btn btn-primary btn-block mb-2">
                                <i class="fas fa-edit"></i> Edit User
                            </a>
                            <form action="{{ route('admin.users.destroy', $user['id']) }}" method="POST" class="d-inline-block w-100">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-block" 
                                        onclick="return confirm('Are you sure you want to delete this user?')">
                                    <i class="fas fa-trash"></i> Delete User
                                </button>
                            </form>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Quick Actions -->
            <div class="card mt-3">
                <div class="card-header">
                    <h3 class="card-title">Quick Actions</h3>
                </div>
                <div class="card-body">
                    <div class="list-group">
                        <a href="{{ route('admin.users.index') }}" class="list-group-item list-group-item-action">
                            <i class="fas fa-arrow-left mr-2"></i> Back to Users List
                        </a>
                        <a href="mailto:{{ $user['email'] }}" class="list-group-item list-group-item-action">
                            <i class="fas fa-envelope mr-2"></i> Send Email
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-8">
            <!-- User Information -->
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">User Information</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h5>Basic Information</h5>
                            <table class="table table-sm">
                                <tr>
                                    <th width="40%">User ID:</th>
                                    <td>{{ $user['id'] ?? 'N/A' }}</td>
                                </tr>
                                <tr>
                                    <th>Name:</th>
                                    <td>{{ $user['name'] ?? 'N/A' }}</td>
                                </tr>
                                <tr>
                                    <th>Email:</th>
                                    <td>{{ $user['email'] ?? 'N/A' }}</td>
                                </tr>
                                <tr>
                                    <th>Phone:</th>
                                    <td>{{ $user['phone'] ?? 'N/A' }}</td>
                                </tr>
                                <tr>
                                    <th>Role:</th>
                                    <td>
                                        <span class="badge badge-{{ $user['role'] == 'admin' ? 'danger' : ($user['role'] == 'employee' ? 'warning' : 'info') }}">
                                            {{ ucfirst($user['role'] ?? 'N/A') }}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h5>Account Information</h5>
                            <table class="table table-sm">
                                <tr>
                                    <th width="40%">Status:</th>
                                    <td>
                                        @if(isset($user['is_active']) && $user['is_active'])
                                            <span class="badge badge-success">Active</span>
                                        @else
                                            <span class="badge badge-secondary">Inactive</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>Created:</th>
                                    <td>
                                        @if(isset($user['created_at']))
                                            {{ \Carbon\Carbon::parse($user['created_at'])->format('d/m/Y H:i') }}
                                        @else
                                            N/A
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <th>Updated:</th>
                                    <td>
                                        @if(isset($user['updated_at']))
                                            {{ \Carbon\Carbon::parse($user['updated_at'])->format('d/m/Y H:i') }}
                                        @else
                                            N/A
                                        @endif
                                    </td>
                                </tr>
                                @if(isset($user['last_login_at']))
                                <tr>
                                    <th>Last Login:</th>
                                    <td>
                                        {{ \Carbon\Carbon::parse($user['last_login_at'])->format('d/m/Y H:i') }}
                                        @if(isset($user['last_login_ip']))
                                            <br>
                                            <small class="text-muted">IP: {{ $user['last_login_ip'] }}</small>
                                        @endif
                                    </td>
                                </tr>
                                @endif
                            </table>
                        </div>
                    </div>
                    
                    @if(isset($user['address']) && $user['address'])
                    <div class="row mt-3">
                        <div class="col-12">
                            <h5>Address</h5>
                            <p class="border p-3 rounded">{{ $user['address'] }}</p>
                        </div>
                    </div>
                    @endif
                    
                    @if(isset($user['date_of_birth']) || isset($user['gender']))
                    <div class="row mt-3">
                        <div class="col-12">
                            <h5>Additional Information</h5>
                            <div class="row">
                                @if(isset($user['date_of_birth']))
                                <div class="col-md-6">
                                    <strong>Date of Birth:</strong><br>
                                    {{ \Carbon\Carbon::parse($user['date_of_birth'])->format('d/m/Y') }}
                                </div>
                                @endif
                                @if(isset($user['gender']))
                                <div class="col-md-6">
                                    <strong>Gender:</strong><br>
                                    {{ ucfirst($user['gender']) }}
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
            
            <!-- Session Messages -->
            @if(session('success'))
                <div class="alert alert-success mt-3">
                    {{ session('success') }}
                </div>
            @endif
            
            @if(session('error'))
                <div class="alert alert-danger mt-3">
                    {{ session('error') }}
                </div>
            @endif
        </div>
    </div>
</div>
@endsection