{{-- resources/views/admin/user/index.blade.php --}}
@extends('layouts.admin')

@section('title', 'User Management')
@section('page_title', 'User Management')
@section('icon', 'fa-users')

@section('breadcrumb')
    @if(request()->has('search') || request()->has('role') || request()->has('status'))
        <li class="breadcrumb-item">Users</li>
        <li class="breadcrumb-item active">Search Results</li>
    @else
        <li class="breadcrumb-item active">Users</li>
    @endif
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="card-title mb-0">
                            <i class="fas fa-users me-2"></i>User Management
                        </h3>
                        <a href="{{ url('admin/users/create') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i> Add New User
                        </a>
                    </div>
                </div>
                
                <div class="card-body">
                    <!-- Filter Section -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card border">
                                <div class="card-body py-3">
                                    <form method="GET" action="{{ url('admin/users/index') }}" class="row g-3 align-items-end">
                                        <div class="col-md-3">
                                            <label class="form-label small">Search</label>
                                            <input type="text" name="search" class="form-control form-control-sm" 
                                                   placeholder="Name, email, or phone..." 
                                                   value="{{ request('search') }}">
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label small">Role</label>
                                            <select name="role" class="form-control form-control-sm">
                                                <option value="">All Roles</option>
                                                @foreach(['admin', 'employee', 'customer'] as $role)
                                                    <option value="{{ $role }}" 
                                                            {{ request('role') == $role ? 'selected' : '' }}>
                                                        {{ ucfirst($role) }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label small">Status</label>
                                            <select name="status" class="form-control form-control-sm">
                                                <option value="">All Status</option>
                                                <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>
                                                    Active
                                                </option>
                                                <option value="inactive" {{ request('status') == 'inactive' ? 'selected' : '' }}>
                                                    Inactive
                                                </option>
                                            </select>
                                        </div>
                                        <div class="col-md-2">
                                            <label class="form-label small">Sort By</label>
                                            <select name="sort" class="form-control form-control-sm">
                                                <option value="newest" {{ request('sort') == 'newest' ? 'selected' : '' }}>
                                                    Newest First
                                                </option>
                                                <option value="oldest" {{ request('sort') == 'oldest' ? 'selected' : '' }}>
                                                    Oldest First
                                                </option>
                                                <option value="name_asc" {{ request('sort') == 'name_asc' ? 'selected' : '' }}>
                                                    Name A-Z
                                                </option>
                                                <option value="name_desc" {{ request('sort') == 'name_desc' ? 'selected' : '' }}>
                                                    Name Z-A
                                                </option>
                                            </select>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="d-flex gap-2">
                                                <button type="submit" class="btn btn-primary btn-sm">
                                                    <i class="fas fa-filter me-1"></i> Filter
                                                </button>
                                                <a href="{{ url('admin/users/index') }}" class="btn btn-secondary btn-sm">
                                                    <i class="fas fa-redo me-1"></i> Reset
                                                </a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Stats Cards -->
                    <div class="row mb-4">
                        <div class="col-md-3 col-sm-6">
                            <div class="stat-card border-start border-primary">
                                <div class="stat-value">{{ $totalUsers ?? 0 }}</div>
                                <div class="stat-label">Total Users</div>
                                <i class="fas fa-users text-primary"></i>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6">
                            <div class="stat-card border-start border-success">
                                <div class="stat-value">{{ $activeUsers ?? 0 }}</div>
                                <div class="stat-label">Active Users</div>
                                <i class="fas fa-user-check text-success"></i>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6">
                            <div class="stat-card border-start border-warning">
                                <div class="stat-value">{{ $adminCount ?? 0 }}</div>
                                <div class="stat-label">Admin Users</div>
                                <i class="fas fa-user-shield text-warning"></i>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6">
                            <div class="stat-card border-start border-info">
                                <div class="stat-value">{{ $customerCount ?? 0 }}</div>
                                <div class="stat-label">Customers</div>
                                <i class="fas fa-shopping-cart text-info"></i>
                            </div>
                        </div>
                    </div>

                    <!-- Users Table -->
                    <div class="table-responsive">
                        <table class="table table-hover data-table">
                            <thead>
                                <tr>
                                    <th width="50">ID</th>
                                    <th>User</th>
                                    <th>Contact</th>
                                    <th>Role</th>
                                    <th>Status</th>
                                    <th>Last Login</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($users as $user)
                                    <tr>
                                        <td>#{{ $user['id'] ?? 'N/A' }}</td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                @if(isset($user['avatar']) && $user['avatar'])
                                                    <img src="{{ $user['avatar'] }}" alt="{{ $user['name'] }}" 
                                                         class="rounded-circle me-3" width="40" height="40" style="object-fit: cover;">
                                                @else
                                                    <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" 
                                                         style="width: 40px; height: 40px; font-size: 16px;">
                                                        {{ substr($user['name'] ?? '?', 0, 1) }}
                                                    </div>
                                                @endif
                                                <div>
                                                    <strong>{{ $user['name'] ?? 'N/A' }}</strong>
                                                    @if(isset($user['date_of_birth']))
                                                        <br>
                                                        <small class="text-muted">
                                                            {{ \Carbon\Carbon::parse($user['date_of_birth'])->age }} years
                                                        </small>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div>
                                                <i class="fas fa-envelope text-muted me-1"></i>
                                                <small>{{ $user['email'] ?? 'N/A' }}</small>
                                            </div>
                                            @if(isset($user['phone']))
                                                <div>
                                                    <i class="fas fa-phone text-muted me-1"></i>
                                                    <small>{{ $user['phone'] }}</small>
                                                </div>
                                            @endif
                                        </td>
                                        <td>
                                            @php
                                                $roleColors = [
                                                    'admin' => 'danger',
                                                    'employee' => 'warning',
                                                    'customer' => 'info'
                                                ];
                                                $roleColor = $roleColors[$user['role'] ?? 'customer'] ?? 'secondary';
                                            @endphp
                                            <span class="badge bg-{{ $roleColor }}">
                                                <i class="fas fa-{{ $user['role'] == 'admin' ? 'user-shield' : ($user['role'] == 'employee' ? 'user-tie' : 'user') }} me-1"></i>
                                                {{ ucfirst($user['role'] ?? 'customer') }}
                                            </span>
                                        </td>
                                        <td>
                                            @if(isset($user['is_active']) && $user['is_active'])
                                                <span class="badge bg-success">
                                                    <i class="fas fa-check-circle me-1"></i> Active
                                                </span>
                                            @else
                                                <span class="badge bg-secondary">
                                                    <i class="fas fa-times-circle me-1"></i> Inactive
                                                </span>
                                            @endif
                                        </td>
                                        <td>
                                            @if(isset($user['last_login_at']) && $user['last_login_at'])
                                                <span title="{{ $user['last_login_at'] }}">
                                                    {{ \Carbon\Carbon::parse($user['last_login_at'])->diffForHumans() }}
                                                </span>
                                                @if(isset($user['last_login_ip']))
                                                    <br>
                                                    <small class="text-muted">IP: {{ $user['last_login_ip'] }}</small>
                                                @endif
                                            @else
                                                <span class="text-muted">Never</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="{{ url('admin/users/' . ($user['id'] ?? '')) }}" 
                                                   class="btn btn-info" data-bs-toggle="tooltip" title="View">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ url('admin/users/' . ($user['id'] ?? '') . '/edit') }}" 
                                                   class="btn btn-warning" data-bs-toggle="tooltip" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" class="btn btn-danger" 
                                                        onclick="confirmDelete('delete-user-{{ $user['id'] ?? '' }}')"
                                                        data-bs-toggle="tooltip" title="Delete">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                            
                                            <form id="delete-user-{{ $user['id'] ?? '' }}" 
                                                  action="{{ url('admin/users/' . ($user['id'] ?? '')) }}" 
                                                  method="POST" style="display: none;">
                                                @csrf
                                                @method('DELETE')
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="fas fa-users fa-3x mb-3"></i>
                                                <h5>No users found</h5>
                                                <p>Try adjusting your search filters</p>
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if(isset($pagination) && $pagination['last_page'] > 1)
                        <nav class="mt-4">
                            <ul class="pagination justify-content-center">
                                @if($pagination['current_page'] > 1)
                                    <li class="page-item">
                                        <a class="page-link" 
                                           href="{{ request()->fullUrlWithQuery(['page' => $pagination['current_page'] - 1]) }}">
                                            <i class="fas fa-chevron-left"></i>
                                        </a>
                                    </li>
                                @endif

                                @for($i = 1; $i <= $pagination['last_page']; $i++)
                                    @if($i == $pagination['current_page'])
                                        <li class="page-item active">
                                            <span class="page-link">{{ $i }}</span>
                                        </li>
                                    @elseif($i >= $pagination['current_page'] - 2 && $i <= $pagination['current_page'] + 2)
                                        <li class="page-item">
                                            <a class="page-link" 
                                               href="{{ request()->fullUrlWithQuery(['page' => $i]) }}">
                                                {{ $i }}
                                            </a>
                                        </li>
                                    @endif
                                @endfor

                                @if($pagination['current_page'] < $pagination['last_page'])
                                    <li class="page-item">
                                        <a class="page-link" 
                                           href="{{ request()->fullUrlWithQuery(['page' => $pagination['current_page'] + 1]) }}">
                                            <i class="fas fa-chevron-right"></i>
                                        </a>
                                    </li>
                                @endif
                            </ul>
                        </nav>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Initialize DataTable
        $('.data-table').DataTable({
            pageLength: 25,
            responsive: true,
            order: [[0, 'desc']],
            columnDefs: [
                { orderable: false, targets: [6] } // Disable sorting for actions column
            ]
        });
    });
</script>
@endsection