@extends('admin.layouts.main')

@section('title', 'Performance Report')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Performance Report</h1>
        <div class="d-flex">
            <button class="btn btn-primary mr-2" onclick="refreshData()">
                <i class="fas fa-sync-alt"></i> Refresh
            </button>
        </div>
    </div>

    <!-- KPI Cards -->
    <div class="row">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Customer Satisfaction
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ isset($apiData['customer_satisfaction']) ? number_format($apiData['customer_satisfaction'], 1) : 0 }}/5
                            </div>
                            <div class="mt-2">
                                <div class="stars">
                                    @for($i = 1; $i <= 5; $i++)
                                        <i class="fas fa-star {{ $i <= round(isset($apiData['customer_satisfaction']) ? $apiData['customer_satisfaction'] : 0) ? 'text-warning' : 'text-secondary' }}"></i>
                                    @endfor
                                </div>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-smile fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Order Completion Rate
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ isset($apiData['order_completion_rate']) ? number_format($apiData['order_completion_rate'], 1) : 0 }}%
                            </div>
                            <div class="mt-2">
                                <div class="progress">
                                    <div class="progress-bar bg-success" 
                                         role="progressbar" 
                                         style="width: {{ isset($apiData['order_completion_rate']) ? $apiData['order_completion_rate'] : 0 }}%">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Average Preparation Time
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ isset($apiData['avg_prep_time']) ? $apiData['avg_prep_time'] : 0 }} mins
                            </div>
                            <div class="mt-2 text-xs">
                                <span class="{{ isset($apiData['prep_time_trend']) && $apiData['prep_time_trend'] == 'down' ? 'text-success' : 'text-danger' }}">
                                    <i class="fas fa-arrow-{{ isset($apiData['prep_time_trend']) && $apiData['prep_time_trend'] == 'down' ? 'down' : 'up' }}"></i>
                                    {{ isset($apiData['prep_time_change']) ? abs($apiData['prep_time_change']) : 0 }}%
                                </span> from last month
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Table Turnover Rate
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ isset($apiData['table_turnover']) ? number_format($apiData['table_turnover'], 1) : 0 }}/day
                            </div>
                            <div class="mt-2 text-xs">
                                Target: 2.5/day
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-table fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Section -->
    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Performance Trends</h6>
                </div>
                <div class="card-body">
                    <canvas id="performanceChart"></canvas>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Top Performers (Staff)</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Staff</th>
                                    <th>Orders</th>
                                    <th>Rating</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if(isset($apiData['top_staff']) && count($apiData['top_staff']) > 0)
                                    @foreach($apiData['top_staff'] as $staff)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="mr-3">
                                                    <img src="https://ui-avatars.com/api/?name={{ urlencode($staff['name']) }}&background=4e73df&color=fff" 
                                                         alt="{{ $staff['name'] }}" 
                                                         style="width: 30px; height: 30px; border-radius: 50%;">
                                                </div>
                                                <div>
                                                    <div class="font-weight-bold">{{ $staff['name'] }}</div>
                                                    <small class="text-muted">{{ $staff['role'] }}</small>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="font-weight-bold">{{ $staff['orders_completed'] }}</td>
                                        <td>
                                            <div class="stars">
                                                @for($i = 1; $i <= 5; $i++)
                                                    <i class="fas fa-star {{ $i <= $staff['rating'] ? 'text-warning' : 'text-secondary' }}" style="font-size: 12px;"></i>
                                                @endfor
                                            </div>
                                            <small>{{ number_format($staff['rating'], 1) }}</small>
                                        </td>
                                    </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td colspan="3" class="text-center">No staff data available</td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Detailed Analysis -->
    <div class="row">
        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Customer Feedback Analysis</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="text-center mb-4">
                                <h4 class="font-weight-bold text-primary">
                                    {{ isset($apiData['positive_reviews']) ? $apiData['positive_reviews'] : 0 }}%
                                </h4>
                                <p class="text-success">Positive Reviews</p>
                                <div class="progress mb-3" style="height: 20px;">
                                    <div class="progress-bar bg-success" 
                                         style="width: {{ isset($apiData['positive_reviews']) ? $apiData['positive_reviews'] : 0 }}%"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="text-center mb-4">
                                <h4 class="font-weight-bold text-primary">
                                    {{ isset($apiData['negative_reviews']) ? $apiData['negative_reviews'] : 0 }}%
                                </h4>
                                <p class="text-danger">Negative Reviews</p>
                                <div class="progress mb-3" style="height: 20px;">
                                    <div class="progress-bar bg-danger" 
                                         style="width: {{ isset($apiData['negative_reviews']) ? $apiData['negative_reviews'] : 0 }}%"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-4">
                        <h6 class="font-weight-bold mb-3">Common Feedback Themes</h6>
                        <div class="list-group">
                            @if(isset($apiData['feedback_themes']) && count($apiData['feedback_themes']) > 0)
                                @foreach($apiData['feedback_themes'] as $theme)
                                <div class="list-group-item">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span>{{ $theme['theme'] }}</span>
                                        <span class="badge badge-{{ $theme['sentiment'] == 'positive' ? 'success' : 'danger' }}">
                                            {{ $theme['count'] }} mentions
                                        </span>
                                    </div>
                                </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Order Processing Metrics</h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-md-4 mb-4">
                            <div class="metric-box p-3 border rounded">
                                <div class="metric-value font-weight-bold text-primary">
                                    {{ isset($apiData['order_accuracy']) ? number_format($apiData['order_accuracy'], 1) : 0 }}%
                                </div>
                                <div class="metric-label text-muted">Order Accuracy</div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-4">
                            <div class="metric-box p-3 border rounded">
                                <div class="metric-value font-weight-bold text-success">
                                    {{ isset($apiData['on_time_delivery']) ? number_format($apiData['on_time_delivery'], 1) : 0 }}%
                                </div>
                                <div class="metric-label text-muted">On-Time Delivery</div>
                            </div>
                        </div>
                        <div class="col-md-4 mb-4">
                            <div class="metric-box p-3 border rounded">
                                <div class="metric-value font-weight-bold text-info">
                                    {{ isset($apiData['first_time_fix']) ? number_format($apiData['first_time_fix'], 1) : 0 }}%
                                </div>
                                <div class="metric-label text-muted">First-Time Fix</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-4">
                        <h6 class="font-weight-bold mb-3">Peak Hours Performance</h6>
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>Time Slot</th>
                                        <th>Orders</th>
                                        <th>Avg. Time</th>
                                        <th>Satisfaction</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(isset($apiData['peak_hours']) && count($apiData['peak_hours']) > 0)
                                        @foreach($apiData['peak_hours'] as $hour)
                                        <tr>
                                            <td>{{ $hour['time_slot'] }}</td>
                                            <td>{{ $hour['orders'] }}</td>
                                            <td>{{ $hour['avg_time'] }} mins</td>
                                            <td>
                                                <div class="stars">
                                                    @for($i = 1; $i <= 5; $i++)
                                                        <i class="fas fa-star {{ $i <= $hour['satisfaction'] ? 'text-warning' : 'text-secondary' }}" style="font-size: 12px;"></i>
                                                    @endfor
                                                </div>
                                            </td>
                                        </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Improvement Areas -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Areas for Improvement</h6>
        </div>
        <div class="card-body">
            <div class="row">
                @if(isset($apiData['improvement_areas']) && count($apiData['improvement_areas']) > 0)
                    @foreach($apiData['improvement_areas'] as $area)
                    <div class="col-md-4 mb-3">
                        <div class="improvement-card p-3 border rounded h-100">
                            <div class="d-flex justify-content-between align-items-start mb-2">
                                <h6 class="font-weight-bold mb-0">{{ $area['area'] }}</h6>
                                <span class="badge badge-{{ $area['priority'] == 'high' ? 'danger' : ($area['priority'] == 'medium' ? 'warning' : 'info') }}">
                                    {{ ucfirst($area['priority']) }} Priority
                                </span>
                            </div>
                            <p class="text-muted small mb-2">{{ $area['description'] }}</p>
                            <div class="progress mb-2" style="height: 8px;">
                                <div class="progress-bar bg-{{ $area['progress'] >= 70 ? 'success' : ($area['progress'] >= 40 ? 'warning' : 'danger') }}" 
                                     style="width: {{ $area['progress'] }}%"></div>
                            </div>
                            <div class="d-flex justify-content-between align-items-center">
                                <small class="text-muted">{{ $area['progress'] }}% complete</small>
                                <small class="text-muted">{{ $area['timeline'] }}</small>
                            </div>
                        </div>
                    </div>
                    @endforeach
                @else
                    <div class="col-12 text-center">
                        <p class="text-muted">No improvement areas identified</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Performance Chart
        const performanceCtx = document.getElementById('performanceChart').getContext('2d');
        new Chart(performanceCtx, {
            type: 'line',
            data: {
                labels: ['Week 1', 'Week 2', 'Week 3', 'Week 4', 'Week 5', 'Week 6'],
                datasets: [{
                    label: 'Customer Satisfaction',
                    data: [4.2, 4.3, 4.1, 4.4, 4.5, 4.6],
                    borderColor: '#4e73df',
                    backgroundColor: 'rgba(78, 115, 223, 0.1)',
                    fill: true,
                    tension: 0.4,
                    yAxisID: 'y'
                }, {
                    label: 'Order Accuracy (%)',
                    data: [95, 96, 94, 97, 98, 99],
                    borderColor: '#1cc88a',
                    backgroundColor: 'rgba(28, 200, 138, 0.1)',
                    fill: true,
                    tension: 0.4,
                    yAxisID: 'y1'
                }, {
                    label: 'Avg Prep Time (mins)',
                    data: [25, 24, 23, 22, 21, 20],
                    borderColor: '#e74a3b',
                    backgroundColor: 'rgba(231, 74, 59, 0.1)',
                    fill: true,
                    tension: 0.4,
                    yAxisID: 'y2'
                }]
            },
            options: {
                scales: {
                    y: {
                        type: 'linear',
                        display: true,
                        position: 'left',
                        min: 4,
                        max: 5,
                        title: {
                            display: true,
                            text: 'Satisfaction (1-5)'
                        }
                    },
                    y1: {
                        type: 'linear',
                        display: true,
                        position: 'right',
                        min: 90,
                        max: 100,
                        title: {
                            display: true,
                            text: 'Accuracy (%)'
                        },
                        grid: {
                            drawOnChartArea: false
                        }
                    },
                    y2: {
                        type: 'linear',
                        display: false
                    }
                }
            }
        });
    });

    function refreshData() {
        location.reload();
    }
</script>
<style>
    .stars {
        color: #ffc107;
    }
    .stars .fa-star.text-secondary {
        color: #e0e0e0 !important;
    }
    .metric-box {
        transition: all 0.3s;
    }
    .metric-box:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    .improvement-card {
        transition: all 0.3s;
    }
    .improvement-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
</style>
@endsection